/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.view;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.graphics.ImageFormat;
import android.graphics.Rect;
import android.graphics.SurfaceTexture;
import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraCaptureSession;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CameraDevice;
import android.hardware.camera2.CameraManager;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.CaptureResult;
import android.hardware.camera2.TotalCaptureResult;
import android.hardware.camera2.params.MeteringRectangle;
import android.hardware.camera2.params.StreamConfigurationMap;
import android.media.Image;
import android.media.ImageReader;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Message;
import android.text.TextUtils;
import android.util.Range;
import android.util.Size;
import android.view.Surface;
import com.gensee.util.Reflection;
import com.gensee.utils.GenseeLog;
import com.gensee.view.VideoCapture;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.concurrent.Semaphore;

@TargetApi(value=21)
public class VideoCamera2Capture
extends VideoCapture {
    private static final String TAG = "VideoCamera2Capture";
    private CameraManager cameraManager;
    private CameraDevice mCameraDevice;
    private CaptureRequest.Builder mPreviewBuilder;
    private SurfaceTexture mSurfaceTexture;
    private CameraCaptureSession mCaptureSession;
    private ImageReader mImageReader;
    protected CameraCharacteristics characteristics;
    private HandlerThread mBackgroundThread;
    private Handler mBackgroundHandler;
    private HandlerThread mViewThread;
    protected Handler mViewHandler;
    private static final int CAMERA2_DO_SWITCH_CAMERA = 10000000;
    private static final int CAMERA2_RELEASE_CAMERA = 10000001;
    private static final int CAMERA2_OPEN_CAMERA = 10000002;
    private Semaphore mCameraOpenLock = new Semaphore(1);
    private Semaphore mCameraCloseLock = new Semaphore(1);
    private Rect mActiveArraySize = new Rect(0, 0, 1, 1);
    private boolean isCameraOpening = false;
    private byte[] yv12Data;
    private CameraDevice.StateCallback deviceStateCallback = new CameraDevice.StateCallback(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onOpened(CameraDevice camera) {
            GenseeLog.d((String)VideoCamera2Capture.TAG, (String)("onOpened camera = " + camera));
            VideoCamera2Capture.this.mCameraOpenLock.release();
            VideoCamera2Capture.this.mCameraCloseLock.release();
            Object object = VideoCamera2Capture.this.cameraLock;
            synchronized (object) {
                VideoCamera2Capture.this.mCameraDevice = camera;
                if (null == VideoCamera2Capture.this.mImageReader) {
                    GenseeLog.d((String)VideoCamera2Capture.TAG, (String)"onOpened mImageReader have release");
                    VideoCamera2Capture.this.mCameraDevice.close();
                    VideoCamera2Capture.this.mCameraDevice = null;
                    return;
                }
                try {
                    VideoCamera2Capture.this.mPreviewBuilder = VideoCamera2Capture.this.mCameraDevice.createCaptureRequest(1);
                    ArrayList<Surface> surfaces = new ArrayList<Surface>();
                    VideoCamera2Capture.this.mSurfaceTexture = VideoCamera2Capture.this.captureCallBack.getSurfaceTexTure();
                    if (null != VideoCamera2Capture.this.mSurfaceTexture) {
                        Surface mSurface = new Surface(VideoCamera2Capture.this.mSurfaceTexture);
                        VideoCamera2Capture.this.mPreviewBuilder.addTarget(mSurface);
                        surfaces.add(mSurface);
                    } else {
                        GenseeLog.w((String)VideoCamera2Capture.TAG, (String)"mSurfaceTexture is null");
                    }
                    if (null != VideoCamera2Capture.this.mImageReader) {
                        VideoCamera2Capture.this.mPreviewBuilder.addTarget(VideoCamera2Capture.this.mImageReader.getSurface());
                        surfaces.add(VideoCamera2Capture.this.mImageReader.getSurface());
                    } else {
                        GenseeLog.e((String)VideoCamera2Capture.TAG, (String)"mImageReader is null");
                    }
                    VideoCamera2Capture.this.mCameraDevice.createCaptureSession(surfaces, VideoCamera2Capture.this.sessionStateCallback, VideoCamera2Capture.this.mBackgroundHandler);
                }
                catch (Exception e) {
                    GenseeLog.e((String)VideoCamera2Capture.TAG, (String)("createCaptureRequest previewBuilder CameraAccessException=" + e));
                }
            }
            if (null != VideoCamera2Capture.this.onCameraInfoListener) {
                VideoCamera2Capture.this.onCameraInfoListener.onCameraOpen(true);
            }
            VideoCamera2Capture.this.isCameraOpening = false;
        }

        public void onDisconnected(CameraDevice camera) {
            VideoCamera2Capture.this.mCameraOpenLock.release();
            VideoCamera2Capture.this.mCameraCloseLock.release();
            GenseeLog.d((String)VideoCamera2Capture.TAG, (String)("onDisconnected camera = " + camera));
            camera.close();
            VideoCamera2Capture.this.mCameraDevice = null;
            VideoCamera2Capture.this.isCameraOpening = false;
        }

        public void onClosed(CameraDevice camera) {
            super.onClosed(camera);
            VideoCamera2Capture.this.mCameraOpenLock.release();
            VideoCamera2Capture.this.mCameraCloseLock.release();
            GenseeLog.d((String)VideoCamera2Capture.TAG, (String)("onClosed camera = " + camera));
            VideoCamera2Capture.this.isCameraOpening = false;
        }

        public void onError(CameraDevice camera, int error) {
            VideoCamera2Capture.this.mCameraOpenLock.release();
            VideoCamera2Capture.this.mCameraCloseLock.release();
            GenseeLog.w((String)VideoCamera2Capture.TAG, (String)("onError camera = " + camera + " error = " + error));
            camera.close();
            VideoCamera2Capture.this.mCameraDevice = null;
            VideoCamera2Capture.this.isCameraOpening = false;
            if (null != VideoCamera2Capture.this.onCameraInfoListener) {
                VideoCamera2Capture.this.onCameraInfoListener.onCameraOpen(false);
            }
        }
    };
    private CameraCaptureSession.StateCallback sessionStateCallback = new CameraCaptureSession.StateCallback(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onConfigured(CameraCaptureSession session) {
            Object object = VideoCamera2Capture.this.cameraLock;
            synchronized (object) {
                if (null != VideoCamera2Capture.this.mCameraDevice) {
                    GenseeLog.d((String)VideoCamera2Capture.TAG, (String)("onConfigured session = " + session.toString()));
                    VideoCamera2Capture.this.mCaptureSession = session;
                    VideoCamera2Capture.this.toStartPreview();
                    try {
                        int[] afs;
                        Range[] fpss = (Range[])VideoCamera2Capture.this.characteristics.get(CameraCharacteristics.CONTROL_AE_AVAILABLE_TARGET_FPS_RANGES);
                        Range suiteFps = VideoCamera2Capture.this.getSuitableFps(fpss);
                        if (null != suiteFps) {
                            VideoCamera2Capture.this.mPreviewBuilder.set(CaptureRequest.CONTROL_AE_TARGET_FPS_RANGE, (Object)suiteFps);
                        } else {
                            GenseeLog.e((String)VideoCamera2Capture.TAG, (String)" Get SuiteFps Error!");
                        }
                        for (int a : afs = (int[])VideoCamera2Capture.this.characteristics.get(CameraCharacteristics.CONTROL_AF_AVAILABLE_MODES)) {
                            if (a != 3) continue;
                            VideoCamera2Capture.this.mPreviewBuilder.set(CaptureRequest.CONTROL_AF_MODE, (Object)3);
                        }
                        VideoCamera2Capture.this.mCaptureSession.setRepeatingRequest(VideoCamera2Capture.this.mPreviewBuilder.build(), VideoCamera2Capture.this.sessionCaptureCallback, VideoCamera2Capture.this.mBackgroundHandler);
                        VideoCamera2Capture.this.mPreviewRunning = true;
                        VideoCamera2Capture.this.caculateRotate();
                        VideoCamera2Capture.this.startSendThread();
                    }
                    catch (CameraAccessException e) {
                        GenseeLog.e((String)VideoCamera2Capture.TAG, (String)"setRepeatingRequest cameraAccessException");
                        VideoCamera2Capture.this.mPreviewRunning = false;
                        VideoCamera2Capture.this._releaseCamera();
                    }
                }
            }
        }

        public void onConfigureFailed(CameraCaptureSession session) {
            GenseeLog.w((String)VideoCamera2Capture.TAG, (String)("onConfigureFailed session = " + session.toString()));
        }
    };
    private CameraCaptureSession.CaptureCallback sessionCaptureCallback = new CameraCaptureSession.CaptureCallback(){

        public void onCaptureStarted(CameraCaptureSession session, CaptureRequest request, long timestamp, long frameNumber) {
            super.onCaptureStarted(session, request, timestamp, frameNumber);
        }

        public void onCaptureCompleted(CameraCaptureSession session, CaptureRequest request, TotalCaptureResult result) {
            super.onCaptureCompleted(session, request, result);
            if (Build.VERSION.SDK_INT >= 30) {
                return;
            }
            VideoCamera2Capture.this.recycle(result);
        }
    };
    static Field sTargetField;
    static Method sTargetMethod;
    private long nStartTime = Calendar.getInstance().getTimeInMillis();
    private int frameCount = 0;
    private ImageReader.OnImageAvailableListener onImageAvailableListener = new ImageReader.OnImageAvailableListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onImageAvailable(ImageReader reader) {
            Image image = null;
            try {
                Object object = VideoCamera2Capture.this.cameraLock;
                synchronized (object) {
                    if (null == VideoCamera2Capture.this.mImageReader || reader != VideoCamera2Capture.this.mImageReader) {
                        return;
                    }
                    image = reader.acquireNextImage();
                }
            }
            catch (Exception e) {
                GenseeLog.w((String)VideoCamera2Capture.TAG, (String)("onImageAvailable acquireNextImage exception = " + e.getMessage()));
            }
            if (null != image) {
                try {
                    byte[] yv12Data = VideoCamera2Capture.this.getDataFromImage(image);
                    int imageSize = VideoCamera2Capture.this.mWidth * VideoCamera2Capture.this.mHeight * ImageFormat.getBitsPerPixel((int)image.getFormat()) / 8;
                    if (null != yv12Data && yv12Data.length == imageSize) {
                        VideoCamera2Capture.this.processVideoData(yv12Data, VideoCamera2Capture.this.mWidth, VideoCamera2Capture.this.mHeight);
                    }
                }
                catch (Exception e) {
                    StackTraceElement[] trace;
                    GenseeLog.e((String)VideoCamera2Capture.TAG, (String)("onImageAvailable imageToYv12 Exception=" + e + ",message=" + e.getMessage()));
                    for (StackTraceElement traceElement : trace = e.getStackTrace()) {
                        GenseeLog.e((String)VideoCamera2Capture.TAG, (String)("\tat " + traceElement));
                    }
                    e.printStackTrace();
                }
                finally {
                    image.close();
                }
            }
        }
    };
    private int nBaseFrate = 25;
    private CameraCaptureSession.CaptureCallback mAfCaptureCallback = new CameraCaptureSession.CaptureCallback(){

        private void process(CaptureResult result) {
            if (null == VideoCamera2Capture.this.mCameraDevice || null == VideoCamera2Capture.this.mCaptureSession || null == VideoCamera2Capture.this.mPreviewBuilder) {
                return;
            }
            Integer afState = (Integer)result.get(CaptureResult.CONTROL_AF_STATE);
            if (null == afState) {
                return;
            }
            GenseeLog.d((String)VideoCamera2Capture.TAG, (String)("mAfCaptureCallback afState = " + afState));
            if (4 == afState || 5 == afState) {
                VideoCamera2Capture.this.mPreviewBuilder.set(CaptureRequest.CONTROL_AF_MODE, (Object)3);
                VideoCamera2Capture.this.mPreviewBuilder.set(CaptureRequest.CONTROL_AF_TRIGGER, (Object)2);
                VideoCamera2Capture.this.mPreviewBuilder.set(CaptureRequest.CONTROL_AE_MODE, (Object)1);
                try {
                    if (null != VideoCamera2Capture.this.onCameraInfoListener) {
                        VideoCamera2Capture.this.onCameraInfoListener.onManualFocus(afState == 4);
                    }
                    VideoCamera2Capture.this.mCaptureSession.setRepeatingRequest(VideoCamera2Capture.this.mPreviewBuilder.build(), null, VideoCamera2Capture.this.mBackgroundHandler);
                }
                catch (CameraAccessException e) {
                    GenseeLog.e((String)VideoCamera2Capture.TAG, (String)("setRepeatingRequest failed, errMsg: " + e.getMessage()));
                }
            }
        }

        public void onCaptureProgressed(CameraCaptureSession session, CaptureRequest request, CaptureResult partialResult) {
            this.process(partialResult);
        }

        public void onCaptureCompleted(CameraCaptureSession session, CaptureRequest request, TotalCaptureResult result) {
            this.process((CaptureResult)result);
        }
    };

    public VideoCamera2Capture() {
        this.startViewThread();
        this.startBackgroundThread();
        Reflection.exemptAll();
    }

    private void startViewThread() {
        if (null == this.mViewThread) {
            this.mViewThread = new HandlerThread("Camera2ViewThread");
            this.mViewThread.start();
            this.mViewHandler = new Handler(this.mViewThread.getLooper()){

                public void handleMessage(Message msg) {
                    super.handleMessage(msg);
                    switch (msg.what) {
                        case 10000000: {
                            VideoCamera2Capture.this._doSwitchCamera();
                            break;
                        }
                        case 10000002: {
                            if (null == msg.obj || !(msg.obj instanceof Integer)) break;
                            VideoCamera2Capture.this._doCameraOpen((Integer)msg.obj);
                            break;
                        }
                        case 10000001: {
                            VideoCamera2Capture.this._releaseCamera();
                        }
                    }
                }
            };
        }
    }

    private void stopViewThread() {
        if (null != this.mViewThread) {
            this.mViewThread.quitSafely();
            try {
                this.mViewThread.join();
                this.mViewThread = null;
                this.mViewHandler = null;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    private void startBackgroundThread() {
        if (null == this.mBackgroundThread) {
            this.mBackgroundThread = new HandlerThread("CameraBackground");
            this.mBackgroundThread.start();
            this.mBackgroundHandler = new Handler(this.mBackgroundThread.getLooper());
        }
    }

    private void stopBackgroundThread() {
        if (null != this.mBackgroundThread) {
            this.mBackgroundThread.quitSafely();
            try {
                this.mBackgroundThread.join();
                this.mBackgroundThread = null;
                this.mBackgroundHandler = null;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    private void _doSwitchCamera() {
        if (!this.mBeginPreviewRunning) {
            GenseeLog.w((String)TAG, (String)"this divice didn't open camera");
            return;
        }
        if (!this.checkCameraPermission()) {
            GenseeLog.w((String)TAG, (String)"_doSwitchCamera checkCameraPermission fail");
            return;
        }
        if (null == this.cameraManager) {
            GenseeLog.w((String)TAG, (String)"_doSwitchCamera cameraManager==null");
            return;
        }
        int num = 0;
        try {
            String[] ids = this.cameraManager.getCameraIdList();
            num = ids.length;
        }
        catch (CameraAccessException e) {
            GenseeLog.e((String)TAG, (String)"do camera switch ids length failure");
        }
        if (num < 2) {
            GenseeLog.w((String)TAG, (String)"this divice can't switch camera");
            return;
        }
        GenseeLog.d((String)TAG, (String)("cameraIdList size = " + num));
        this._releaseCamera();
        CameraManager manager = (CameraManager)this.captureCallBack.getContext().getSystemService("camera");
        try {
            Integer lastCameraFacing = null;
            for (String cameraId : manager.getCameraIdList()) {
                if (!TextUtils.equals((CharSequence)cameraId, (CharSequence)(this.cameraIndex + ""))) continue;
                lastCameraFacing = (Integer)this.characteristics.get(CameraCharacteristics.LENS_FACING);
                break;
            }
            Integer nowCameraFacing = 0;
            if (null != lastCameraFacing) {
                if (lastCameraFacing == 0) {
                    nowCameraFacing = 1;
                } else if (lastCameraFacing == 1) {
                    nowCameraFacing = 0;
                }
            }
            for (int cameraId = 0; cameraId < manager.getCameraIdList().length; ++cameraId) {
                Integer facing;
                CameraCharacteristics characteristics = manager.getCameraCharacteristics(cameraId + "");
                StreamConfigurationMap map = (StreamConfigurationMap)characteristics.get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP);
                if (map == null || (facing = (Integer)characteristics.get(CameraCharacteristics.LENS_FACING)) == null || facing != nowCameraFacing) continue;
                this.cameraIndex = cameraId;
                break;
            }
        }
        catch (CameraAccessException e) {
            e.printStackTrace();
        }
        this._doCameraOpen(this.cameraIndex);
        if (null != this.iVideoCoreInterface) {
            this.iVideoCoreInterface.saveCameraId(this.cameraIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _releaseCamera() {
        try {
            Object object = this.cameraLock;
            synchronized (object) {
                this.mCameraOpenLock.acquire();
                this.releaseSendThread();
                if (null != this.mCaptureSession) {
                    this.mCaptureSession.close();
                }
                if (this.mCameraDevice != null) {
                    GenseeLog.d((String)TAG, (String)"videocapture releaseCamera camera not null");
                    this.mCameraDevice.close();
                } else {
                    this.mCameraCloseLock.release();
                    GenseeLog.d((String)TAG, (String)"videocapture releaseCamera camera null");
                }
                if (null != this.mImageReader) {
                    this.mImageReader.close();
                }
                this.mCaptureSession = null;
                this.mCameraDevice = null;
                this.mImageReader = null;
                this.isCameraOpening = false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            GenseeLog.e((String)TAG, (String)("_releaseCamera Exception=" + e));
        }
        finally {
            this.mCameraOpenLock.release();
        }
    }

    @SuppressLint(value={"MissingPermission"})
    private void _doCameraOpen(int cameraIndex) {
        if (this.isCameraOpening) {
            GenseeLog.d((String)TAG, (String)"_doCameraOpen cameradevice have opened");
            return;
        }
        if (null != this.captureCallBack) {
            this.caculateRotate();
            this.mSurfaceTexture = this.captureCallBack.getSurfaceTexTure();
            if (this.checkCameraPermission()) {
                try {
                    GenseeLog.d((String)TAG, (String)("_doCameraOpen begin open cameraIndex=" + cameraIndex));
                    this.mCameraOpenLock.acquire();
                    GenseeLog.d((String)TAG, (String)"_doCameraOpen get Semaphore cameraopenlock success");
                    this.mCameraCloseLock.acquire();
                    GenseeLog.d((String)TAG, (String)"_doCameraOpen get Semaphore cameracloselock success");
                    this.cameraManager = (CameraManager)this.captureCallBack.getContext().getSystemService("camera");
                    this.characteristics = this.cameraManager.getCameraCharacteristics(cameraIndex + "");
                    int hardwarelevel = (Integer)this.characteristics.get(CameraCharacteristics.INFO_SUPPORTED_HARDWARE_LEVEL);
                    if (hardwarelevel != 1 || hardwarelevel != 3) {
                        GenseeLog.w((String)TAG, (String)("camera2 feature not support hardwarelevel = " + hardwarelevel));
                    }
                    this.mActiveArraySize = (Rect)this.characteristics.get(CameraCharacteristics.SENSOR_INFO_ACTIVE_ARRAY_SIZE);
                    StreamConfigurationMap map = (StreamConfigurationMap)this.characteristics.get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP);
                    Size[] sizes = map.getOutputSizes(SurfaceTexture.class);
                    ArrayList<Size> ss = null;
                    if (sizes != null) {
                        ss = new ArrayList<Size>();
                        for (int i = 0; i < sizes.length; ++i) {
                            Size s = sizes[i];
                            if (Math.max(s.getWidth(), s.getHeight()) < 300) {
                                GenseeLog.d((String)TAG, (String)("Supported w = " + s.getWidth() + " h = " + s.getHeight() + "(size too small, remove this)"));
                                continue;
                            }
                            GenseeLog.d((String)TAG, (String)("Supported w = " + s.getWidth() + " h = " + s.getHeight()));
                            ss.add(s);
                        }
                    }
                    this.resetPreviewWH();
                    Size suiteSize = VideoCamera2Capture.getOptimalPreviewSize(ss, this.mWidth, this.mHeight);
                    GenseeLog.d((String)TAG, (String)("getOptimalPreviewSize suiteSize widht = " + suiteSize.getWidth() + " height = " + suiteSize.getHeight()));
                    this.mWidth = suiteSize.getWidth();
                    this.mHeight = suiteSize.getHeight();
                    this.mImageReader = ImageReader.newInstance((int)this.mWidth, (int)this.mHeight, (int)35, (int)2);
                    this.mImageReader.setOnImageAvailableListener(this.onImageAvailableListener, this.mBackgroundHandler);
                    if (null != this.mSurfaceTexture) {
                        this.mSurfaceTexture.setDefaultBufferSize(suiteSize.getWidth(), suiteSize.getHeight());
                    }
                    this.notifyPreviewSize();
                    GenseeLog.d((String)TAG, (String)("Get Suite Preview fbv width = " + suiteSize.getWidth() + " height = " + suiteSize.getHeight()));
                    GenseeLog.d((String)TAG, (String)("openCamera cameraIndex = " + cameraIndex));
                    this.isCameraOpening = true;
                    this.cameraManager.openCamera(cameraIndex + "", this.deviceStateCallback, this.mBackgroundHandler);
                }
                catch (Exception e) {
                    this.mCameraOpenLock.release();
                    this.mCameraCloseLock.release();
                    e.printStackTrace();
                    GenseeLog.e((String)TAG, (String)("doCameraOpen exception message = " + e.getMessage()));
                }
            }
        }
    }

    @SuppressLint(value={"SoonBlockedPrivateApi"})
    private void recycle(TotalCaptureResult tcr) {
        try {
            if (null == sTargetField) {
                sTargetField = tcr.getClass().getSuperclass().getDeclaredField("mResults");
                sTargetField.setAccessible(true);
            }
            if (null == sTargetMethod) {
                sTargetMethod = Class.forName("android.hardware.camera2.impl.CameraMetadataNative").getDeclaredMethod("close", new Class[0]);
                sTargetMethod.setAccessible(true);
            }
            sTargetMethod.invoke(sTargetField.get(tcr), new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    private byte[] getDataFromImage(Image image) {
        Rect crop = image.getCropRect();
        int format = image.getFormat();
        int width = crop.width();
        int height = crop.height();
        Image.Plane[] planes = image.getPlanes();
        if (!this.checkAndroidImageFormat(image)) {
            return null;
        }
        int offset = 0;
        int dataSize = width * height * ImageFormat.getBitsPerPixel((int)format) / 8;
        if (null == this.yv12Data || this.yv12Data.length != dataSize) {
            this.yv12Data = new byte[dataSize];
        }
        byte[] rowData = new byte[planes[0].getRowStride()];
        for (int i = 0; i < planes.length; ++i) {
            int shift = i == 0 ? 0 : 1;
            Image.Plane plane = null;
            if (i == 0) {
                plane = planes[0];
            } else if (i == 1) {
                plane = planes[2];
            } else if (i == 2) {
                plane = planes[1];
            }
            ByteBuffer buffer = plane.getBuffer();
            int rowStride = plane.getRowStride();
            int pixelStride = plane.getPixelStride();
            int w = crop.width() >> shift;
            int h = crop.height() >> shift;
            ((Buffer)buffer).position(rowStride * (crop.top >> shift) + pixelStride * (crop.left >> shift));
            for (int row = 0; row < h; ++row) {
                int length;
                int bytesPerPixel = ImageFormat.getBitsPerPixel((int)format) / 8;
                if (pixelStride == bytesPerPixel) {
                    length = w * bytesPerPixel;
                    buffer.get(this.yv12Data, offset, length);
                    offset += length;
                } else {
                    length = (w - 1) * pixelStride + bytesPerPixel;
                    buffer.get(rowData, 0, length);
                    for (int col = 0; col < w; ++col) {
                        this.yv12Data[offset++] = rowData[col * pixelStride];
                    }
                }
                if (row >= h - 1) continue;
                ((Buffer)buffer).position(buffer.position() + rowStride - length);
            }
        }
        return this.yv12Data;
    }

    private boolean checkAndroidImageFormat(Image image) {
        int format = image.getFormat();
        Image.Plane[] planes = image.getPlanes();
        boolean isValid = false;
        switch (format) {
            case 17: 
            case 35: 
            case 842094169: {
                if (planes.length == 3) {
                    isValid = true;
                    break;
                }
                GenseeLog.e((String)TAG, (String)"YUV420 format Images should have 3 planes!");
                break;
            }
            default: {
                GenseeLog.e((String)TAG, (String)"YUV420 format not support!");
            }
        }
        return isValid;
    }

    protected void processVideoData(byte[] data, int mWidth, int mHeight) {
        this.addData(data, mWidth, mHeight);
    }

    @Override
    public void setOrientation(int ortation) {
        GenseeLog.d((String)TAG, (String)("setOrientation ortation = " + ortation));
        int old = this.orientation;
        super.setOrientation(ortation);
        if (old != this.orientation && this.mPreviewRunning && this.mCameraDevice != null) {
            this.caculateRotate();
            this.notifyPreviewSize();
        }
    }

    @Override
    public void doCameraSwitch() {
        if (null != this.mViewHandler) {
            this.mViewHandler.removeMessages(10000000);
            this.mViewHandler.sendEmptyMessage(10000000);
        }
    }

    @Override
    protected boolean doCameraOpen() {
        if (null != this.mViewHandler) {
            GenseeLog.i((String)TAG, (String)"doCameraOpen sendMessageDelayed(150)");
            this.mViewHandler.removeMessages(10000001);
            this.mViewHandler.removeMessages(10000002);
            Message message = this.mViewHandler.obtainMessage();
            message.what = 10000002;
            message.obj = this.cameraIndex;
            this.mViewHandler.sendMessageDelayed(message, 150L);
        }
        return false;
    }

    @Override
    public boolean releaseCamera() {
        if (null != this.mViewHandler) {
            GenseeLog.i((String)TAG, (String)"releaseCamera sendMessageDelayed(150)");
            this.mViewHandler.removeMessages(10000001);
            this.mViewHandler.removeMessages(10000002);
            this.isCameraOpening = false;
            Message message = this.mViewHandler.obtainMessage();
            message.what = 10000001;
            this.mViewHandler.sendMessageDelayed(message, 150L);
        }
        return true;
    }

    private Range<Integer> getSuitableFps(Range<Integer>[] fpss) {
        int fpsMin = 0;
        int fpsMax = 0;
        if (null != fpss && fpss.length > 0) {
            for (int i = 0; i < fpss.length; ++i) {
                Range<Integer> fps = fpss[i];
                if (this.nBaseFrate < (Integer)fps.getLower() || this.nBaseFrate > (Integer)fps.getUpper()) continue;
                if (fpsMin <= 0 || fpsMax <= 0) {
                    fpsMin = (Integer)fps.getLower();
                    fpsMax = (Integer)fps.getUpper();
                    continue;
                }
                if ((Integer)fps.getUpper() > fpsMax) continue;
                if ((Integer)fps.getUpper() == fpsMax) {
                    if (Math.abs((Integer)fps.getLower() - this.nBaseFrate) >= Math.abs(fpsMin - this.nBaseFrate)) continue;
                    fpsMin = (Integer)fps.getLower();
                    fpsMax = (Integer)fps.getUpper();
                    continue;
                }
                fpsMin = (Integer)fps.getLower();
                fpsMax = (Integer)fps.getUpper();
            }
        }
        if (fpsMin > 0 && fpsMax > 0) {
            GenseeLog.i((String)TAG, (String)("camera fps fpsMin = " + fpsMin + " fpsMax = " + fpsMax));
            return new Range((Comparable)Integer.valueOf(fpsMin), (Comparable)Integer.valueOf(fpsMax));
        }
        GenseeLog.w((String)TAG, (String)"camera suitable fps not found");
        if (null != fpss && fpss.length > 0) {
            return fpss[0];
        }
        return null;
    }

    public static Size getOptimalPreviewSize(List<Size> sizes, int w, int h) {
        if (sizes == null) {
            GenseeLog.w((String)TAG, (String)("getOptimalPreviewSize sizes=" + sizes));
            return null;
        }
        double ASPECT_TOLERANCE = 0.05;
        double targetRatio = (double)w / (double)h;
        Size optimalSize = null;
        double minDiff = Double.MAX_VALUE;
        for (Size size : sizes) {
            double ratio;
            if (size.getWidth() < w || size.getHeight() < h || Math.abs((ratio = (double)size.getWidth() / (double)size.getHeight()) - targetRatio) > 0.05 || !((double)Math.abs(size.getHeight() - h) < minDiff)) continue;
            optimalSize = size;
            minDiff = Math.abs(size.getHeight() - h);
        }
        if (optimalSize == null) {
            minDiff = Double.MAX_VALUE;
            for (Size size : sizes) {
                if (!((double)Math.abs(size.getHeight() - h) < minDiff)) continue;
                optimalSize = size;
                minDiff = Math.abs(size.getHeight() - h);
            }
        }
        return optimalSize;
    }

    @Override
    protected void caculateRotate() {
        if (null == this.characteristics) {
            return;
        }
        Context context = this.captureCallBack.getContext();
        int result = 0;
        result = context instanceof Activity ? VideoCamera2Capture.getCameraDisplayOrientation((Activity)context, this.characteristics) : (2 == this.orientation ? 0 : 90);
        int rotation = result;
        int facing = (Integer)this.characteristics.get(CameraCharacteristics.LENS_FACING);
        int facingFront = 0;
        switch (this.orientation) {
            case 1: {
                this.videoParam.rotate = facing == facingFront ? rotation : (rotation + 180) % 360;
                break;
            }
            case 10: {
                this.videoParam.rotate = (facingFront == facing ? rotation : (rotation + 180) % 360) + 1;
                break;
            }
            case 11: 
            case 13: {
                this.videoParam.rotate = (facingFront == facing ? rotation : (rotation + 180) % 360) + 2;
                break;
            }
            case 2: {
                this.videoParam.rotate = rotation;
                break;
            }
            case 12: {
                this.videoParam.rotate = rotation + 1;
                break;
            }
        }
        GenseeLog.d((String)TAG, (String)("caculateRotate rotation = " + rotation + this.videoParam.toString() + "face = " + facing));
    }

    public static int getCameraDisplayOrientation(Activity activity, CameraCharacteristics info) {
        int result;
        int rotation = activity.getWindowManager().getDefaultDisplay().getRotation();
        int degrees = 0;
        switch (rotation) {
            case 0: {
                degrees = 0;
                break;
            }
            case 1: {
                degrees = 90;
                break;
            }
            case 2: {
                degrees = 180;
                break;
            }
            case 3: {
                degrees = 270;
            }
        }
        if ((Integer)info.get(CameraCharacteristics.LENS_FACING) == 0) {
            result = ((Integer)info.get(CameraCharacteristics.SENSOR_ORIENTATION) + degrees) % 360;
            result = (360 - result) % 360;
        } else {
            result = ((Integer)info.get(CameraCharacteristics.SENSOR_ORIENTATION) - degrees + 360) % 360;
        }
        return result;
    }

    protected void toStartPreview() {
    }

    @Override
    public void release() {
        super.release();
        this.stopBackgroundThread();
        this.stopViewThread();
    }

    private int clamp(int x, int min, int max) {
        if (x > max) {
            return max;
        }
        if (x < min) {
            return min;
        }
        return x;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void switchFlashOnOrOff(boolean bOpen) {
        Object object = this.cameraLock;
        synchronized (object) {
            if (null == this.mPreviewBuilder || null == this.mCaptureSession) {
                GenseeLog.w((String)TAG, (String)"switchFlashOnOrOff return");
                return;
            }
            if (bOpen) {
                this.mPreviewBuilder.set(CaptureRequest.FLASH_MODE, (Object)2);
            } else {
                this.mPreviewBuilder.set(CaptureRequest.FLASH_MODE, (Object)0);
            }
            try {
                this.mCaptureSession.setRepeatingRequest(this.mPreviewBuilder.build(), null, this.mBackgroundHandler);
            }
            catch (CameraAccessException e) {
                e.printStackTrace();
                return;
            }
        }
    }

    public boolean isSupportFlashOnOrOff() {
        if (null != this.characteristics) {
            return (Boolean)this.characteristics.get(CameraCharacteristics.FLASH_INFO_AVAILABLE);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void focusOnTouch(double x1, double y1, int focusWidth, int focusHeight, int viewWidth, int viewHeight) {
        int cropHeight;
        int cropWidth;
        int mDisplayRotate;
        double x = x1;
        double y = y1;
        int realPreviewWidth = this.mWidth;
        int realPreviewHeight = this.mHeight;
        int n = mDisplayRotate = 2 == this.orientation ? 0 : 90;
        if (null != this.captureCallBack && null != this.captureCallBack.getContext()) {
            Context context = this.captureCallBack.getContext();
            if (context instanceof Activity) {
                mDisplayRotate = VideoCamera2Capture.getCameraDisplayOrientation((Activity)context, this.characteristics);
            } else {
                int n2 = mDisplayRotate = 2 == this.orientation ? 0 : 90;
            }
        }
        if (90 == mDisplayRotate || 270 == mDisplayRotate) {
            realPreviewWidth = this.mHeight;
            realPreviewHeight = this.mWidth;
        }
        double imgScale = 1.0;
        double verticalOffset = 0.0;
        double horizontalOffset = 0.0;
        if (realPreviewHeight * viewWidth > realPreviewWidth * viewHeight) {
            imgScale = (double)viewWidth * 1.0 / (double)realPreviewWidth;
            verticalOffset = ((double)realPreviewHeight - (double)viewHeight / imgScale) / 2.0;
        } else {
            imgScale = (double)viewHeight * 1.0 / (double)realPreviewHeight;
            horizontalOffset = ((double)realPreviewWidth - (double)viewWidth / imgScale) / 2.0;
        }
        x = x / imgScale + horizontalOffset;
        y = y / imgScale + verticalOffset;
        if (90 == mDisplayRotate) {
            double tmp = x;
            x = y;
            y = (double)this.mHeight - tmp;
        } else if (270 == mDisplayRotate) {
            double tmp = x;
            x = (double)this.mWidth - y;
            y = tmp;
        }
        Rect cropRegion = (Rect)this.mPreviewBuilder.get(CaptureRequest.SCALER_CROP_REGION);
        if (null == cropRegion) {
            GenseeLog.e((String)TAG, (String)"can't get crop region");
            cropRegion = this.mActiveArraySize;
        }
        if (this.mHeight * (cropWidth = cropRegion.width()) > this.mWidth * (cropHeight = cropRegion.height())) {
            imgScale = (double)cropHeight * 1.0 / (double)this.mHeight;
            verticalOffset = 0.0;
            horizontalOffset = ((double)cropWidth - imgScale * (double)this.mWidth) / 2.0;
        } else {
            imgScale = (double)cropWidth * 1.0 / (double)this.mWidth;
            horizontalOffset = 0.0;
            verticalOffset = ((double)cropHeight - imgScale * (double)this.mHeight) / 2.0;
        }
        x = x * imgScale + horizontalOffset + (double)cropRegion.left;
        y = y * imgScale + verticalOffset + (double)cropRegion.top;
        double tapAreaRatio = 0.1;
        Rect rect = new Rect();
        rect.left = this.clamp((int)(x - tapAreaRatio / 2.0 * (double)cropRegion.width()), 0, cropRegion.width());
        rect.right = this.clamp((int)(x + tapAreaRatio / 2.0 * (double)cropRegion.width()), 0, cropRegion.width());
        rect.top = this.clamp((int)(y - tapAreaRatio / 2.0 * (double)cropRegion.height()), 0, cropRegion.height());
        rect.bottom = this.clamp((int)(y + tapAreaRatio / 2.0 * (double)cropRegion.height()), 0, cropRegion.height());
        GenseeLog.d((String)TAG, (String)(" rect left = " + rect.left + " right = " + rect.right + " top = " + rect.top + " bottom = " + rect.bottom));
        Object object = this.cameraLock;
        synchronized (object) {
            if (null == this.mCameraDevice || null == this.mCaptureSession || null == this.mPreviewBuilder) {
                if (null != this.onCameraInfoListener) {
                    this.onCameraInfoListener.onManualFocus(false);
                }
                return;
            }
            this.mPreviewBuilder.set(CaptureRequest.CONTROL_AF_REGIONS, (Object)new MeteringRectangle[]{new MeteringRectangle(rect, 1000)});
            this.mPreviewBuilder.set(CaptureRequest.CONTROL_AE_REGIONS, (Object)new MeteringRectangle[]{new MeteringRectangle(rect, 1000)});
            this.mPreviewBuilder.set(CaptureRequest.CONTROL_AF_MODE, (Object)1);
            this.mPreviewBuilder.set(CaptureRequest.CONTROL_AF_TRIGGER, (Object)1);
            this.mPreviewBuilder.set(CaptureRequest.CONTROL_AE_PRECAPTURE_TRIGGER, (Object)1);
            try {
                this.mCaptureSession.setRepeatingRequest(this.mPreviewBuilder.build(), this.mAfCaptureCallback, this.mBackgroundHandler);
            }
            catch (CameraAccessException e) {
                GenseeLog.e((String)TAG, (String)("setRepeatingRequest failed, " + e.getMessage()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSupportFocusAuto() {
        Object object = this.cameraLock;
        synchronized (object) {
            if (null == this.characteristics) {
                return false;
            }
            int[] afs = (int[])this.characteristics.get(CameraCharacteristics.CONTROL_AF_AVAILABLE_MODES);
            if (null == afs || afs.length <= 0) {
                return false;
            }
            for (int af : afs) {
                GenseeLog.d((String)TAG, (String)("isSupportFocusAuto af = " + af));
                if (af != 1) continue;
                return true;
            }
            return false;
        }
    }

    @Override
    public boolean isCameraSwitchEnable() {
        try {
            this.cameraManager = (CameraManager)this.captureCallBack.getContext().getSystemService("camera");
            String[] ids = this.cameraManager.getCameraIdList();
            return ids == null ? false : ids.length > 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}

