/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.view;

import android.content.Context;
import android.graphics.SurfaceTexture;
import android.hardware.Camera;
import android.util.AttributeSet;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import com.gensee.util.ResourceUtil;
import com.gensee.utils.GenseeLog;
import com.gensee.videoparam.IVideoCoreInterface;
import com.gensee.videoparam.OnVideoHardEncodeDataCallback;
import com.gensee.view.ILocalVideoView;
import com.gensee.view.VideoCameraCapture;
import com.gensee.view.VideoCapture;
import com.gensee.view.beauty.IGSLocalVideoView;
import java.io.IOException;

public class LocalVideoView
extends SurfaceView
implements SurfaceHolder.Callback,
IGSLocalVideoView,
VideoCapture.OnCaptureCallBack {
    private static final String TAG = "LocalVideoHolder";
    private VideoCapture capture;
    private SurfaceHolder mHolder;

    public LocalVideoView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        ResourceUtil.getIns().attachCtx(this.getContext());
        SurfaceHolder mSurfaceHolder = this.getHolder();
        mSurfaceHolder.setType(3);
        mSurfaceHolder.addCallback((SurfaceHolder.Callback)this);
        this.capture = new VideoCameraCapture();
        this.capture.setOnCaptureCallBack(this);
    }

    public LocalVideoView(Context context) {
        this(context, null);
    }

    public LocalVideoView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
        Camera camera = this.capture.getCamera();
        if (camera != null) {
            this.capture.rePreView();
        } else {
            this.mHolder = holder;
        }
    }

    public void surfaceCreated(SurfaceHolder holder) {
        this.capture.setOnCaptureCallBack(this);
        this.mHolder = holder;
        this.capture.surfaceAvailable();
        GenseeLog.d((String)TAG, (String)"surfaceCreated ");
    }

    public void surfaceDestroyed(SurfaceHolder holder) {
        this.capture.releaseCamera();
        this.capture.setOnCaptureCallBack(null);
        this.mHolder = null;
        GenseeLog.d((String)TAG, (String)"surfaceDestroyed ");
    }

    @Override
    public boolean isHolderCreated() {
        return this.mHolder != null;
    }

    public boolean open(Object param, IVideoCoreInterface iVideoCoreInterface) {
        this.capture.open(param, iVideoCoreInterface);
        this.post(new Runnable(){

            @Override
            public void run() {
                if (LocalVideoView.this.getVisibility() != 0) {
                    LocalVideoView.this.setVisibility(0);
                }
                LocalVideoView.this.capture.cameraOpen();
            }
        });
        return false;
    }

    public boolean isCameraSwitchEnable() {
        return this.capture.isCameraSwitchEnable();
    }

    public void doCameraSwitch() {
        this.capture.doCameraSwitch();
    }

    public int getOrientation() {
        return this.capture.getOrientation();
    }

    public void setOrientation(int ortation) {
        this.capture.setOrientation(ortation);
    }

    public boolean close() {
        return this.capture.close();
    }

    public Camera getCamera() {
        return this.capture.getCamera();
    }

    public void setHardEncode(boolean isHardEncode) {
        this.capture.setHardEncode(isHardEncode);
    }

    public boolean isVideoHardEncode() {
        return this.capture.isVideoHardEncode();
    }

    public void setOnCameraPermissionListener(ILocalVideoView.OnCameraPermissionListener onCameraPermissionListener) {
        this.capture.setOnCameraPermissionListener(onCameraPermissionListener);
    }

    public void setOnCameraInfoListener(ILocalVideoView.OnCameraInfoListener onCameraInfoListener) {
        this.capture.setOnCameraInfoListener(onCameraInfoListener);
    }

    @Override
    public boolean onSetPreviewHolder(Camera camera) throws IOException {
        if (camera != null && this.mHolder != null) {
            camera.setPreviewDisplay(this.mHolder);
            return true;
        }
        return false;
    }

    @Override
    public SurfaceTexture getSurfaceTexTure() {
        return null;
    }

    public void setVideoSize(int width, int height) {
        this.capture.setVideoSize(this.getContext(), width, height);
    }

    public void release() {
        this.capture.release();
    }

    public void setVideoCore(IVideoCoreInterface iVideoCoreInterface) {
        this.capture.setVideoCore(iVideoCoreInterface);
    }

    public void setHardEncodeDataCallback(OnVideoHardEncodeDataCallback callback) {
        this.capture.setHardEncodeDataCallback(callback);
    }

    public void setFps(int fps) {
        this.capture.setFps(fps);
    }

    public void setBitRate(int bitRate) {
        this.capture.setBitRate(bitRate);
    }

    public void switchFlashOnOrOff(boolean bOpen) {
        this.capture.switchFlashOnOrOff(bOpen);
    }

    public boolean isSupportFlashOnOrOff() {
        return this.capture.isSupportFlashOnOrOff();
    }

    public void focusOnTouch(double x, double y, int focusWidth, int focusHeight, int viewWidth, int viewHeight) {
        this.capture.focusOnTouch(x, y, focusWidth, focusHeight, viewWidth, viewHeight);
    }

    public boolean isSupportFocusAuto() {
        return this.capture.isSupportFocusAuto();
    }

    public void forceKeyFrame() {
        this.capture.forceKeyFrame();
    }

    @Override
    public void reOpenCamera() {
        this.post(new Runnable(){

            @Override
            public void run() {
                if (LocalVideoView.this.getVisibility() != 0) {
                    LocalVideoView.this.setVisibility(0);
                }
                if (null != LocalVideoView.this.capture) {
                    LocalVideoView.this.capture.cameraOpen();
                }
            }
        });
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        ResourceUtil.getIns().detachCtx();
    }
}

