/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.util;

import android.content.Context;
import com.gensee.util.Reflection;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;

public class ResourceUtil {
    private static ResourceUtil instance;
    private Context context;

    private ResourceUtil() {
    }

    public static ResourceUtil getIns() {
        if (null == instance) {
            instance = new ResourceUtil();
        }
        return instance;
    }

    public Context getContext() {
        return this.context;
    }

    public void attachCtx(Context context) {
        this.context = context;
        Reflection.exemptAll();
    }

    public void detachCtx() {
        this.context = null;
    }

    public String readAssetsAsString(String path) {
        this.checkCtx();
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(this.context.getAssets().open(path), "UTF-8"));
            StringBuffer buffer = new StringBuffer();
            String str = reader.readLine();
            while (str != null) {
                buffer.append(str);
                buffer.append("\n");
                str = reader.readLine();
            }
            return buffer.toString();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private boolean checkCtx() {
        if (null == this.context) {
            throw new RuntimeException("ResourceUtil's context is null ");
        }
        return true;
    }

    public boolean isHorizontal() {
        this.checkCtx();
        return this.context.getResources().getConfiguration().orientation == 2;
    }
}

