/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.util;

import java.util.concurrent.LinkedBlockingQueue;

public class RecycleQueue<T> {
    private LinkedBlockingQueue<T> queue;
    private LinkedBlockingQueue<T> cache;

    private RecycleQueue() {
    }

    public RecycleQueue(int capacity) {
        if (null == this.queue) {
            this.queue = new LinkedBlockingQueue(capacity);
        }
        if (null == this.cache) {
            this.cache = new LinkedBlockingQueue(capacity);
        }
    }

    public void offer(T entry) {
        this.queue.offer(entry);
    }

    public T poll() {
        return this.queue.poll();
    }

    public T take() throws InterruptedException {
        return this.queue.take();
    }

    public T pullFromCache() {
        return this.cache.poll();
    }

    public T takeFromCache() throws InterruptedException {
        return this.cache.take();
    }

    public void recycle(T entry) {
        this.cache.offer(entry);
    }

    public void release() {
        this.queue.clear();
        this.queue.clear();
    }
}

