/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.texture.sticker;

import android.graphics.Bitmap;
import android.graphics.RectF;
import android.util.Size;
import com.gensee.texture.sticker.BaseSticker;
import com.gensee.utils.GenseeLog;

public class ImageSticker
extends BaseSticker {
    private Object bitmapLock = new Object();
    private ImageStickerParam param;

    public ImageSticker() {
        this(new int[1]);
        this.name = "ImageSticker";
    }

    public ImageSticker(int[] textureId) {
        super(textureId);
    }

    @Override
    public void init() {
        super.init();
        this.updateSize(this.outputWidth, this.outputHeight, this.viewWidth, this.viewHeight);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setParam(ImageStickerParam param) {
        Object object = this.bitmapLock;
        synchronized (object) {
            this.param = param;
        }
        this.updateSize(this.outputWidth, this.outputHeight, this.viewWidth, this.viewHeight);
    }

    @Override
    public void updateSize(int outputWidth, int outputHeight, int viewWidth, int viewHeight) {
        this.outputWidth = outputWidth;
        this.outputHeight = outputHeight;
        this.viewWidth = viewWidth;
        this.viewHeight = viewHeight;
        this.calculateAndUpdateLocation(true, this.param.desVideoLogoMarginTop, this.param.desVideoLogoMarginRight);
        this.outputPosition = this.position;
        this.outputTexCoordinate = this.texCoordinate;
    }

    private void calculateAndUpdateLocation(boolean isOutput, int marginTop, int marginRight) {
        float bottom;
        float top;
        float left;
        float right;
        int bitmapW = this.param.bitmap.getWidth();
        int bitmapH = this.param.bitmap.getHeight();
        if (isOutput) {
            right = 1.0f - (float)marginRight / (float)this.outputWidth;
            left = right - (float)bitmapW / (float)this.outputWidth;
            top = 1.0f - (float)marginTop / (float)this.outputHeight;
            bottom = top - (float)bitmapH / (float)this.outputHeight;
            this.updateLocation(new float[]{0.0f, 1.0f, 1.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f}, new float[]{left, bottom, right, bottom, left, top, right, top});
        } else {
            int destViewWidth = this.viewWidth;
            int destViewHeight = this.viewHeight;
            float viewScale = (float)this.viewWidth / (float)this.viewHeight;
            float videoScale = (float)this.outputWidth / (float)this.outputHeight;
            if (viewScale > videoScale) {
                destViewWidth = (int)((float)this.viewHeight * videoScale);
            } else {
                destViewHeight = (int)((float)this.viewWidth / videoScale);
            }
            right = 1.0f - (float)(this.viewWidth - destViewWidth) / 2.0f / (float)this.viewHeight - (float)marginRight / (float)this.viewWidth;
            left = right - (float)bitmapW / (float)destViewWidth;
            top = 1.0f - (float)(this.viewHeight - destViewHeight) / 2.0f / (float)this.viewHeight - (float)marginTop / (float)this.viewHeight;
            bottom = top - (float)bitmapH / (float)destViewHeight;
            this.updateLocation(new float[]{0.0f, 1.0f, 1.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f}, new float[]{left, bottom, right, bottom, left, 0.5f, right, 0.5f});
        }
        GenseeLog.i((String)this.TAG, (String)("calculateAndUpdateLocation left=" + left + ",right=" + right + ",bottom=" + bottom + ",top=" + top + ",  marginTop = [" + marginTop + "], marginRight = [" + marginRight + "]"));
    }

    @Override
    protected RectF getRect() {
        return this.param.getRect(this.outputWidth, this.outputHeight);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void draw(float[] transformMatrix) {
        Object object = this.bitmapLock;
        synchronized (object) {
            if (null != this.param.bitmap && !this.param.bitmap.isRecycled()) {
                this.bindTexture(this.param.bitmap);
            }
        }
        this.active();
        this.draw();
        this.inactive();
    }

    public static class ImageStickerParam {
        public float x;
        public float y;
        public float scale;
        public Size size;
        public Bitmap bitmap;
        public int localVideoLogoMarginTop;
        public int localVideoLogoMarginRight;
        public int desVideoLogoMarginTop;
        public int desVideoLogoMarginRight;

        public ImageStickerParam(Bitmap bitmap, int localVideoLogoMarginTop, int localVideoLogoMarginRight, int desVideoLogoMarginTop, int desVideoLogoMarginRight) {
            this.bitmap = bitmap;
            this.size = new Size(bitmap.getWidth(), bitmap.getHeight());
            this.x = 0.03f;
            this.y = 0.02f;
            this.scale = 1.2f;
            this.localVideoLogoMarginTop = localVideoLogoMarginTop;
            this.localVideoLogoMarginRight = localVideoLogoMarginRight;
            this.desVideoLogoMarginTop = desVideoLogoMarginTop;
            this.desVideoLogoMarginRight = desVideoLogoMarginRight;
        }

        public RectF getRect(int width, int height) {
            RectF rect = new RectF();
            rect.left = -1.0f;
            rect.top = 1.0f;
            rect.right = rect.left + (float)(this.size.getWidth() + this.desVideoLogoMarginRight) / (float)width * this.scale;
            rect.bottom = rect.top - (float)(this.size.getHeight() + this.desVideoLogoMarginTop) / (float)height * this.scale;
            rect.offset(this.x * 2.0f, -this.y * 2.0f);
            return rect;
        }
    }
}

