/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.texture.sticker;

import android.graphics.Bitmap;
import android.graphics.RectF;
import android.opengl.GLES20;
import android.opengl.GLUtils;
import com.gensee.texture.BaseTexture;
import java.nio.FloatBuffer;

public abstract class BaseSticker
extends BaseTexture {
    private final String VERTEX_STICKER = "attribute vec4 aPosition;\nattribute vec2 aTextureCoord;\nvarying vec2 vTextureCoord;\nvoid main(){\n    gl_Position= aPosition;\n    vTextureCoord = aTextureCoord;\n}";
    private final String FRAGMENT_STICKER = "precision mediump float;\nvarying mediump vec2 vTextureCoord;\nuniform sampler2D uTexture;\nvoid main(){\n    vec4 color = texture2D(uTexture, vTextureCoord);\n    gl_FragColor = color;\n}";
    public int outputWidth = 0;
    public int outputHeight = 0;
    public int viewWidth;
    public int viewHeight;
    private int aPositionLocation = 0;
    private int aTextureCoordinateLocation = 0;
    private int uTextureLocation = 0;
    private int[] texture = new int[1];
    protected FloatBuffer outputPosition;
    protected FloatBuffer screenPosition;
    protected FloatBuffer outputTexCoordinate;
    protected FloatBuffer screenTexCoordinate;

    public BaseSticker(int[] textureId) {
        super(textureId);
    }

    @Override
    public void init() {
        super.init();
        if (this.outputWidth <= 0 || this.outputHeight <= 0) {
            throw new RuntimeException("Width and height cannot be 0");
        }
        this.createProgram();
        this.createTexture(this.texture);
    }

    private void createProgram() {
        this.shaderProgram = this.createProgram("attribute vec4 aPosition;\nattribute vec2 aTextureCoord;\nvarying vec2 vTextureCoord;\nvoid main(){\n    gl_Position= aPosition;\n    vTextureCoord = aTextureCoord;\n}", "precision mediump float;\nvarying mediump vec2 vTextureCoord;\nuniform sampler2D uTexture;\nvoid main(){\n    vec4 color = texture2D(uTexture, vTextureCoord);\n    gl_FragColor = color;\n}");
        this.aPositionLocation = this.getAttribLocation("aPosition");
        this.uTextureLocation = this.getUniformLocation("uTexture");
        this.aTextureCoordinateLocation = this.getAttribLocation("aTextureCoord");
    }

    private void createTexture(int[] texture) {
        GLES20.glGenTextures((int)texture.length, (int[])texture, (int)0);
        GLES20.glBindTexture((int)3553, (int)texture[0]);
        GLES20.glTexParameterf((int)3553, (int)10240, (float)9729.0f);
        GLES20.glTexParameterf((int)3553, (int)10241, (float)9729.0f);
        GLES20.glTexParameterf((int)3553, (int)10242, (float)33071.0f);
        GLES20.glTexParameterf((int)3553, (int)10243, (float)33071.0f);
        GLES20.glBindTexture((int)3553, (int)0);
    }

    public void updateSize(int outputWidth, int outputHeight, int viewWidth, int viewHeight) {
        this.outputWidth = outputWidth;
        this.outputHeight = outputHeight;
        this.viewWidth = viewWidth;
        this.viewHeight = viewHeight;
        RectF rect = this.getRect();
        this.updateLocation(new float[]{0.0f, 1.0f, 1.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f}, new float[]{rect.left, rect.bottom, rect.right, rect.bottom, rect.left, rect.top, rect.right, rect.top});
    }

    protected abstract RectF getRect();

    void bindTexture(Bitmap bitmap) {
        GLES20.glBindTexture((int)3553, (int)this.texture[0]);
        GLUtils.texImage2D((int)3553, (int)0, (Bitmap)bitmap, (int)0);
        GLES20.glBindTexture((int)3553, (int)0);
    }

    void active() {
        GLES20.glUseProgram((int)this.shaderProgram);
        GLES20.glBindFramebuffer((int)36160, (int)this.textureId[0]);
        GLES20.glActiveTexture((int)33984);
        GLES20.glBindTexture((int)3553, (int)this.texture[0]);
        this.setUniform1i(this.uTextureLocation, 0);
        this.enableVertex(this.aPositionLocation, this.aTextureCoordinateLocation);
        GLES20.glEnable((int)3042);
        GLES20.glBlendFunc((int)1, (int)771);
    }

    public void draw() {
        this.drawer.draw();
    }

    void inactive() {
        this.disableVertex(this.aPositionLocation, this.aTextureCoordinateLocation);
        GLES20.glBindFramebuffer((int)36160, (int)0);
        GLES20.glBindTexture((int)3553, (int)0);
        GLES20.glDisable((int)3042);
        GLES20.glUseProgram((int)0);
        GLES20.glFlush();
    }

    @Override
    public void release() {
        super.release();
        GLES20.glDeleteTextures((int)this.texture.length, (int[])this.texture, (int)0);
    }
}

