/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.texture.filter;

import android.opengl.GLES20;
import com.gensee.texture.filter.BaseFilter;

public class NormalFilter
extends BaseFilter {
    private int aPositionLocation = 0;
    private int uTextureLocation = 0;
    private int aTextureCoordinateLocation = 0;

    public NormalFilter() {
        this(0, 0, new int[1]);
    }

    public NormalFilter(int width, int height, int[] textureId) {
        super(width, height, textureId);
    }

    @Override
    public void init() {
        super.init();
        this.aPositionLocation = this.getAttribLocation("aPosition");
        this.uTextureLocation = this.getUniformLocation("uTexture");
        this.aTextureCoordinateLocation = this.getAttribLocation("aTextureCoord");
        GLES20.glUseProgram((int)0);
    }

    @Override
    public String getVertex() {
        return "attribute vec4 aPosition;\nattribute vec2 aTextureCoord;\nvarying vec2 vTextureCoord;\nvoid main(){\n    gl_Position= aPosition;\n    vTextureCoord = aTextureCoord;\n}";
    }

    @Override
    public String getFragment() {
        return "precision mediump float;\nvarying mediump vec2 vTextureCoord;\nuniform sampler2D uTexture;\nvoid main(){\n    vec4 color = vec4(texture2D(uTexture, vTextureCoord).rgb, 1.0);\n    gl_FragColor = color;\n}";
    }

    @Override
    public void draw(float[] transformMatrix) {
        this.active(this.uTextureLocation);
        this.enableVertex(this.aPositionLocation, this.aTextureCoordinateLocation);
        this.draw();
        this.disableVertex(this.aPositionLocation, this.aTextureCoordinateLocation);
        this.inactive();
    }
}

