/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.texture.filter;

import com.gensee.texture.BaseTexture;
import com.gensee.texture.filter.BaseFilter;
import com.gensee.texture.filter.NormalFilter;
import com.gensee.texture.sticker.BaseSticker;
import com.gensee.utils.GenseeLog;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;

public class GroupFilter
extends BaseFilter {
    private BaseFilter mFilter;
    private LinkedBlockingQueue<BaseTexture> initList = new LinkedBlockingQueue();
    private LinkedBlockingQueue<BaseTexture> releaseList = new LinkedBlockingQueue();
    private List<BaseFilter> filters = new ArrayList<BaseFilter>();
    private ArrayList<BaseSticker> stickers = new ArrayList();
    private NormalFilter lastFilter = null;
    private boolean deFlashing = true;

    public static GroupFilter create(BaseFilter baseFilter) {
        return new GroupFilter(baseFilter);
    }

    private GroupFilter(int width, int height, int[] textureId) {
        super(width, height, textureId);
    }

    private GroupFilter(BaseFilter baseFilter) {
        this(0, 0, new int[1]);
        this.mFilter = baseFilter;
        this.addFilter(this.mFilter);
    }

    @Override
    public void init() {
        if (this.width <= 0 || this.height <= 0) {
            throw new RuntimeException("Width and height cannot be 0");
        }
        this.initDeFlashing();
        this.initList();
    }

    public GroupFilter addFilter(BaseFilter filter) {
        this.addToInitList(filter);
        return this;
    }

    public GroupFilter addSticker(BaseSticker sticker) {
        this.addToInitList(sticker);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFilter(BaseFilter baseFilter) {
        List<BaseFilter> list = this.filters;
        synchronized (list) {
            this.filters.remove(baseFilter);
        }
        this.updateLink();
        this.addToReleaseList(baseFilter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeSticker(BaseSticker baseSticker) {
        ArrayList<BaseSticker> arrayList = this.stickers;
        synchronized (arrayList) {
            this.stickers.remove(baseSticker);
        }
        this.addToReleaseList(baseSticker);
    }

    private void printLink() {
        StringBuffer bf = new StringBuffer();
        for (int i = 0; i < this.filters.size(); ++i) {
            bf.append(this.filters.get((int)i).textureId[0]).append("->").append(this.filters.get((int)i).frameBuffer[0]).append("(").append(this.filters.get((int)i).frameBufferTexture[0]).append(")");
        }
        GenseeLog.i((String)("Link: " + bf.toString()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateLink() {
        List<BaseFilter> list = this.filters;
        synchronized (list) {
            BaseFilter firstFilter = this.filters.get(0);
            firstFilter.textureId = this.textureId;
            this.frameBuffer[0] = firstFilter.frameBuffer[0];
            int[] lastFrameBufferTexture = firstFilter.frameBufferTexture;
            for (int i = 0; i < this.filters.size(); ++i) {
                if (0 == i) continue;
                this.filters.get((int)i).textureId = lastFrameBufferTexture;
                lastFrameBufferTexture = this.filters.get((int)i).frameBufferTexture;
            }
            if (null == this.lastFilter) {
                this.frameBufferTexture[0] = lastFrameBufferTexture[0];
            } else {
                this.lastFilter.textureId = lastFrameBufferTexture;
                this.frameBufferTexture[0] = this.lastFilter.frameBufferTexture[0];
            }
            ArrayList<BaseSticker> arrayList = this.stickers;
            synchronized (arrayList) {
                for (int i = 0; i < this.stickers.size(); ++i) {
                    this.stickers.get((int)i).textureId = this.filters.get((int)(this.filters.size() - 1)).frameBuffer;
                }
            }
            this.printLink();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToInitList(BaseTexture baseTexture) {
        LinkedBlockingQueue<BaseTexture> linkedBlockingQueue = this.initList;
        synchronized (linkedBlockingQueue) {
            this.initList.offer(baseTexture);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToReleaseList(BaseTexture texture) {
        LinkedBlockingQueue<BaseTexture> linkedBlockingQueue = this.releaseList;
        synchronized (linkedBlockingQueue) {
            this.releaseList.offer(texture);
        }
    }

    private void initDeFlashing() {
        if (this.deFlashing && null == this.lastFilter) {
            this.lastFilter = new NormalFilter(this.width, this.height, this.textureId);
            this.lastFilter.init();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initList() {
        if (this.initList.isEmpty()) {
            return;
        }
        if (this.width <= 0 || this.height <= 0) {
            throw new RuntimeException("Width and height cannot be 0");
        }
        LinkedBlockingQueue<BaseTexture> linkedBlockingQueue = this.initList;
        synchronized (linkedBlockingQueue) {
            BaseTexture texture = this.initList.poll();
            if (texture instanceof BaseFilter) {
                List<BaseFilter> list = this.filters;
                synchronized (list) {
                    ((BaseFilter)texture).width = this.width;
                    ((BaseFilter)texture).height = this.height;
                    texture.init();
                    this.filters.add((BaseFilter)texture);
                    this.updateLink();
                }
            } else if (texture instanceof BaseSticker) {
                ArrayList<BaseSticker> arrayList = this.stickers;
                synchronized (arrayList) {
                    ((BaseSticker)texture).outputWidth = this.width;
                    ((BaseSticker)texture).outputHeight = this.height;
                    texture.init();
                    this.stickers.add((BaseSticker)texture);
                    this.updateLink();
                }
            } else if (null != texture) {
                texture.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseList() {
        if (this.releaseList.isEmpty()) {
            return;
        }
        LinkedBlockingQueue<BaseTexture> linkedBlockingQueue = this.releaseList;
        synchronized (linkedBlockingQueue) {
            BaseTexture texture = this.releaseList.poll();
            if (null != texture) {
                texture.release();
            }
        }
    }

    public void updateImageParam(int x) {
    }

    @Override
    public String getVertex() {
        return "shader/vertex_normal.glsl";
    }

    @Override
    public String getFragment() {
        return "shader/fragment_normal.glsl";
    }

    @Override
    public void draw(float[] transformMatrix) {
        this.initList();
        this.releaseList();
        this.drawFilters();
        this.drawStickers();
        this.lastFilter.draw(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drawFilters() {
        List<BaseFilter> list = this.filters;
        synchronized (list) {
            if (this.filters.isEmpty()) {
                return;
            }
            for (int i = 0; i < this.filters.size(); ++i) {
                this.filters.get(i).draw(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drawStickers() {
        ArrayList<BaseSticker> arrayList = this.stickers;
        synchronized (arrayList) {
            if (this.stickers.isEmpty()) {
                return;
            }
            for (int i = 0; i < this.stickers.size(); ++i) {
                this.stickers.get(i).draw(null);
            }
        }
    }

    public void updateStickerSize(int outputWidth, int outputHeight, int viewWidth, int viewHeight) {
        if (null != this.stickers) {
            for (int i = 0; i < this.stickers.size(); ++i) {
                BaseSticker baseSticker = this.stickers.get(i);
                baseSticker.updateSize(outputWidth, outputHeight, viewWidth, viewHeight);
            }
        }
    }
}

