/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.texture.filter;

import android.opengl.GLES20;
import com.gensee.texture.BaseFrameBufferTexture;

public abstract class BaseFilter
extends BaseFrameBufferTexture {
    public abstract String getVertex();

    public abstract String getFragment();

    public BaseFilter(int width, int height, int[] textureId) {
        super(width, height, textureId);
    }

    @Override
    public void init() {
        super.init();
        if (this.width <= 0 || this.height <= 0) {
            throw new RuntimeException("Width and height cannot be 0");
        }
        this.shaderProgram = this.createProgram(this.getVertex(), this.getFragment());
        this.initFrameBuffer();
    }

    public void active(int samplerLocation) {
        GLES20.glUseProgram((int)this.shaderProgram);
        GLES20.glBindFramebuffer((int)36160, (int)this.frameBuffer[0]);
        GLES20.glActiveTexture((int)33984);
        GLES20.glBindTexture((int)3553, (int)this.textureId[0]);
        this.setUniform1i(samplerLocation, 0);
    }

    public void inactive() {
        GLES20.glBindFramebuffer((int)36160, (int)0);
        GLES20.glBindTexture((int)3553, (int)0);
        GLES20.glUseProgram((int)0);
        GLES20.glFlush();
    }

    protected void draw() {
        this.drawer.draw();
    }
}

