/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.texture;

import android.graphics.SurfaceTexture;
import android.opengl.GLES20;
import com.gensee.egl.Egl;
import com.gensee.texture.BaseTexture;
import com.gensee.util.GLHelper;

public abstract class TextureManager {
    public SurfaceTexture surfaceTexture;
    public Egl egl = null;
    public int[] textureId;
    protected BaseTexture texture;

    public abstract void draw(float[] var1);

    protected void createTexture(int target) {
        if (null == this.textureId) {
            this.textureId = new int[1];
        } else {
            GLES20.glDeleteTextures((int)1, (int[])this.textureId, (int)0);
        }
        this.textureId[0] = 0;
        GLES20.glGenTextures((int)1, (int[])this.textureId, (int)0);
        GLES20.glBindTexture((int)target, (int)this.textureId[0]);
        GLES20.glTexParameterf((int)target, (int)10241, (float)9729.0f);
        GLES20.glTexParameterf((int)target, (int)10240, (float)9729.0f);
        GLES20.glTexParameterf((int)target, (int)10242, (float)33071.0f);
        GLES20.glTexParameterf((int)target, (int)10243, (float)33071.0f);
        GLHelper.checkGLES2Error("createTexture");
    }

    public abstract void updateLocation(int var1, int var2, int var3, int var4);

    public void updateInputTexture(int[] textureId) {
        this.textureId = textureId;
        this.texture.textureId = textureId;
    }

    public void release() {
        this.egl.makeCurrent();
        this.texture.release();
        this.texture = null;
        this.egl.release();
        this.egl = null;
    }
}

