/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.texture;

import android.graphics.SurfaceTexture;
import android.opengl.EGLContext;
import com.gensee.egl.Egl;
import com.gensee.texture.NormalTexture;
import com.gensee.texture.TextureManager;
import com.gensee.utils.GenseeLog;

public class ScreenTextureManager
extends TextureManager {
    public ScaleType scaleType = ScaleType.CENTER_CROP;

    public ScreenTextureManager(SurfaceTexture screenTexture, int[] textureId, EGLContext eglContext) {
        this.surfaceTexture = screenTexture;
        this.init(screenTexture, textureId, eglContext);
        this.updateInputTexture(textureId);
    }

    private void init(SurfaceTexture screenTexture, int[] textureId, EGLContext eglContext) {
        if (null != screenTexture) {
            this.egl = new Egl(">>Screen<<");
            this.egl.initEGL(screenTexture, eglContext);
            this.egl.makeCurrent();
            if (null == textureId) {
                throw new RuntimeException("textureId can not be null");
            }
            if (null == this.texture) {
                this.texture = new NormalTexture(textureId);
            }
            this.texture.name = "Screen Texture";
        } else {
            GenseeLog.e((String)"Egl create failed");
        }
    }

    public void updateTexture(SurfaceTexture screenTexture, int[] textureId, EGLContext eglContext) {
        if (this.surfaceTexture != screenTexture) {
            this.init(screenTexture, textureId, eglContext);
        }
        this.updateInputTexture(textureId);
    }

    @Override
    public void draw(float[] transformMatrix) {
        if (null == this.texture) {
            GenseeLog.e((String)"Render failed. Texture is null");
            return;
        }
        this.texture.draw(transformMatrix);
    }

    @Override
    public void updateLocation(int viewWidth, int viewHeight, int outputWidth, int outputHeight) {
        float[] location = new float[8];
        float[] textureLocation = new float[8];
        this.calculateLocation(viewWidth, viewHeight, outputWidth, outputHeight, location, textureLocation);
        this.texture.updateLocation(textureLocation, location);
    }

    private void calculateLocation(int viewWidth, int viewHeight, int outputWidth, int outputHeight, float[] location, float[] textureLocation) {
        GenseeLog.i((String)("calculateLocation() viewWidth = [" + viewWidth + "], viewHeight = [" + viewHeight + "], outputWidth = [" + outputWidth + "], outputHeight = [" + outputHeight + "], location = [" + location + "], textureLocation = [" + textureLocation + "]"));
        float left = 0.0f;
        float right = 0.0f;
        float bottom = 0.0f;
        float top = 0.0f;
        int destViewWidth = viewWidth;
        int destViewHeight = viewHeight;
        if (this.scaleType == ScaleType.CENTER_CROP) {
            float widthScale = (float)viewWidth / (float)outputWidth;
            float heightScale = (float)viewHeight / (float)outputHeight;
            float max = Math.max(widthScale, heightScale);
            destViewWidth = (int)((float)outputWidth * max);
            destViewHeight = (int)((float)outputHeight * max);
            left = (float)(-destViewWidth) / (float)viewWidth;
            right = -left;
            bottom = (float)(-destViewHeight) / (float)viewHeight;
            top = -bottom;
        } else if (this.scaleType == ScaleType.CENTER_INSIDE) {
            float viewScale = (float)viewWidth / (float)viewHeight;
            float videoScale = (float)outputWidth / (float)outputHeight;
            if (viewScale > videoScale) {
                destViewWidth = (int)((float)viewHeight * videoScale);
            } else {
                destViewHeight = (int)((float)viewWidth / videoScale);
            }
            left = (float)(-destViewWidth) / (float)viewWidth;
            right = -left;
            bottom = (float)(-destViewHeight) / (float)viewHeight;
            top = -bottom;
        }
        GenseeLog.i((String)("screen left=" + left + ",right=" + right + ",bottom=" + bottom + ",top=" + top));
        System.arraycopy(new float[]{left, bottom, right, bottom, left, top, right, top}, 0, location, 0, 8);
        System.arraycopy(new float[]{0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f}, 0, textureLocation, 0, 8);
    }

    private float getCoordinate(float distance) {
        return 0.0f == distance ? distance : 1.0f - distance;
    }

    public static enum ScaleType {
        CENTER_CROP,
        CENTER_INSIDE;

    }
}

