/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.texture;

import android.opengl.GLES20;
import com.gensee.texture.BaseTexture;

public class NormalTexture
extends BaseTexture {
    private float[] VERTICES_SCREEN = new float[]{0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f};
    private int aPositionLocation = 0;
    private int aTextureCoordinateLocation = 0;
    private int uTextureLocation = 0;

    public NormalTexture(int[] textureId) {
        super(textureId);
        this.init();
        this.createProgram();
    }

    private void createProgram() {
        this.shaderProgram = this.createProgram("attribute vec4 aPosition;\nattribute vec2 aTextureCoord;\nvarying vec2 vTextureCoord;\nvoid main(){\n    gl_Position= aPosition;\n    vTextureCoord = aTextureCoord;\n}", "precision mediump float;\nvarying mediump vec2 vTextureCoord;\nuniform sampler2D uTexture;\nvoid main(){\n    vec4 color = vec4(texture2D(uTexture, vTextureCoord).rgb, 1.0);\n    gl_FragColor = color;\n}");
        this.aPositionLocation = this.getAttribLocation("aPosition");
        this.uTextureLocation = this.getUniformLocation("uTexture");
        this.aTextureCoordinateLocation = this.getAttribLocation("aTextureCoord");
    }

    @Override
    public void draw(float[] transformMatrix) {
        GLES20.glUseProgram((int)this.shaderProgram);
        GLES20.glActiveTexture((int)33984);
        GLES20.glBindTexture((int)3553, (int)this.textureId[0]);
        GLES20.glUniform1i((int)this.uTextureLocation, (int)0);
        this.enableVertex(this.aPositionLocation, this.aTextureCoordinateLocation);
        this.drawer.draw();
        GLES20.glDisableVertexAttribArray((int)this.aPositionLocation);
        GLES20.glDisableVertexAttribArray((int)this.aTextureCoordinateLocation);
        GLES20.glBindTexture((int)3553, (int)0);
        GLES20.glUseProgram((int)0);
        GLES20.glFlush();
    }
}

