/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.texture;

import android.opengl.EGLContext;
import android.view.Surface;
import com.gensee.egl.Egl;
import com.gensee.texture.NormalTexture;
import com.gensee.texture.TextureManager;
import com.gensee.utils.GenseeLog;

public class CodeCTextureManager
extends TextureManager {
    private Surface surface;

    public CodeCTextureManager(Surface surface, int[] textureId, EGLContext eglContext) {
        this.surface = surface;
        this.egl = new Egl("Codec");
        this.egl.initEGL(surface, eglContext);
        this.egl.makeCurrent();
        if (null == textureId) {
            throw new RuntimeException("textureId can not be null");
        }
        this.texture = new NormalTexture(textureId);
        this.texture.name = "CodeC";
    }

    @Override
    public void draw(float[] transformMatrix) {
        if (null == this.texture) {
            GenseeLog.e((String)"Render failed. Texture is null");
            return;
        }
        this.texture.draw(transformMatrix);
    }

    @Override
    public void release() {
        GenseeLog.i((String)"CodeCTextureManager release");
        super.release();
        this.surface.release();
    }

    @Override
    public void updateLocation(int viewWidth, int viewHeight, int outputWidth, int outputHeight) {
    }
}

