/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.texture;

import android.graphics.SurfaceTexture;
import com.gensee.egl.Egl;
import com.gensee.texture.BaseFrameBufferTexture;
import com.gensee.texture.CameraTexture;
import com.gensee.texture.TextureManager;
import com.gensee.util.ResourceUtil;
import com.gensee.utils.GenseeLog;

public class CameraTextureManager
extends TextureManager {
    private int outWidth = 320;
    private int outHeight = 240;
    private int previewW;
    private int previewH;
    private boolean isTextureInit;

    public boolean isTextureInit() {
        return this.isTextureInit;
    }

    public void setOutputSize(int width, int height) {
        this.outWidth = width;
        this.outHeight = height;
    }

    public void updateTexture() {
        if (null == this.egl) {
            this.egl = new Egl(">>Camera<<");
            this.egl.initEGL();
        }
        this.egl.makeCurrent();
        this.createTexture(36197);
        if (null == this.texture) {
            this.texture = new CameraTexture(this.outWidth, this.outHeight, this.textureId);
            this.texture.name = "camera Texture";
        }
        this.initTexture();
    }

    private void initTexture() {
        if (null != this.surfaceTexture) {
            this.surfaceTexture.release();
            this.surfaceTexture = null;
        }
        if (null != this.textureId) {
            this.surfaceTexture = new SurfaceTexture(this.textureId[0]);
        }
        this.isTextureInit = true;
        GenseeLog.i((String)("camera textureId:" + (this.textureId != null ? Integer.valueOf(this.textureId[0]) : "null")));
    }

    @Override
    public void draw(float[] transformMatrix) {
        if (null == this.texture) {
            GenseeLog.e((String)"Render failed. Texture is null");
            return;
        }
        this.texture.draw(transformMatrix);
    }

    @Override
    public void updateLocation(int previewW, int previewH, int outputWidth, int outputHeight) {
        GenseeLog.i((String)("updateLocation previewW = [" + previewW + "], previewH = [" + previewH + "], outputWidth = [" + outputWidth + "], outputHeight = [" + outputHeight + "]"));
        this.previewW = previewW;
        this.previewH = previewH;
        ((CameraTexture)this.texture).updateFrameBuffer(this.outWidth, this.outHeight);
        float[] location = new float[8];
        float[] textureLocation = new float[8];
        this.calculateBestLocation(location, textureLocation);
        this.texture.updateLocation(textureLocation, location);
    }

    public void calculateBestLocation(float[] location, float[] textureLocation) {
        boolean isHorizontal = ResourceUtil.getIns().isHorizontal();
        int previewWidth = isHorizontal ? this.previewW : this.previewH;
        int previewHeight = isHorizontal ? this.previewH : this.previewW;
        int videoWidth = this.outWidth;
        int videoHeight = this.outHeight;
        float previewScale = (float)previewWidth / (float)previewHeight;
        float videoScale = (float)videoWidth / (float)videoHeight;
        int destPreviewWidth = previewWidth;
        int destPreviewHeight = previewHeight;
        if (previewScale > videoScale) {
            destPreviewWidth = (int)((float)previewHeight * videoScale);
            if (0 != destPreviewWidth % 2) {
                ++destPreviewWidth;
            }
        } else {
            destPreviewHeight = (int)((float)previewWidth / videoScale);
            if (0 != destPreviewHeight % 2) {
                ++destPreviewHeight;
            }
        }
        float left = (float)(previewWidth - destPreviewWidth) / 2.0f / (float)previewWidth;
        float right = 1.0f - left;
        float bottom = (float)(previewHeight - destPreviewHeight) / 2.0f / (float)previewHeight;
        float top = 1.0f - bottom;
        GenseeLog.i((String)("camera left=" + left + ",right=" + right + ",bottom=" + bottom + ",top=" + top));
        System.arraycopy(new float[]{-1.0f, -1.0f, 1.0f, -1.0f, -1.0f, 1.0f, 1.0f, 1.0f}, 0, location, 0, 8);
        System.arraycopy(new float[]{left, bottom, right, bottom, left, top, right, top}, 0, textureLocation, 0, 8);
    }

    public int[] getFrameBuffer() {
        return ((BaseFrameBufferTexture)this.texture).frameBuffer;
    }

    public int[] getFrameBufferTexture() {
        return ((BaseFrameBufferTexture)this.texture).frameBufferTexture;
    }

    @Override
    public void release() {
        super.release();
        this.isTextureInit = false;
    }
}

