/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.texture;

import android.opengl.GLES20;
import com.gensee.texture.BaseFrameBufferTexture;

public class CameraTexture
extends BaseFrameBufferTexture {
    private final String VERTEX_CAMERA = "attribute vec4 aPosition;\nattribute vec4 aTextureCoord;\nuniform mat4 uTextureMatrix;\nvarying vec2 vTextureCoord;\nvoid main(){\n    gl_Position= aPosition;\n    vTextureCoord = (uTextureMatrix * aTextureCoord).xy;\n}";
    private final String FRAGMENT_CAMERA = "#extension GL_OES_EGL_image_external : require\nprecision mediump float;\nvarying mediump vec2 vTextureCoord;\nuniform samplerExternalOES uTexture;\nvoid main(){\n    vec4 color = vec4(texture2D(uTexture, vTextureCoord).rgb, 1.0);\n    gl_FragColor = color;\n}";
    private int aPositionLocation = 0;
    private int uTextureLocation = 0;
    private int aTextureCoordinateLocation = 0;
    private int uTextureMatrix = 0;

    public CameraTexture(int width, int height, int[] textureId) {
        super(width, height, textureId);
        this.init();
        this.createProgram();
        this.initFrameBuffer();
    }

    private void createProgram() {
        this.shaderProgram = this.createProgram("attribute vec4 aPosition;\nattribute vec4 aTextureCoord;\nuniform mat4 uTextureMatrix;\nvarying vec2 vTextureCoord;\nvoid main(){\n    gl_Position= aPosition;\n    vTextureCoord = (uTextureMatrix * aTextureCoord).xy;\n}", "#extension GL_OES_EGL_image_external : require\nprecision mediump float;\nvarying mediump vec2 vTextureCoord;\nuniform samplerExternalOES uTexture;\nvoid main(){\n    vec4 color = vec4(texture2D(uTexture, vTextureCoord).rgb, 1.0);\n    gl_FragColor = color;\n}");
        this.aPositionLocation = this.getAttribLocation("aPosition");
        this.uTextureLocation = this.getUniformLocation("uTexture");
        this.aTextureCoordinateLocation = this.getAttribLocation("aTextureCoord");
        this.uTextureMatrix = this.getUniformLocation("uTextureMatrix");
    }

    @Override
    public void draw(float[] transformMatrix) {
        if (null == transformMatrix) {
            throw new RuntimeException("TransformMatrix can not be null");
        }
        GLES20.glBindFramebuffer((int)36160, (int)this.frameBuffer[0]);
        GLES20.glUseProgram((int)this.shaderProgram);
        GLES20.glActiveTexture((int)33984);
        GLES20.glBindTexture((int)36197, (int)this.textureId[0]);
        GLES20.glUniform1i((int)this.uTextureLocation, (int)0);
        this.enableVertex(this.aPositionLocation, this.aTextureCoordinateLocation);
        GLES20.glUniformMatrix4fv((int)this.uTextureMatrix, (int)1, (boolean)false, (float[])transformMatrix, (int)0);
        this.drawer.draw();
        GLES20.glDisableVertexAttribArray((int)this.aPositionLocation);
        GLES20.glDisableVertexAttribArray((int)this.aTextureCoordinateLocation);
        GLES20.glBindTexture((int)36197, (int)0);
        GLES20.glUseProgram((int)0);
        GLES20.glBindFramebuffer((int)36160, (int)0);
        GLES20.glFlush();
    }
}

