/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.texture;

import android.opengl.GLES20;
import com.gensee.texture.ITexture;
import com.gensee.util.GLHelper;
import com.gensee.utils.GenseeLog;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;

public abstract class BaseTexture
implements ITexture {
    protected final String TAG = this.getClass().getSimpleName();
    private final int COORDS_PER_VERTEX = 2;
    private final int TEXTURE_COORDS_PER_VERTEX = 2;
    private final int COORDS_BYTE_SIZE = 32;
    private int[] vbos = new int[1];
    protected FloatBuffer position = null;
    protected FloatBuffer texCoordinate = null;
    private boolean requestUpdateLocation = false;
    private Object lock = new Object();
    protected int shaderProgram = 0;
    public int[] textureId;
    public String name;
    protected GLDrawer drawer = new GLDrawer();
    public static final String VERTEX_NORMAL = "attribute vec4 aPosition;\nattribute vec2 aTextureCoord;\nvarying vec2 vTextureCoord;\nvoid main(){\n    gl_Position= aPosition;\n    vTextureCoord = aTextureCoord;\n}";
    public static final String FRAGMENT_NORMAL = "precision mediump float;\nvarying mediump vec2 vTextureCoord;\nuniform sampler2D uTexture;\nvoid main(){\n    vec4 color = vec4(texture2D(uTexture, vTextureCoord).rgb, 1.0);\n    gl_FragColor = color;\n}";
    public static final String NO_FILTER_VERTEX_SHADER = "attribute vec4 position;\nattribute vec4 inputTextureCoordinate;\n \nvarying vec2 textureCoordinate;\n \nvoid main()\n{\n    gl_Position = position;\n    textureCoordinate = inputTextureCoordinate.xy;\n}";
    public static final String NO_FILTER_FRAGMENT_SHADER = "varying highp vec2 textureCoordinate;\n \nuniform sampler2D inputImageTexture;\n \nvoid main()\n{\n     gl_FragColor = texture2D(inputImageTexture, textureCoordinate);\n}";

    @Override
    public void init() {
        this.createVBO();
    }

    private BaseTexture() {
    }

    public BaseTexture(int[] textureId) {
        this.textureId = textureId;
        this.updateLocation(new float[]{0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f}, new float[]{-1.0f, -1.0f, 1.0f, -1.0f, -1.0f, 1.0f, 1.0f, 1.0f});
    }

    protected int createProgram(String vertex, String fragment) {
        int vertexShader = this.loadShader(35633, vertex);
        int fragmentShader = this.loadShader(35632, fragment);
        return this.linkProgram(vertexShader, fragmentShader);
    }

    private int loadShader(int type, String shaderSource) {
        int shader = GLES20.glCreateShader((int)type);
        if (shader == 0) {
            throw new RuntimeException("Create Shader Failed! error=" + GLES20.glGetError());
        }
        GLES20.glShaderSource((int)shader, (String)shaderSource);
        GLES20.glCompileShader((int)shader);
        return shader;
    }

    private int linkProgram(int verShader, int fragShader) {
        int program = GLES20.glCreateProgram();
        if (program == 0) {
            throw new RuntimeException("Create Program Failed!" + GLES20.glGetError());
        }
        GLES20.glAttachShader((int)program, (int)verShader);
        GLES20.glAttachShader((int)program, (int)fragShader);
        GLES20.glLinkProgram((int)program);
        GLES20.glUseProgram((int)program);
        return program;
    }

    protected void enableVertex(int posLoc, int texLoc) {
        this.updateVBOs();
        GLES20.glBindBuffer((int)34962, (int)this.vbos[0]);
        GLES20.glEnableVertexAttribArray((int)posLoc);
        GLES20.glEnableVertexAttribArray((int)texLoc);
        GLES20.glVertexAttribPointer((int)posLoc, (int)2, (int)5126, (boolean)false, (int)8, (int)0);
        GLES20.glVertexAttribPointer((int)texLoc, (int)2, (int)5126, (boolean)false, (int)8, (int)32);
        GLES20.glBindBuffer((int)34962, (int)0);
    }

    protected void disableVertex(int position, int coordinate) {
        GLES20.glDisableVertexAttribArray((int)position);
        GLES20.glDisableVertexAttribArray((int)coordinate);
    }

    private void createVBO() {
        GLES20.glGenBuffers((int)this.vbos.length, (int[])this.vbos, (int)0);
        GLES20.glBindBuffer((int)34962, (int)this.vbos[0]);
        GLES20.glBufferData((int)34962, (int)64, null, (int)35044);
        GLES20.glBindBuffer((int)34962, (int)0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateVBOs() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.requestUpdateLocation) {
                return;
            }
            this.requestUpdateLocation = false;
        }
        GLES20.glBindBuffer((int)34962, (int)this.vbos[0]);
        GLES20.glBufferSubData((int)34962, (int)0, (int)32, (Buffer)this.position);
        GLES20.glBufferSubData((int)34962, (int)32, (int)32, (Buffer)this.texCoordinate);
        GLES20.glBindBuffer((int)34962, (int)0);
    }

    protected int getAttribLocation(String name) {
        return GLES20.glGetAttribLocation((int)this.shaderProgram, (String)name);
    }

    protected int getUniformLocation(String name) {
        return GLES20.glGetUniformLocation((int)this.shaderProgram, (String)name);
    }

    protected void setUniform1i(int location, int value) {
        GLES20.glUniform1i((int)location, (int)value);
    }

    protected void setUniform1f(int location, float value) {
        GLES20.glUniform1f((int)location, (float)value);
    }

    private FloatBuffer createShapeVerticesBuffer(float[] array) {
        FloatBuffer result = ByteBuffer.allocateDirect(4 * array.length).order(ByteOrder.nativeOrder()).asFloatBuffer();
        result.put(array).position(0);
        return result;
    }

    public void release() {
        GenseeLog.i((String)("before delete vbos=" + this.vbos[0]));
        GLES20.glDeleteBuffers((int)this.vbos.length, (int[])this.vbos, (int)0);
        if (0 != GLHelper.checkGLES2Error(this.TAG + " release 1")) {
            return;
        }
        if (this.shaderProgram != 0) {
            GLES20.glDeleteProgram((int)this.shaderProgram);
        }
        if (0 != GLHelper.checkGLES2Error(this.TAG + " release 2")) {
            // empty if block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateLocation(float[] texCoordinate, float[] position) {
        GenseeLog.i((String)this.TAG, (String)(this.name + ": updateLocation,texCoordinate={" + texCoordinate[0] + "," + texCoordinate[1] + "," + texCoordinate[2] + "," + texCoordinate[3] + "," + texCoordinate[4] + "," + texCoordinate[5] + "," + texCoordinate[6] + "," + texCoordinate[7] + ", position={" + position[0] + "," + position[1] + "," + position[2] + "," + position[3] + "," + position[4] + "," + position[5] + "," + position[6] + "," + position[7]));
        this.position = this.createShapeVerticesBuffer(position);
        this.texCoordinate = this.createShapeVerticesBuffer(texCoordinate);
        Object object = this.lock;
        synchronized (object) {
            this.requestUpdateLocation = true;
        }
    }

    public class GLDrawer {
        public void draw() {
            GLES20.glDrawArrays((int)5, (int)0, (int)4);
        }
    }
}

