/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.texture;

import android.opengl.GLES20;
import com.gensee.texture.BaseTexture;
import com.gensee.util.GLHelper;
import com.gensee.utils.GenseeLog;

public abstract class BaseFrameBufferTexture
extends BaseTexture {
    private static final String TAG = "BaseFrameBufferTexture";
    public int width;
    public int height;
    public int[] frameBuffer = new int[1];
    public int[] frameBufferTexture = new int[1];

    public BaseFrameBufferTexture(int width, int height, int[] textureId) {
        super(textureId);
        this.width = width;
        this.height = height;
    }

    public void updateFrameBuffer(int width, int height) {
        this.width = width;
        this.height = height;
        GLES20.glBindTexture((int)3553, (int)this.frameBufferTexture[0]);
        GLES20.glTexImage2D((int)3553, (int)0, (int)6408, (int)this.width, (int)this.height, (int)0, (int)6408, (int)5121, null);
        GLES20.glBindTexture((int)3553, (int)0);
    }

    public void initFrameBuffer() {
        this.releaseFrameBuffer();
        GLES20.glGenFramebuffers((int)1, (int[])this.frameBuffer, (int)0);
        GLES20.glGenTextures((int)1, (int[])this.frameBufferTexture, (int)0);
        GLES20.glBindTexture((int)3553, (int)this.frameBufferTexture[0]);
        GLES20.glTexImage2D((int)3553, (int)0, (int)6408, (int)this.width, (int)this.height, (int)0, (int)6408, (int)5121, null);
        GLES20.glTexParameterf((int)3553, (int)10240, (float)9729.0f);
        GLES20.glTexParameterf((int)3553, (int)10241, (float)9729.0f);
        GLES20.glTexParameterf((int)3553, (int)10242, (float)33071.0f);
        GLES20.glTexParameterf((int)3553, (int)10243, (float)33071.0f);
        GLES20.glBindFramebuffer((int)36160, (int)this.frameBuffer[0]);
        GLES20.glFramebufferTexture2D((int)36160, (int)36064, (int)3553, (int)this.frameBufferTexture[0], (int)0);
        GLES20.glBindTexture((int)3553, (int)0);
        GLES20.glBindFramebuffer((int)36160, (int)0);
        if (0 != GLHelper.checkGLES2Error("BaseFrameBufferTexture initFrameBuffer ")) {
            return;
        }
        GenseeLog.d((String)TAG, (String)(" enable frame buffer: frameBuffer[0]=" + this.frameBuffer[0] + ",frameBufferTexture[0]=" + this.frameBufferTexture[0]));
    }

    private void releaseFrameBuffer() {
        GLES20.glDeleteFramebuffers((int)1, (int[])this.frameBuffer, (int)0);
        if (0 != GLHelper.checkGLES2Error("BaseFrameBufferTexture releaseFrameBuffer 1")) {
            return;
        }
        GLES20.glDeleteTextures((int)1, (int[])this.frameBufferTexture, (int)0);
        if (0 != GLHelper.checkGLES2Error("BaseFrameBufferTexture releaseFrameBuffer 2")) {
            return;
        }
    }

    @Override
    public void release() {
        super.release();
        this.releaseFrameBuffer();
    }
}

