/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.render;

import android.graphics.Bitmap;
import android.graphics.SurfaceTexture;
import android.opengl.GLES20;
import com.gensee.pipline.GLEventPipeline;
import com.gensee.pipline.Pipeline;
import com.gensee.texture.CameraTextureManager;
import com.gensee.texture.ScreenTextureManager;
import com.gensee.texture.filter.BaseFilter;
import com.gensee.texture.filter.BeautyFilter;
import com.gensee.texture.filter.GroupFilter;
import com.gensee.texture.filter.NormalFilter;
import com.gensee.texture.sticker.ImageSticker;
import com.gensee.utils.GenseeLog;

public class GLRender {
    private static final String TAG = "GLRender";
    private final Pipeline pipeline;
    private final CameraTextureManager cameraTextureManager;
    private ScreenTextureManager screenManager;
    private SurfaceTexture screenTexture;
    private final int[] outputFrameBuffer = new int[1];
    private final int[] outputFrameBufferTexture = new int[1];
    private final float[] transformMatrix = new float[16];
    private int viewWidth;
    private int viewHeight;
    private int outputWidth;
    private int outputHeight;
    private int previewW;
    private int previewH;
    private BaseFilter filter;
    private final Object filterLock = new Object();
    private Bitmap mBitmap;
    private int localVideoLogoMarginTop;
    private int localVideoLogoMarginRight;
    private int desVideoLogoMarginTop;
    private int desVideoLogoMarginRight;
    private GroupFilter groupFilter;
    private boolean isBeauty;
    private ImageSticker imageSticker;
    public boolean isRenderInit;

    public GLRender(CameraTextureManager cameraTextureManager, BaseFilter filter) {
        this.filter = filter;
        this.cameraTextureManager = cameraTextureManager;
        this.pipeline = GLEventPipeline.getInstance();
    }

    public void start(SurfaceTexture texture, int viewWidth, int viewHeight, int previewW, int previewH, int outputWidth, int outputHeight) {
        this.screenTexture = texture;
        this.previewW = previewW;
        this.previewH = previewH;
        this.viewWidth = viewWidth;
        this.viewHeight = viewHeight;
        this.outputWidth = outputWidth;
        this.outputHeight = outputHeight;
        this.pipeline.queueEvent(new Runnable(){

            @Override
            public void run() {
                GLRender.this.init();
            }
        });
    }

    public void updateSurfaceTexture(SurfaceTexture screenTexture) {
        GenseeLog.i((String)"GLRender updateSurfaceTexture ");
        this.screenTexture = screenTexture;
        this.filter.init();
        this.screenManager.updateTexture(screenTexture, this.getFrameBufferTexture(), this.cameraTextureManager.egl.eglContext);
    }

    private void init() {
        GenseeLog.i((String)TAG, (String)"render init start");
        BaseFilter f = null != this.filter ? this.filter : new NormalFilter();
        this.initFilter(f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initFilter(BaseFilter f) {
        Object object = this.filterLock;
        synchronized (object) {
            GenseeLog.i((String)TAG, (String)("initFilter, Camera texture: " + this.cameraTextureManager.getFrameBuffer()[0] + "," + this.cameraTextureManager.getFrameBufferTexture()[0] + ",outputWidth=" + this.outputWidth + ",outputHeight=" + this.outputHeight));
            this.cameraTextureManager.egl.makeCurrent();
            this.filter.release();
            this.filter = f;
            this.filter.width = this.outputWidth;
            this.filter.height = this.outputHeight;
            this.filter.textureId = this.cameraTextureManager.getFrameBufferTexture();
            if (this.filter instanceof GroupFilter) {
                ((GroupFilter)this.filter).updateStickerSize(this.outputWidth, this.outputHeight, this.viewWidth, this.viewHeight);
            }
            this.filter.init();
            this.outputFrameBuffer[0] = this.filter.frameBuffer[0];
            this.outputFrameBufferTexture[0] = this.filter.frameBufferTexture[0];
        }
        this.initScreen();
        this.isRenderInit = true;
    }

    private void initScreen() {
        GenseeLog.i((String)("screenManager=" + this.screenManager + ",screenTexture=" + this.screenTexture));
        if (null == this.screenManager && null != this.screenTexture) {
            this.screenManager = new ScreenTextureManager(this.screenTexture, this.getFrameBufferTexture(), this.cameraTextureManager.egl.eglContext);
        }
        this.screenManager.updateInputTexture(this.getFrameBufferTexture());
        this.screenManager.egl.makeCurrent();
        this.screenManager.updateLocation(this.viewWidth, this.viewHeight, this.outputWidth, this.outputHeight);
    }

    public void onFrameAvailable() {
        this.pipeline.queueEvent(new Runnable(){

            @Override
            public void run() {
                GLRender.this.draw();
            }
        });
    }

    private void draw() {
        this.drawCamera();
        this.drawFilter();
        if (null == this.screenManager) {
            return;
        }
        this.screenManager.egl.makeCurrent();
        GLES20.glViewport((int)0, (int)0, (int)this.viewWidth, (int)this.viewHeight);
        GLES20.glClear((int)16384);
        GLES20.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        this.screenManager.draw(this.transformMatrix);
        this.screenManager.egl.swapBuffers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drawFilter() {
        Object object = this.filterLock;
        synchronized (object) {
            if (null == this.cameraTextureManager || null == this.cameraTextureManager.egl) {
                return;
            }
            this.cameraTextureManager.egl.makeCurrent();
            GLES20.glViewport((int)0, (int)0, (int)this.outputWidth, (int)this.outputHeight);
            GLES20.glClear((int)16384);
            GLES20.glClearColor((float)0.3f, (float)0.3f, (float)0.3f, (float)0.0f);
            this.filter.draw(null);
        }
    }

    private void drawCamera() {
        if (null == this.cameraTextureManager || null == this.cameraTextureManager.egl) {
            return;
        }
        this.cameraTextureManager.egl.makeCurrent();
        if (null != this.cameraTextureManager.surfaceTexture) {
            this.cameraTextureManager.surfaceTexture.updateTexImage();
            this.cameraTextureManager.surfaceTexture.getTransformMatrix(this.transformMatrix);
        }
        GLES20.glClear((int)16384);
        GLES20.glClearColor((float)0.3f, (float)0.3f, (float)0.3f, (float)0.0f);
        this.cameraTextureManager.draw(this.transformMatrix);
    }

    public void post(Runnable runnable) {
        this.pipeline.queueEvent(runnable, false);
    }

    public void updateSize(final int outputWidth, final int outputHeight) {
        GenseeLog.i((String)("updateSize outputWidth=" + outputWidth + ",outputHeight=" + outputHeight));
        this.outputWidth = outputWidth;
        this.outputHeight = outputHeight;
        this.pipeline.queueEvent(new Runnable(){

            @Override
            public void run() {
                ((GLRender)GLRender.this).cameraTextureManager.egl.makeCurrent();
                GLRender.this.cameraTextureManager.updateLocation(GLRender.this.previewW, GLRender.this.previewH, outputWidth, outputHeight);
            }
        });
        this.pipeline.queueEvent(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = GLRender.this.filterLock;
                synchronized (object) {
                    ((GLRender)GLRender.this).cameraTextureManager.egl.makeCurrent();
                    GLRender.this.filter.updateFrameBuffer(outputWidth, outputHeight);
                }
            }
        });
    }

    public void setBeauty(boolean isBeauty) {
        GenseeLog.i((String)TAG, (String)(" setBeauty=" + isBeauty));
        this.isBeauty = isBeauty;
        this.resolveFilter();
    }

    public void setVideoDataPng(Bitmap bitmap) {
        GenseeLog.i((String)TAG, (String)(" setVideoDataPng isBeauty=" + this.isBeauty));
        this.mBitmap = bitmap;
        this.resolveFilter();
    }

    public void setVideoDataPng(Bitmap bitmap, int localVideoLogoMarginTop, int localVideoLogoMarginRight, int desVideoLogoMarginTop, int desVideoLogoMarginRight) {
        GenseeLog.i((String)TAG, (String)(" setVideoDataPng isBeauty=" + this.isBeauty + ",bitmap = [" + bitmap + "], localVideoLogoMarginTop = [" + localVideoLogoMarginTop + "], localVideoLogoMarginRight = [" + localVideoLogoMarginRight + "], desVideoLogoMarginTop = [" + desVideoLogoMarginTop + "], desVideoLogoMarginRight = [" + desVideoLogoMarginRight + "]"));
        this.mBitmap = bitmap;
        this.localVideoLogoMarginTop = localVideoLogoMarginTop;
        this.localVideoLogoMarginRight = localVideoLogoMarginRight;
        this.desVideoLogoMarginTop = desVideoLogoMarginTop;
        this.desVideoLogoMarginRight = desVideoLogoMarginRight;
        this.resolveFilter();
    }

    private void resolveFilter() {
        this.pipeline.queueEvent(new Runnable(){

            @Override
            public void run() {
                BaseFilter temp;
                BaseFilter baseFilter = temp = GLRender.this.isBeauty ? new BeautyFilter() : new NormalFilter();
                if (null != GLRender.this.mBitmap) {
                    GLRender.this.groupFilter = GroupFilter.create(temp);
                    GLRender.this.imageSticker = new ImageSticker();
                    GLRender.this.imageSticker.setParam(new ImageSticker.ImageStickerParam(GLRender.this.mBitmap, GLRender.this.localVideoLogoMarginTop, GLRender.this.localVideoLogoMarginRight, GLRender.this.desVideoLogoMarginTop, GLRender.this.desVideoLogoMarginRight));
                    GLRender.this.groupFilter.addSticker(GLRender.this.imageSticker);
                    GLRender.this.filter = GLRender.this.groupFilter;
                } else {
                    GLRender.this.filter = temp;
                }
            }
        });
        if (null != this.cameraTextureManager && this.cameraTextureManager.isTextureInit()) {
            this.pipeline.queueEvent(new Runnable(){

                @Override
                public void run() {
                    GLRender.this.initFilter(GLRender.this.filter);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] getFrameBuffer() {
        Object object = this.filterLock;
        synchronized (object) {
            return this.outputFrameBuffer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] getFrameBufferTexture() {
        Object object = this.filterLock;
        synchronized (object) {
            return this.outputFrameBufferTexture;
        }
    }

    public void release() {
        this.screenManager.release();
        this.screenManager = null;
        this.isRenderInit = false;
    }
}

