/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.pipline;

import android.os.Handler;
import com.gensee.pipline.EventPipeline;
import com.gensee.pipline.Pipeline;

public class GLEventPipeline
implements Pipeline {
    private static GLEventPipeline instance;
    private EventPipeline eventPipeline;

    public static GLEventPipeline getInstance() {
        if (null == instance) {
            instance = new GLEventPipeline();
        }
        return instance;
    }

    private GLEventPipeline() {
    }

    private void check() {
        if (null == this.eventPipeline) {
            this.eventPipeline = EventPipeline.create("GLEventPipeline");
        }
    }

    @Override
    public void queueEvent(Runnable event) {
        this.queueEvent(event, false);
    }

    @Override
    public void queueEvent(Runnable event, int what) {
        this.check();
        this.eventPipeline.queueEvent(event, what);
    }

    @Override
    public void queueEvent(Runnable event, boolean front) {
        this.check();
        this.eventPipeline.queueEvent(event, front);
    }

    @Override
    public void queueEvent(Runnable event, long delayed) {
        this.check();
        this.eventPipeline.queueEvent(event, delayed);
    }

    @Override
    public void removeEvent(int what) {
        this.check();
        this.eventPipeline.removeEvent(what);
    }

    @Override
    public void quit() {
        if (null != this.eventPipeline) {
            this.eventPipeline.quit();
            this.eventPipeline = null;
        }
    }

    @Override
    public boolean started() {
        return null != this.eventPipeline && this.eventPipeline.started();
    }

    @Override
    public String getName() {
        return null == this.eventPipeline ? "UNKNOWN" : this.eventPipeline.getName();
    }

    @Override
    public Handler getHandler() {
        return this.eventPipeline.getHandler();
    }

    @Override
    public void sleep() {
        this.eventPipeline.sleep();
    }

    @Override
    public void wake() {
        this.eventPipeline.wake();
    }
}

