/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.pipline;

import android.os.Handler;
import android.os.HandlerThread;
import android.os.Message;
import com.gensee.pipline.Pipeline;
import com.gensee.utils.GenseeLog;

public class EventPipeline
implements Pipeline {
    private Object lock = new Object();
    private HandlerThread mHandlerThread;
    private Handler mHandler;
    private boolean start = false;

    public static EventPipeline create(String name) {
        return new EventPipeline(name);
    }

    private EventPipeline(String name) {
        this.mHandlerThread = new HandlerThread(name);
        this.mHandlerThread.start();
        this.mHandler = new Handler(this.mHandlerThread.getLooper()){

            public void handleMessage(Message msg) {
                if (null != msg.obj && msg.obj instanceof Runnable) {
                    ((Runnable)msg.obj).run();
                }
            }
        };
        this.start = true;
    }

    @Override
    public void queueEvent(Runnable event) {
        this.queueEvent(event, false);
    }

    @Override
    public void queueEvent(Runnable event, int what) {
        if (!this.start) {
            GenseeLog.d((String)"EventPipeline has quited");
            return;
        }
        this.mHandler.sendMessage(this.mHandler.obtainMessage(what, (Object)event));
    }

    @Override
    public void queueEvent(Runnable event, boolean front) {
        if (!this.start) {
            GenseeLog.d((String)"EventPipeline has quited");
            return;
        }
        if (front) {
            this.mHandler.sendMessageAtFrontOfQueue(this.mHandler.obtainMessage(0, (Object)event));
        } else {
            this.mHandler.sendMessage(this.mHandler.obtainMessage(0, (Object)event));
        }
    }

    @Override
    public void queueEvent(Runnable event, long delayed) {
        if (!this.start) {
            GenseeLog.d((String)"EventPipeline has quited");
            return;
        }
        this.mHandler.sendMessageDelayed(this.mHandler.obtainMessage(0, (Object)event), delayed);
    }

    @Override
    public void removeEvent(int what) {
        if (!this.start) {
            GenseeLog.d((String)"EventPipeline has quited");
            return;
        }
        this.mHandler.removeMessages(what);
    }

    @Override
    public void quit() {
        if (!this.start) {
            GenseeLog.d((String)"EventPipeline has quited");
            return;
        }
        this.start = false;
        this.mHandlerThread.interrupt();
        this.mHandlerThread.quitSafely();
    }

    @Override
    public boolean started() {
        return this.start;
    }

    @Override
    public String getName() {
        return this.mHandlerThread.getName();
    }

    @Override
    public Handler getHandler() {
        return this.mHandler;
    }

    @Override
    public void sleep() {
        this.queueEvent(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = EventPipeline.this.lock;
                synchronized (object) {
                    try {
                        EventPipeline.this.lock.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
        }, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void wake() {
        Object object = this.lock;
        synchronized (object) {
            this.lock.notifyAll();
        }
    }
}

