/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.encoder;

import android.annotation.SuppressLint;
import android.media.Image;
import android.media.ImageReader;
import android.opengl.EGLContext;
import android.opengl.GLES20;
import android.view.Surface;
import com.gensee.convert.VideoCoreLibrary;
import com.gensee.pipline.EventPipeline;
import com.gensee.pipline.Pipeline;
import com.gensee.texture.CodeCTextureManager;
import com.gensee.util.RecycleQueue;
import java.nio.Buffer;
import java.nio.ByteBuffer;

public class FramePreEncoder
implements ImageReader.OnImageAvailableListener,
Runnable {
    private CodeCTextureManager codeCManager;
    private Surface surface;
    private int outputWidth;
    private int outputHeight;
    private byte[] data;
    private ImageReader imageReader;
    private Pipeline mPipeline = EventPipeline.create("FrameEncoder");
    private RecycleQueue<byte[]> cache;
    private Thread mEncodeThread;
    private boolean running = true;
    private SendDataReadyCallback sendDataReadyCallback;
    private long frameCount;
    private long lastTime;
    private long lastCount;

    public void setSendDataReadyCallback(SendDataReadyCallback sendDataReadyCallback) {
        this.sendDataReadyCallback = sendDataReadyCallback;
    }

    public FramePreEncoder(int[] textureId, EGLContext eglContext, int outputWidth, int outputHeight) {
        this.outputWidth = outputWidth;
        this.outputHeight = outputHeight;
        this.init();
        this.codeCManager = new CodeCTextureManager(this.surface, textureId, eglContext);
    }

    @SuppressLint(value={"WrongConstant"})
    private void init() {
        this.data = new byte[this.outputWidth * this.outputHeight * 4];
        this.imageReader = ImageReader.newInstance((int)this.outputWidth, (int)this.outputHeight, (int)1, (int)2);
        this.imageReader.setOnImageAvailableListener((ImageReader.OnImageAvailableListener)this, this.mPipeline.getHandler());
        this.surface = this.imageReader.getSurface();
        this.cache = new RecycleQueue(5);
        this.mEncodeThread = new Thread((Runnable)this, "FrameEncoderThread");
        this.mEncodeThread.start();
    }

    public void onFrameAvailable(int outputWidth, int outputHeight) {
        if (null == this.codeCManager || null == this.codeCManager.egl) {
            return;
        }
        this.codeCManager.egl.makeCurrent();
        GLES20.glViewport((int)0, (int)0, (int)outputWidth, (int)outputHeight);
        GLES20.glClear((int)16384);
        GLES20.glClearColor((float)0.3f, (float)0.3f, (float)0.3f, (float)0.0f);
        this.codeCManager.draw(null);
        this.codeCManager.egl.swapBuffers();
    }

    public void onImageAvailable(ImageReader reader) {
        Image image = reader.acquireNextImage();
        Image.Plane[] planes = image.getPlanes();
        int width = image.getWidth();
        int rowStride = planes[0].getRowStride();
        int pixelStride = planes[0].getPixelStride();
        int rowPadding = rowStride - pixelStride * width;
        this.preEncode(planes[0].getBuffer(), rowPadding);
        image.close();
    }

    private void preEncode(Buffer buffer, int rowPadding) {
        byte[] yuvData = this.cache.pullFromCache();
        if (null == yuvData) {
            yuvData = new byte[this.outputWidth * this.outputHeight * 3 >> 1];
        }
        VideoCoreLibrary.copyToByteArray((ByteBuffer)buffer, this.data, this.outputHeight, this.outputWidth * 4, rowPadding);
        VideoCoreLibrary.ConvertToI420(this.data, yuvData, this.outputWidth, this.outputHeight, 0);
        this.cache.offer(yuvData);
        ++this.frameCount;
    }

    @Override
    public void run() {
        while (this.running) {
            byte[] yuvData;
            try {
                yuvData = this.cache.take();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                break;
            }
            if (null != this.sendDataReadyCallback) {
                this.sendDataReadyCallback.onSendDataReady(yuvData, this.outputWidth, this.outputHeight);
            }
            this.cache.recycle(yuvData);
        }
        this.codeCManager.release();
        this.cache.release();
    }

    public void release() {
        if (!this.running) {
            return;
        }
        this.running = false;
        this.mEncodeThread.interrupt();
        this.imageReader.close();
        this.mPipeline.quit();
    }

    public static interface SendDataReadyCallback {
        public void onSendDataReady(byte[] var1, int var2, int var3);
    }
}

