/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.egl;

import android.graphics.SurfaceTexture;
import android.opengl.EGL14;
import android.opengl.EGLConfig;
import android.opengl.EGLContext;
import android.opengl.EGLDisplay;
import android.opengl.EGLSurface;
import android.opengl.GLUtils;
import android.view.Surface;
import com.gensee.utils.GenseeLog;

public class Egl {
    private String name = null;
    EGLDisplay eglDisplay = null;
    EGLConfig eglConfig = null;
    EGLSurface eglSurface = null;
    public EGLContext eglContext = null;
    public static final int COLOR_CHANNELS = 4;
    public static final int GL_CLOLR_DEFAULT = 6408;
    public static final int EGL_RECORDABLE_ANDROID = 12610;
    public static final int[] CONFIG_DEFAULT = new int[]{12352, 4, 12324, 8, 12323, 8, 12322, 8, 12321, 8, 12325, 0, 12326, 0, 12344};
    public static final int[] CONFIG_ANDROID = new int[]{12352, 4, 12324, 8, 12323, 8, 12322, 8, 12321, 8, 12610, 1, 12325, 0, 12326, 0, 12344};

    private Egl() {
    }

    public Egl(String name) {
        this.name = name;
    }

    public void initEGL() {
        this.eglDisplay = this.createDisplay(0);
        if (null == this.eglDisplay) {
            return;
        }
        this.eglConfig = this.createConfig(this.eglDisplay, CONFIG_DEFAULT);
        if (null == this.eglConfig) {
            return;
        }
        this.eglContext = this.createContext(this.eglDisplay, this.eglConfig, null);
        if (null == this.eglContext) {
            return;
        }
        this.createPbufferSurface();
    }

    public void initEGL(SurfaceTexture surfaceTexture, EGLContext context) {
        this.eglDisplay = this.createDisplay(0);
        if (null == this.eglDisplay) {
            return;
        }
        this.eglConfig = this.createConfig(this.eglDisplay, CONFIG_DEFAULT);
        if (null == this.eglConfig) {
            return;
        }
        this.eglContext = this.createContext(this.eglDisplay, this.eglConfig, context);
        if (null == this.eglContext) {
            return;
        }
        this.createWindowSurface(surfaceTexture);
    }

    public void initEGL(Surface surface, EGLContext context) {
        this.eglDisplay = this.createDisplay(0);
        if (null == this.eglDisplay) {
            return;
        }
        this.eglConfig = this.createConfig(this.eglDisplay, CONFIG_ANDROID);
        if (null == this.eglConfig) {
            return;
        }
        this.eglContext = this.createContext(this.eglDisplay, this.eglConfig, context);
        if (null == this.eglContext) {
            return;
        }
        this.createWindowSurface(surface);
    }

    private EGLDisplay createDisplay(int displayId) {
        EGLDisplay eglDisplay = EGL14.eglGetDisplay((int)displayId);
        if (EGL14.EGL_NO_DISPLAY == eglDisplay) {
            GenseeLog.e((String)("eglGetDisplay,failed:" + GLUtils.getEGLErrorString((int)EGL14.eglGetError())));
            return null;
        }
        int[] versions = new int[2];
        if (!EGL14.eglInitialize((EGLDisplay)eglDisplay, (int[])versions, (int)0, (int[])versions, (int)1)) {
            GenseeLog.e((String)("eglInitialize,failed:" + GLUtils.getEGLErrorString((int)EGL14.eglGetError())));
            return null;
        }
        return eglDisplay;
    }

    private EGLConfig createConfig(EGLDisplay display, int[] configSpec) {
        int[] configsCount = new int[1];
        EGLConfig[] configs = new EGLConfig[1];
        EGL14.eglChooseConfig((EGLDisplay)display, (int[])configSpec, (int)0, (EGLConfig[])configs, (int)0, (int)1, (int[])configsCount, (int)0);
        if (configsCount[0] <= 0) {
            GenseeLog.e((String)("eglChooseConfig,failed:" + GLUtils.getEGLErrorString((int)EGL14.eglGetError())));
            return null;
        }
        return configs[0];
    }

    private EGLContext createContext(EGLDisplay display, EGLConfig config, EGLContext context) {
        int[] contextSpec;
        EGLContext eglContext = EGL14.eglCreateContext((EGLDisplay)display, (EGLConfig)config, (EGLContext)(context != null ? context : EGL14.EGL_NO_CONTEXT), (int[])(contextSpec = new int[]{12440, 2, 12344}), (int)0);
        if (EGL14.EGL_NO_CONTEXT == eglContext) {
            GenseeLog.e((String)("eglCreateContext,failed:" + GLUtils.getEGLErrorString((int)EGL14.eglGetError())));
            return null;
        }
        return eglContext;
    }

    private void createPbufferSurface() {
        int[] surfaceAttribs = new int[]{12375, 1, 12374, 1, 12344};
        int[] values = new int[1];
        EGL14.eglQueryContext((EGLDisplay)this.eglDisplay, (EGLContext)this.eglContext, (int)12440, (int[])values, (int)0);
        this.eglSurface = EGL14.eglCreatePbufferSurface((EGLDisplay)this.eglDisplay, (EGLConfig)this.eglConfig, (int[])surfaceAttribs, (int)0);
        if (null == this.eglSurface || EGL14.EGL_NO_SURFACE == this.eglSurface) {
            GenseeLog.e((String)("eglCreatePbufferSurface,failed:" + GLUtils.getEGLErrorString((int)EGL14.eglGetError())));
            return;
        }
    }

    private void createWindowSurface(Object surface) {
        int[] values = new int[1];
        int[] surfaceAttribs = new int[]{12344};
        EGL14.eglQueryContext((EGLDisplay)this.eglDisplay, (EGLContext)this.eglContext, (int)12440, (int[])values, (int)0);
        this.eglSurface = EGL14.eglCreateWindowSurface((EGLDisplay)this.eglDisplay, (EGLConfig)this.eglConfig, (Object)surface, (int[])surfaceAttribs, (int)0);
        if (null == this.eglSurface || EGL14.EGL_NO_SURFACE == this.eglSurface) {
            GenseeLog.e((String)("eglCreateWindowSurface,failed:" + GLUtils.getEGLErrorString((int)EGL14.eglGetError())));
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void makeCurrent() {
        Egl egl = this;
        synchronized (egl) {
            if (EGL14.EGL_NO_CONTEXT == this.eglContext) {
                GenseeLog.i((String)(this.name + " egl failed had release!"));
                return;
            }
            if (!EGL14.eglMakeCurrent((EGLDisplay)this.eglDisplay, (EGLSurface)this.eglSurface, (EGLSurface)this.eglSurface, (EGLContext)this.eglContext)) {
                GenseeLog.e((String)(this.name + " makeCurrent failed: " + GLUtils.getEGLErrorString((int)EGL14.eglGetError())));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void swapBuffers() {
        Egl egl = this;
        synchronized (egl) {
            if (!EGL14.eglSwapBuffers((EGLDisplay)this.eglDisplay, (EGLSurface)this.eglSurface)) {
                GenseeLog.e((String)(this.name + " swapBuffers,failed!" + GLUtils.getEGLErrorString((int)EGL14.eglGetError())));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        Egl egl = this;
        synchronized (egl) {
            this.makeCurrent();
            EGL14.eglDestroySurface((EGLDisplay)this.eglDisplay, (EGLSurface)this.eglSurface);
            EGL14.eglDestroyContext((EGLDisplay)this.eglDisplay, (EGLContext)this.eglContext);
            EGL14.eglTerminate((EGLDisplay)this.eglDisplay);
            EGL14.eglMakeCurrent((EGLDisplay)this.eglDisplay, (EGLSurface)EGL14.EGL_NO_SURFACE, (EGLSurface)EGL14.EGL_NO_SURFACE, (EGLContext)EGL14.EGL_NO_CONTEXT);
            this.eglContext = EGL14.EGL_NO_CONTEXT;
            this.eglDisplay = EGL14.EGL_NO_DISPLAY;
            this.eglSurface = EGL14.EGL_NO_SURFACE;
        }
    }
}

