/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.camera;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.SurfaceTexture;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CameraManager;
import android.os.Build;
import com.gensee.camera.BaseCamera;
import com.gensee.camera.Camera1Impl;
import com.gensee.camera.Camera2Impl;
import com.gensee.common.RTSharedPref;
import com.gensee.encoder.FramePreEncoder;
import com.gensee.pipline.GLEventPipeline;
import com.gensee.render.GLRender;
import com.gensee.texture.CameraTextureManager;
import com.gensee.texture.filter.BaseFilter;
import com.gensee.texture.filter.NormalFilter;
import com.gensee.util.ResourceUtil;
import com.gensee.utils.GenseeLog;
import com.gensee.videoparam.IVideoCoreInterface;
import com.gensee.videoparam.OnVideoHardEncodeDataCallback;
import com.gensee.videoparam.VideoParam;
import com.gensee.view.ILocalVideoView;
import com.gensee.view.VideoHardEncoded;

public class CameraProvider
implements SurfaceTexture.OnFrameAvailableListener,
FramePreEncoder.SendDataReadyCallback,
BaseCamera.CameraImplCallback {
    private static final String TAG = "CameraProvider";
    private FramePreEncoder frameEncoder;
    private CameraTextureManager cameraTextureManager;
    private BaseCamera cameraImpl;
    private GLRender render;
    private int outputWidth = 0;
    private int outputHeight = 0;
    private int viewWidth;
    private int viewHeight;
    private int previewW;
    private int previewH;
    private int requireW;
    private int requireH;
    private boolean isHardEncoded;
    private VideoHardEncoded mVideoHardEncoded;
    private IVideoCoreInterface iVideoCoreInterface;
    private OnVideoHardEncodeDataCallback dataCallback;
    private int mBitRate;
    private int mFps;
    private VideoParam mSendVideoParam;
    private SurfaceTexture screenTexture;
    private BaseFilter filter = new NormalFilter();

    public void setHardEncode(boolean hardEncode) {
        GenseeLog.d((String)TAG, (String)("setHardEncode isHardEncode " + hardEncode));
        this.isHardEncoded = hardEncode;
    }

    public boolean getHardEncode() {
        return this.isHardEncoded;
    }

    private CameraProvider() {
        this.cameraTextureManager = new CameraTextureManager();
        this.cameraImpl = this.isCamera2FullSupport(ResourceUtil.getIns().getContext()) ? new Camera2Impl(this.cameraTextureManager) : new Camera1Impl(this.cameraTextureManager);
        this.cameraImpl.setOnFrameAvailableListener(this);
        this.cameraImpl.setCameraImplCallback(this);
        this.render = new GLRender(this.cameraTextureManager, this.filter);
    }

    public static CameraProvider create() {
        return new CameraProvider();
    }

    public void onFrameAvailable(SurfaceTexture surfaceTexture) {
        this.render.onFrameAvailable();
        this.render.post(new Runnable(){

            @Override
            public void run() {
                CameraProvider.this.frameEncoder.onFrameAvailable(CameraProvider.this.outputWidth, CameraProvider.this.outputHeight);
            }
        });
    }

    @Override
    public void onPreviewSize(int previewW, int previewH) {
        this.previewW = previewW;
        this.previewH = previewH;
    }

    public void onSurfaceTextureAvailable(final SurfaceTexture screenTexture, int width, int height) {
        this.screenTexture = screenTexture;
        this.viewWidth = width;
        this.viewHeight = height;
        if (this.cameraImpl.isPreviewing()) {
            this.render.post(new Runnable(){

                @Override
                public void run() {
                    CameraProvider.this.cameraImpl.open();
                    CameraProvider.this.render.updateSurfaceTexture(screenTexture);
                }
            });
        }
    }

    @Override
    public void onSendDataReady(byte[] yv12Data, int width, int height) {
        if (null == this.mSendVideoParam) {
            this.mSendVideoParam = new VideoParam();
        }
        this.mSendVideoParam.width = width;
        this.mSendVideoParam.height = height;
        this.mSendVideoParam.bitCount = 125000;
        this.mSendVideoParam.fmt = 16;
        if (this.isHardEncoded) {
            if (null != this.mVideoHardEncoded) {
                this.mVideoHardEncoded.sendEncodeFrame(yv12Data, width, height, 0);
            }
        } else if (null != this.iVideoCoreInterface) {
            this.iVideoCoreInterface.sendVideoData(yv12Data, this.mSendVideoParam);
        }
    }

    public void onSurfaceTextureSizeChanged(SurfaceTexture surface, int width, int height) {
    }

    public void setVideoParams(Object param, IVideoCoreInterface iVideoCoreInterface) {
        this.iVideoCoreInterface = iVideoCoreInterface;
        if (param instanceof VideoParam) {
            this.resetPreviewWH((VideoParam)param);
            this.outputWidth = ((VideoParam)param).width;
            this.outputHeight = ((VideoParam)param).height;
        }
        this.cameraImpl.setParams(param, iVideoCoreInterface);
    }

    private void resetPreviewWH(VideoParam videoParam) {
        if (null != videoParam) {
            int width = videoParam.width;
            int height = videoParam.height;
            if (width < height) {
                int tmp = width;
                width = height;
                height = tmp;
            }
            int userSettingWidth = 0;
            int userSettingHeight = 0;
            if (null != RTSharedPref.getIns()) {
                userSettingWidth = RTSharedPref.getIns().getInt("save.video.width", 320);
                userSettingHeight = RTSharedPref.getIns().getInt("save.video.height", 240);
            }
            GenseeLog.d((String)TAG, (String)("setVideoParam param.width = " + videoParam.width + " param.height = " + videoParam.height + " userSettingWidth = " + userSettingWidth + " userSettingHeight = " + userSettingHeight));
            if (width > userSettingWidth || height > userSettingHeight) {
                userSettingHeight = height;
                userSettingWidth = width;
            }
            this.outputWidth = userSettingWidth;
            this.outputHeight = userSettingHeight;
        }
    }

    public void open() {
        if (this.isHardEncoded) {
            if (null != this.mVideoHardEncoded) {
                GenseeLog.d((String)"videocapture forceKeyFrame");
                this.mVideoHardEncoded.forceKeyFrame();
            } else {
                this.initHardEncoder();
            }
        } else if (null != this.mVideoHardEncoded) {
            this.mVideoHardEncoded.release();
            this.mVideoHardEncoded = null;
        }
        this.render.post(new Runnable(){

            @Override
            public void run() {
                CameraProvider.this.cameraImpl.open();
                if (((CameraProvider)CameraProvider.this).render.isRenderInit) {
                    CameraProvider.this.render.updateSurfaceTexture(CameraProvider.this.screenTexture);
                } else if (null != CameraProvider.this.screenTexture) {
                    CameraProvider.this.render.start(CameraProvider.this.screenTexture, CameraProvider.this.viewWidth, CameraProvider.this.viewHeight, CameraProvider.this.previewW, CameraProvider.this.previewH, CameraProvider.this.outputWidth, CameraProvider.this.outputHeight);
                    CameraProvider.this.render.updateSize(CameraProvider.this.outputWidth, CameraProvider.this.outputHeight);
                }
                if (null == CameraProvider.this.frameEncoder) {
                    CameraProvider.this.frameEncoder = new FramePreEncoder(CameraProvider.this.render.getFrameBufferTexture(), ((CameraProvider)CameraProvider.this).cameraTextureManager.egl.eglContext, CameraProvider.this.outputWidth, CameraProvider.this.outputHeight);
                }
                CameraProvider.this.frameEncoder.setSendDataReadyCallback(CameraProvider.this);
            }
        });
    }

    private void initHardEncoder() {
        if (null == this.mVideoHardEncoded) {
            this.mVideoHardEncoded = new VideoHardEncoded(this.outputWidth, this.outputHeight, this.iVideoCoreInterface);
            this.mVideoHardEncoded.setVideoCore(this.iVideoCoreInterface);
            this.mVideoHardEncoded.setHardEncodeDataCallback(this.dataCallback);
            this.mVideoHardEncoded.setBitRate(this.mBitRate);
            this.mVideoHardEncoded.setFps(this.mFps);
            this.mVideoHardEncoded.start();
        }
    }

    public void setBeauty(boolean isBeauty) {
        this.render.setBeauty(isBeauty);
    }

    public void setPreviewSize(Context context, int width, int height) {
        GenseeLog.i((String)TAG, (String)("setPreviewSize width = " + width + " height = " + height));
        this.previewW = width;
        this.previewH = height;
        this.cameraImpl.setPreviewSize(width, height);
    }

    public void setVideoSize(Context context, int width, int height) {
        this.requireW = width;
        this.requireH = height;
        if (null != this.iVideoCoreInterface) {
            this.iVideoCoreInterface.setVideoSize(context, width, height);
        }
        this.cameraImpl.setPreviewSize(width, height);
    }

    public void setOnCameraPermissionListener(ILocalVideoView.OnCameraPermissionListener onCameraPermissionListener) {
        this.cameraImpl.setOnCameraPermissionListener(onCameraPermissionListener);
    }

    public void setOnCameraInfoListener(ILocalVideoView.OnCameraInfoListener onCameraInfoListener) {
        this.cameraImpl.setOnCameraInfoListener(onCameraInfoListener);
    }

    public void setHardEncodeDataCallback(OnVideoHardEncodeDataCallback callback) {
        this.dataCallback = callback;
        if (this.mVideoHardEncoded != null) {
            this.mVideoHardEncoded.setHardEncodeDataCallback(callback);
        }
    }

    public void setVideoCore(IVideoCoreInterface videoCoreInterface) {
        this.iVideoCoreInterface = videoCoreInterface;
        if (this.iVideoCoreInterface != null) {
            this.iVideoCoreInterface.setVideoSize(ResourceUtil.getIns().getContext(), this.requireW, this.requireH);
        }
    }

    public void setBitRate(int bitRate) {
        GenseeLog.d((String)TAG, (String)("setBitRate bitRate = " + bitRate + " encoder = " + this.mVideoHardEncoded));
        this.mBitRate = bitRate;
        if (this.mVideoHardEncoded != null) {
            this.mVideoHardEncoded.setBitRate(bitRate);
        }
    }

    public void setFps(int fps) {
        GenseeLog.d((String)TAG, (String)("setFps fps = " + fps + " encoder = " + this.mVideoHardEncoded));
        this.mFps = fps;
        if (this.mVideoHardEncoded != null) {
            this.mVideoHardEncoded.setFps(fps);
        }
    }

    public void forceKeyFrame() {
        if (this.mVideoHardEncoded != null && this.isHardEncoded) {
            this.mVideoHardEncoded.forceKeyFrame();
        }
    }

    public boolean isCameraSwitchEnable() {
        return this.cameraImpl.isCameraSwitchEnable();
    }

    public void doCameraSwitch() {
        this.render.post(new Runnable(){

            @Override
            public void run() {
                CameraProvider.this.cameraImpl.doCameraSwitch();
            }
        });
    }

    public void reOpenCamera() {
        this.render.post(new Runnable(){

            @Override
            public void run() {
                CameraProvider.this.cameraImpl.open();
            }
        });
    }

    public boolean isSupportFlashOnOrOff() {
        return this.cameraImpl.isSupportFlashOnOrOff();
    }

    public void switchFlashOnOrOff(boolean bOpen) {
        this.cameraImpl.switchFlashOnOrOff(bOpen);
    }

    public void close() {
        GenseeLog.i((String)TAG, (String)"close start");
        if (this.isHardEncoded && null != this.mVideoHardEncoded) {
            this.mVideoHardEncoded.release();
            this.mVideoHardEncoded = null;
        }
        if (null != RTSharedPref.getIns() && RTSharedPref.getIns().getInt("KEY_JOIN_STATUS", 0) == 1) {
            if (null != this.iVideoCoreInterface) {
                this.iVideoCoreInterface.saveCameraId(-1);
            }
        } else {
            GenseeLog.w((String)TAG, (String)"no switch camera index, RTSharePref getIns is null");
        }
        this.render.post(new Runnable(){

            @Override
            public void run() {
                CameraProvider.this.cameraImpl.close();
            }
        });
    }

    public boolean isSupportFocusAuto() {
        return this.cameraImpl.isSupportFocusAuto();
    }

    public void onSurfaceTextureDestroyed() {
        this.render.post(new Runnable(){

            @Override
            public void run() {
                CameraProvider.this.cameraImpl.releaseCamera();
            }
        });
    }

    public void release() {
        this.dataCallback = null;
        this.iVideoCoreInterface = null;
        try {
            this.render.post(new Runnable(){

                @Override
                public void run() {
                    CameraProvider.this.cameraImpl.release();
                    CameraProvider.this.cameraTextureManager.release();
                    CameraProvider.this.cameraTextureManager = null;
                    CameraProvider.this.frameEncoder.release();
                    CameraProvider.this.render.release();
                    GLEventPipeline.getInstance().quit();
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
            GenseeLog.e((String)TAG, (String)("release exception=" + e));
        }
    }

    public void setVideoDataPng(Bitmap mBitmap) {
        this.render.setVideoDataPng(mBitmap);
    }

    public void setVideoDataPng(Bitmap mBitmap, int localVideoLogoMarginTop, int localVideoLogoMarginRight, int desVideoLogoMarginTop, int desVideoLogoMarginRight) {
        this.render.setVideoDataPng(mBitmap, localVideoLogoMarginTop, localVideoLogoMarginRight, desVideoLogoMarginTop, desVideoLogoMarginRight);
    }

    private boolean isCamera2FullSupport(Context mContext) {
        if (mContext == null) {
            return false;
        }
        if (Build.VERSION.SDK_INT < 21) {
            return false;
        }
        try {
            CameraManager manager = (CameraManager)mContext.getSystemService("camera");
            String[] idList = manager.getCameraIdList();
            boolean isFullSupport = true;
            if (idList.length == 0) {
                isFullSupport = false;
            } else {
                for (String str : idList) {
                    if (str == null || str.trim().isEmpty()) {
                        isFullSupport = false;
                        break;
                    }
                    CameraCharacteristics characteristics = manager.getCameraCharacteristics(str);
                    int supportLevel = (Integer)characteristics.get(CameraCharacteristics.INFO_SUPPORTED_HARDWARE_LEVEL);
                    GenseeLog.i((String)TAG, (String)("camera2 supportLevel=" + supportLevel));
                    if (supportLevel != 2) continue;
                    isFullSupport = false;
                    break;
                }
            }
            GenseeLog.i((String)TAG, (String)("isCamera2FullSupport = " + isFullSupport));
            return isFullSupport;
        }
        catch (Throwable ignore) {
            return false;
        }
    }

    public void focusOnTouch(double x, double y, int focusWidth, int focusHeight, int viewWidth, int viewHeight) {
        this.cameraImpl.focusOnTouch(x, y, focusWidth, focusHeight, viewWidth, viewHeight);
    }
}

