/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.camera;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.graphics.Rect;
import android.graphics.SurfaceTexture;
import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraCaptureSession;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CameraDevice;
import android.hardware.camera2.CameraManager;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.CaptureResult;
import android.hardware.camera2.TotalCaptureResult;
import android.hardware.camera2.params.MeteringRectangle;
import android.hardware.camera2.params.StreamConfigurationMap;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import android.text.TextUtils;
import android.util.Range;
import android.util.Size;
import android.view.Surface;
import com.gensee.camera.BaseCamera;
import com.gensee.texture.CameraTextureManager;
import com.gensee.util.ResourceUtil;
import com.gensee.utils.GenseeLog;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.concurrent.Semaphore;

public class Camera2Impl
extends BaseCamera {
    private static final int CAMERA2_DO_SWITCH_CAMERA = 10000000;
    private static final int CAMERA2_RELEASE_CAMERA = 10000001;
    private static final int CAMERA2_OPEN_CAMERA = 10000002;
    private final Semaphore mCameraOpenLock = new Semaphore(1);
    private final Semaphore mCameraCloseLock = new Semaphore(1);
    private CameraTextureManager textureManager;
    private boolean isCameraOpening;
    private CameraManager cameraManager;
    private CameraCharacteristics characteristics;
    private Rect mActiveArraySize;
    private HandlerThread mBackgroundThread;
    private Handler mBackgroundHandler;
    private CameraDevice mCameraDevice;
    private CaptureRequest.Builder mPreviewBuilder;
    private SurfaceTexture mSurfaceTexture;
    private CameraCaptureSession mCaptureSession;
    private CameraDevice.StateCallback deviceStateCallback = new CameraDevice.StateCallback(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onOpened(CameraDevice camera) {
            GenseeLog.i((String)Camera2Impl.this.TAG, (String)("onOpened camera = " + camera));
            Camera2Impl.this.mCameraOpenLock.release();
            Camera2Impl.this.mCameraCloseLock.release();
            Object object = Camera2Impl.this.cameraLock;
            synchronized (object) {
                Camera2Impl.this.mCameraDevice = camera;
                try {
                    Camera2Impl.this.mPreviewBuilder = Camera2Impl.this.mCameraDevice.createCaptureRequest(1);
                    ArrayList<Surface> surfaces = new ArrayList<Surface>();
                    Camera2Impl.this.mSurfaceTexture = ((Camera2Impl)Camera2Impl.this).textureManager.surfaceTexture;
                    if (null != Camera2Impl.this.mSurfaceTexture) {
                        Surface mSurface = new Surface(Camera2Impl.this.mSurfaceTexture);
                        Camera2Impl.this.mPreviewBuilder.addTarget(mSurface);
                        surfaces.add(mSurface);
                    } else {
                        GenseeLog.w((String)Camera2Impl.this.TAG, (String)"mSurfaceTexture is null");
                    }
                    Camera2Impl.this.mCameraDevice.createCaptureSession(surfaces, Camera2Impl.this.sessionStateCallback, Camera2Impl.this.mBackgroundHandler);
                }
                catch (Exception e) {
                    GenseeLog.e((String)Camera2Impl.this.TAG, (String)("createCaptureRequest previewBuilder CameraAccessException=" + e));
                }
            }
            if (null != Camera2Impl.this.onCameraInfoListener) {
                Camera2Impl.this.onCameraInfoListener.onCameraOpen(true);
            }
            Camera2Impl.this.isCameraOpening = false;
        }

        public void onDisconnected(CameraDevice camera) {
            Camera2Impl.this.mCameraOpenLock.release();
            Camera2Impl.this.mCameraCloseLock.release();
            GenseeLog.i((String)Camera2Impl.this.TAG, (String)("onDisconnected camera = " + camera));
            camera.close();
            Camera2Impl.this.mCameraDevice = null;
            Camera2Impl.this.isCameraOpening = false;
        }

        public void onClosed(CameraDevice camera) {
            super.onClosed(camera);
            Camera2Impl.this.mCameraOpenLock.release();
            Camera2Impl.this.mCameraCloseLock.release();
            GenseeLog.i((String)Camera2Impl.this.TAG, (String)("onClosed camera = " + camera));
            Camera2Impl.this.isCameraOpening = false;
        }

        public void onError(CameraDevice camera, int error) {
            Camera2Impl.this.mCameraOpenLock.release();
            Camera2Impl.this.mCameraCloseLock.release();
            GenseeLog.w((String)Camera2Impl.this.TAG, (String)("onError camera = " + camera + " error = " + error));
            camera.close();
            Camera2Impl.this.mCameraDevice = null;
            Camera2Impl.this.isCameraOpening = false;
            if (null != Camera2Impl.this.onCameraInfoListener) {
                Camera2Impl.this.onCameraInfoListener.onCameraOpen(false);
            }
        }
    };
    private CameraCaptureSession.StateCallback sessionStateCallback = new CameraCaptureSession.StateCallback(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onConfigured(CameraCaptureSession session) {
            Object object = Camera2Impl.this.cameraLock;
            synchronized (object) {
                if (null != Camera2Impl.this.mCameraDevice) {
                    GenseeLog.i((String)Camera2Impl.this.TAG, (String)("onConfigured session = " + session.toString()));
                    Camera2Impl.this.mCaptureSession = session;
                    try {
                        int[] afs;
                        Range[] fpss = (Range[])Camera2Impl.this.characteristics.get(CameraCharacteristics.CONTROL_AE_AVAILABLE_TARGET_FPS_RANGES);
                        Range suiteFps = Camera2Impl.this.getSuitableFps(fpss);
                        if (null != suiteFps) {
                            Camera2Impl.this.mPreviewBuilder.set(CaptureRequest.CONTROL_AE_TARGET_FPS_RANGE, (Object)suiteFps);
                        } else {
                            GenseeLog.e((String)Camera2Impl.this.TAG, (String)" Get SuiteFps Error!");
                        }
                        for (int a : afs = (int[])Camera2Impl.this.characteristics.get(CameraCharacteristics.CONTROL_AF_AVAILABLE_MODES)) {
                            if (a != 3) continue;
                            Camera2Impl.this.mPreviewBuilder.set(CaptureRequest.CONTROL_AF_MODE, (Object)3);
                        }
                        Camera2Impl.this.mCaptureSession.setRepeatingRequest(Camera2Impl.this.mPreviewBuilder.build(), Camera2Impl.this.sessionCaptureCallback, Camera2Impl.this.mBackgroundHandler);
                        Camera2Impl.this.mPreviewRunning = true;
                        Camera2Impl.this.calculateRotate();
                    }
                    catch (CameraAccessException e) {
                        GenseeLog.e((String)Camera2Impl.this.TAG, (String)"setRepeatingRequest cameraAccessException");
                        Camera2Impl.this.mPreviewRunning = false;
                        Camera2Impl.this._releaseCamera();
                    }
                }
            }
        }

        public void onConfigureFailed(CameraCaptureSession session) {
            GenseeLog.w((String)Camera2Impl.this.TAG, (String)("onConfigureFailed session = " + session.toString()));
        }
    };
    private CameraCaptureSession.CaptureCallback sessionCaptureCallback = new CameraCaptureSession.CaptureCallback(){

        public void onCaptureStarted(CameraCaptureSession session, CaptureRequest request, long timestamp, long frameNumber) {
            super.onCaptureStarted(session, request, timestamp, frameNumber);
        }

        public void onCaptureCompleted(CameraCaptureSession session, CaptureRequest request, TotalCaptureResult result) {
            super.onCaptureCompleted(session, request, result);
            if (Build.VERSION.SDK_INT >= 30) {
                return;
            }
            Camera2Impl.this.recycle(result);
        }
    };
    static Field sTargetField;
    static Method sTargetMethod;
    private CameraCaptureSession.CaptureCallback mAfCaptureCallback = new CameraCaptureSession.CaptureCallback(){

        private void process(CaptureResult result) {
            if (null == Camera2Impl.this.mCameraDevice || null == Camera2Impl.this.mCaptureSession || null == Camera2Impl.this.mPreviewBuilder) {
                return;
            }
            Integer afState = (Integer)result.get(CaptureResult.CONTROL_AF_STATE);
            if (null == afState) {
                return;
            }
            GenseeLog.d((String)Camera2Impl.this.TAG, (String)("mAfCaptureCallback afState = " + afState));
            if (4 == afState || 5 == afState) {
                Camera2Impl.this.mPreviewBuilder.set(CaptureRequest.CONTROL_AF_MODE, (Object)3);
                Camera2Impl.this.mPreviewBuilder.set(CaptureRequest.CONTROL_AF_TRIGGER, (Object)2);
                Camera2Impl.this.mPreviewBuilder.set(CaptureRequest.CONTROL_AE_MODE, (Object)1);
                try {
                    if (null != Camera2Impl.this.onCameraInfoListener) {
                        Camera2Impl.this.onCameraInfoListener.onManualFocus(afState == 4);
                    }
                    Camera2Impl.this.mCaptureSession.setRepeatingRequest(Camera2Impl.this.mPreviewBuilder.build(), null, Camera2Impl.this.mBackgroundHandler);
                }
                catch (CameraAccessException e) {
                    GenseeLog.e((String)Camera2Impl.this.TAG, (String)("setRepeatingRequest failed, errMsg: " + e.getMessage()));
                }
            }
        }

        public void onCaptureProgressed(CameraCaptureSession session, CaptureRequest request, CaptureResult partialResult) {
            this.process(partialResult);
        }

        public void onCaptureCompleted(CameraCaptureSession session, CaptureRequest request, TotalCaptureResult result) {
            this.process((CaptureResult)result);
        }
    };

    private Camera2Impl() {
    }

    public Camera2Impl(CameraTextureManager textureManager) {
        this.textureManager = textureManager;
        this.startBackgroundThread();
    }

    private void _doOpenCamera() {
        if (this.isCameraOpening) {
            GenseeLog.i((String)this.TAG, (String)"_doCameraOpen cameradevice have opened");
            return;
        }
        this.calculateRotate();
        if (!this.checkCameraPermission()) {
            if (null != this.onCameraPermissionListener) {
                this.onCameraPermissionListener.onCameraPermission();
            }
            return;
        }
        try {
            GenseeLog.i((String)this.TAG, (String)("_doCameraOpen begin open cameraIndex=" + this.cameraIndex));
            this.mCameraOpenLock.acquire();
            GenseeLog.i((String)this.TAG, (String)"_doCameraOpen get Semaphore cameraopenlock success");
            this.mCameraCloseLock.acquire();
            GenseeLog.i((String)this.TAG, (String)"_doCameraOpen get Semaphore cameracloselock success");
            this.cameraManager = (CameraManager)ResourceUtil.getIns().getContext().getSystemService("camera");
            this.characteristics = this.cameraManager.getCameraCharacteristics(this.cameraIndex + "");
            int hardwarelevel = (Integer)this.characteristics.get(CameraCharacteristics.INFO_SUPPORTED_HARDWARE_LEVEL);
            GenseeLog.w((String)this.TAG, (String)("camera2 feature support hardwarelevel = " + hardwarelevel));
            this.mActiveArraySize = (Rect)this.characteristics.get(CameraCharacteristics.SENSOR_INFO_ACTIVE_ARRAY_SIZE);
            StreamConfigurationMap map = (StreamConfigurationMap)this.characteristics.get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP);
            Size[] sizes = map.getOutputSizes(SurfaceTexture.class);
            ArrayList<Size> ss = null;
            if (sizes != null) {
                ss = new ArrayList<Size>();
                for (int i = 0; i < sizes.length; ++i) {
                    Size s = sizes[i];
                    if (Math.max(s.getWidth(), s.getHeight()) < 300) {
                        GenseeLog.i((String)this.TAG, (String)("Supported w = " + s.getWidth() + " h = " + s.getHeight() + "(size too small, remove this)"));
                        continue;
                    }
                    GenseeLog.i((String)this.TAG, (String)("Supported w = " + s.getWidth() + " h = " + s.getHeight()));
                    ss.add(s);
                }
            }
            Size suiteSize = this.getOptimalPreviewSize2(ss);
            GenseeLog.i((String)this.TAG, (String)("getOptimalPreviewSize suiteSize widht = " + suiteSize.getWidth() + " height = " + suiteSize.getHeight()));
            this.previewWidth = suiteSize.getWidth();
            this.previewHeight = suiteSize.getHeight();
            if (null != this.textureManager) {
                this.textureManager.surfaceTexture.setDefaultBufferSize(suiteSize.getWidth(), suiteSize.getHeight());
            }
            this.notifyPreviewSize();
            GenseeLog.i((String)this.TAG, (String)("Get Suite Preview fbv width = " + suiteSize.getWidth() + " height = " + suiteSize.getHeight()));
            GenseeLog.i((String)this.TAG, (String)("openCamera cameraIndex = " + this.cameraIndex));
            this.isCameraOpening = true;
            this.cameraManager.openCamera(this.cameraIndex + "", this.deviceStateCallback, this.mBackgroundHandler);
        }
        catch (Exception e) {
            this.mCameraOpenLock.release();
            this.mCameraCloseLock.release();
            e.printStackTrace();
            GenseeLog.e((String)this.TAG, (String)("doCameraOpen exception message = " + e.getMessage()));
        }
    }

    @SuppressLint(value={"SoonBlockedPrivateApi"})
    private void recycle(TotalCaptureResult tcr) {
        try {
            if (null == sTargetField) {
                sTargetField = tcr.getClass().getSuperclass().getDeclaredField("mResults");
                sTargetField.setAccessible(true);
            }
            if (null == sTargetMethod) {
                sTargetMethod = Class.forName("android.hardware.camera2.impl.CameraMetadataNative").getDeclaredMethod("close", new Class[0]);
                sTargetMethod.setAccessible(true);
            }
            sTargetMethod.invoke(sTargetField.get(tcr), new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _releaseCamera() {
        try {
            Object object = this.cameraLock;
            synchronized (object) {
                this.mCameraOpenLock.acquire();
                if (null != this.mCaptureSession) {
                    this.mCaptureSession.close();
                }
                if (this.mCameraDevice != null) {
                    GenseeLog.i((String)this.TAG, (String)"videocapture releaseCamera camera not null");
                    this.mCameraDevice.close();
                } else {
                    this.mCameraCloseLock.release();
                    GenseeLog.i((String)this.TAG, (String)"videocapture releaseCamera camera null");
                }
                this.mCaptureSession = null;
                this.mCameraDevice = null;
                this.isCameraOpening = false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            GenseeLog.e((String)this.TAG, (String)("_releaseCamera Exception=" + e));
        }
        finally {
            this.mCameraOpenLock.release();
        }
    }

    private void startBackgroundThread() {
        if (null == this.mBackgroundThread) {
            this.mBackgroundThread = new HandlerThread("CameraBackground");
            this.mBackgroundThread.start();
            this.mBackgroundHandler = new Handler(this.mBackgroundThread.getLooper());
        }
    }

    private void stopBackgroundThread() {
        if (null != this.mBackgroundThread) {
            this.mBackgroundThread.quitSafely();
            try {
                this.mBackgroundThread.join();
                this.mBackgroundThread = null;
                this.mBackgroundHandler = null;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    private Range<Integer> getSuitableFps(Range<Integer>[] fpss) {
        int fpsMin = 0;
        int fpsMax = 0;
        int needFps = 30;
        if (null != fpss && fpss.length > 0) {
            for (Range<Integer> fps : fpss) {
                if (needFps < (Integer)fps.getLower() || needFps > (Integer)fps.getUpper()) continue;
                if (fpsMin <= 0 || fpsMax <= 0) {
                    fpsMin = (Integer)fps.getLower();
                    fpsMax = (Integer)fps.getUpper();
                    continue;
                }
                if ((Integer)fps.getUpper() > fpsMax) continue;
                if ((Integer)fps.getUpper() == fpsMax) {
                    if (Math.abs((Integer)fps.getLower() - needFps) >= Math.abs(fpsMin - needFps)) continue;
                    fpsMin = (Integer)fps.getLower();
                    fpsMax = (Integer)fps.getUpper();
                    continue;
                }
                fpsMin = (Integer)fps.getLower();
                fpsMax = (Integer)fps.getUpper();
            }
        }
        if (fpsMin > 0 && fpsMax > 0) {
            GenseeLog.i((String)this.TAG, (String)("camera fps fpsMin = " + fpsMin + " fpsMax = " + fpsMax));
            return new Range((Comparable)Integer.valueOf(fpsMin), (Comparable)Integer.valueOf(fpsMax));
        }
        GenseeLog.w((String)this.TAG, (String)"camera suitable fps not found");
        if (null != fpss && fpss.length > 0) {
            return fpss[0];
        }
        return null;
    }

    @Override
    protected void doOpenCamera() {
        this.textureManager.updateTexture();
        this.textureManager.surfaceTexture.setOnFrameAvailableListener(this.onFrameAvailableListener);
        this._doOpenCamera();
        this.textureManager.updateLocation(this.previewWidth, this.previewHeight, this.videoParam.width, this.videoParam.height);
    }

    @Override
    protected void calculateRotate() {
    }

    @Override
    protected void setOutputSize(int width, int height) {
        this.textureManager.setOutputSize(width, height);
    }

    @Override
    public boolean isCameraSwitchEnable() {
        try {
            this.cameraManager = (CameraManager)ResourceUtil.getIns().getContext().getSystemService("camera");
            String[] ids = this.cameraManager.getCameraIdList();
            return ids != null && ids.length > 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void focusOnTouch(double x1, double y1, int focusWidth, int focusHeight, int viewWidth, int viewHeight) {
        int cropHeight;
        int cropWidth;
        double x = x1;
        double y = y1;
        int realPreviewWidth = this.previewWidth;
        int realPreviewHeight = this.previewHeight;
        int mDisplayRotate = 2 == this.orientation ? 0 : 90;
        Context context = ResourceUtil.getIns().getContext();
        if (null != context) {
            if (context instanceof Activity) {
                mDisplayRotate = this.getCameraDisplayOrientation((Activity)context, this.characteristics);
            } else {
                int n = mDisplayRotate = 2 == this.orientation ? 0 : 90;
            }
        }
        if (90 == mDisplayRotate || 270 == mDisplayRotate) {
            realPreviewWidth = this.previewHeight;
            realPreviewHeight = this.previewWidth;
        }
        double imgScale = 1.0;
        double verticalOffset = 0.0;
        double horizontalOffset = 0.0;
        if (realPreviewHeight * viewWidth > realPreviewWidth * viewHeight) {
            imgScale = (double)viewWidth * 1.0 / (double)realPreviewWidth;
            verticalOffset = ((double)realPreviewHeight - (double)viewHeight / imgScale) / 2.0;
        } else {
            imgScale = (double)viewHeight * 1.0 / (double)realPreviewHeight;
            horizontalOffset = ((double)realPreviewWidth - (double)viewWidth / imgScale) / 2.0;
        }
        x = x / imgScale + horizontalOffset;
        y = y / imgScale + verticalOffset;
        if (90 == mDisplayRotate) {
            double tmp = x;
            x = y;
            y = (double)this.previewHeight - tmp;
        } else if (270 == mDisplayRotate) {
            double tmp = x;
            x = (double)this.previewWidth - y;
            y = tmp;
        }
        Rect cropRegion = (Rect)this.mPreviewBuilder.get(CaptureRequest.SCALER_CROP_REGION);
        if (null == cropRegion) {
            GenseeLog.e((String)this.TAG, (String)"can't get crop region");
            cropRegion = this.mActiveArraySize;
        }
        if (this.previewHeight * (cropWidth = cropRegion.width()) > this.previewWidth * (cropHeight = cropRegion.height())) {
            imgScale = (double)cropHeight * 1.0 / (double)this.previewHeight;
            verticalOffset = 0.0;
            horizontalOffset = ((double)cropWidth - imgScale * (double)this.previewWidth) / 2.0;
        } else {
            imgScale = (double)cropWidth * 1.0 / (double)this.previewWidth;
            horizontalOffset = 0.0;
            verticalOffset = ((double)cropHeight - imgScale * (double)this.previewHeight) / 2.0;
        }
        x = x * imgScale + horizontalOffset + (double)cropRegion.left;
        y = y * imgScale + verticalOffset + (double)cropRegion.top;
        double tapAreaRatio = 0.1;
        Rect rect = new Rect();
        rect.left = this.clamp((int)(x - tapAreaRatio / 2.0 * (double)cropRegion.width()), 0, cropRegion.width());
        rect.right = this.clamp((int)(x + tapAreaRatio / 2.0 * (double)cropRegion.width()), 0, cropRegion.width());
        rect.top = this.clamp((int)(y - tapAreaRatio / 2.0 * (double)cropRegion.height()), 0, cropRegion.height());
        rect.bottom = this.clamp((int)(y + tapAreaRatio / 2.0 * (double)cropRegion.height()), 0, cropRegion.height());
        GenseeLog.d((String)this.TAG, (String)(" rect left = " + rect.left + " right = " + rect.right + " top = " + rect.top + " bottom = " + rect.bottom));
        Object object = this.cameraLock;
        synchronized (object) {
            if (null == this.mCameraDevice || null == this.mCaptureSession || null == this.mPreviewBuilder) {
                if (null != this.onCameraInfoListener) {
                    this.onCameraInfoListener.onManualFocus(false);
                }
                return;
            }
            this.mPreviewBuilder.set(CaptureRequest.CONTROL_AF_REGIONS, (Object)new MeteringRectangle[]{new MeteringRectangle(rect, 1000)});
            this.mPreviewBuilder.set(CaptureRequest.CONTROL_AE_REGIONS, (Object)new MeteringRectangle[]{new MeteringRectangle(rect, 1000)});
            this.mPreviewBuilder.set(CaptureRequest.CONTROL_AF_MODE, (Object)1);
            this.mPreviewBuilder.set(CaptureRequest.CONTROL_AF_TRIGGER, (Object)1);
            this.mPreviewBuilder.set(CaptureRequest.CONTROL_AE_PRECAPTURE_TRIGGER, (Object)1);
            try {
                this.mCaptureSession.setRepeatingRequest(this.mPreviewBuilder.build(), this.mAfCaptureCallback, this.mBackgroundHandler);
            }
            catch (CameraAccessException e) {
                GenseeLog.e((String)this.TAG, (String)("setRepeatingRequest failed, " + e.getMessage()));
            }
        }
    }

    public int getCameraDisplayOrientation(Activity activity, CameraCharacteristics info) {
        int result;
        int rotation = activity.getWindowManager().getDefaultDisplay().getRotation();
        int degrees = 0;
        switch (rotation) {
            case 0: {
                degrees = 0;
                break;
            }
            case 1: {
                degrees = 90;
                break;
            }
            case 2: {
                degrees = 180;
                break;
            }
            case 3: {
                degrees = 270;
            }
        }
        if ((Integer)info.get(CameraCharacteristics.LENS_FACING) == 0) {
            result = ((Integer)info.get(CameraCharacteristics.SENSOR_ORIENTATION) + degrees) % 360;
            result = (360 - result) % 360;
        } else {
            result = ((Integer)info.get(CameraCharacteristics.SENSOR_ORIENTATION) - degrees + 360) % 360;
        }
        return result;
    }

    @Override
    public void doCameraSwitch() {
        if (null == this.cameraManager) {
            GenseeLog.w((String)this.TAG, (String)"_doSwitchCamera cameraManager==null");
            return;
        }
        int num = 0;
        try {
            String[] ids = this.cameraManager.getCameraIdList();
            num = ids.length;
        }
        catch (CameraAccessException e) {
            GenseeLog.e((String)this.TAG, (String)"do camera switch ids length failure");
        }
        if (num < 2) {
            GenseeLog.w((String)this.TAG, (String)"this divice can't switch camera");
            return;
        }
        GenseeLog.d((String)this.TAG, (String)("cameraIdList size = " + num));
        this._releaseCamera();
        CameraManager manager = (CameraManager)ResourceUtil.getIns().getContext().getSystemService("camera");
        try {
            Integer lastCameraFacing = null;
            for (String cameraId : manager.getCameraIdList()) {
                if (!TextUtils.equals((CharSequence)cameraId, (CharSequence)(this.cameraIndex + ""))) continue;
                lastCameraFacing = (Integer)this.characteristics.get(CameraCharacteristics.LENS_FACING);
                break;
            }
            int nowCameraFacing = 0;
            if (null != lastCameraFacing && lastCameraFacing == 0) {
                nowCameraFacing = 1;
            }
            for (int cameraId = 0; cameraId < manager.getCameraIdList().length; ++cameraId) {
                Integer facing;
                CameraCharacteristics characteristics = manager.getCameraCharacteristics(cameraId + "");
                StreamConfigurationMap map = (StreamConfigurationMap)characteristics.get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP);
                if (map == null || (facing = (Integer)characteristics.get(CameraCharacteristics.LENS_FACING)) == null || facing != nowCameraFacing) continue;
                this.cameraIndex = cameraId;
                break;
            }
        }
        catch (CameraAccessException e) {
            GenseeLog.e((String)this.TAG, (String)("CameraAccessException e" + (Object)((Object)e)));
            e.printStackTrace();
        }
        this._doOpenCamera();
        if (null != this.iVideoCoreInterface) {
            this.iVideoCoreInterface.saveCameraId(this.cameraIndex);
        }
    }

    @Override
    public boolean isSupportFlashOnOrOff() {
        if (null != this.characteristics) {
            return (Boolean)this.characteristics.get(CameraCharacteristics.FLASH_INFO_AVAILABLE);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isSupportFocusAuto() {
        Object object = this.cameraLock;
        synchronized (object) {
            if (null == this.characteristics) {
                return false;
            }
            int[] afs = (int[])this.characteristics.get(CameraCharacteristics.CONTROL_AF_AVAILABLE_MODES);
            if (null == afs || afs.length <= 0) {
                return false;
            }
            for (int af : afs) {
                GenseeLog.d((String)this.TAG, (String)("isSupportFocusAuto af = " + af));
                if (af != 1) continue;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void switchFlashOnOrOff(boolean bOpen) {
        Object object = this.cameraLock;
        synchronized (object) {
            if (null == this.mPreviewBuilder || null == this.mCaptureSession) {
                GenseeLog.w((String)this.TAG, (String)"switchFlashOnOrOff return");
                return;
            }
            if (bOpen) {
                this.mPreviewBuilder.set(CaptureRequest.FLASH_MODE, (Object)2);
            } else {
                this.mPreviewBuilder.set(CaptureRequest.FLASH_MODE, (Object)0);
            }
            try {
                this.mCaptureSession.setRepeatingRequest(this.mPreviewBuilder.build(), null, this.mBackgroundHandler);
            }
            catch (CameraAccessException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    protected void doCloseCamera() {
        this._releaseCamera();
    }

    @Override
    public void releaseCamera() {
        this._releaseCamera();
    }

    @Override
    public void release() {
        this.stopBackgroundThread();
    }
}

