/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.camera;

import android.app.Activity;
import android.graphics.Rect;
import android.graphics.RectF;
import android.hardware.Camera;
import android.util.Size;
import com.gensee.camera.BaseCamera;
import com.gensee.pipline.GLEventPipeline;
import com.gensee.texture.CameraTextureManager;
import com.gensee.util.ResourceUtil;
import com.gensee.utils.GenseeLog;
import java.util.ArrayList;
import java.util.List;

public class Camera1Impl
extends BaseCamera {
    private GLEventPipeline pipeline;
    private CameraTextureManager textureManager;
    private Camera mCamera;
    private Camera.CameraInfo cameraInfo = new Camera.CameraInfo();
    private boolean mFocusAreaSupported;
    private boolean mMeteringAreaSupported;
    private ArrayList<Camera.Area> mFocusArea;
    private ArrayList<Camera.Area> mMeteringArea;

    private Camera1Impl() {
    }

    public Camera1Impl(CameraTextureManager textureManager) {
        this.textureManager = textureManager;
        this.pipeline = GLEventPipeline.getInstance();
    }

    @Override
    protected void doOpenCamera() {
        GenseeLog.i((String)this.TAG, (String)"doOpenCamera");
        if (null != this.mCamera) {
            this.calculateRotate();
            return;
        }
        this.openCameraAndPreview();
    }

    @Override
    public void setOutputSize(int width, int height) {
        this.textureManager.setOutputSize(width, height);
    }

    private void openCameraAndPreview() {
        this.stopPreview();
        this.textureManager.updateTexture();
        this.textureManager.surfaceTexture.setOnFrameAvailableListener(this.onFrameAvailableListener);
        if (!this.openCameraWithIndex() || !this.checkCameraPermission()) {
            if (null != this.onCameraPermissionListener && this.mCamera == null) {
                this.onCameraPermissionListener.onCameraPermission();
            }
            return;
        }
        this.prepare();
        this.textureManager.updateLocation(this.previewWidth, this.previewHeight, this.videoParam.width, this.videoParam.height);
        this.startPreview();
    }

    private boolean openCameraWithIndex() {
        GenseeLog.i((String)("openCameraWithIndex, cameraIndex = " + this.cameraIndex));
        if (this.cameraIndex != -1) {
            Camera.getCameraInfo((int)this.cameraIndex, (Camera.CameraInfo)this.cameraInfo);
            this.mCamera = this.openCamera(this.cameraIndex);
        } else {
            int index;
            int cameraNum = Camera.getNumberOfCameras();
            if (cameraNum == 1) {
                Camera.getCameraInfo((int)index, (Camera.CameraInfo)this.cameraInfo);
                this.mCamera = this.openCamera(index);
            } else {
                for (index = 0; index < cameraNum; ++index) {
                    Camera.getCameraInfo((int)index, (Camera.CameraInfo)this.cameraInfo);
                    if (1 != this.cameraInfo.facing) continue;
                    this.mCamera = this.openCamera(index);
                    if (this.mCamera == null) continue;
                    this.cameraIndex = index;
                    break;
                }
            }
        }
        GenseeLog.d((String)this.TAG, (String)("initCamera mCamera = " + this.mCamera));
        return this.mCamera != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Camera openCamera(int index) {
        Camera tmp = null;
        Object object = this.cameraLock;
        synchronized (object) {
            try {
                GenseeLog.i((String)("openCamera 4 index = " + index));
                tmp = Camera.open((int)index);
                this.setCameraDisplayOrientation(tmp);
            }
            catch (RuntimeException e) {
                e.printStackTrace();
                GenseeLog.w((String)this.TAG, (String)("openCamera " + e.toString()));
            }
            GenseeLog.i((String)("openCamera index = " + index + " camera = " + (null == tmp ? "null" : tmp.toString())));
            if (null != this.onCameraInfoListener) {
                this.onCameraInfoListener.onCameraInfo(tmp, this.cameraInfo, index);
                this.onCameraInfoListener.onCameraOpen(null != tmp);
            }
            return tmp;
        }
    }

    private void prepare() {
        try {
            List fpsRange;
            List focusModes;
            List sceneModes;
            List flashModes;
            Camera.Parameters p = this.mCamera.getParameters();
            List ss = p.getSupportedPreviewSizes();
            ArrayList<Size> outSizeList = new ArrayList<Size>();
            if (ss != null) {
                for (int i = ss.size() - 1; i >= 0; --i) {
                    Camera.Size s = (Camera.Size)ss.get(i);
                    if (Math.max(s.width, s.height) < 300) {
                        GenseeLog.d((String)this.TAG, (String)("Supported w = " + s.width + " h = " + s.height + "(size too small, remove this)"));
                        ss.remove(s);
                        continue;
                    }
                    outSizeList.add(new Size(s.width, s.height));
                    GenseeLog.d((String)this.TAG, (String)("Supported w = " + s.width + " h = " + s.height));
                }
            }
            Size optimalSize = this.getOptimalPreviewSize2(outSizeList);
            this.previewWidth = optimalSize.getWidth();
            this.previewHeight = optimalSize.getHeight();
            p.setPreviewSize(optimalSize.getWidth(), optimalSize.getHeight());
            this.notifyPreviewSize();
            if (p.getSupportedPreviewFormats().contains(17)) {
                p.setPreviewFormat(17);
            } else {
                p.setPreviewFormat(842094169);
            }
            GenseeLog.d((String)this.TAG, (String)("preview optimalSize w =  " + optimalSize.getWidth() + " h = " + optimalSize.getHeight()));
            List modes = p.getSupportedSceneModes();
            if (null != modes && modes.contains("auto")) {
                p.setWhiteBalance("auto");
            }
            if (null != (flashModes = p.getSupportedFlashModes()) && flashModes.contains("auto")) {
                p.setFlashMode("auto");
            }
            if (null != (sceneModes = p.getSupportedSceneModes()) && sceneModes.contains("auto")) {
                p.setSceneMode("auto");
            }
            if (null != (focusModes = p.getSupportedFocusModes())) {
                if (focusModes.contains("continuous-video")) {
                    p.setFocusMode("continuous-video");
                } else if (focusModes.contains("continuous-picture")) {
                    p.setFocusMode("continuous-picture");
                } else if (focusModes.contains("auto")) {
                    p.setFocusMode("auto");
                }
            }
            if (null == (fpsRange = p.getSupportedPreviewFpsRange())) {
                GenseeLog.e((String)this.TAG, (String)"getSupportedPreviewFpsRange == null");
                return;
            }
            int fpsMin = 0;
            int fpsMax = 0;
            for (int i = 0; i < fpsRange.size(); ++i) {
                int[] fps = (int[])fpsRange.get(i);
                if (30000 < fps[0] || 30000 > fps[1]) continue;
                if (fpsMin <= 0 || fpsMax <= 0) {
                    fpsMin = fps[0];
                    fpsMax = fps[1];
                    continue;
                }
                if (fps[1] == fpsMax) {
                    if (Math.abs(fps[0] - 30000) >= Math.abs(fpsMin - 30000)) continue;
                    fpsMin = fps[0];
                    fpsMax = fps[1];
                    continue;
                }
                if (fps[1] >= fpsMax) continue;
                fpsMin = fps[0];
                fpsMax = fps[1];
            }
            if (fpsMin > 0 && fpsMax > 0) {
                p.setPreviewFpsRange(fpsMin, fpsMax);
                GenseeLog.i((String)this.TAG, (String)("camera fps fpsMin = " + fpsMin + " fpsMax = " + fpsMax));
            }
            if (p.isAutoExposureLockSupported()) {
                p.setAutoExposureLock(false);
            }
            if (p.isVideoStabilizationSupported()) {
                p.setVideoStabilization(true);
            }
            this.mCamera.setParameters(p);
        }
        catch (Exception ex) {
            this.stopPreview();
            GenseeLog.e((String)this.TAG, (String)"openCamera fail");
            GenseeLog.e((String)this.TAG, (Throwable)ex);
        }
    }

    private void startPreview() {
        GenseeLog.i((String)this.TAG, (String)"startPreview()");
        this.calculateRotate();
        try {
            this.mCamera.setPreviewTexture(this.textureManager.surfaceTexture);
            this.mCamera.startPreview();
            this.mPreviewRunning = true;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.releaseCamera();
            GenseeLog.e((String)("startPreview Exception e:" + e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopPreview() {
        if (null == this.mCamera) {
            return;
        }
        try {
            Object object = this.cameraLock;
            synchronized (object) {
                this.mCamera.setPreviewCallback(null);
                this.mCamera.setPreviewTexture(null);
                this.mCamera.stopPreview();
                this.mCamera.release();
                this.mCamera = null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            GenseeLog.e((String)this.TAG, (String)("stopPreview exception=" + e.getMessage()));
        }
    }

    public void setCameraDisplayOrientation(Camera camera) {
        int result;
        if (null == this.cameraInfo || camera == null) {
            GenseeLog.e((String)"setCameraDisplayOrientation fail!");
            return;
        }
        Camera.CameraInfo info = this.cameraInfo;
        int rotation = ((Activity)ResourceUtil.getIns().getContext()).getWindowManager().getDefaultDisplay().getRotation();
        int degrees = 0;
        switch (rotation) {
            case 0: {
                degrees = 0;
                break;
            }
            case 1: {
                degrees = 90;
                break;
            }
            case 2: {
                degrees = 180;
                break;
            }
            case 3: {
                degrees = 270;
            }
        }
        if (info.facing == 1) {
            result = (info.orientation + degrees) % 360;
            result = (360 - result) % 360;
        } else {
            result = (info.orientation - degrees + 360) % 360;
        }
        camera.setDisplayOrientation(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateRotate() {
        Object object = this.cameraLock;
        synchronized (object) {
            this.setCameraDisplayOrientation(this.mCamera);
        }
    }

    @Override
    public boolean isCameraSwitchEnable() {
        return Camera.getNumberOfCameras() > 1;
    }

    @Override
    public boolean isSupportFlashOnOrOff() {
        if (null == this.mCamera) {
            return false;
        }
        Camera.Parameters parameters = null;
        try {
            parameters = this.mCamera.getParameters();
        }
        catch (Exception e) {
            this.mCamera = null;
        }
        if (parameters == null) {
            return false;
        }
        List flashModes = parameters.getSupportedFlashModes();
        if (flashModes == null) {
            return false;
        }
        return flashModes.contains("torch");
    }

    @Override
    public void switchFlashOnOrOff(boolean bOpen) {
        if (this.mCamera == null) {
            return;
        }
        Camera.Parameters parameters = this.mCamera.getParameters();
        if (parameters == null) {
            return;
        }
        List flashModes = parameters.getSupportedFlashModes();
        if (flashModes == null) {
            return;
        }
        String flashMode = parameters.getFlashMode();
        if (bOpen) {
            if (!"torch".equals(flashMode) && flashModes.contains("torch")) {
                parameters.setFlashMode("torch");
                this.mCamera.setParameters(parameters);
            }
        } else if (!"off".equals(flashMode) && flashModes.contains("off")) {
            parameters.setFlashMode("off");
            this.mCamera.setParameters(parameters);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isSupportFocusAuto() {
        Object object = this.cameraLock;
        synchronized (object) {
            if (null != this.mCamera) {
                Camera.Parameters parameters = this.mCamera.getParameters();
                List lists = parameters.getSupportedFocusModes();
                return this.isSupported("auto", lists);
            }
            return false;
        }
    }

    private boolean isSupported(String value, List<String> supported) {
        return supported != null && supported.contains(value);
    }

    @Override
    public void focusOnTouch(double x, double y, int focusWidth, int focusHeight, int viewWidth, int viewHeight) {
        Camera.Parameters mInitialParams = this.mCamera.getParameters();
        this.mFocusAreaSupported = mInitialParams.getMaxNumFocusAreas() > 0 && this.isSupported("auto", mInitialParams.getSupportedFocusModes());
        boolean bl = this.mMeteringAreaSupported = mInitialParams.getMaxNumMeteringAreas() > 0;
        if (this.mFocusArea == null) {
            this.mFocusArea = new ArrayList();
            this.mFocusArea.add(new Camera.Area(new Rect(), 1));
            this.mMeteringArea = new ArrayList();
            this.mMeteringArea.add(new Camera.Area(new Rect(), 1));
        }
        Rect focusRect = this.calculateTapArea(x, y, 1.0f, viewWidth, viewHeight);
        Rect meteringRect = this.calculateTapArea(x, y, 1.5f, viewWidth, viewHeight);
        this.mCamera.cancelAutoFocus();
        this.mFocusArea.clear();
        this.mFocusArea.add(new Camera.Area(focusRect, 800));
        this.mMeteringArea.clear();
        this.mMeteringArea.add(new Camera.Area(meteringRect, 800));
        try {
            final String currentFocusMode = mInitialParams.getFocusMode();
            mInitialParams.setFocusMode("macro");
            this.setFocusParameters();
            this.mCamera.autoFocus(new Camera.AutoFocusCallback(){

                public void onAutoFocus(boolean success, Camera camera) {
                    if (null != Camera1Impl.this.onCameraInfoListener) {
                        Camera1Impl.this.onCameraInfoListener.onManualFocus(success);
                    }
                    Camera.Parameters params = camera.getParameters();
                    params.setFocusMode(currentFocusMode);
                    camera.setParameters(params);
                }
            });
        }
        catch (Exception e) {
            GenseeLog.e((String)this.TAG, (String)("autoFocus exception e.msg = " + e.getMessage()));
        }
    }

    private Rect calculateTapArea(double x, double y, float coefficient, int viewWidth, int viewHeight) {
        float focusAreaSize = 300.0f;
        int areaSize = Float.valueOf(focusAreaSize * coefficient).intValue();
        int centerX = (int)(x / (double)viewWidth * 2000.0 - 1000.0);
        int centerY = (int)(y / (double)viewHeight * 2000.0 - 1000.0);
        int halfAreaSize = areaSize / 2;
        RectF rectF = new RectF((float)this.clamp(centerX - halfAreaSize, -1000, 1000), (float)this.clamp(centerY - halfAreaSize, -1000, 1000), (float)this.clamp(centerX + halfAreaSize, -1000, 1000), (float)this.clamp(centerY + halfAreaSize, -1000, 1000));
        GenseeLog.i((String)this.TAG, (String)("calculateTapArea rectF=" + rectF));
        return new Rect(Math.round(rectF.left), Math.round(rectF.top), Math.round(rectF.right), Math.round(rectF.bottom));
    }

    private void setFocusParameters() {
        Camera.Parameters mParameters = this.mCamera.getParameters();
        mParameters.setFlashMode("off");
        if (this.mFocusAreaSupported) {
            mParameters.setFocusAreas(this.mFocusArea);
        }
        if (this.mMeteringAreaSupported) {
            mParameters.setMeteringAreas(this.mMeteringArea);
        }
        this.mCamera.setParameters(mParameters);
    }

    @Override
    public void doCameraSwitch() {
        int num = Camera.getNumberOfCameras();
        if (num < 2) {
            GenseeLog.w((String)("this device can't switch camera,getNumberOfCameras=" + num));
            return;
        }
        this.cameraIndex = (this.cameraIndex + 1) % num;
        this.pipeline.queueEvent(new Runnable(){

            @Override
            public void run() {
                Camera1Impl.this.openCameraAndPreview();
            }
        });
        if (null != this.iVideoCoreInterface) {
            this.iVideoCoreInterface.saveCameraId(this.cameraIndex);
        }
    }

    @Override
    public void releaseCamera() {
        this.stopPreview();
    }

    @Override
    protected void doCloseCamera() {
        this.stopPreview();
    }

    @Override
    public void release() {
        this.stopPreview();
        this.mBeginPreviewRunning = false;
        this.mPreviewRunning = false;
    }
}

