/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.camera;

import android.content.Context;
import android.graphics.SurfaceTexture;
import android.os.Process;
import android.util.Size;
import com.gensee.camera.ICamera;
import com.gensee.util.ResourceUtil;
import com.gensee.utils.GenseeLog;
import com.gensee.videoparam.IVideoCoreInterface;
import com.gensee.videoparam.VideoParam;
import com.gensee.view.ILocalVideoView;
import java.util.List;

public abstract class BaseCamera
implements ICamera {
    protected final String TAG = this.getClass().getSimpleName();
    protected int previewWidth;
    protected int previewHeight;
    protected IVideoCoreInterface iVideoCoreInterface;
    protected VideoParam videoParam;
    protected boolean mBeginPreviewRunning;
    protected boolean mPreviewRunning;
    protected int cameraIndex;
    protected int orientation;
    protected final Object cameraLock = new Object();
    protected final int BASE_FPS = 30000;
    protected SurfaceTexture.OnFrameAvailableListener onFrameAvailableListener;
    protected ILocalVideoView.OnCameraPermissionListener onCameraPermissionListener;
    protected ILocalVideoView.OnCameraInfoListener onCameraInfoListener;
    protected CameraImplCallback cameraImplCallback;

    public void setCameraImplCallback(CameraImplCallback cameraImplCallback) {
        this.cameraImplCallback = cameraImplCallback;
    }

    public void setOnFrameAvailableListener(SurfaceTexture.OnFrameAvailableListener onFrameAvailableListener) {
        this.onFrameAvailableListener = onFrameAvailableListener;
    }

    @Override
    public void setParams(Object param, IVideoCoreInterface iVideoCoreInterface) {
        this.iVideoCoreInterface = iVideoCoreInterface;
        if (param instanceof VideoParam) {
            GenseeLog.i((String)"videocapture open start");
            this.setVideoParam((VideoParam)param);
            this.mBeginPreviewRunning = true;
        }
    }

    public void setVideoParam(VideoParam param) {
        this.videoParam = param;
        int outputWidth = null == param ? 320 : param.width;
        int outputHeight = null == param ? 240 : param.height;
        this.setOutputSize(outputWidth, outputHeight);
        if (this.iVideoCoreInterface != null) {
            this.cameraIndex = this.iVideoCoreInterface.getCameraId();
            if (this.cameraIndex == -1) {
                this.cameraIndex = this.videoParam.cameraIndex;
                this.iVideoCoreInterface.saveCameraId(this.cameraIndex);
            }
        } else {
            this.cameraIndex = this.videoParam.cameraIndex;
        }
    }

    public void setPreviewSize(int width, int height) {
        this.previewWidth = width;
        this.previewHeight = height;
    }

    @Override
    public void open() {
        GenseeLog.i((String)this.TAG, (String)"start open camera 1");
        this.doOpenCamera();
    }

    @Override
    public void close() {
        GenseeLog.i((String)this.TAG, (String)"camera close start");
        this.cameraIndex = -1;
        this.mBeginPreviewRunning = false;
        if (null != this.iVideoCoreInterface) {
            this.iVideoCoreInterface.saveCameraId(this.cameraIndex);
        }
        this.doCloseCamera();
        this.mPreviewRunning = false;
    }

    public boolean isPreviewing() {
        return this.mBeginPreviewRunning && this.mPreviewRunning;
    }

    protected Size getOptimalPreviewSize(List<Size> ss) {
        int bestWidth = 0;
        int bestHeight = 0;
        for (Size size : ss) {
            if (size.getWidth() < this.videoParam.height || size.getHeight() < this.videoParam.width || size.getWidth() * size.getHeight() >= bestWidth * bestHeight && 0 != bestWidth * bestHeight) continue;
            bestWidth = size.getWidth();
            bestHeight = size.getHeight();
        }
        return new Size(bestWidth, bestHeight);
    }

    protected Size getOptimalPreviewSize2(List<Size> sizes) {
        if (sizes == null) {
            return null;
        }
        int outW = this.videoParam.width;
        int outH = this.videoParam.height;
        double ASPECT_TOLERANCE = 0.05;
        double targetRatio = (double)outW / (double)outH;
        Size optimalSize = null;
        double minDiff = Double.MAX_VALUE;
        for (Size size : sizes) {
            double ratio;
            if (size.getWidth() < outW || size.getHeight() < outH || Math.abs((ratio = (double)size.getWidth() / (double)size.getHeight()) - targetRatio) > 0.05 || !((double)Math.abs(size.getHeight() - outH) < minDiff)) continue;
            optimalSize = size;
            minDiff = Math.abs(size.getHeight() - outH);
        }
        if (optimalSize == null) {
            minDiff = Double.MAX_VALUE;
            for (Size size : sizes) {
                if (!((double)Math.abs(size.getHeight() - outH) < minDiff)) continue;
                optimalSize = size;
                minDiff = Math.abs(size.getHeight() - outH);
            }
        }
        return optimalSize;
    }

    protected void notifyPreviewSize() {
        if (this.onCameraInfoListener != null) {
            if (this.orientation == 2) {
                this.onCameraInfoListener.onPreviewSize(this.previewWidth, this.previewHeight);
            } else {
                this.onCameraInfoListener.onPreviewSize(this.previewHeight, this.previewWidth);
            }
        }
        if (null != this.cameraImplCallback) {
            this.cameraImplCallback.onPreviewSize(this.previewWidth, this.previewHeight);
        }
    }

    protected boolean checkCameraPermission() {
        Context context = ResourceUtil.getIns().getContext();
        if (null == context) {
            GenseeLog.w((String)this.TAG, (String)"checkCameraPermission context = null");
            return false;
        }
        int cameraPermission = context.checkPermission("android.permission.CAMERA", Process.myPid(), Process.myUid());
        if (cameraPermission != 0) {
            if (null != this.onCameraPermissionListener) {
                this.onCameraPermissionListener.onCameraPermission();
            }
            GenseeLog.w((String)this.TAG, (String)("checkCameraPermission camera permission not granted, onCameraPermissionListener is " + this.onCameraPermissionListener));
            return false;
        }
        return true;
    }

    protected int clamp(int x, int min, int max) {
        if (x > max) {
            return max;
        }
        if (x < min) {
            return min;
        }
        return x;
    }

    public void setOnCameraInfoListener(ILocalVideoView.OnCameraInfoListener onCameraInfoListener) {
        this.onCameraInfoListener = onCameraInfoListener;
    }

    public void setOnCameraPermissionListener(ILocalVideoView.OnCameraPermissionListener onCameraPermissionListener) {
        this.onCameraPermissionListener = onCameraPermissionListener;
    }

    protected abstract void doOpenCamera();

    protected abstract void doCloseCamera();

    protected abstract void calculateRotate();

    protected abstract void setOutputSize(int var1, int var2);

    public abstract boolean isCameraSwitchEnable();

    public abstract void focusOnTouch(double var1, double var3, int var5, int var6, int var7, int var8);

    public static interface CameraImplCallback {
        public void onPreviewSize(int var1, int var2);
    }
}

