/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.beauty.filter.gpuimage;

import android.opengl.GLES20;
import android.util.Log;
import com.gensee.beauty.filter.utils.Rotation;
import com.gensee.beauty.filter.utils.TextureRotationUtil;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;

public class GPUCameraInputFilter {
    public static final int NO_TEXTURE = -1;
    public static final int NOT_INIT = -1;
    public static final int ON_DRAWN = 1;
    private int programHandle;
    int[] uniforms = new int[3];
    private int[] _textureY;
    private int[] _textureU;
    private int[] _textureV;
    private FloatBuffer verticleBuffer;
    private FloatBuffer coordBuffer;
    private boolean mIsInitialized;
    protected int mOutputWidth;
    protected int mOutputHeight;
    private int[] mFrameBuffers = null;
    private int[] mFrameBufferTextures = null;
    private int mFrameWidth = -1;
    private int mFrameHeight = -1;
    private byte[] yData;
    private byte[] uData;
    private byte[] vData;

    public void init() {
        this.programHandle = 0;
        this._textureU = new int[1];
        this._textureV = new int[1];
        this._textureY = new int[1];
        this.verticleBuffer = ByteBuffer.allocateDirect(TextureRotationUtil.CUBE.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
        this.verticleBuffer.put(TextureRotationUtil.CUBE).position(0);
        this.coordBuffer = ByteBuffer.allocateDirect(TextureRotationUtil.TEXTURE_NO_ROTATION.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
        this.coordBuffer.put(TextureRotationUtil.getRotation(Rotation.NORMAL, false, true)).position(0);
        this.loadShaders();
        this.setupBuffers();
        this.mIsInitialized = true;
    }

    public void setFlipHorizontalAndVertical(boolean flipHorizontal, boolean flipVertical) {
        this.coordBuffer.clear();
        this.coordBuffer.put(TextureRotationUtil.getRotation(Rotation.NORMAL, flipHorizontal, !flipVertical)).position(0);
    }

    private void loadShaders() {
        String vertexShader = "\nattribute vec4  position;                              \nattribute vec2  TextCoordIn;                           \nvarying  vec2 TextCoordOut;                            \n                                                       \nvoid main(void)                                        \n{                                                      \n   gl_Position = position;                             \n   TextCoordOut = TextCoordIn;                         \n}                                                      \n";
        String fragmentShader = "precision mediump float;\nuniform sampler2D SamplerY;\t\t\t\t\t\nuniform sampler2D SamplerU;\t\t\t\t\t\nuniform sampler2D SamplerV;\t\t\t\t\t\nvarying highp vec2 TextCoordOut;\t\t\t\t\t\t\t\nvoid main()                                  \n{                                            \nfloat y,u,v,r,g,b, gradx, grady; \ny = texture2D(SamplerY, TextCoordOut).a;\nu = texture2D(SamplerU, TextCoordOut).a;\nv = texture2D(SamplerV, TextCoordOut).a;\ny = 1.16438355 * (y - 0.0625);\nu = u - 0.5;\nv = v - 0.5;\nr = clamp(y + 1.596 * v, 0.0, 1.0);\ng = clamp(y - 0.391 * u - 0.813 * v, 0.0, 1.0);\nb = clamp(y + 2.018 * u, 0.0, 1.0);\ngl_FragColor = vec4(r,g,b,1.0);\n}\n";
        int vertexShaderHandle = GLES20.glCreateShader((int)35633);
        if (vertexShaderHandle != 0) {
            GLES20.glShaderSource((int)vertexShaderHandle, (String)"\nattribute vec4  position;                              \nattribute vec2  TextCoordIn;                           \nvarying  vec2 TextCoordOut;                            \n                                                       \nvoid main(void)                                        \n{                                                      \n   gl_Position = position;                             \n   TextCoordOut = TextCoordIn;                         \n}                                                      \n");
            GLES20.glCompileShader((int)vertexShaderHandle);
            int[] compileStatus = new int[1];
            GLES20.glGetShaderiv((int)vertexShaderHandle, (int)35713, (int[])compileStatus, (int)0);
            if (compileStatus[0] == 0) {
                Log.e((String)"ES20_ERROR", (String)("ES20_ERROR = " + GLES20.glGetShaderInfoLog((int)vertexShaderHandle)));
                GLES20.glDeleteShader((int)vertexShaderHandle);
                vertexShaderHandle = 0;
            }
        }
        if (vertexShaderHandle == 0) {
            throw new RuntimeException("failed to creating vertex shader");
        }
        int fragmentShaderHandle = GLES20.glCreateShader((int)35632);
        if (fragmentShaderHandle != 0) {
            GLES20.glShaderSource((int)fragmentShaderHandle, (String)"precision mediump float;\nuniform sampler2D SamplerY;\t\t\t\t\t\nuniform sampler2D SamplerU;\t\t\t\t\t\nuniform sampler2D SamplerV;\t\t\t\t\t\nvarying highp vec2 TextCoordOut;\t\t\t\t\t\t\t\nvoid main()                                  \n{                                            \nfloat y,u,v,r,g,b, gradx, grady; \ny = texture2D(SamplerY, TextCoordOut).a;\nu = texture2D(SamplerU, TextCoordOut).a;\nv = texture2D(SamplerV, TextCoordOut).a;\ny = 1.16438355 * (y - 0.0625);\nu = u - 0.5;\nv = v - 0.5;\nr = clamp(y + 1.596 * v, 0.0, 1.0);\ng = clamp(y - 0.391 * u - 0.813 * v, 0.0, 1.0);\nb = clamp(y + 2.018 * u, 0.0, 1.0);\ngl_FragColor = vec4(r,g,b,1.0);\n}\n");
            GLES20.glCompileShader((int)fragmentShaderHandle);
            int[] compileStatus = new int[1];
            GLES20.glGetShaderiv((int)fragmentShaderHandle, (int)35713, (int[])compileStatus, (int)0);
            if (compileStatus[0] == 0) {
                GLES20.glDeleteShader((int)fragmentShaderHandle);
                fragmentShaderHandle = 0;
            }
        }
        if (fragmentShaderHandle == 0) {
            throw new RuntimeException("failed to create fragment shader");
        }
        this.programHandle = GLES20.glCreateProgram();
        if (this.programHandle != 0) {
            GLES20.glAttachShader((int)this.programHandle, (int)vertexShaderHandle);
            GLES20.glAttachShader((int)this.programHandle, (int)fragmentShaderHandle);
            GLES20.glBindAttribLocation((int)this.programHandle, (int)0, (String)"position");
            GLES20.glBindAttribLocation((int)this.programHandle, (int)1, (String)"TexCoordIn");
            GLES20.glLinkProgram((int)this.programHandle);
            int[] linkStatus = new int[1];
            GLES20.glGetProgramiv((int)this.programHandle, (int)35714, (int[])linkStatus, (int)0);
            if (linkStatus[0] == 0) {
                GLES20.glDeleteProgram((int)this.programHandle);
                this.programHandle = 0;
            }
        }
        if (this.programHandle == 0) {
            throw new RuntimeException("failed to create program");
        }
        this.uniforms[0] = GLES20.glGetUniformLocation((int)this.programHandle, (String)"SamplerY");
        this.uniforms[1] = GLES20.glGetUniformLocation((int)this.programHandle, (String)"SamplerU");
        this.uniforms[2] = GLES20.glGetUniformLocation((int)this.programHandle, (String)"SamplerV");
        if (vertexShaderHandle > 0) {
            GLES20.glDeleteShader((int)vertexShaderHandle);
            vertexShaderHandle = 0;
        }
        if (fragmentShaderHandle > 0) {
            GLES20.glDeleteShader((int)fragmentShaderHandle);
            fragmentShaderHandle = 0;
        }
        this.GetGLError(1);
    }

    private FloatBuffer floatToBuffer(float[] a) {
        ByteBuffer mbb = ByteBuffer.allocateDirect(a.length * 4);
        mbb.order(ByteOrder.nativeOrder());
        FloatBuffer mBuffer = mbb.asFloatBuffer();
        mBuffer.put(a);
        mBuffer.position(0);
        return mBuffer;
    }

    private void setupBuffers() {
        GLES20.glUseProgram((int)this.programHandle);
        GLES20.glGenTextures((int)1, (IntBuffer)IntBuffer.wrap(this._textureY));
        GLES20.glGenTextures((int)1, (IntBuffer)IntBuffer.wrap(this._textureU));
        GLES20.glGenTextures((int)1, (IntBuffer)IntBuffer.wrap(this._textureV));
        GLES20.glUniform1i((int)this.uniforms[0], (int)0);
        GLES20.glUniform1i((int)this.uniforms[1], (int)1);
        GLES20.glUniform1i((int)this.uniforms[2], (int)2);
        this.GetGLError(0);
    }

    private void clearUpTextures() {
        if (null != this._textureY && this._textureY.length > 0 && this._textureY[0] > 0) {
            GLES20.glDeleteTextures((int)1, (IntBuffer)IntBuffer.wrap(this._textureY));
            this._textureY[0] = 0;
        }
        if (null != this._textureU && this._textureU.length > 0 && this._textureU[0] > 0) {
            GLES20.glDeleteTextures((int)1, (IntBuffer)IntBuffer.wrap(this._textureU));
            this._textureU[0] = 0;
        }
        if (null != this._textureV && this._textureV.length > 0 && this._textureV[0] > 0) {
            GLES20.glDeleteTextures((int)1, (IntBuffer)IntBuffer.wrap(this._textureV));
            this._textureV[0] = 0;
        }
    }

    public int getProgram() {
        return this.programHandle;
    }

    public void destroy() {
        this.destroyFramebuffers();
        this.clearUpTextures();
        if (this.programHandle > 0) {
            GLES20.glDeleteProgram((int)this.programHandle);
            this.programHandle = 0;
        }
    }

    public void onDisplaySizeChanged(int width, int height) {
        this.mOutputWidth = width;
        this.mOutputHeight = height;
    }

    private boolean playVideoData(byte[] yuvData) {
        if (null == yuvData) {
            return false;
        }
        if (yuvData.length != this.mFrameWidth * this.mFrameHeight * 3 / 2) {
            return false;
        }
        if (null == this.yData || this.yData.length != this.mFrameWidth * this.mFrameHeight) {
            this.yData = new byte[this.mFrameWidth * this.mFrameHeight];
        }
        System.arraycopy(yuvData, 0, this.yData, 0, this.mFrameWidth * this.mFrameHeight);
        if (null == this.uData || this.uData.length != this.mFrameWidth * this.mFrameHeight / 4) {
            this.uData = new byte[this.mFrameWidth * this.mFrameHeight / 4];
        }
        if (null == this.vData || this.vData.length != this.mFrameWidth * this.mFrameHeight / 4) {
            this.vData = new byte[this.mFrameWidth * this.mFrameHeight / 4];
        }
        System.arraycopy(yuvData, this.mFrameWidth * this.mFrameHeight, this.vData, 0, this.mFrameWidth * this.mFrameHeight / 4);
        System.arraycopy(yuvData, this.mFrameWidth * this.mFrameHeight * 5 / 4, this.uData, 0, this.mFrameWidth * this.mFrameHeight / 4);
        int textureIdY = this._textureY[0];
        GLES20.glActiveTexture((int)33984);
        GLES20.glBindTexture((int)3553, (int)textureIdY);
        GLES20.glTexParameterf((int)3553, (int)10242, (float)33071.0f);
        GLES20.glTexParameterf((int)3553, (int)10243, (float)33071.0f);
        GLES20.glTexParameterf((int)3553, (int)10240, (float)9729.0f);
        GLES20.glTexParameterf((int)3553, (int)10241, (float)9729.0f);
        GLES20.glTexImage2D((int)3553, (int)0, (int)6406, (int)this.mFrameWidth, (int)this.mFrameHeight, (int)0, (int)6406, (int)5121, (Buffer)ByteBuffer.wrap(this.yData));
        GLES20.glActiveTexture((int)33985);
        int textureIdU = this._textureU[0];
        GLES20.glBindTexture((int)3553, (int)textureIdU);
        GLES20.glTexParameterf((int)3553, (int)10242, (float)33071.0f);
        GLES20.glTexParameterf((int)3553, (int)10243, (float)33071.0f);
        GLES20.glTexParameterf((int)3553, (int)10240, (float)9729.0f);
        GLES20.glTexParameterf((int)3553, (int)10241, (float)9729.0f);
        GLES20.glTexImage2D((int)3553, (int)0, (int)6406, (int)(this.mFrameWidth / 2), (int)(this.mFrameHeight / 2), (int)0, (int)6406, (int)5121, (Buffer)ByteBuffer.wrap(this.uData));
        GLES20.glActiveTexture((int)33986);
        int textureIdV = this._textureV[0];
        GLES20.glBindTexture((int)3553, (int)textureIdV);
        GLES20.glTexParameterf((int)3553, (int)10242, (float)33071.0f);
        GLES20.glTexParameterf((int)3553, (int)10243, (float)33071.0f);
        GLES20.glTexParameterf((int)3553, (int)10240, (float)9729.0f);
        GLES20.glTexParameterf((int)3553, (int)10241, (float)9729.0f);
        GLES20.glTexImage2D((int)3553, (int)0, (int)6406, (int)(this.mFrameWidth / 2), (int)(this.mFrameHeight / 2), (int)0, (int)6406, (int)5121, (Buffer)ByteBuffer.wrap(this.vData));
        return true;
    }

    public int onDrawFrame(byte[] yuvData, FloatBuffer cubeBuffer, FloatBuffer textureBuffer) {
        GLES20.glUseProgram((int)this.programHandle);
        if (!this.mIsInitialized) {
            return -1;
        }
        GLES20.glClear((int)16640);
        if (this.playVideoData(yuvData)) {
            GLES20.glVertexAttribPointer((int)0, (int)2, (int)5126, (boolean)false, (int)0, (Buffer)cubeBuffer);
            GLES20.glVertexAttribPointer((int)1, (int)2, (int)5126, (boolean)false, (int)0, (Buffer)textureBuffer);
            GLES20.glEnableVertexAttribArray((int)0);
            GLES20.glEnableVertexAttribArray((int)1);
            GLES20.glDrawArrays((int)5, (int)0, (int)4);
            GLES20.glDisableVertexAttribArray((int)0);
            GLES20.glDisableVertexAttribArray((int)1);
        }
        return 1;
    }

    public int onDrawFrame(byte[] yuvData) {
        GLES20.glClear((int)16640);
        if (this.mFrameBuffers == null) {
            return -1;
        }
        GLES20.glViewport((int)0, (int)0, (int)this.mFrameWidth, (int)this.mFrameHeight);
        GLES20.glBindFramebuffer((int)36160, (int)this.mFrameBuffers[0]);
        GLES20.glUseProgram((int)this.programHandle);
        if (!this.mIsInitialized) {
            return -1;
        }
        if (this.playVideoData(yuvData)) {
            GLES20.glVertexAttribPointer((int)0, (int)2, (int)5126, (boolean)false, (int)0, (Buffer)this.verticleBuffer);
            GLES20.glVertexAttribPointer((int)1, (int)2, (int)5126, (boolean)false, (int)0, (Buffer)this.coordBuffer);
            GLES20.glEnableVertexAttribArray((int)0);
            GLES20.glEnableVertexAttribArray((int)1);
            GLES20.glDrawArrays((int)5, (int)0, (int)4);
            GLES20.glDisableVertexAttribArray((int)0);
            GLES20.glDisableVertexAttribArray((int)1);
            GLES20.glBindTexture((int)36197, (int)0);
            GLES20.glBindFramebuffer((int)36160, (int)0);
            GLES20.glViewport((int)0, (int)0, (int)this.mOutputWidth, (int)this.mOutputHeight);
            return this.mFrameBufferTextures[0];
        }
        return -1;
    }

    public void initCameraFrameBuffer(int width, int height) {
        if (this.mFrameBuffers != null && (this.mFrameWidth != width || this.mFrameHeight != height)) {
            this.destroyFramebuffers();
        }
        if (this.mFrameBuffers == null) {
            this.mFrameWidth = width;
            this.mFrameHeight = height;
            this.mFrameBuffers = new int[1];
            this.mFrameBufferTextures = new int[1];
            GLES20.glGenFramebuffers((int)1, (int[])this.mFrameBuffers, (int)0);
            GLES20.glGenTextures((int)1, (int[])this.mFrameBufferTextures, (int)0);
            GLES20.glBindTexture((int)3553, (int)this.mFrameBufferTextures[0]);
            GLES20.glTexImage2D((int)3553, (int)0, (int)6408, (int)width, (int)height, (int)0, (int)6408, (int)5121, null);
            GLES20.glTexParameterf((int)3553, (int)10240, (float)9729.0f);
            GLES20.glTexParameterf((int)3553, (int)10241, (float)9729.0f);
            GLES20.glTexParameterf((int)3553, (int)10242, (float)33071.0f);
            GLES20.glTexParameterf((int)3553, (int)10243, (float)33071.0f);
            GLES20.glBindFramebuffer((int)36160, (int)this.mFrameBuffers[0]);
            GLES20.glFramebufferTexture2D((int)36160, (int)36064, (int)3553, (int)this.mFrameBufferTextures[0], (int)0);
            GLES20.glBindTexture((int)3553, (int)0);
            GLES20.glBindFramebuffer((int)36160, (int)0);
        }
    }

    public void destroyFramebuffers() {
        if (this.mFrameBufferTextures != null) {
            GLES20.glDeleteTextures((int)1, (int[])this.mFrameBufferTextures, (int)0);
            this.mFrameBufferTextures = null;
        }
        if (this.mFrameBuffers != null) {
            GLES20.glDeleteFramebuffers((int)1, (int[])this.mFrameBuffers, (int)0);
            this.mFrameBuffers = null;
        }
        this.mFrameWidth = -1;
        this.mFrameHeight = -1;
    }

    public void GetGLError(int nCount) {
        int err = GLES20.glGetError();
        while (err != 0) {
            Log.i((String)"GLError", (String)("GLError errorcode = " + err + ", errorResponse = " + this.getGlErrorString(err) + ", nCount = " + nCount));
            err = GLES20.glGetError();
        }
    }

    public String getGlErrorString(int error) {
        String str;
        switch (error) {
            case 0: {
                str = "GL_NO_ERROR";
                break;
            }
            case 1280: {
                str = "GL_INVALID_ENUM";
                break;
            }
            case 1281: {
                str = "GL_INVALID_VALUE";
                break;
            }
            case 1282: {
                str = "GL_INVALID_OPERATION";
                break;
            }
            case 1285: {
                str = "GL_OUT_OF_MEMORY";
                break;
            }
            case 1286: {
                str = "GL_INVALID_FRAMEBUFFER_OPERATION";
                break;
            }
            default: {
                str = "(ERROR: Unknown Error Enum)";
            }
        }
        return str;
    }

    private class UniformSampler {
        public static final int UNIFORM_SAMPLER_Y = 0;
        public static final int UNIFORM_SAMPLER_U = 1;
        public static final int UNIFORM_SAMPLER_V = 2;
        public static final int NUM_UNIFORMS = 3;

        private UniformSampler() {
        }
    }

    private class Attrib {
        public static final int TTRIB_VERTEX = 0;
        public static final int ATTRIB_TEXCOORD = 1;
        public static final int NUM_ATTRIBUTES = 2;

        private Attrib() {
        }
    }
}

