/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.beauty.filter.advanced;

import android.opengl.GLES20;
import com.gensee.beauty.filter.gpuimage.GPUImageFilter;

public class MagicBeautyFilter
extends GPUImageFilter {
    private static final String DEFAULT_BEAUTY = "//I just want to see the result.\nprecision highp float;\n\nuniform sampler2D inputImageTexture;\nuniform float texelWidthOffset;\nuniform float texelHeightOffset;\n\nvarying vec2 textureCoordinate;\n\nconst vec4 params = vec4(0.33, 0.63, 0.4, 0.35);\nconst highp vec3 W = vec3(0.299,0.587,0.114);\nconst mat3 saturateMatrix = mat3(\n                                1.1102,-0.0598,-0.061,\n                                -0.0774,1.0826,-0.1186,\n                                -0.0228,-0.0228,1.1772);\n\n//why it's not in vsh -_-\nvec2 blurCoordinates[24];\n\nfloat hardLight(float color) {\n    if(color <= 0.5) {\n        color = color * color * 2.0;\n    } else {\n        color = 1.0 - ((1.0 - color)*(1.0 - color) * 2.0);\n    }\n    return color;\n}\n\nvoid main() {\n    vec3 centralColor = texture2D(inputImageTexture, textureCoordinate).rgb;\n\n    vec2 singleStepOffset=vec2(texelWidthOffset,texelHeightOffset);\n    blurCoordinates[0] = textureCoordinate.xy + singleStepOffset * vec2(0.0, -10.0);\n    blurCoordinates[1] = textureCoordinate.xy + singleStepOffset * vec2(0.0, 10.0);\n    blurCoordinates[2] = textureCoordinate.xy + singleStepOffset * vec2(-10.0, 0.0);\n    blurCoordinates[3] = textureCoordinate.xy + singleStepOffset * vec2(10.0, 0.0);\n    blurCoordinates[4] = textureCoordinate.xy + singleStepOffset * vec2(5.0, -8.0);\n    blurCoordinates[5] = textureCoordinate.xy + singleStepOffset * vec2(5.0, 8.0);\n    blurCoordinates[6] = textureCoordinate.xy + singleStepOffset * vec2(-5.0, 8.0);\n    blurCoordinates[7] = textureCoordinate.xy + singleStepOffset * vec2(-5.0, -8.0);\n    blurCoordinates[8] = textureCoordinate.xy + singleStepOffset * vec2(8.0, -5.0);\n    blurCoordinates[9] = textureCoordinate.xy + singleStepOffset * vec2(8.0, 5.0);\n    blurCoordinates[10] = textureCoordinate.xy + singleStepOffset * vec2(-8.0, 5.0);\n    blurCoordinates[11] = textureCoordinate.xy + singleStepOffset * vec2(-8.0, -5.0);\n    blurCoordinates[12] = textureCoordinate.xy + singleStepOffset * vec2(0.0, -6.0);\n    blurCoordinates[13] = textureCoordinate.xy + singleStepOffset * vec2(0.0, 6.0);\n    blurCoordinates[14] = textureCoordinate.xy + singleStepOffset * vec2(6.0, 0.0);\n    blurCoordinates[15] = textureCoordinate.xy + singleStepOffset * vec2(-6.0, 0.0);\n    blurCoordinates[16] = textureCoordinate.xy + singleStepOffset * vec2(-4.0, -4.0);\n    blurCoordinates[17] = textureCoordinate.xy + singleStepOffset * vec2(-4.0, 4.0);\n    blurCoordinates[18] = textureCoordinate.xy + singleStepOffset * vec2(4.0, -4.0);\n    blurCoordinates[19] = textureCoordinate.xy + singleStepOffset * vec2(4.0, 4.0);\n    blurCoordinates[20] = textureCoordinate.xy + singleStepOffset * vec2(-2.0, -2.0);\n    blurCoordinates[21] = textureCoordinate.xy + singleStepOffset * vec2(-2.0, 2.0);\n    blurCoordinates[22] = textureCoordinate.xy + singleStepOffset * vec2(2.0, -2.0);\n    blurCoordinates[23] = textureCoordinate.xy + singleStepOffset * vec2(2.0, 2.0);\n\n    float sampleColor = centralColor.g * 22.0;\n    sampleColor += texture2D(inputImageTexture, blurCoordinates[0]).g;\n    sampleColor += texture2D(inputImageTexture, blurCoordinates[1]).g;\n    sampleColor += texture2D(inputImageTexture, blurCoordinates[2]).g;\n    sampleColor += texture2D(inputImageTexture, blurCoordinates[3]).g;\n    sampleColor += texture2D(inputImageTexture, blurCoordinates[4]).g;\n    sampleColor += texture2D(inputImageTexture, blurCoordinates[5]).g;\n    sampleColor += texture2D(inputImageTexture, blurCoordinates[6]).g;\n    sampleColor += texture2D(inputImageTexture, blurCoordinates[7]).g;\n    sampleColor += texture2D(inputImageTexture, blurCoordinates[8]).g;\n    sampleColor += texture2D(inputImageTexture, blurCoordinates[9]).g;\n    sampleColor += texture2D(inputImageTexture, blurCoordinates[10]).g;\n    sampleColor += texture2D(inputImageTexture, blurCoordinates[11]).g;\n    sampleColor += texture2D(inputImageTexture, blurCoordinates[12]).g * 2.0;\n    sampleColor += texture2D(inputImageTexture, blurCoordinates[13]).g * 2.0;\n    sampleColor += texture2D(inputImageTexture, blurCoordinates[14]).g * 2.0;\n    sampleColor += texture2D(inputImageTexture, blurCoordinates[15]).g * 2.0;\n    sampleColor += texture2D(inputImageTexture, blurCoordinates[16]).g * 2.0;\n    sampleColor += texture2D(inputImageTexture, blurCoordinates[17]).g * 2.0;\n    sampleColor += texture2D(inputImageTexture, blurCoordinates[18]).g * 2.0;\n    sampleColor += texture2D(inputImageTexture, blurCoordinates[19]).g * 2.0;\n    sampleColor += texture2D(inputImageTexture, blurCoordinates[20]).g * 3.0;\n    sampleColor += texture2D(inputImageTexture, blurCoordinates[21]).g * 3.0;\n    sampleColor += texture2D(inputImageTexture, blurCoordinates[22]).g * 3.0;\n    sampleColor += texture2D(inputImageTexture, blurCoordinates[23]).g * 3.0;\n    sampleColor = sampleColor / 62.0;\n\n    float highPass = centralColor.g - sampleColor + 0.5;\n\n    for(int i = 0; i < 5;i++)\n    {\n        highPass = hardLight(highPass);\n    }\n    float luminance = dot(centralColor, W);\n    float alpha = pow(luminance, params.r);\n\n    vec3 smoothColor = centralColor + (centralColor-vec3(highPass))*alpha*0.1;\n\n    smoothColor.r = clamp(pow(smoothColor.r, params.g),0.0,1.0);\n    smoothColor.g = clamp(pow(smoothColor.g, params.g),0.0,1.0);\n    smoothColor.b = clamp(pow(smoothColor.b, params.g),0.0,1.0);\n\n    vec3 screen = vec3(1.0) - (vec3(1.0)-smoothColor) * (vec3(1.0)-centralColor);\n    vec3 lighten = max(smoothColor, centralColor);\n    vec3 softLight = 2.0 * centralColor*smoothColor + centralColor*centralColor\n                     - 2.0 * centralColor*centralColor * smoothColor;\n\n    gl_FragColor = vec4(mix(centralColor, screen, alpha), 1.0);\n    gl_FragColor.rgb = mix(gl_FragColor.rgb, lighten, alpha);\n    gl_FragColor.rgb = mix(gl_FragColor.rgb, softLight, params.b);\n\n    vec3 satColor = gl_FragColor.rgb * saturateMatrix;\n    gl_FragColor.rgb = mix(gl_FragColor.rgb, satColor, params.a);\n}";
    public int beautyLevel = 5;
    private int mSingleStepOffsetLocation;
    private int brightnessLocation;
    private float toneLevel;
    private float brightLevel;
    private int texelWidthLocation;
    private int texelHeightLocation;
    private float texelWidthOffset;
    private float texelHeightOffset;

    public MagicBeautyFilter() {
        super("attribute vec4 position;\nattribute vec4 inputTextureCoordinate;\n \nvarying vec2 textureCoordinate;\n \nvoid main()\n{\n    gl_Position = position;\n    textureCoordinate = inputTextureCoordinate.xy;\n}", DEFAULT_BEAUTY);
    }

    @Override
    protected void onInit() {
        super.onInit();
        this.brightnessLocation = GLES20.glGetUniformLocation((int)this.mGLProgId, (String)"brightness");
        this.mSingleStepOffsetLocation = GLES20.glGetUniformLocation((int)this.getProgram(), (String)"singleStepOffset");
        this.texelWidthLocation = GLES20.glGetUniformLocation((int)this.mGLProgId, (String)"texelWidthOffset");
        this.texelHeightLocation = GLES20.glGetUniformLocation((int)this.mGLProgId, (String)"texelHeightOffset");
    }

    private void setTexelSize(float w, float h) {
        this.setFloatVec2(this.mSingleStepOffsetLocation, new float[]{1.0f / w, 1.0f / h});
    }

    @Override
    public void onInputSizeChanged(int width, int height) {
        super.onInputSizeChanged(width, height);
        this.setTexelSize(width, height);
        this.setTexelOffset(2.0f, width * 3, height * 3);
    }

    public void setToneLevel(float toneLeve) {
        this.toneLevel = toneLeve;
        this.setParams(this.beautyLevel, this.toneLevel);
    }

    public void setTexelOffset(float texelOffset, float mWidth, float mHeight) {
        this.texelWidthOffset = this.texelHeightOffset = texelOffset;
        this.setFloat(this.texelWidthLocation, texelOffset / mWidth);
        this.setFloat(this.texelHeightLocation, texelOffset / mHeight);
    }

    public void setParams(int beauty, float tone) {
        this.beautyLevel = beauty;
        this.toneLevel = tone;
        float[] vector = new float[]{0.3f, 0.5f, 0.1f + 0.3f * tone, 0.1f + 0.3f * tone};
    }

    public void setBeautyLevel(int level) {
        this.setParams(1, 0.0f);
        switch (level) {
            case 0: {
                this.setBrightLevel(0.0f);
                break;
            }
            case 1: {
                this.setBrightLevel(0.2f);
                break;
            }
            case 2: {
                this.setBrightLevel(0.5f);
                break;
            }
            case 3: {
                this.setBrightLevel(0.3f);
                break;
            }
            case 4: {
                this.setBrightLevel(0.8f);
                break;
            }
            case 5: {
                this.setBrightLevel(1.0f);
                break;
            }
        }
    }

    public void setBrightLevel(float brightLevel) {
        this.setFloat(this.brightnessLocation, 0.6f * (-0.5f + brightLevel));
    }

    public void onBeautyLevelChanged() {
        this.setBeautyLevel(this.beautyLevel);
    }
}

