/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.beauty.filter.advanced;

import android.opengl.GLES20;
import com.gensee.beauty.filter.gpuimage.GPUImageFilter;

public class GPUBeautyFilter
extends GPUImageFilter {
    public static int beautyLevel = 5;
    private int mSingleStepOffsetLocation;
    private int mParamsLocation;
    private static final String BEAUTY_FRAGMENT_SHADER = "precision mediump float;\n\nvarying mediump vec2 textureCoordinate;\n\nuniform sampler2D inputImageTexture;\nuniform vec2 singleStepOffset;\nuniform mediump float params;\n\nconst highp vec3 W = vec3(0.299,0.587,0.114);\nvec2 blurCoordinates[20];\n\nfloat hardLight(float color)\n{\nif(color <= 0.5)\ncolor = color * color * 2.0;\nelse\ncolor = 1.0 - ((1.0 - color)*(1.0 - color) * 2.0);\nreturn color;\n}\n\nvoid main(){\n\nvec3 centralColor = texture2D(inputImageTexture, textureCoordinate).rgb;\nblurCoordinates[0] = textureCoordinate.xy + singleStepOffset * vec2(0.0, -10.0);\nblurCoordinates[1] = textureCoordinate.xy + singleStepOffset * vec2(0.0, 10.0);\nblurCoordinates[2] = textureCoordinate.xy + singleStepOffset * vec2(-10.0, 0.0);\nblurCoordinates[3] = textureCoordinate.xy + singleStepOffset * vec2(10.0, 0.0);\nblurCoordinates[4] = textureCoordinate.xy + singleStepOffset * vec2(5.0, -8.0);\nblurCoordinates[5] = textureCoordinate.xy + singleStepOffset * vec2(5.0, 8.0);\nblurCoordinates[6] = textureCoordinate.xy + singleStepOffset * vec2(-5.0, 8.0);\nblurCoordinates[7] = textureCoordinate.xy + singleStepOffset * vec2(-5.0, -8.0);\nblurCoordinates[8] = textureCoordinate.xy + singleStepOffset * vec2(8.0, -5.0);\nblurCoordinates[9] = textureCoordinate.xy + singleStepOffset * vec2(8.0, 5.0);\nblurCoordinates[10] = textureCoordinate.xy + singleStepOffset * vec2(-8.0, 5.0);\nblurCoordinates[11] = textureCoordinate.xy + singleStepOffset * vec2(-8.0, -5.0);\nblurCoordinates[12] = textureCoordinate.xy + singleStepOffset * vec2(0.0, -6.0);\nblurCoordinates[13] = textureCoordinate.xy + singleStepOffset * vec2(0.0, 6.0);\nblurCoordinates[14] = textureCoordinate.xy + singleStepOffset * vec2(6.0, 0.0);\nblurCoordinates[15] = textureCoordinate.xy + singleStepOffset * vec2(-6.0, 0.0);\nblurCoordinates[16] = textureCoordinate.xy + singleStepOffset * vec2(-4.0, -4.0);\nblurCoordinates[17] = textureCoordinate.xy + singleStepOffset * vec2(-4.0, 4.0);\nblurCoordinates[18] = textureCoordinate.xy + singleStepOffset * vec2(4.0, -4.0);\nblurCoordinates[19] = textureCoordinate.xy + singleStepOffset * vec2(4.0, 4.0);\n\nfloat sampleColor = centralColor.g * 20.0;\nsampleColor += texture2D(inputImageTexture, blurCoordinates[0]).g;\nsampleColor += texture2D(inputImageTexture, blurCoordinates[1]).g;\nsampleColor += texture2D(inputImageTexture, blurCoordinates[2]).g;\nsampleColor += texture2D(inputImageTexture, blurCoordinates[3]).g;\nsampleColor += texture2D(inputImageTexture, blurCoordinates[4]).g;\nsampleColor += texture2D(inputImageTexture, blurCoordinates[5]).g;\nsampleColor += texture2D(inputImageTexture, blurCoordinates[6]).g;\nsampleColor += texture2D(inputImageTexture, blurCoordinates[7]).g;\nsampleColor += texture2D(inputImageTexture, blurCoordinates[8]).g;\nsampleColor += texture2D(inputImageTexture, blurCoordinates[9]).g;\nsampleColor += texture2D(inputImageTexture, blurCoordinates[10]).g;\nsampleColor += texture2D(inputImageTexture, blurCoordinates[11]).g;\nsampleColor += texture2D(inputImageTexture, blurCoordinates[12]).g * 2.0;\nsampleColor += texture2D(inputImageTexture, blurCoordinates[13]).g * 2.0;\nsampleColor += texture2D(inputImageTexture, blurCoordinates[14]).g * 2.0;\nsampleColor += texture2D(inputImageTexture, blurCoordinates[15]).g * 2.0;\nsampleColor += texture2D(inputImageTexture, blurCoordinates[16]).g * 2.0;\nsampleColor += texture2D(inputImageTexture, blurCoordinates[17]).g * 2.0;\nsampleColor += texture2D(inputImageTexture, blurCoordinates[18]).g * 2.0;\nsampleColor += texture2D(inputImageTexture, blurCoordinates[19]).g * 2.0;\n\nsampleColor = sampleColor / 48.0;\n\nfloat highPass = centralColor.g - sampleColor + 0.5;\n\nfor(int i = 0; i < 5;i++)\n{\nhighPass = hardLight(highPass);\n}\nfloat luminance = dot(centralColor, W);\n\nfloat alpha = pow(luminance, params);\n\nvec3 smoothColor = centralColor + (centralColor-vec3(highPass))*alpha*0.1;\n\ngl_FragColor = vec4(mix(smoothColor.rgb, max(smoothColor, centralColor), alpha), 1.0);\n}";

    public GPUBeautyFilter() {
        super("attribute vec4 position;\nattribute vec4 inputTextureCoordinate;\n \nvarying vec2 textureCoordinate;\n \nvoid main()\n{\n    gl_Position = position;\n    textureCoordinate = inputTextureCoordinate.xy;\n}", BEAUTY_FRAGMENT_SHADER);
    }

    @Override
    protected void onInit() {
        super.onInit();
        this.mSingleStepOffsetLocation = GLES20.glGetUniformLocation((int)this.getProgram(), (String)"singleStepOffset");
        this.mParamsLocation = GLES20.glGetUniformLocation((int)this.getProgram(), (String)"params");
        this.setBeautyLevel(beautyLevel);
    }

    private void setTexelSize(float w, float h) {
        if (w < 640.0f) {
            w = 640.0f;
        }
        if (h < 360.0f) {
            h = 360.0f;
        }
        this.setFloatVec2(this.mSingleStepOffsetLocation, new float[]{w / 640.0f * (0.3f / w), h / 360.0f * (0.3f / h)});
    }

    @Override
    public void onInputSizeChanged(int width, int height) {
        super.onInputSizeChanged(width, height);
        this.setTexelSize(width, height);
    }

    public void setBeautyLevel(int level) {
        switch (level) {
            case 1: {
                this.setFloat(this.mParamsLocation, 1.0f);
                break;
            }
            case 2: {
                this.setFloat(this.mParamsLocation, 0.8f);
                break;
            }
            case 3: {
                this.setFloat(this.mParamsLocation, 0.6f);
                break;
            }
            case 4: {
                this.setFloat(this.mParamsLocation, 0.4f);
                break;
            }
            case 5: {
                this.setFloat(this.mParamsLocation, 0.33f);
                break;
            }
        }
    }

    public void onBeautyLevelChanged() {
        this.setBeautyLevel(beautyLevel);
    }
}

