/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.beauty;

import android.graphics.Bitmap;
import com.gensee.beauty.GPUImageRenderer;
import com.gensee.beauty.PixelBuffer;
import com.gensee.beauty.filter.FilterSetting;
import com.gensee.beauty.filter.utils.Rotation;
import com.gensee.convert.VideoCoreLibrary;
import com.gensee.utils.GenseeLog;
import com.gensee.videoparam.VideoParam;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.concurrent.LinkedBlockingQueue;

public class GPUFilterDataRead
implements GPUImageRenderer.OnDataPrepareListener,
Runnable {
    private static final String TAG = "GPUFilterDataRead";
    private Object object = new Object();
    private Thread sendThread;
    private boolean bSendFlag = true;
    private GPUImageRenderer mGpuImageRenderer;
    private PixelBuffer pixelBuffer;
    private FilterSetting mFilterSetting;
    private int width;
    private int height;
    private Rotation rotation;
    private boolean flipVertical;
    private boolean flipHorizontal;
    private int realWidth;
    private int realHeigth;
    private OnPrepareDataSendListener mOnPrepareDataSendListener;
    private int orientation;
    byte[] yv12;
    private Buffer dstBuffer;
    private Buffer tempBuffer;
    private final int MAX_QUEUE_SIZE = 1;
    private VideoParam videoParam;
    private LinkedBlockingQueue<FileterYuvData> dataList = new LinkedBlockingQueue();
    private GPUImageRenderer.ScaleType mScaleType = GPUImageRenderer.ScaleType.CENTER_CROP;
    private FileOutputStream streamYuv2 = null;

    public void setOnPrepareDataSendListener(OnPrepareDataSendListener mOnPrepareDataSendListener) {
        this.mOnPrepareDataSendListener = mOnPrepareDataSendListener;
    }

    public GPUFilterDataRead() {
        this.mFilterSetting = new FilterSetting();
        this.mGpuImageRenderer = new GPUImageRenderer(this.mFilterSetting.getFilter());
        this.mFilterSetting.setRenderer(this.mGpuImageRenderer);
    }

    public void setVideoDataPng(Bitmap mBitmap) {
        this.mFilterSetting.setVideoDataPng(mBitmap);
        if (this.realWidth > 0 && this.realHeigth > 0) {
            this.mFilterSetting.resolveVideoDataPng(this.realWidth, this.realHeigth);
        }
    }

    public void setVideoDataPng(Bitmap mBitmap, int desVideologoMarginTop, int desVideologoMarginRight) {
        this.mFilterSetting.setVideoDataPng(mBitmap, desVideologoMarginTop, desVideologoMarginRight);
        if (this.realWidth > 0 && this.realHeigth > 0) {
            this.mFilterSetting.resolveVideoDataPng(this.realWidth, this.realHeigth);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void ontDataPrepare(byte[] yuvData, int width, int height, Rotation rotation, boolean flipHorizontal, boolean flipVertical) {
        FileterYuvData filterYuvData = new FileterYuvData(yuvData, width, height, rotation, flipHorizontal, flipVertical);
        Object object = this.object;
        synchronized (object) {
            if (null != this.dataList && this.dataList.size() >= 1) {
                this.dataList.remove();
            }
            this.dataList.add(filterYuvData);
            this.object.notifyAll();
        }
    }

    public void switchBeauty(boolean bOpen) {
        if (null != this.mGpuImageRenderer) {
            this.mFilterSetting.switchBeauty(bOpen);
        }
    }

    public void setVideoParam(VideoParam videoParam) {
        this.videoParam = videoParam;
    }

    public void startSendThread() {
        if (null != this.sendThread) {
            GenseeLog.w((String)TAG, (String)"startSendThread have thread is running");
            return;
        }
        if (null == this.dataList) {
            this.dataList = new LinkedBlockingQueue();
        }
        this.dataList.clear();
        this.width = -1;
        this.height = -1;
        this.rotation = Rotation.NORMAL;
        this.flipHorizontal = false;
        this.flipVertical = false;
        this.bSendFlag = true;
        if (null == this.sendThread) {
            this.sendThread = new Thread((Runnable)this, TAG);
            this.sendThread.start();
        }
    }

    public void releaseSendThread() {
        if (null != this.sendThread) {
            this.bSendFlag = false;
            if (null != this.dataList) {
                this.dataList.clear();
                this.dataList = null;
            }
            this.sendThread = null;
        }
        this.yv12 = null;
        this.dstBuffer = null;
        this.tempBuffer = null;
        if (null != this.mFilterSetting) {
            this.mFilterSetting.release();
        }
    }

    public void setOrientation(int ortation) {
        if (this.orientation != ortation) {
            this.orientation = ortation;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (this.bSendFlag) {
            FileterYuvData data;
            Object object = this.object;
            synchronized (object) {
                if (this.dataList == null) {
                    return;
                }
                if (null == this.dataList.peek()) {
                    try {
                        this.object.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                data = (FileterYuvData)this.dataList.remove();
            }
            if (this.width != data.width || this.height != data.height || this.rotation != data.getRotation() || this.flipHorizontal != data.isFlipHorizontal() || this.flipVertical != data.isFlipVertical()) {
                if (null != this.mGpuImageRenderer) {
                    this.mGpuImageRenderer.destroyCameraFrameBuffer();
                }
                this.width = data.getWidth();
                this.height = data.getHeight();
                this.rotation = data.getRotation();
                this.flipHorizontal = data.isFlipHorizontal();
                this.flipVertical = data.isFlipVertical();
                int needWidth = null != this.videoParam ? this.videoParam.width : 320;
                int needHeight = null != this.videoParam ? this.videoParam.height : 240;
                int tmepWidth = needWidth;
                int tmepHeight = needHeight;
                if (this.realWidth != tmepWidth || this.realHeigth != tmepHeight) {
                    this.mFilterSetting.resolveVideoDataPng(tmepWidth, tmepHeight);
                }
                this.realWidth = tmepWidth;
                this.realHeigth = tmepHeight;
                this.mGpuImageRenderer.setScaleType(this.mScaleType);
                this.mGpuImageRenderer.setRotation(this.rotation, this.flipHorizontal, this.flipVertical);
                this.mGpuImageRenderer.setImageWH(this.width, this.height);
                if (null == this.pixelBuffer) {
                    this.pixelBuffer = new PixelBuffer(tmepWidth, tmepHeight);
                    this.pixelBuffer.setRenderer(this.mGpuImageRenderer);
                } else {
                    this.pixelBuffer.releaseEglSurface();
                    this.pixelBuffer.updateElgSurface(tmepWidth, tmepHeight);
                }
                this.mGpuImageRenderer.initCameraFrameBuffer(this.width, this.height);
                this.mGpuImageRenderer.setFlipHorizontalAndVertical(this.flipHorizontal, this.flipVertical);
                this.mGpuImageRenderer.onInputSizeChanged(this.width, this.height);
            }
            this.mGpuImageRenderer.setYuvData(data.getYuvData());
            ByteBuffer srcBuffer = this.pixelBuffer.getBitmap();
            if (srcBuffer == null) continue;
            int buffSize = this.realWidth * this.realHeigth * 3 >> 1;
            if (null == this.dstBuffer || this.dstBuffer.remaining() != buffSize) {
                this.dstBuffer = ByteBuffer.allocateDirect(buffSize);
            }
            if (null == this.tempBuffer || this.tempBuffer.remaining() != srcBuffer.remaining()) {
                this.tempBuffer = ByteBuffer.allocateDirect(srcBuffer.remaining());
            }
            VideoCoreLibrary.RGBAtoYV12(srcBuffer, this.dstBuffer, this.tempBuffer, this.realWidth, this.realHeigth);
            if (null != this.dstBuffer && this.dstBuffer.remaining() > 0) {
                if (this.yv12 == null || this.yv12.length != buffSize) {
                    this.yv12 = new byte[buffSize];
                }
                this.dstBuffer.position(0);
                ((ByteBuffer)this.dstBuffer).get(this.yv12);
            }
            if (null == this.mOnPrepareDataSendListener) continue;
            this.mOnPrepareDataSendListener.onSendData(this.yv12, this.realWidth, this.realHeigth);
        }
        if (null != this.pixelBuffer) {
            this.pixelBuffer.destroy();
        }
    }

    private void initFile2() throws IOException {
        File f = new File("/sdcard/android-yuv2.yuv");
        if (!f.exists()) {
            f.createNewFile();
        }
        this.streamYuv2 = new FileOutputStream(f);
    }

    public static interface OnPrepareDataSendListener {
        public void onSendData(byte[] var1, int var2, int var3);
    }

    private class FileterYuvData {
        private byte[] yuvData;
        private int width;
        private int height;
        private Rotation rotation;
        private boolean flipVertical;
        private boolean flipHorizontal;

        public FileterYuvData(byte[] yuvData, int width, int height, Rotation rotation, boolean flipHorizontal, boolean flipVertical) {
            this.yuvData = yuvData;
            this.width = width;
            this.height = height;
            this.rotation = rotation;
            this.flipVertical = flipVertical;
            this.flipHorizontal = flipHorizontal;
        }

        public byte[] getYuvData() {
            return this.yuvData;
        }

        public void setYuvData(byte[] yuvData) {
            this.yuvData = yuvData;
        }

        public int getWidth() {
            return this.width;
        }

        public void setWidth(int width) {
            this.width = width;
        }

        public int getHeight() {
            return this.height;
        }

        public void setHeight(int height) {
            this.height = height;
        }

        public Rotation getRotation() {
            return this.rotation;
        }

        public void setRotation(Rotation rotation) {
            this.rotation = rotation;
        }

        public boolean isFlipVertical() {
            return this.flipVertical;
        }

        public void setFlipVertical(boolean flipVertical) {
            this.flipVertical = flipVertical;
        }

        public boolean isFlipHorizontal() {
            return this.flipHorizontal;
        }

        public void setFlipHorizontal(boolean flipHorizontal) {
            this.flipHorizontal = flipHorizontal;
        }

        public String toString() {
            return "FileterYuvData [yuvData=" + Arrays.toString(this.yuvData) + ", width=" + this.width + ", height=" + this.height + ", rotation=" + (Object)((Object)this.rotation) + ", flipVertical=" + this.flipVertical + ", flipHorizontal=" + this.flipHorizontal + "]";
        }
    }
}

