/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.view;

import android.app.Activity;
import android.content.Context;
import android.os.Handler;
import android.os.Message;
import android.text.Editable;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.RadioButton;
import android.widget.TextView;
import android.widget.Toast;
import com.gensee.player.IPlayerVote;
import com.gensee.utils.GenseeLog;
import com.gensee.view.AbsVotePopView;
import com.gensee.view.AutoScrollTextView;
import com.gensee.view.GsAbsView;
import com.gensee.view.VoteProgressBar;
import com.gensee.vote.OnVoteListener;
import com.gensee.vote.VotePlayerAnswer;
import com.gensee.vote.VotePlayerGroup;
import com.gensee.vote.VotePlayerQuestion;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;

public abstract class GSVoteView
extends GsAbsView
implements OnVoteListener,
AbsVotePopView.InterfaceSelectOther {
    private ImageView ivClose;
    private Button btnCommit;
    private TextView tvSelected;
    private TextView tvCount;
    private AutoScrollTextView tvQiangZhiTip;
    private ListView lvReceive;
    private VoteReceiveAdapter adapter;
    private AbsVotePopView pop;
    private boolean bSummited = false;
    private String sCurrentVoteGroupId = "";
    private String sPreCurrentVoteGroupId = "";
    private List<VotePlayerGroup> voteList = new ArrayList<VotePlayerGroup>();
    private List<String> voteIds = new ArrayList<String>();
    public IPlayerVote mPlayerVoteHandle;
    private Handler handler = new Handler(){

        public void handleMessage(Message msg) {
            Object obj = msg.obj;
            switch (msg.what) {
                case 401: {
                    break;
                }
                case 403: {
                    VotePlayerGroup msg1 = (VotePlayerGroup)obj;
                    GSVoteView.this.showReceiveView();
                    GSVoteView.this.add(msg1);
                    break;
                }
                case 404: 
                case 406: {
                    VotePlayerGroup msg2 = (VotePlayerGroup)obj;
                    GSVoteView.this.showReceiveView();
                    GSVoteView.this.voteResult(msg2);
                    break;
                }
                case 405: {
                    VotePlayerGroup tmp = (VotePlayerGroup)obj;
                    GSVoteView.this.submit(tmp);
                    break;
                }
            }
        }
    };

    public void setModuleHandle(IPlayerVote playerModule) {
        this.mPlayerVoteHandle = playerModule;
    }

    public GSVoteView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.loadView(context);
    }

    public GSVoteView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public GSVoteView(Context context) {
        this(context, null);
    }

    public void onClick(View v) {
        if (this.getVoteReceiverCommitBtnId() == v.getId()) {
            this.commit();
        } else if (this.getVoteSelectTvId() == v.getId()) {
            this.voteIds.clear();
            ArrayList<String> tmpList = new ArrayList<String>();
            for (VotePlayerGroup voteGroup : this.voteList) {
                this.voteIds.add(voteGroup.getM_strId());
                tmpList.add(voteGroup.getM_strText());
            }
            this.pop = this.getVotePopView(this.getRootView(), this, tmpList);
            this.pop.showPopWindow((View)this.tvSelected);
        }
    }

    private void commit() {
        VotePlayerGroup voteGroup = this.getVoteGroupById(this.sCurrentVoteGroupId);
        if (null == voteGroup) {
            return;
        }
        if (voteGroup.isM_bForce()) {
            if (!voteGroup.haveAllAnswer()) {
                Toast.makeText((Context)this.getContext(), (int)this.getVoteAnswerAllQuestionsTip(), (int)3000).show();
                return;
            }
        } else if (!voteGroup.haveAnswer()) {
            Toast.makeText((Context)this.getContext(), (int)this.getVoteAnswersTip(), (int)3000).show();
            return;
        }
        if (null != this.mPlayerVoteHandle) {
            this.mPlayerVoteHandle.voteSubmit(voteGroup);
            voteGroup.setM_bSubmited(true);
            this.submit(voteGroup);
            this.commitSuccess(voteGroup);
        }
    }

    @Override
    protected void initView(View view) {
        this.ivClose = (ImageView)this.findViewById(this.getVoteReceiverColseIvId());
        this.ivClose.setOnClickListener((View.OnClickListener)this);
        this.btnCommit = (Button)this.findViewById(this.getVoteReceiverCommitBtnId());
        this.btnCommit.setOnClickListener((View.OnClickListener)this);
        this.tvSelected = (TextView)this.findViewById(this.getVoteSelectTvId());
        this.tvSelected.setOnClickListener((View.OnClickListener)this);
        this.tvCount = (TextView)this.findViewById(this.getVoteCountTvId());
        this.tvQiangZhiTip = (AutoScrollTextView)this.findViewById(this.getVoteQiangZhiTvId());
        this.tvQiangZhiTip.initScrollTextView(((Activity)this.getContext()).getWindowManager(), view.getContext().getString(this.getVoteQiangZhiTipStrId()));
        this.lvReceive = (ListView)this.findViewById(this.getVoteReceiverLvId());
        this.adapter = new VoteReceiveAdapter();
        this.lvReceive.setAdapter((ListAdapter)this.adapter);
    }

    private void showReceiveView() {
    }

    private void enableTab(boolean bEnable, boolean isCard) {
        this.tvSelected.setEnabled(bEnable);
        if (bEnable) {
            this.tvCount.setVisibility(0);
            this.tvQiangZhiTip.setVisibility(8);
        } else {
            this.tvQiangZhiTip.initScrollTextView(((Activity)this.getContext()).getWindowManager(), isCard ? this.getCardQianzhiTip() : this.getContext().getString(this.getVoteQiangZhiTipStrId()));
            this.tvQiangZhiTip.setVisibility(0);
            this.tvCount.setVisibility(8);
        }
    }

    private void updateTv() {
        this.tvCount.setText((CharSequence)String.format(this.getResources().getString(this.getVoteCountStrId()), this.voteList.size()));
    }

    private VotePlayerGroup getVoteGroupById(String voteGroupId) {
        VotePlayerGroup returnValue = null;
        for (VotePlayerGroup voteGroup : this.voteList) {
            if (!voteGroup.getM_strId().equals(voteGroupId)) continue;
            returnValue = voteGroup;
            break;
        }
        return returnValue;
    }

    private void voteHaveCommit(VotePlayerGroup voteGroup) {
        if (voteGroup.isVoteSubmmit()) {
            this.bSummited = true;
            this.btnCommit.setSelected(true);
            this.btnCommit.setEnabled(false);
            this.btnCommit.setText(this.getVoteHaveCommitStrId());
        } else {
            this.btnCommit.setText(this.getVoteCommitStrId());
        }
    }

    public void stepToVoteGroup(String voteGroupId) {
        this.bSummited = false;
        this.btnCommit.setEnabled(true);
        this.btnCommit.setSelected(false);
        this.sCurrentVoteGroupId = voteGroupId;
        VotePlayerGroup voteGroup = this.getVoteGroupById(voteGroupId);
        if (null == voteGroup) {
            Toast.makeText((Context)this.getContext(), (int)this.getVoteNotExistStrId(), (int)3000).show();
            return;
        }
        this.tvSelected.setText((CharSequence)voteGroup.getM_strText());
        if (!voteGroup.getType().equals("OTHER")) {
            for (VotePlayerQuestion voteQuestion : voteGroup.getM_questions()) {
                for (VotePlayerAnswer voteAnswer : voteQuestion.getM_answers()) {
                    if (!"".equals(voteAnswer.getM_strId()) && !voteAnswer.isM_bChoose()) continue;
                }
            }
            this.voteHaveCommit(voteGroup);
            if (voteGroup.isM_bDeadline() || voteGroup.isM_bPublishResult()) {
                this.btnCommit.setVisibility(8);
            } else {
                this.btnCommit.setVisibility(0);
            }
            this.adapter.nodifyData(this.getVoteGroupById(voteGroupId));
        }
    }

    public void add(VotePlayerGroup voteGroup) {
        VotePlayerGroup currentVoteGroup;
        GenseeLog.i((String)"vote add");
        boolean bTrue = false;
        for (int i = 0; i < this.voteList.size(); ++i) {
            VotePlayerGroup temp = this.voteList.get(i);
            if (!temp.getM_strId().equals(voteGroup.getM_strId())) continue;
            bTrue = true;
            break;
        }
        if (!bTrue) {
            VotePlayerGroup currentVoteGroup2;
            this.voteList.add(voteGroup);
            this.updateTv();
            if (voteGroup.isM_bForce() && !voteGroup.isVoteSubmmit() && !voteGroup.isM_bPublishResult() && !voteGroup.isM_bDeadline() && null != (currentVoteGroup2 = this.getVoteGroupById(this.sCurrentVoteGroupId)) && (!currentVoteGroup2.isM_bForce() || currentVoteGroup2.isM_bForce() && (currentVoteGroup2.isVoteSubmmit() || currentVoteGroup2.isM_bPublishResult() || currentVoteGroup2.isM_bDeadline()))) {
                this.sPreCurrentVoteGroupId = this.sCurrentVoteGroupId;
                this.stepToVoteGroup(voteGroup.getM_strId());
                this.enableTab(false, GSVoteView.isVoteCard(voteGroup));
                return;
            }
        }
        if ("".equals(this.sCurrentVoteGroupId)) {
            this.sCurrentVoteGroupId = this.voteList.get(0).getM_strId();
            this.stepToVoteGroup(this.sCurrentVoteGroupId);
        }
        if (null != (currentVoteGroup = this.getVoteGroupById(this.sCurrentVoteGroupId)) && currentVoteGroup.isM_bForce() && !currentVoteGroup.isVoteSubmmit() && !currentVoteGroup.isM_bPublishResult() && !currentVoteGroup.isM_bDeadline()) {
            this.enableTab(false, GSVoteView.isVoteCard(currentVoteGroup));
        }
    }

    public void voteResult(VotePlayerGroup voteGroup) {
        boolean bTrue = false;
        for (int i = 0; i < this.voteList.size(); ++i) {
            VotePlayerGroup temp = this.voteList.get(i);
            if (!temp.getM_strId().equals(voteGroup.getM_strId())) continue;
            bTrue = true;
            this.voteList.set(i, voteGroup);
            break;
        }
        if (!bTrue) {
            this.voteList.add(voteGroup);
            this.updateTv();
        }
        if (!this.sCurrentVoteGroupId.equals(voteGroup.getM_strId())) {
            this.showReceiveView();
            if ("".equals(this.sCurrentVoteGroupId)) {
                this.sCurrentVoteGroupId = this.voteList.get(0).getM_strId();
            }
            this.stepToVoteGroup(voteGroup.getM_strId());
        } else if (this.sCurrentVoteGroupId.equals(voteGroup.getM_strId())) {
            this.adapter.nodifyData(voteGroup);
            this.btnCommit.setVisibility(8);
            if (voteGroup.isM_bForce()) {
                this.commitSuccess(voteGroup);
            }
        }
        if (this.sCurrentVoteGroupId.equals(voteGroup.getM_strId()) && voteGroup.isM_bDeadline() && !voteGroup.isM_bPublishResult()) {
            Toast.makeText((Context)this.getContext(), (int)this.getVoteDeadlineTipStrId(), (int)3000).show();
        }
    }

    public void submit(VotePlayerGroup voteGroup) {
        for (VotePlayerGroup temp : this.voteList) {
            if (!temp.getM_strId().equals(voteGroup.getM_strId())) continue;
            temp.setArrayUsers(voteGroup.getM_users());
            if (!this.sCurrentVoteGroupId.equals(temp.getM_strId())) break;
            this.voteHaveCommit(temp);
            if (!temp.isVoteSubmmit()) break;
            this.adapter.nodifyData(temp);
            break;
        }
    }

    private void commitSuccess(VotePlayerGroup voteGroup) {
        boolean bTrue = false;
        boolean bNextForce = false;
        VotePlayerGroup nextVoteGroup = null;
        for (VotePlayerGroup voteGroup1 : this.voteList) {
            if (voteGroup1.getM_strId().equals(voteGroup.getM_strId())) {
                bTrue = true;
                continue;
            }
            if (!bTrue || !voteGroup1.isM_bForce() || voteGroup1.isVoteSubmmit() || voteGroup1.isM_bPublishResult() || voteGroup1.isM_bDeadline()) continue;
            bNextForce = true;
            nextVoteGroup = voteGroup1;
            this.stepToVoteGroup(voteGroup1.getM_strId());
            break;
        }
        if (!bNextForce) {
            if (!"".equals(this.sPreCurrentVoteGroupId)) {
                this.stepToVoteGroup(this.sPreCurrentVoteGroupId);
            }
            this.enableTab(true, false);
        } else {
            this.enableTab(false, GSVoteView.isVoteCard(nextVoteGroup));
        }
    }

    @Override
    public void sendToOther(int position) {
        this.stepToVoteGroup(this.voteIds.get(position));
    }

    protected abstract int getVoteReceiverColseIvId();

    protected abstract int getVoteReceiverCommitBtnId();

    protected abstract int getVoteSelectTvId();

    protected abstract int getVoteCountTvId();

    protected abstract int getVoteQiangZhiTvId();

    protected abstract int getVoteQiangZhiTipStrId();

    protected abstract int getVoteReceiverLvId();

    protected abstract int getVoteReceiverItemLayoutId();

    protected abstract int getQuestionNameTvId();

    protected abstract int getAnswerItemLyId();

    protected abstract int getQuestionTotalTvId();

    protected abstract int getSingleChoiceStrId();

    protected abstract int getMultiChoiceStrId();

    protected abstract int getTextWdStrId();

    protected abstract int getVoteAnswerLayoutId();

    protected abstract int getVoteReceiverChoiceLyId();

    protected abstract int getVoteReceiverWdItemEdtId();

    protected abstract int getVoteReceiverAnswerCbId();

    protected abstract int getVoteReceiverAnswerRbId();

    protected abstract int getVoteReceiverAnswerTvId();

    protected abstract int getVoteReceiverAnswerIvId();

    protected abstract int getVoteProgressbarSingleId();

    protected abstract int getVoteProgressbarMultiId();

    protected abstract int getVoteAnswerCountTvId();

    protected abstract int getVoteTotalPersonJoinStrId();

    protected abstract int getVoteQuestionFenShuStrId();

    protected abstract int getVoteCountStrId();

    protected abstract int getVoteNotExistStrId();

    protected abstract int getVoteHaveCommitStrId();

    protected abstract int getVoteCommitStrId();

    protected abstract int getVoteDeadlineTipStrId();

    protected abstract int getVoteAnswerAllQuestionsTip();

    protected abstract int getVoteAnswersTip();

    protected abstract String getCardSubject();

    protected abstract String getCardQianzhiTip();

    protected abstract AbsVotePopView getVotePopView(View var1, AbsVotePopView.InterfaceSelectOther var2, List<String> var3);

    public void sendMessage(int what, Object object) {
        this.handler.sendMessage(this.handler.obtainMessage(what, object));
    }

    @Override
    public void onVotePublish(VotePlayerGroup voteGroup) {
        this.replaceCardSubject(voteGroup);
        this.sendMessage(403, voteGroup);
    }

    @Override
    public void onVotePublishResult(VotePlayerGroup voteGroup) {
        this.replaceCardSubject(voteGroup);
        this.sendMessage(404, voteGroup);
    }

    private void replaceCardSubject(VotePlayerGroup voteGroup) {
        if (GSVoteView.isVoteCard(voteGroup)) {
            List<VotePlayerQuestion> qs = voteGroup.getM_questions();
            if (qs != null) {
                for (VotePlayerQuestion q : qs) {
                    List<VotePlayerAnswer> answers;
                    if (q == null || (answers = q.getM_answers()) == null || answers.size() != 2) continue;
                    answers.get(0).setM_strText("\u221a");
                    answers.get(1).setM_strText("x");
                }
            }
            voteGroup.setM_strText(this.getCardSubject());
        }
    }

    private static boolean isVoteCard(VotePlayerGroup voteGroup) {
        if (voteGroup == null) {
            return false;
        }
        String voteType = voteGroup.getVoteType();
        return "publish_card".equals(voteType) || "publish_cardresult".equals(voteType);
    }

    @Override
    public void onVotePostUrl(String strURL, long optUser) {
    }

    @Override
    public void onVoteSubmitRet(int ret) {
        int resId = 0;
        switch (ret) {
            case 1: {
                resId = this.getVoteAnswerAllQuestionsTip();
                break;
            }
            case 2: {
                resId = this.getVoteAnswersTip();
                break;
            }
        }
        if (resId != 0) {
            final int tipRes = resId;
            this.post(new Runnable(){

                @Override
                public void run() {
                    Toast.makeText((Context)GSVoteView.this.getContext(), (int)tipRes, (int)3000).show();
                }
            });
        }
    }

    private class VoteReceiveAdapter
    extends BaseAdapter {
        private VotePlayerGroup voteGroup;

        private VoteReceiveAdapter() {
        }

        public void nodifyData(VotePlayerGroup voteGroup) {
            this.voteGroup = voteGroup;
            this.notifyDataSetChanged();
        }

        public int getCount() {
            if (null == this.voteGroup) {
                return 0;
            }
            return this.voteGroup.getM_questions().size();
        }

        public Object getItem(int position) {
            return this.voteGroup.getM_questions().get(position);
        }

        public long getItemId(int position) {
            return position;
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            ViewHolder viewHolder = null;
            if (null == convertView) {
                convertView = LayoutInflater.from((Context)parent.getContext()).inflate(GSVoteView.this.getVoteReceiverItemLayoutId(), null);
                viewHolder = new ViewHolder(convertView);
                convertView.setTag((Object)viewHolder);
            } else {
                viewHolder = (ViewHolder)convertView.getTag();
            }
            viewHolder.init((VotePlayerQuestion)this.getItem(position), position);
            return convertView;
        }

        private class ViewHolder {
            private TextView tvQuestionName;
            private LinearLayout lyQuestionItems;
            private TextView tvQuestionTotal;
            private TextWatcher textWatcher;

            public ViewHolder(View view) {
                this.tvQuestionName = (TextView)view.findViewById(GSVoteView.this.getQuestionNameTvId());
                this.lyQuestionItems = (LinearLayout)view.findViewById(GSVoteView.this.getAnswerItemLyId());
                this.tvQuestionTotal = (TextView)view.findViewById(GSVoteView.this.getQuestionTotalTvId());
            }

            public void init(final VotePlayerQuestion voteQuestion, int index) {
                int i;
                int nChildViewCount;
                if (voteQuestion == null) {
                    return;
                }
                boolean isCard = GSVoteView.isVoteCard(VoteReceiveAdapter.this.voteGroup);
                if (isCard) {
                    this.tvQuestionName.setVisibility(8);
                } else {
                    this.tvQuestionName.setVisibility(0);
                    String sValue = index + 1 + ". " + voteQuestion.getM_strText();
                    if (voteQuestion.getM_strType().equals("single")) {
                        sValue = sValue + GSVoteView.this.getResources().getString(GSVoteView.this.getSingleChoiceStrId());
                    } else if (voteQuestion.getM_strType().equals("multi")) {
                        sValue = sValue + GSVoteView.this.getResources().getString(GSVoteView.this.getMultiChoiceStrId());
                    } else if (voteQuestion.getM_strType().equals("text")) {
                        sValue = sValue + GSVoteView.this.getResources().getString(GSVoteView.this.getTextWdStrId());
                    }
                    this.tvQuestionName.setText((CharSequence)sValue);
                }
                final ArrayList<VotePlayerAnswer> answersList = new ArrayList<VotePlayerAnswer>();
                for (VotePlayerAnswer voteAnswer : voteQuestion.getM_answers()) {
                    if ("".equals(voteAnswer.getM_strId())) continue;
                    answersList.add(voteAnswer);
                }
                final ArrayList<RadioButton> rbButtonList = new ArrayList<RadioButton>();
                int nValue = 65;
                int nAnswerSize = answersList.size();
                if (voteQuestion.getM_strType().equals("text")) {
                    nAnswerSize = 1;
                }
                if ((nChildViewCount = this.lyQuestionItems.getChildCount()) < nAnswerSize) {
                    for (i = 0; i < nAnswerSize - nChildViewCount; ++i) {
                        View view = LayoutInflater.from((Context)GSVoteView.this.getContext()).inflate(GSVoteView.this.getVoteAnswerLayoutId(), null);
                        this.lyQuestionItems.addView(view);
                    }
                } else if (nChildViewCount > nAnswerSize) {
                    for (i = nChildViewCount - 1; i > nAnswerSize - 1; --i) {
                        this.lyQuestionItems.removeViewAt(i);
                    }
                }
                int nMax = 0;
                if (voteQuestion.getM_strType().equals("multi")) {
                    for (VotePlayerAnswer voteAnswer1 : answersList) {
                        nMax += voteAnswer1.getTotal();
                    }
                } else {
                    nMax = voteQuestion.getTotal();
                }
                if (nMax <= 0) {
                    nMax = 100;
                }
                for (int i2 = 0; i2 < nAnswerSize; ++i2) {
                    View view = this.lyQuestionItems.getChildAt(i2);
                    LinearLayout lyChoice = (LinearLayout)view.findViewById(GSVoteView.this.getVoteReceiverChoiceLyId());
                    EditText edtWdt = (EditText)view.findViewById(GSVoteView.this.getVoteReceiverWdItemEdtId());
                    if (voteQuestion.getM_strType().equals("multi") || voteQuestion.getM_strType().equals("single")) {
                        edtWdt.setVisibility(8);
                        lyChoice.setVisibility(0);
                        final VotePlayerAnswer voteAnswer = (VotePlayerAnswer)answersList.get(i2);
                        CheckBox cbBox = (CheckBox)view.findViewById(GSVoteView.this.getVoteReceiverAnswerCbId());
                        RadioButton rbButton = (RadioButton)view.findViewById(GSVoteView.this.getVoteReceiverAnswerRbId());
                        TextView tvAnswer = (TextView)view.findViewById(GSVoteView.this.getVoteReceiverAnswerTvId());
                        ImageView ivSelect = (ImageView)view.findViewById(GSVoteView.this.getVoteReceiverAnswerIvId());
                        VoteProgressBar progressBarSingle = (VoteProgressBar)view.findViewById(GSVoteView.this.getVoteProgressbarSingleId());
                        VoteProgressBar progressBarMulti = (VoteProgressBar)view.findViewById(GSVoteView.this.getVoteProgressbarMultiId());
                        TextView tvAnswerCount = (TextView)view.findViewById(GSVoteView.this.getVoteAnswerCountTvId());
                        String answerContent = voteAnswer.getM_strText();
                        if (!isCard) {
                            answerContent = (char)nValue + ". " + answerContent;
                            ++nValue;
                        }
                        tvAnswer.setText((CharSequence)answerContent);
                        if (GSVoteView.this.bSummited || VoteReceiveAdapter.this.voteGroup.isM_bDeadline() || VoteReceiveAdapter.this.voteGroup.isM_bPublishResult()) {
                            if (voteAnswer.isM_bCorrect()) {
                                ivSelect.setVisibility(0);
                            } else {
                                ivSelect.setVisibility(8);
                            }
                        } else {
                            ivSelect.setVisibility(8);
                        }
                        if (voteQuestion.getM_strType().equals("single")) {
                            cbBox.setVisibility(8);
                            rbButton.setVisibility(0);
                            rbButton.setChecked(voteAnswer.isM_bChoose());
                            rbButtonList.add(rbButton);
                            rbButton.setEnabled(!GSVoteView.this.bSummited);
                        } else if (voteQuestion.getM_strType().equals("multi")) {
                            cbBox.setVisibility(0);
                            rbButton.setVisibility(8);
                            cbBox.setChecked(voteAnswer.isM_bChoose());
                            cbBox.setEnabled(!GSVoteView.this.bSummited);
                        }
                        if (VoteReceiveAdapter.this.voteGroup.isM_bDeadline() || VoteReceiveAdapter.this.voteGroup.isM_bPublishResult()) {
                            if (voteQuestion.getM_strType().equals("single")) {
                                progressBarSingle.setVisibility(0);
                                progressBarMulti.setVisibility(8);
                                progressBarSingle.setMax(nMax);
                                progressBarSingle.setProgress(voteAnswer.getTotal());
                            } else {
                                progressBarSingle.setVisibility(8);
                                progressBarMulti.setVisibility(0);
                                progressBarMulti.setMax(nMax);
                                progressBarMulti.setProgress(voteAnswer.getTotal());
                            }
                            cbBox.setVisibility(8);
                            rbButton.setVisibility(8);
                            int nSize = voteAnswer.getTotal();
                            float result = (float)nSize / (float)nMax;
                            DecimalFormat format = (DecimalFormat)DecimalFormat.getInstance();
                            format.applyPattern("##.##");
                            String fr = (int)(Float.parseFloat(format.format(result)) * 100.0f) + "%";
                            tvAnswerCount.setText((CharSequence)fr);
                            tvAnswerCount.setVisibility(0);
                            this.tvQuestionTotal.setVisibility(0);
                            String sTotal = String.format(GSVoteView.this.getResources().getString(GSVoteView.this.getVoteTotalPersonJoinStrId()), voteQuestion.getTotal());
                            if (voteQuestion.getM_nScore() > 0) {
                                sTotal = sTotal + String.format(GSVoteView.this.getResources().getString(GSVoteView.this.getVoteQuestionFenShuStrId()), voteQuestion.getM_nScore());
                            }
                            this.tvQuestionTotal.setText((CharSequence)sTotal);
                        } else {
                            progressBarSingle.setVisibility(8);
                            progressBarMulti.setVisibility(8);
                            tvAnswerCount.setVisibility(8);
                            this.tvQuestionTotal.setVisibility(8);
                        }
                        rbButton.setOnClickListener(new View.OnClickListener(){

                            public void onClick(View v) {
                                if (((RadioButton)v).isChecked()) {
                                    boolean bHave = false;
                                    for (VotePlayerAnswer voteAnswer1 : answersList) {
                                        if (voteAnswer1.isM_bChoose()) {
                                            bHave = true;
                                        }
                                        voteAnswer1.setM_bChoose(false);
                                    }
                                    if (!bHave) {
                                        // empty if block
                                    }
                                    for (RadioButton rbButton : rbButtonList) {
                                        if (rbButton == (RadioButton)v || !rbButton.isChecked()) continue;
                                        rbButton.setChecked(false);
                                    }
                                }
                                voteAnswer.setM_bChoose(((RadioButton)v).isChecked());
                            }
                        });
                        cbBox.setOnClickListener(new View.OnClickListener(){

                            public void onClick(View v) {
                                int nSelectCount = 0;
                                for (VotePlayerAnswer voteAnswer1 : answersList) {
                                    if (!voteAnswer1.isM_bChoose()) continue;
                                    ++nSelectCount;
                                }
                                voteAnswer.setM_bChoose(((CheckBox)v).isChecked());
                                if (nSelectCount == 1 ? !((CheckBox)v).isChecked() : nSelectCount != 0 || ((CheckBox)v).isChecked()) {
                                    // empty if block
                                }
                            }
                        });
                        continue;
                    }
                    if (null != this.textWatcher) {
                        edtWdt.removeTextChangedListener(this.textWatcher);
                    }
                    this.textWatcher = new TextWatcher(){

                        public void onTextChanged(CharSequence s, int start, int before, int count) {
                            voteQuestion.setM_strAnwser(s.toString());
                        }

                        public void beforeTextChanged(CharSequence s, int start, int count, int after) {
                        }

                        public void afterTextChanged(Editable s) {
                        }
                    };
                    edtWdt.addTextChangedListener(this.textWatcher);
                    edtWdt.setVisibility(0);
                    edtWdt.setText((CharSequence)voteQuestion.getM_strAnwser());
                    lyChoice.setVisibility(8);
                    if (GSVoteView.this.bSummited || VoteReceiveAdapter.this.voteGroup.isM_bDeadline() || VoteReceiveAdapter.this.voteGroup.isM_bPublishResult()) {
                        edtWdt.setVisibility(8);
                        continue;
                    }
                    edtWdt.setVisibility(0);
                }
            }
        }
    }
}

