/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.view;

import android.content.Context;
import android.os.Bundle;
import android.os.Message;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.EditText;
import android.widget.ListAdapter;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.gensee.adapter.AbstractAdapter;
import com.gensee.adapter.AbstractViewHolder;
import com.gensee.entity.qa.RtQaMsg;
import com.gensee.holder.qa.impl.AbstractQaImpl;
import com.gensee.holder.qa.impl.QaMsgQueue;
import com.gensee.player.IPlayerQA;
import com.gensee.routine.UserInfo;
import com.gensee.utils.DateUtil;
import com.gensee.utils.GenseeLog;
import com.gensee.utils.StringUtil;
import com.gensee.utils.ThreadPool;
import com.gensee.view.GsAbsView;
import com.gensee.view.IQaView;
import com.gensee.view.QaLvView;
import java.util.Calendar;
import java.util.List;
import java.util.UUID;

public abstract class GSQaView
extends GsAbsView
implements IQaView {
    private View btnSend;
    private RelativeLayout relTip;
    private TextView tvTip;
    private EditText editContent;
    private IPlayerQA mQaHandle;
    private boolean isMute;
    private boolean isRoomMute;
    private PublicQaLv mPublicQaLv;
    private SelfQaLv mSelfQaLv;
    private QaImpl mQaImpl;

    public GSQaView(Context context) {
        this(context, null);
    }

    private long getUserId() {
        UserInfo info = this.mQaHandle == null ? null : this.mQaHandle.getSelfInfo();
        return info == null ? 0L : info.getUserId();
    }

    public GSQaView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    public GSQaView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    @Override
    public void setModuleHandle(IPlayerQA qaHandle) {
        this.mQaHandle = qaHandle;
        QaMsgQueue.getIns().initMsgDb(this.getContext());
    }

    @Override
    public void onQaMute(boolean isMute) {
        this.isMute = isMute;
        this.qaEnable();
    }

    @Override
    public void onRoomMute(boolean isMute) {
        this.isRoomMute = isMute;
        this.qaEnable();
    }

    @Override
    public void onReconnection() {
        QaMsgQueue.getIns().release();
    }

    protected void qaEnable() {
        this.post(new Runnable(){

            @Override
            public void run() {
                GSQaView.this.btnSend.setEnabled(!GSQaView.this.isMute && !GSQaView.this.isRoomMute);
                GSQaView.this.editContent.setEnabled(!GSQaView.this.isMute && !GSQaView.this.isRoomMute);
                GSQaView.this.editContent.setText((CharSequence)"");
            }
        });
    }

    @Override
    public void onQa(String questionId, String question, String questionOwner, String answerId, String answer, String answerOwner, int questionTime, int answerTime, long qaOwnerId, boolean isCancel) {
        this.addMsg(questionId, question, questionOwner, answerId, answer, answerOwner, questionTime, answerTime, qaOwnerId, isCancel);
    }

    public void addMsg(final String questionId, String question, String questionOwner, String answerId, String answer, String answerOwner, int questionTime, int answerTime, long qaOwnerId, boolean isCancel) {
        UserInfo self = this.mQaHandle.getSelfInfo();
        if (isCancel) {
            boolean bTrue = false;
            if (null != self && qaOwnerId == self.getUserId()) {
                bTrue = true;
            }
            final boolean bTmpTrue = bTrue;
            ThreadPool.getInstance().execute(new Runnable(){

                @Override
                public void run() {
                    QaMsgQueue.getIns().cancelQaMsg(questionId, bTmpTrue);
                }
            });
        } else {
            RtQaMsg msg = new RtQaMsg();
            msg.setAnswer(answer);
            msg.setAnswerId(answerId);
            msg.setAnswerOwner(answerOwner);
            msg.setAnswerTimestamp((long)answerTime);
            msg.setQuestId(questionId);
            msg.setQuestion(question);
            msg.setQuestOwnerId(qaOwnerId);
            msg.setQuestOwnerName(questionOwner);
            msg.setQuestTimgstamp((long)questionTime);
            msg.setTimestamp(Calendar.getInstance().getTimeInMillis());
            this.mQaImpl.addMsg(msg);
        }
    }

    public void onClick(View v) {
        int id = v.getId();
        if (id == this.getQaSendBtnId()) {
            if (this.isMute || this.isRoomMute) {
                return;
            }
            String q = this.editContent.getText().toString();
            if ("".equals(q)) {
                GenseeLog.w((String)"question content is empty");
                return;
            }
            this.editContent.setText((CharSequence)"");
            if (this.mQaHandle != null) {
                String uuid = UUID.randomUUID().toString();
                this.mQaHandle.question(uuid, q);
                RtQaMsg msg = new RtQaMsg();
                msg.setQuestId(uuid);
                msg.setQuestion(q);
                UserInfo self = this.mQaHandle.getSelfInfo();
                if (self != null) {
                    msg.setQuestOwnerId(self.getUserId());
                    msg.setQuestOwnerName(self.getName());
                }
                long now = Calendar.getInstance().getTimeInMillis();
                msg.setQuestTimgstamp(now / 1000L);
                msg.setTimestamp(now);
                this.mQaImpl.addMsg(msg);
            } else {
                GenseeLog.w((String)"mQaHandle is null");
            }
        } else if (id == this.getLimitSelfQaId()) {
            if (this.mQaHandle == null || this.mSelfQaLv == null || this.mPublicQaLv == null) {
                return;
            }
            TextView tvPublicQuerySelf = this.mPublicQaLv.tvQuerySelf;
            TextView tvSelfQuerySelf = this.mSelfQaLv.tvQuerySelf;
            tvPublicQuerySelf.setSelected(!tvPublicQuerySelf.isSelected());
            tvSelfQuerySelf.setSelected(!tvSelfQuerySelf.isSelected());
            this.mSelfQaLv.show(tvSelfQuerySelf.isSelected());
            if (tvSelfQuerySelf.isSelected()) {
                final UserInfo self = this.mQaHandle.getSelfInfo();
                if (null != self) {
                    ThreadPool.getInstance().execute(new Runnable(){

                        @Override
                        public void run() {
                            QaMsgQueue.getIns().getSelfQaLatestMsg(self.getUserId());
                        }
                    });
                }
            } else {
                QaMsgQueue.getIns().getMsgList();
                QaMsgQueue.getIns().resetSelfList();
            }
        }
    }

    @Override
    protected void initView(View view) {
        super.initView(view);
        this.relTip = (RelativeLayout)view.findViewById(this.getRelTipId());
        this.tvTip = (TextView)view.findViewById(this.getTvTipId());
        this.btnSend = view.findViewById(this.getQaSendBtnId());
        this.editContent = (EditText)view.findViewById(this.getQaEditId());
        this.btnSend.setOnClickListener((View.OnClickListener)this);
        this.mPublicQaLv = new PublicQaLv();
        QaMsgQueue.getIns().setOnQaHolderListener((QaMsgQueue.OnQaHolderListener)this.mPublicQaLv);
        this.mPublicQaLv.initView(view);
        this.mSelfQaLv = new SelfQaLv();
        this.mSelfQaLv.initView(view);
        this.mQaImpl = new QaImpl();
    }

    protected abstract int getLimitSelfQaId();

    protected abstract AbsQaAdapter getQaAdapter(Context var1);

    protected abstract int getQaHeadViewLayout();

    protected abstract int getQaSendBtnId();

    protected abstract int getQaListViewId();

    protected abstract int getSelfQaListViewId();

    protected abstract int getSelfQaRl();

    protected abstract int getQaEditId();

    protected abstract int getQaShowOwnerTextRes();

    protected abstract int getMeStrRes();

    protected abstract int getRelTipId();

    protected abstract int getRelTipStrId();

    protected abstract int getTvTipId();

    @Override
    public void release() {
        this.mQaImpl.release();
        this.isMute = false;
        this.isRoomMute = false;
    }

    protected class SelfQaLv
    extends QaLvView {
        private TextView tvQuerySelf;
        private RelativeLayout rlQuerySelf;

        protected SelfQaLv() {
        }

        @Override
        protected void initView(View view) {
            super.initView(view);
            View headerView = LayoutInflater.from((Context)GSQaView.this.getContext()).inflate(GSQaView.this.getQaHeadViewLayout(), null);
            this.lvChat.addHeaderView(headerView);
            this.adapter = GSQaView.this.getQaAdapter(GSQaView.this.getContext());
            this.lvChat.setAdapter((ListAdapter)this.adapter);
            this.tvQuerySelf = (TextView)headerView.findViewById(GSQaView.this.getLimitSelfQaId());
            this.tvQuerySelf.setText(GSQaView.this.getQaShowOwnerTextRes());
            this.tvQuerySelf.setOnClickListener((View.OnClickListener)GSQaView.this);
            this.tvQuerySelf.setSelected(false);
            this.rlQuerySelf = (RelativeLayout)view.findViewById(GSQaView.this.getSelfQaRl());
        }

        protected void show(boolean bVisible) {
            this.rlQuerySelf.setVisibility(bVisible ? 0 : 8);
        }

        private void refreshMsg(int what, List<RtQaMsg> msgList, boolean bLatest) {
            Message message = new Message();
            message.obj = msgList;
            message.what = what;
            Bundle bundle = new Bundle();
            bundle.putBoolean("QALATEST", bLatest);
            message.setData(bundle);
            this.sendMessage(message);
        }

        @Override
        protected void refresh() {
            ThreadPool.getInstance().execute(new Runnable(){

                @Override
                public void run() {
                    UserInfo self = GSQaView.this.mQaHandle.getSelfInfo();
                    QaMsgQueue.getIns().onSelfMessageFresh(self == null ? -1L : self.getUserId());
                }
            });
        }

        @Override
        protected void loadMore() {
            ThreadPool.getInstance().execute(new Runnable(){

                @Override
                public void run() {
                    UserInfo self = GSQaView.this.mQaHandle.getSelfInfo();
                    QaMsgQueue.getIns().onSelfMessageLoadMore(self == null ? -1L : self.getUserId());
                }
            });
        }

        @Override
        protected int getLvId() {
            return GSQaView.this.getSelfQaListViewId();
        }
    }

    protected class PublicQaLv
    extends QaLvView
    implements QaMsgQueue.OnQaHolderListener {
        private TextView tvQuerySelf;

        protected PublicQaLv() {
        }

        @Override
        protected void initView(View view) {
            super.initView(view);
            View headerView = LayoutInflater.from((Context)GSQaView.this.getContext()).inflate(GSQaView.this.getQaHeadViewLayout(), null);
            this.lvChat.addHeaderView(headerView);
            this.adapter = GSQaView.this.getQaAdapter(GSQaView.this.getContext());
            this.lvChat.setAdapter((ListAdapter)this.adapter);
            this.tvQuerySelf = (TextView)headerView.findViewById(GSQaView.this.getLimitSelfQaId());
            this.tvQuerySelf.setText(GSQaView.this.getQaShowOwnerTextRes());
            this.tvQuerySelf.setOnClickListener((View.OnClickListener)GSQaView.this);
            this.tvQuerySelf.setSelected(false);
        }

        @Override
        protected void refresh() {
            ThreadPool.getInstance().execute(new Runnable(){

                @Override
                public void run() {
                    QaMsgQueue.getIns().onMessageFresh();
                }
            });
        }

        @Override
        protected void loadMore() {
            ThreadPool.getInstance().execute(new Runnable(){

                @Override
                public void run() {
                    QaMsgQueue.getIns().onMessageLoadMore();
                }
            });
        }

        @Override
        protected int getLvId() {
            return GSQaView.this.getQaListViewId();
        }

        public boolean isLvBottom() {
            return this.getLvBottom();
        }

        public boolean isSelfLvBottom() {
            return null != GSQaView.this.mSelfQaLv ? GSQaView.this.mSelfQaLv.getLvBottom() : false;
        }

        private void refreshMsg(int what, List<RtQaMsg> msgList, boolean bLatest) {
            Message message = new Message();
            message.obj = msgList;
            message.what = what;
            Bundle bundle = new Bundle();
            bundle.putBoolean("QALATEST", bLatest);
            message.setData(bundle);
            this.sendMessage(message);
        }

        public void refreshMsg(List<RtQaMsg> msgList, boolean bLatest) {
            this.refreshMsg(20000, msgList, bLatest);
        }

        public void onPullMsg(List<RtQaMsg> msgList, boolean bLatest) {
            this.refreshMsg(20004, msgList, bLatest);
        }

        public void onLoadMsg(List<RtQaMsg> msgList, boolean bLatest) {
            this.refreshMsg(20005, msgList, bLatest);
        }

        public void refreshSelfMsg(List<RtQaMsg> msgList, boolean bLatest) {
            if (null != GSQaView.this.mSelfQaLv) {
                GSQaView.this.mSelfQaLv.refreshMsg(20002, msgList, bLatest);
            }
        }

        public void onPullSelfMsg(List<RtQaMsg> msgList, boolean bLatest) {
            if (null != GSQaView.this.mSelfQaLv) {
                GSQaView.this.mSelfQaLv.refreshMsg(20006, msgList, bLatest);
            }
        }

        public void onLoadSelfMsg(List<RtQaMsg> msgList, boolean bLatest) {
            if (null != GSQaView.this.mSelfQaLv) {
                GSQaView.this.mSelfQaLv.refreshMsg(20007, msgList, bLatest);
            }
        }

        public void onCancelMsg(List<RtQaMsg> msgList, boolean bLatest) {
            this.refreshMsg(20001, msgList, bLatest);
        }

        public void onCancelSelfMsg(List<RtQaMsg> msgList, boolean bLatest) {
            if (null != GSQaView.this.mSelfQaLv) {
                GSQaView.this.mSelfQaLv.refreshMsg(20008, msgList, bLatest);
            }
        }

        public void onNewMsgCount(int nMsgCount) {
        }

        public long getSelfUserId() {
            UserInfo self = null != GSQaView.this.mQaHandle ? GSQaView.this.mQaHandle.getSelfInfo() : null;
            return null != self ? self.getUserId() : 0L;
        }

        public void clear() {
        }
    }

    protected class QaImpl
    extends AbstractQaImpl {
    }

    protected abstract class AbsQaAdapter
    extends AbstractAdapter {
        public AbsQaAdapter(Context context) {
        }

        public int getCount() {
            return this.objectList == null ? 0 : this.objectList.size();
        }

        public Object getItem(int positon) {
            return positon < this.getCount() ? this.objectList.get(positon) : null;
        }

        protected abstract class AbsQaHolder
        extends AbstractViewHolder {
            private TextView txtQContent;
            private TextView txtAContent;
            private TextView txtQUser;
            private TextView txtAUser;
            private TextView txtQTime;
            private TextView txtATime;
            private View relAnwserView;
            private TextView txtSameQ;

            protected AbsQaHolder(View v) {
                super(v);
            }

            public void initView(View v) {
                if (v != null) {
                    this.txtQContent = (TextView)v.findViewById(this.getQTextViewId());
                    this.txtAContent = (TextView)v.findViewById(this.getATextViewId());
                    this.txtQUser = (TextView)v.findViewById(this.getQUserTextViewId());
                    this.txtAUser = (TextView)v.findViewById(this.getAUserTextViewId());
                    this.txtQTime = (TextView)v.findViewById(this.getQTimeTextViewId());
                    this.txtATime = (TextView)v.findViewById(this.getATimeTextViewId());
                    this.relAnwserView = v.findViewById(this.getAnswerGroupViewId());
                    int sameQResId = this.getSameQTVId();
                    if (sameQResId != 0) {
                        this.txtSameQ = (TextView)v.findViewById(sameQResId);
                    }
                }
            }

            public void initValue(int positon) {
                final RtQaMsg msg = (RtQaMsg)AbsQaAdapter.this.getItem(positon);
                if (msg != null) {
                    String answer;
                    UserInfo userInfo;
                    this.txtQContent.setText((CharSequence)msg.getQuestion());
                    this.txtQUser.setText((CharSequence)("- " + msg.getQuestOwnerName()));
                    long qTime = msg.getQuestTimgstamp();
                    if (qTime > 0L) {
                        this.txtQTime.setText((CharSequence)(" (" + DateUtil.getStringDateShort((long)qTime).substring(11) + ")"));
                    } else {
                        this.txtQTime.setText((CharSequence)"");
                    }
                    boolean isOwnQ = false;
                    if (GSQaView.this.mQaHandle != null && (userInfo = GSQaView.this.mQaHandle.getSelfInfo()) != null && msg.getQuestOwnerId() == userInfo.getId()) {
                        isOwnQ = true;
                    }
                    final boolean ownQ = isOwnQ;
                    if (this.txtSameQ != null) {
                        this.txtSameQ.setOnClickListener(new View.OnClickListener(){

                            public void onClick(View view) {
                                if (GSQaView.this.mQaHandle != null && !ownQ) {
                                    GSQaView.this.mQaHandle.sameQuestion(msg.getQuestId(), null);
                                }
                            }
                        });
                    }
                    if (StringUtil.isEmpty((String)(answer = msg.getAnswer()))) {
                        this.relAnwserView.setVisibility(8);
                        if (this.txtSameQ != null && !isOwnQ) {
                            this.txtSameQ.setVisibility(0);
                        }
                    } else {
                        if (this.txtSameQ != null) {
                            this.txtSameQ.setVisibility(8);
                        }
                        this.txtAContent.setText((CharSequence)msg.getAnswer());
                        this.txtAUser.setText((CharSequence)("- " + msg.getAnswerOwner()));
                        long aTime = msg.getAnswerTimestamp();
                        if (aTime > 0L) {
                            this.txtATime.setText((CharSequence)(" (" + DateUtil.getStringDateShort((long)aTime).substring(11) + ")"));
                        } else {
                            this.txtATime.setText((CharSequence)"");
                        }
                        this.relAnwserView.setVisibility(0);
                    }
                }
            }

            protected abstract int getQUserTextViewId();

            protected abstract int getAUserTextViewId();

            protected abstract int getQTextViewId();

            protected abstract int getATextViewId();

            protected abstract int getQTimeTextViewId();

            protected abstract int getATimeTextViewId();

            protected abstract int getAnswerGroupViewId();

            protected int getSameQTVId() {
                return 0;
            }
        }
    }
}

