/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.view;

import android.os.Bundle;
import com.gensee.adapter.AbstractAdapter;
import com.gensee.entity.chat.AbsChatMessage;
import com.gensee.view.BaseLvView;
import java.util.List;

public abstract class ChatLvView
extends BaseLvView {
    public static final int NEW_MSG = 10000;
    public static final int CHAT_CANCEL_PUB = 10001;
    public static final int NEW_REFRESH = 10002;
    public static final int NEW_LOADMORE = 10003;
    public static final int NEW_SELF_MSG = 10004;
    public static final int NEW_SELF_REFRESH = 10005;
    public static final int NEW_SELF_LOADMORE = 10006;
    public static final int CHAT_CANCEL_SELF_PUB = 10007;
    protected String TAG = this.getClass().getSimpleName();
    protected AbstractAdapter adapter;

    protected void notifyData(final List<AbsChatMessage> msgList) {
        if (null != this.adapter) {
            this.adapter.notifyData(msgList);
            this.postDelayed(new Runnable(){

                @Override
                public void run() {
                    if (ChatLvView.this.getLvBottom()) {
                        ChatLvView.this.lvChat.setSelection(msgList.size());
                    }
                }
            }, 500L);
        }
    }

    @Override
    public void onMessage(int what, Object obj, Bundle bundle) {
        super.onMessage(what, obj, bundle);
        switch (what) {
            case 10003: 
            case 10006: {
                this.lvChat.stopLoadMore();
                this.notifyData((List)obj);
                boolean bLatest = bundle.getBoolean("LATEST");
                this.updateXListViewUi(bLatest);
                this.bRefreshing = false;
                break;
            }
            case 10000: 
            case 10004: {
                boolean bLatestNewMsg = bundle.getBoolean("LATEST");
                this.notifyData((List)obj);
                this.updateXListViewUi(bLatestNewMsg);
                break;
            }
            case 10002: 
            case 10005: {
                boolean bLatest1 = bundle.getBoolean("LATEST");
                this.updateXListViewUi(bLatest1);
                this.notifyData((List)obj);
                this.onLvReLoad();
                this.bRefreshing = false;
                break;
            }
            case 10001: 
            case 10007: {
                this.notifyData((List)obj);
                this.updateXListViewUi(bundle.getBoolean("LATEST"));
            }
        }
    }
}

