/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.view;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.PopupWindow;
import android.widget.TextView;
import java.util.ArrayList;
import java.util.List;

public abstract class AbsVotePopView
extends PopupWindow {
    private final int MAX_SIZE = 6;
    private ListView listView;
    private TextView tvSelect;
    protected AbsVotePopAdapter popAdapter;
    protected InterfaceSelectOther interfaceSelectOther;
    private boolean isOpenPop = false;
    private List<String> popList = new ArrayList<String>();
    protected View parent;

    public AbsVotePopView(View parentView, InterfaceSelectOther interfaceSelectOther, List<String> searchList) {
        this.interfaceSelectOther = interfaceSelectOther;
        LayoutInflater inflater = LayoutInflater.from((Context)parentView.getContext());
        View view = inflater.inflate(this.getVotePopLayoutId(), null);
        this.listView = (ListView)view.findViewById(this.getVoteLvId());
        this.tvSelect = (TextView)parentView.findViewById(this.getVoteSelectTvId());
        this.tvSelect.setSelected(false);
        this.popAdapter = this.getVoteViewAdapter();
        this.listView.setAdapter((ListAdapter)this.popAdapter);
        this.setContentView(view);
        this.setWidth((int)parentView.getContext().getResources().getDimension(this.getVotePopItemWidthResId()));
        this.setHeight((int)parentView.getContext().getResources().getDimension(this.getVotePopItemHeightResId()));
        this.setBackgroundDrawable(parentView.getContext().getResources().getDrawable(17170445));
        this.setFocusable(true);
        this.setOutsideTouchable(false);
        this.setOnDismissListener(new PopupWindow.OnDismissListener(){

            public void onDismiss() {
                AbsVotePopView.this.isOpenPop = false;
                AbsVotePopView.this.tvSelect.setSelected(false);
            }
        });
        this.popList = searchList;
    }

    public void showPopWindow(View v) {
        if (this.popList.size() <= 0) {
            return;
        }
        this.parent = v;
        this.popAdapter.notifyDataSetChanged();
        this.changePopState(v);
    }

    public void updatePopWindow() {
    }

    private void changePopState(View v) {
        boolean bl = this.isOpenPop = !this.isOpenPop;
        if (this.isOpenPop) {
            this.tvSelect.setSelected(true);
            this.popAwindow(v);
        } else {
            this.tvSelect.setSelected(false);
            this.dismiss();
        }
    }

    protected void popAwindow(View parent) {
        this.setWidth(parent.getWidth());
        int nSize = this.popList.size();
        if (nSize > 6) {
            nSize = 6;
        }
        this.setHeight((int)parent.getContext().getResources().getDimension(this.getVotePopItemHeightResId()) * nSize + (nSize - 1) + 4);
        int[] location = new int[2];
        parent.getLocationOnScreen(location);
        this.showAtLocation(parent, 51, location[0], location[1] + parent.getHeight());
    }

    protected abstract int getVotePopLayoutId();

    protected abstract int getVoteLvId();

    protected abstract int getVoteSelectTvId();

    protected abstract int getVotePopItemWidthResId();

    protected abstract int getVotePopItemHeightResId();

    protected abstract AbsVotePopAdapter getVoteViewAdapter();

    public static interface InterfaceSelectOther {
        public void sendToOther(int var1);
    }

    protected abstract class AbsVoteViewHolder {
        protected TextView tvTitle;

        protected abstract int getVoteNameTvId();

        public AbsVoteViewHolder(View view) {
            this.tvTitle = (TextView)view.findViewById(this.getVoteNameTvId());
        }

        public void init(String menuItem, final int position) {
            this.tvTitle.setText((CharSequence)menuItem);
            this.tvTitle.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (null != AbsVotePopView.this.interfaceSelectOther) {
                        AbsVotePopView.this.interfaceSelectOther.sendToOther(position);
                        AbsVotePopView.this.dismiss();
                    }
                }
            });
        }
    }

    protected abstract class AbsVotePopAdapter
    extends BaseAdapter {
        protected AbsVotePopAdapter() {
        }

        public int getCount() {
            if (null == AbsVotePopView.this.popList) {
                return 0;
            }
            return AbsVotePopView.this.popList.size();
        }

        public Object getItem(int position) {
            return AbsVotePopView.this.popList.get(position);
        }

        public long getItemId(int position) {
            return position;
        }

        protected abstract int getVoteItemLayoutId();

        protected abstract AbsVoteViewHolder createVoteViewHolder(View var1);

        public View getView(int position, View convertView, ViewGroup parent) {
            AbsVoteViewHolder viewHolder = null;
            if (null == convertView) {
                LayoutInflater inflater = LayoutInflater.from((Context)parent.getContext());
                convertView = inflater.inflate(this.getVoteItemLayoutId(), null);
                viewHolder = this.createVoteViewHolder(convertView);
                convertView.setTag((Object)viewHolder);
            } else {
                viewHolder = (AbsVoteViewHolder)convertView.getTag();
            }
            viewHolder.init((String)AbsVotePopView.this.popList.get(position), position);
            return convertView;
        }
    }
}

