/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.player;

import android.content.Context;
import android.os.Handler;
import android.util.Log;
import com.gensee.chatfilter.SensiviteWordFilter;
import com.gensee.common.GenseeConfig;
import com.gensee.common.PlayerEnv;
import com.gensee.common.ServiceType;
import com.gensee.entity.BroadCastMsg;
import com.gensee.entity.ChatMsg;
import com.gensee.entity.InitParam;
import com.gensee.entity.LiveInfo;
import com.gensee.entity.LoginResEntity;
import com.gensee.entity.PayInfo;
import com.gensee.entity.PingEntity;
import com.gensee.entity.Reward;
import com.gensee.entity.RewardResult;
import com.gensee.holder.chat.impl.MsgQueue;
import com.gensee.holder.qa.impl.QaMsgQueue;
import com.gensee.media.AVConfig;
import com.gensee.media.IVideoIndication;
import com.gensee.net.RewardAction;
import com.gensee.net.RtmpReq;
import com.gensee.net.StringRes;
import com.gensee.pdu.GSDocView;
import com.gensee.player.IPlayerChat;
import com.gensee.player.IPlayerQA;
import com.gensee.player.IPlayerVote;
import com.gensee.player.NativePlayer;
import com.gensee.player.OnChatListener;
import com.gensee.player.OnPlayListener;
import com.gensee.player.OnQaListener;
import com.gensee.player.VideoRate;
import com.gensee.routine.UserInfo;
import com.gensee.service.IBaseExtension;
import com.gensee.service.IRedEnvelopes;
import com.gensee.taskret.OnTaskRet;
import com.gensee.user.UserManager;
import com.gensee.utils.FileUtil;
import com.gensee.utils.GenseeLog;
import com.gensee.utils.StringUtil;
import com.gensee.videoparam.VideoParam;
import com.gensee.view.GSDocViewGx;
import com.gensee.view.GSVoteView;
import com.gensee.view.IChatView;
import com.gensee.view.ILocalVideoView;
import com.gensee.view.IQaView;
import com.gensee.vote.OnVoteListener;
import com.gensee.vote.VotePlayerGroup;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Queue;
import java.util.Random;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Player
implements IPlayerChat,
IPlayerQA,
IPlayerVote {
    protected static final String TAG = "Player";
    private NativePlayer mPlayer;
    private OnPlayListener mListener;
    private OnChatListener onChatListener;
    private OnVoteListener voteCallback;
    private OnQaListener mQaListener;
    private IChatView mChatView;
    private IQaView mQaView;
    private UserInfo selfInfo;
    private VideoRate rate = VideoRate.RATE_NORMAL;
    private LoginResEntity p;
    private HashMap<String, Long> mQaMap;
    private Set<String> selfChatMsgs;
    private SensiviteWordFilter mWordFilter;
    private Context mContext;
    private InitParam initParam;
    private RtmpReq req;
    private List<String> idcs = null;
    private List<String> preferredIdcs = new ArrayList<String>();
    private List<String> mOverseasIDCList = null;
    private IRedEnvelopes redEnvelopes;
    private List<IBaseExtension> extensions;
    private int doubleTeacherStatus;
    private boolean isPublish = false;
    private boolean isCaching = false;
    Handler mHandler = new Handler();
    private boolean autoPreferredNetwork = false;
    private boolean uploadPreferredNetworkLog = false;
    private PreferredNetworkConfig preferredNetworkConfig;
    private int joinType = -1;
    private NativePlayer.OnNativeListener nativeCallback = new NativePlayer.OnNativeListener(){
        private Runnable joinTimeoutRunnable = new Runnable(){

            @Override
            public void run() {
                Player.this.trackPreferredLog(4, 2, "joinTimeoutRunnable");
                if (!Player.this.isPublish) {
                    return;
                }
                Player.this.trackPreferredLog(4, 2, "selectNewIdc, but join timeout\uff0cselect next idc");
                this.selectNewIdc();
            }
        };
        private long selectNewIdcTime = 0L;
        Runnable cacheTimeOutRunnable = new Runnable(){

            @Override
            public void run() {
                Player.this.trackPreferredLog(4, 6, "cacheTimeOutRunnable");
                if (!Player.this.isPublish) {
                    return;
                }
                Player.this.trackPreferredLog(4, 6, "\u7f13\u51b2\u65f6\u95f4\u8d85\u8fc7" + ((Player)Player.this).preferredNetworkConfig.TIMEOUT + "\u79d2\uff0c\u5207\u6362\u8282\u70b9");
                this.selectNewIdc();
                cacheTime.clear();
            }
        };
        private Runnable cacheCountRunnable = new Runnable(){

            @Override
            public void run() {
                cacheTime.add("1");
                Player.this.mHandler.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        cacheTime.poll();
                    }
                }, 30000L);
                Player.this.trackPreferredLog(4, 6, "\u5f00\u59cb\u7f13\u51b2\uff0c\u589e\u52a01\u6b21,\u65f6\u95f4\u8303\u56f4\u5185\u5df2\u6709" + cacheTime.size() + "\u6b21\u7f13\u51b2");
                if (cacheTime.size() > ((Player)Player.this).preferredNetworkConfig.CACHE_TIME) {
                    Player.this.trackPreferredLog(4, 6, "\u8d85\u8fc7" + ((Player)Player.this).preferredNetworkConfig.CACHE_TIME + "\u6b21\uff0c\u8fbe\u5230\u5207\u6362\u6761\u4ef6");
                    cacheTime.clear();
                    GenseeLog.d((String)Player.TAG, (String)"removeCallbacksAndMessages isCaching true");
                    this.selectNewIdc();
                    return;
                }
                Player.this.mHandler.postDelayed(cacheCountRunnable, 1000L);
            }
        };
        private Queue<String> cacheTime = new ArrayDeque<String>();
        private Queue<Long> changeIdcTime = new ArrayDeque<Long>();

        @Override
        public void onUserUpdate(UserInfo info) {
            UserManager.getIns().userUpdate(info, 0);
            if (Player.this.mListener != null) {
                Player.this.mListener.onUserUpdate(info);
            }
            if (null != Player.this.mChatView) {
                Player.this.mChatView.updateChatTarget(info, false);
            }
        }

        @Override
        public void onUserLeave(UserInfo info) {
            UserManager.getIns().userLeave(info.getUserId());
            if (null != Player.this.mChatView) {
                Player.this.mChatView.updateChatTarget(info, true);
            }
            if (Player.this.mListener != null) {
                Player.this.mListener.onUserLeave(info);
            }
        }

        @Override
        public void onUserJoin(UserInfo info) {
            UserManager.getIns().userJoin(info, Player.this.selfInfo.getUserId());
            if (Player.this.mListener != null) {
                Player.this.mListener.onUserJoin(info);
            }
        }

        @Override
        public void onRosterTotal(int total) {
            if (Player.this.mListener != null) {
                Player.this.mListener.onRosterTotal(total);
            }
        }

        @Override
        public void onReconnecting() {
            Player.this.trackPreferredLog(5, 6, "onReconnecting");
            if (Player.this.mListener != null) {
                Player.this.mListener.onReconnecting();
            }
            if (null != Player.this.onChatListener) {
                Player.this.onChatListener.onReconnection();
            }
            if (Player.this.mQaView != null) {
                Player.this.mQaView.onReconnection();
            }
            if (Player.this.isCaching) {
                this.onCaching(false);
            }
        }

        @Override
        public void onLeave(int reason) {
            GenseeLog.trackLog((int)4, (int)2, (String)Player.TAG, (String)("onLeave reason = " + reason));
            GenseeLog.clearLogEntry();
            if (Player.this.mListener != null) {
                Player.this.mListener.onLeave(reason);
            }
            Player.this.mHandler.removeCallbacksAndMessages(null);
            GenseeLog.d((String)Player.TAG, (String)"removeCallbacksAndMessages onLeave");
        }

        private void selectPreferredIdcs() {
            if (Player.this.mOverseasIDCList.contains(Player.this.getCurIdc())) {
                Player.this.preferredIdcs = Player.this.idcs;
            } else {
                Player.this.preferredIdcs = new ArrayList(Player.this.idcs);
                Player.this.preferredIdcs.removeAll(Player.this.mOverseasIDCList);
            }
            Player.this.trackPreferredLog(4, 1, "onJoin preferredIdcs: " + Player.this.preferredIdcs.toString());
        }

        @Override
        public void onJoin(int result) {
            GenseeLog.trackLog((int)4, (int)2, (String)Player.TAG, (String)("onJoin result = " + result));
            GenseeLog.trackLog((int)4, (int)1, (String)Player.TAG, (String)("currentIdc  = " + Player.this.getCurIdc()));
            Player.this.outputLogText("onJoin result = " + result);
            Player.this.outputLogText("currentIdc  = " + Player.this.getCurIdc());
            if (result == 6) {
                if (Player.this.autoPreferredNetwork && Player.this.joinType == -1 && !((Player)Player.this).mPlayer.useCdn) {
                    this.outputLog("\u542f\u52a8\u4f18\u9009\u903b\u8f91\uff01");
                    this.selectPreferredIdcs();
                }
                if (Player.this.joinType == 2) {
                    this.changeIdcTime.add(System.currentTimeMillis());
                    Player.this.trackPreferredLog(4, 7, "autoPreferredNetwork success!!! use " + (System.currentTimeMillis() - this.selectNewIdcTime) / 1000L + "second");
                    if (Player.this.mListener != null) {
                        Player.this.mListener.onAutoSwitchIdcSuccess();
                    }
                }
                this.cacheTime.clear();
            }
            Player.this.mHandler.removeCallbacksAndMessages(null);
            if (9 == result || 10 == result) {
                GenseeLog.trackLog((int)6, (int)2, (String)Player.TAG, (String)"onJoin: \u8282\u70b9\u65e0\u6cd5\u8fde\u63a5");
                Player.this.outputLogText("onJoin: \u8282\u70b9\u65e0\u6cd5\u8fde\u63a5");
                if (Player.this.autoPreferredNetwork && Player.this.joinType == 2) {
                    Player.this.trackPreferredLog(4, 1, "Start preferred network");
                    if (!this.selectNewIdc()) {
                        Player.this.trackPreferredLog(5, 1, "AutoPreferredNetwork failed, tried too many times.");
                        Player.this.onJoinRet(result);
                        Player.this.joinType = -1;
                    }
                } else {
                    GenseeLog.i((String)Player.TAG, (String)("onJoinRet\uff0cautoPreferredNetwork " + Player.this.autoPreferredNetwork + " joinType:" + Player.this.joinType));
                    Player.this.onJoinRet(result);
                    Player.this.joinType = -1;
                }
            } else {
                Player.this.onJoinRet(result);
                Player.this.joinType = -1;
            }
            if (Player.this.mListener != null && ((Player)Player.this).mPlayer.useCdn) {
                Player.this.mListener.onCdnEnable(((Player)Player.this).mPlayer.currentCdnName, ((Player)Player.this).mPlayer.cdnList);
            }
            if (Player.this.mListener != null) {
                Player.this.mListener.onPlayerType(((Player)Player.this).mPlayer.playerType);
            }
        }

        private boolean selectNewIdc() {
            Player.this.mHandler.removeCallbacksAndMessages(null);
            long currTime = System.currentTimeMillis();
            while (this.changeIdcTime.size() != 0 && this.changeIdcTime.peek() < currTime - 300000L) {
                GenseeLog.i((String)("remove changeIdcTime:" + this.changeIdcTime.poll()));
            }
            if (!((Player)Player.this).mPlayer.useCdn && ((Player)Player.this).mPlayer.playerType != OnPlayListener.PlayerType.HLS && !Player.this.isDoubleTeacherOrGroup()) {
                if (this.changeIdcTime.size() >= 3) {
                    Player.this.trackPreferredLog(4, 7, "5\u5206\u949f\u5185\u6210\u529f\u5207\u6362\u4e863\u6b21\uff0c\u5207\u6362\u81f3hls\u3002");
                    Player.this.joinType = 2;
                    this.switchToHlsMode();
                    return true;
                }
            } else if (this.changeIdcTime.size() >= 4) {
                Player.this.trackPreferredLog(4, 7, "5\u5206\u949f\u5185\u5207\u6362\u4e864\u6b21\u8282\u70b9\uff0c\u4e0d\u518d\u5207\u6362\u3002");
                Player.this.joinType = -1;
                return false;
            }
            if (!Player.this.autoPreferredNetwork) {
                Player.this.trackPreferredLog(4, 6, "autoPreferredNetwork is close.return");
                return false;
            }
            Player.this.trackPreferredLog(4, 7, "\u81ea\u52a8\u5207\u6362\u8282\u70b9");
            String newIdc = this.getNextIdcId();
            if (!StringUtil.isEmpty((String)newIdc)) {
                Player.this.trackPreferredLog(4, 7, "selectNewIdc " + newIdc + ", old idc is " + Player.this.getCurIdc());
                this.selectNewIdcTime = System.currentTimeMillis();
                Player.this.setIdcIdInternal(newIdc, null);
                Player.this.mHandler.postDelayed(this.joinTimeoutRunnable, (long)(((Player)Player.this).preferredNetworkConfig.TIMEOUT * 1000));
                GenseeLog.d((String)Player.TAG, (String)("postDelayed joinTimeoutRunnable " + ((Player)Player.this).preferredNetworkConfig.TIMEOUT * 1000));
                return true;
            }
            return false;
        }

        private void switchToHlsMode() {
            Player.this.mPlayer.leave(new OnTaskRet(){

                public void onTaskRet(boolean ret, int id, String desc) {
                    selectNewIdcTime = System.currentTimeMillis();
                    Player.this.joinRoomWithHls(Player.this.p);
                }
            });
        }

        private String getNextIdcId() {
            List idcs = Player.this.preferredIdcs;
            String curIdc = Player.this.getCurIdc();
            String newIdc = "";
            if (!Player.this.preferredIdcs.contains(curIdc)) {
                newIdc = "auto";
                return newIdc;
            }
            if (idcs != null && idcs.size() > 1) {
                int newIndex = idcs.indexOf(curIdc) + 1;
                if (newIndex == idcs.size()) {
                    newIndex = 0;
                }
                for (int i = newIndex; i < idcs.size(); ++i) {
                    if (StringUtil.isEmpty((String)((String)idcs.get(i)))) continue;
                    newIdc = (String)idcs.get(i);
                    break;
                }
            }
            return newIdc;
        }

        @Override
        public void onErr(int errCode) {
            GenseeLog.trackLog((int)6, (int)1, (String)Player.TAG, (String)("onErr errCode = " + errCode));
            if (Player.this.mListener != null) {
                Player.this.mListener.onErr(errCode);
            }
        }

        @Override
        public void onCaching(boolean isCaching) {
            Player.this.isCaching = isCaching;
            Player.this.trackPreferredLog(4, 6, "onCaching isCaching = " + isCaching);
            if (Player.this.mListener != null) {
                Player.this.mListener.onCaching(isCaching);
            }
            if (Player.this.isPublish && !((Player)Player.this).mPlayer.useCdn) {
                this.preferredNetwork(isCaching);
            }
        }

        private void preferredNetwork(boolean isCaching) {
            if (isCaching) {
                Player.this.mHandler.post(this.cacheCountRunnable);
                GenseeLog.d((String)Player.TAG, (String)("postDelayed cacheTimeOutRunnable use " + ((Player)Player.this).preferredNetworkConfig.TIMEOUT * 1000));
                Player.this.mHandler.postDelayed(this.cacheTimeOutRunnable, (long)(((Player)Player.this).preferredNetworkConfig.TIMEOUT * 1000));
            } else {
                Player.this.mHandler.removeCallbacks(this.cacheTimeOutRunnable);
                Player.this.mHandler.removeCallbacks(this.cacheCountRunnable);
                GenseeLog.d((String)Player.TAG, (String)"removeCallbacks isCaching false");
            }
        }

        @Override
        public void onQa(String questionId, String question, String questionOwner, String answerId, String answer, String answerOwner, int questionTime, int answerTime, long qaOwnerId, boolean isCancel) {
            GenseeLog.d((String)Player.TAG, (String)("onQa questionId = " + questionId));
            if (!StringUtil.isEmpty((String)questionId)) {
                HashMap cache = Player.this.getQaCache();
                if (!isCancel && answerTime <= 0 && StringUtil.isEmpty((String)answer) && cache.containsKey(questionId)) {
                    return;
                }
                if (isCancel) {
                    cache.remove(questionId);
                }
            }
            if (Player.this.mQaListener != null) {
                Player.this.mQaListener.onQa(questionId, question, questionOwner, answerId, answer, answerOwner, questionTime, answerTime, qaOwnerId, isCancel);
            }
        }

        @Override
        public void OnChatWithPersion(ChatMsg msg) {
            if (Player.this.onChatListener != null) {
                Player.this.onChatListener.onChatWithPerson(msg);
            }
        }

        @Override
        public void OnChatWithPublic(ChatMsg msg) {
            Set sets;
            String msgId = msg.getId();
            if (msgId != null && (sets = Player.this.getSelfChatMsgs()).contains(msgId)) {
                sets.remove(msgId);
                return;
            }
            if (Player.this.onChatListener != null) {
                Player.this.onChatListener.onChatWithPublic(msg);
            }
        }

        @Override
        public void onMute(boolean isMute) {
            if (null != Player.this.onChatListener) {
                Player.this.onChatListener.onMute(isMute);
            }
            if (Player.this.mQaListener != null) {
                Player.this.mQaListener.onQaMute(isMute);
            }
        }

        @Override
        public void onVotePublish(VotePlayerGroup voteGroup) {
            GenseeLog.d((String)Player.TAG, (String)("onVotePublish voteGroup=" + voteGroup));
            if (null != Player.this.voteCallback) {
                Player.this.voteCallback.onVotePublish(voteGroup);
            }
        }

        @Override
        public void onVotePublishResult(VotePlayerGroup voteGroup) {
            GenseeLog.d((String)Player.TAG, (String)("onVotePublishResult voteGroup=" + voteGroup));
            if (null != Player.this.voteCallback) {
                Player.this.voteCallback.onVotePublishResult(voteGroup);
            }
        }

        @Override
        public void onDocSwitch(int docType, String docName) {
            if (Player.this.mListener != null) {
                Player.this.mListener.onDocSwitch(docType, docName);
            }
        }

        public void outputLog(String log) {
            Player.this.outputLogText(log);
        }

        @Override
        public void onVideoBegin() {
            if (Player.this.mListener != null) {
                Player.this.mListener.onVideoBegin();
            }
        }

        @Override
        public void onVideoEnd() {
            if (Player.this.mListener != null) {
                Player.this.mListener.onVideoEnd();
            }
        }

        @Override
        public void onVideoSize(int width, int height, boolean isAs) {
            if (Player.this.mListener != null) {
                Player.this.mListener.onVideoSize(width, height, isAs);
            }
        }

        @Override
        public void onAudioLevel(int level) {
            if (Player.this.mListener != null) {
                Player.this.mListener.onAudioLevel(level);
            }
        }

        @Override
        public void onVideoDataNotify() {
            if (Player.this.mListener != null) {
                Player.this.mListener.onVideoDataNotify();
            }
        }

        @Override
        public void onChatEnable(boolean isEnable) {
            if (Player.this.onChatListener != null) {
                Player.this.onChatListener.onRoomMute(!isEnable);
            }
        }

        @Override
        public void onQaEnable(boolean isEnable) {
            if (Player.this.mQaListener != null) {
                Player.this.mQaListener.onRoomMute(!isEnable);
            }
        }

        @Override
        public void onPublish(boolean isPlaying) {
            if (Player.this.mListener != null) {
                Player.this.mListener.onPublish(isPlaying);
            }
            if (null != Player.this.onChatListener) {
                Player.this.onChatListener.onPublish(isPlaying);
            }
            Player.this.isPublish = isPlaying;
            GenseeLog.trackLog((int)4, (int)1, (String)Player.TAG, (String)("\u76f4\u64ad\u95f4\u72b6\u6001\uff1a" + isPlaying));
            if (!isPlaying) {
                Player.this.mHandler.removeCallbacks(this.cacheTimeOutRunnable);
                Player.this.mHandler.removeCallbacks(this.cacheCountRunnable);
            }
        }

        @Override
        public void onSubject(String subject) {
            if (Player.this.mListener != null) {
                Player.this.mListener.onSubject(subject);
            }
        }

        @Override
        public void onPageSize(int pos, int width, int height) {
            if (Player.this.mListener != null) {
                Player.this.mListener.onPageSize(pos, width, height);
            }
        }

        @Override
        public void onPublicMsg(BroadCastMsg msg) {
            if (Player.this.mListener != null) {
                Player.this.mListener.onPublicMsg(msg);
            }
        }

        @Override
        public void onInvite(int type, boolean isOpen) {
            if (Player.this.mListener != null) {
                Player.this.mListener.onInvite(type, isOpen);
            }
        }

        @Override
        public void onMicNotify(int notify) {
            if (Player.this.mListener != null) {
                Player.this.mListener.onMicNotify(notify);
            }
        }

        @Override
        public void onCameraNotify(int notify) {
            if (Player.this.mListener != null) {
                Player.this.mListener.onCameraNotify(notify);
            }
        }

        @Override
        public void onLiveText(String language, String text) {
            if (Player.this.mListener != null) {
                Player.this.mListener.onLiveText(language, text);
            }
        }

        @Override
        public void onRollcall(int timeOut) {
            if (Player.this.mListener != null) {
                Player.this.mListener.onRollcall(timeOut);
            }
        }

        @Override
        public void onLottery(int cmd, String lotteryInfo) {
            if (Player.this.mListener != null) {
                Player.this.mListener.onLottery(cmd, lotteryInfo);
            }
        }

        @Override
        public void onFileShare(int cmd, String fileName, String fileUrl) {
            if (Player.this.mListener != null) {
                Player.this.mListener.onFileShare(cmd, fileName, fileUrl);
            }
        }

        @Override
        public void onFileShareDl(int ret, String fileUrl, String filePath) {
            if (Player.this.mListener != null) {
                Player.this.mListener.onFileShareDl(ret, fileUrl, filePath);
            }
        }

        @Override
        public void onScreenStatus(boolean isAs) {
            if (Player.this.mListener != null) {
                Player.this.mListener.onScreenStatus(isAs);
            }
        }

        @Override
        public void onModuleFocus(int mode) {
            if (Player.this.mListener != null) {
                Player.this.mListener.onModuleFocus(mode);
            }
        }

        @Override
        public void onIdcList(List<PingEntity> idcs) {
        }

        @Override
        public void onThirdVote(String url) {
            if (Player.this.mListener != null) {
                Player.this.mListener.onThirdVote(url);
            }
        }

        @Override
        public void onRedBagTip(RewardResult result) {
            if (result == null) {
                GenseeLog.w((String)Player.TAG, (String)"onRedBagTip result==null");
                return;
            }
            String msgType = result.getMsgType();
            if ("hongbao".equals(msgType)) {
                if (Player.this.redEnvelopes != null && result instanceof RewardResult) {
                    Player.this.redEnvelopes.notify(result);
                } else {
                    GenseeLog.e((String)Player.TAG, (String)"onRedBagTip RedEnvelopes not rigister this Player object! and you can not receive hongbao.");
                }
            } else if (Player.this.mListener != null) {
                Player.this.mListener.onRedBagTip(result);
            }
        }

        @Override
        public void onMedalPraise(String result) {
            this.onObjectMsg(result);
        }

        @Override
        public void onCommonBroadMessage(String result) {
            this.onObjectMsg(result);
        }

        private void onObjectMsg(String result) {
            if (result == null) {
                GenseeLog.w((String)Player.TAG, (String)"onObjectMsg result==null");
                return;
            }
            String extend = "<extendedMessage>";
            if (result.startsWith(extend)) {
                int len = extend.length();
                result = result.substring(len, result.length() - len - 1);
            }
            if (Player.this.extensions != null && Player.this.extensions.size() > 0) {
                for (IBaseExtension extension : Player.this.extensions) {
                    extension.notify(result);
                }
            } else {
                GenseeLog.e((String)Player.TAG, (String)"onObjectMsg extensions not rigister this Player object! and you can not receive medalPraise or voteevent callback.");
            }
        }

        @Override
        public void onGotoPay(PayInfo info) {
        }

        @Override
        public void onRewordEnable(boolean isAliPay, boolean isWx) {
        }

        @Override
        public void onChatcensor(String type, String id) {
            if (Player.this.onChatListener != null) {
                Player.this.onChatListener.onChatcensor(type, id);
            }
        }

        @Override
        public void onGetUserInfo(UserInfo[] info) {
            if (Player.this.mListener != null) {
                Player.this.mListener.onGetUserInfo(info);
            }
        }

        @Override
        public String getAudioCodec() {
            LoginResEntity tmpEntity = Player.this.p;
            return tmpEntity != null ? Player.this.p.getAudioCodec() : "";
        }

        @Override
        public void onLiveInfo(LiveInfo info) {
        }

        @Override
        public void onGetLog(int type, String param) {
            UserInfo self = Player.this.getSelfInfo();
            if (self == null || StringUtil.isEmpty((String)param) || !param.equals(self.getName()) && !param.equals(String.valueOf(self.getId()))) {
                GenseeLog.w((String)Player.TAG, (String)("onGetLog it is not my log param " + param));
                return;
            }
            InitParam tmp = Player.this.initParam;
            Context c = Player.this.mContext;
            if (c != null && tmp != null) {
                GenseeLog.reportDiagonse((Context)c, (String)tmp.getDomain(), (ServiceType)tmp.getServiceType(), (String)("report onPlayerSDK ,by GetLog sdk version = " + GenseeConfig.getSDKVersion()), (boolean)true);
            } else {
                GenseeLog.w((String)Player.TAG, (String)("onGetLog can not send log context = " + c + " p = " + tmp));
            }
        }

        @Override
        public void onHongbaoEnable(boolean enable) {
        }

        @Override
        public boolean isFilterOtherGroupMsg(String subclass, String toGroup) {
            LoginResEntity entity = Player.this.p;
            if (entity != null && entity.isGroupInfoValid() && !StringUtil.isEmpty((String)toGroup) && !toGroup.equals(entity.getGroupCode())) {
                return true;
            }
            return entity != null && !StringUtil.isEmpty((String)subclass) && !subclass.equals(entity.getWebcastId());
        }

        @Override
        public boolean isFilterOtherGroupMsg(UserInfo info) {
            LoginResEntity entity = Player.this.p;
            if (entity != null && entity.isGroupInfoValid()) {
                String groupCode = entity.getGroupCode();
                if (info == null) {
                    return true;
                }
                if (info.isHost() || info.isAssistant() || info.isPresenter()) {
                    return false;
                }
                if (groupCode != null && !groupCode.equals(info.getGroupId())) {
                    return true;
                }
            }
            return false;
        }

        @Override
        public void onDoubleTeacherStatusChange(int status) {
            MsgQueue.getIns().release();
            QaMsgQueue.getIns().release();
            Player.this.getQaCache().clear();
            if (Player.this.onChatListener != null) {
                Player.this.onChatListener.onMute(false);
            }
            Player.this.doubleTeacherStatus = status;
            OnPlayListener l = Player.this.mListener;
            if (l != null) {
                LoginResEntity entity = Player.this.p;
                if (entity != null) {
                    boolean isMasterRoom = status == 1;
                    entity.setRunStatus(isMasterRoom ? 1 : 0);
                    l.onSubject(isMasterRoom ? entity.getMasterSubject() : entity.getWebcastSubject());
                }
                l.onDoubleTeacherStatusChange(status);
            }
        }

        @Override
        public void onAutoSwitchIdcSuccess() {
        }

        @Override
        public void onCdnEnable(String currentCdnName, String[] cdnList) {
        }

        @Override
        public void onPlayerType(OnPlayListener.PlayerType type) {
        }
    };

    public Player() {
        this.mPlayer = new NativePlayer();
    }

    public void setGSVideoView(IVideoIndication videoView) {
        this.mPlayer.setGSVideoView(videoView);
    }

    public void setGSDocView(GSDocView docView) {
        this.mPlayer.setGSDocView(docView);
    }

    public void setGSDocViewGx(GSDocViewGx docViewGx) {
        this.mPlayer.setGSDocViewGx(docViewGx);
    }

    public void setGSChatView(IChatView v) {
        if (v != null) {
            v.setModuleHandle(this);
            this.mChatView = v;
            this.setOnChatListener(v);
        }
    }

    public void setGSVoteView(GSVoteView v) {
        if (v != null) {
            this.setOnVoteListener(v);
            v.setModuleHandle(this);
        }
    }

    public void setGSQaView(IQaView qaView) {
        if (qaView != null) {
            qaView.setModuleHandle(this);
            this.mQaView = qaView;
            this.setOnQaListener(qaView);
        }
    }

    public String getCurIdc() {
        return this.mPlayer.getIdcId();
    }

    public boolean setIdcId(String idcId, OnTaskRet taskRet) {
        this.joinType = 1;
        this.trackPreferredLog(4, 7, "switch idc by user");
        return this.mPlayer.setIdcId(idcId, taskRet);
    }

    private boolean setIdcIdInternal(String idcId, OnTaskRet taskRet) {
        this.joinType = 2;
        this.trackPreferredLog(4, 7, "switch idc by auto");
        return this.mPlayer.setIdcId(idcId, taskRet);
    }

    public void setOnQaListener(OnQaListener qaListener) {
        this.mQaListener = qaListener;
    }

    public void setOnChatListener(OnChatListener onChatListener) {
        this.onChatListener = onChatListener;
        this.notifySitePriChat(onChatListener, this.p);
    }

    private void notifySitePriChat(OnChatListener onChatListener, LoginResEntity p) {
        if (onChatListener != null && p != null) {
            onChatListener.onStuPriChat(p.isSiteSutChatEnable());
        }
    }

    public void testOnCaching() {
        this.nativeCallback.onCaching(true);
        int i = new Random().nextInt(4000);
        this.outputLogText("\u6a21\u62df\u5ef6\u8fdf" + i + "\u8c6a\u79d2");
        new Handler().postDelayed(new Runnable(){

            @Override
            public void run() {
                Player.this.nativeCallback.onCaching(false);
            }
        }, (long)i);
    }

    public void setOnVoteListener(OnVoteListener voteListener) {
        this.voteCallback = voteListener;
    }

    public void join(Context context, InitParam p, OnPlayListener l) {
        if (context == null || p == null) {
            GenseeLog.e((String)TAG, (String)("join context = " + context + " p = " + p));
            return;
        }
        this.mListener = l;
        this.setServerPort(p.getHttpPort(), p.getWebsocketPort());
        this.initWithParam(context, p);
    }

    public void outputLogText(String text) {
        Log.i((String)TAG, (String)("outputLog: " + text));
        if (this.mListener != null) {
            // empty if block
        }
    }

    private void initDB(Context context) {
    }

    protected void initWithParam(final Context context, final InitParam p) {
        if (this.req != null) {
            this.req.setCallback(null);
        }
        final GenseeLog genseeLog = new GenseeLog();
        GenseeLog.setLogEntry((GenseeLog)genseeLog);
        this.req = new RtmpReq(context, new RtmpReq.Callback(){
            private LoginResEntity loginResEntity = null;

            @Override
            public void onResult(LoginResEntity loginResEntity) {
                OnPlayListener l;
                List pingEntities = loginResEntity.getPingArray();
                if (pingEntities != null && pingEntities.size() > 0) {
                    Player.this.idcs = new ArrayList(1);
                    for (PingEntity pe : pingEntities) {
                        if (pe == null || StringUtil.isEmpty((String)pe.getIdcId())) continue;
                        Player.this.idcs.add(pe.getIdcId());
                    }
                }
                if ((l = Player.this.mListener) != null) {
                    l.onIdcList(pingEntities);
                    boolean addr = StringUtil.isEmpty((String)loginResEntity.getPayNotifyUrl());
                    l.onRewordEnable(!addr && loginResEntity.isAliPaySupport(), !addr && loginResEntity.isWxPaySupport());
                    l.onLiveInfo((LiveInfo)loginResEntity);
                    l.onHongbaoEnable(!StringUtil.isEmpty((String)loginResEntity.getRedPacketApi()));
                }
                this.loginResEntity = loginResEntity;
                genseeLog.setWebcastAndUserInfo(loginResEntity.getWebcastId(), loginResEntity.getUserId() + "", loginResEntity.getNickName());
                genseeLog.startUploadTrackLog();
                Player.this.req.requestNetConfig();
            }

            @Override
            public void onPreferredNetworkConfig(String result) {
                if (!StringUtil.isEmpty((String)result)) {
                    try {
                        int i;
                        JSONObject jsonObject = new JSONObject(result);
                        if (jsonObject.has("netSelection")) {
                            JSONArray netSelection = jsonObject.getJSONArray("netSelection");
                            for (i = 0; i < netSelection.length(); ++i) {
                                String param = netSelection.getString(i);
                                String[] splitArr = param.split(":");
                                if (!splitArr[0].equalsIgnoreCase(p.getDomain().split(":")[0])) continue;
                                if (splitArr.length == 1 || splitArr[splitArr.length - 1].equalsIgnoreCase("Preferred")) {
                                    Player.this.autoPreferredNetwork = true;
                                    continue;
                                }
                                if (splitArr[splitArr.length - 1].equalsIgnoreCase("Log")) {
                                    Player.this.uploadPreferredNetworkLog = true;
                                    continue;
                                }
                                if (splitArr[splitArr.length - 1].equalsIgnoreCase("Log&&Preferred")) {
                                    Player.this.autoPreferredNetwork = true;
                                    Player.this.uploadPreferredNetworkLog = true;
                                    continue;
                                }
                                Player.this.autoPreferredNetwork = true;
                            }
                        }
                        Player.this.preferredNetworkConfig = new PreferredNetworkConfig(jsonObject.getInt("waitingNumber"), jsonObject.getInt("waitingTimes"));
                        Player.this.mOverseasIDCList = new ArrayList();
                        if (jsonObject.has("overseasIDCList")) {
                            JSONArray overseasIDCList = jsonObject.getJSONArray("overseasIDCList");
                            for (i = 0; i < overseasIDCList.length(); ++i) {
                                Player.this.mOverseasIDCList.add(overseasIDCList.getString(i));
                            }
                        }
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                        GenseeLog.e((Throwable)e);
                    }
                }
                if (Player.this.preferredNetworkConfig == null) {
                    GenseeLog.w((String)Player.TAG, (String)" preferredNetworkConfig is null use default config ");
                    Player.this.preferredNetworkConfig = new PreferredNetworkConfig(5, 15);
                }
                GenseeLog.trackLog((int)4, (int)1, (String)Player.TAG, (String)("\u670d\u52a1\u7aef\u662f\u5426\u914d\u7f6e\u4e86\u4f18\u9009\u7f51\u7edc\u6a21\u5f0f\uff1a" + Player.this.autoPreferredNetwork));
                GenseeLog.trackLog((int)4, (int)1, (String)Player.TAG, (String)("\u662f\u5426\u4e0a\u4f20\u4f18\u9009\u7f51\u7edc\u65e5\u5fd7\uff1a" + Player.this.uploadPreferredNetworkLog));
                Player.this.outputLogText("\u670d\u52a1\u7aef\u662f\u5426\u914d\u7f6e\u4e86\u4f18\u9009\u7f51\u7edc\u6a21\u5f0f\uff1a" + Player.this.autoPreferredNetwork);
                Player.this.outputLogText("\u662f\u5426\u4e0a\u4f20\u4f18\u9009\u7f51\u7edc\u65e5\u5fd7\uff1a" + Player.this.uploadPreferredNetworkLog);
                if (Player.this.mListener != null) {
                    Player.this.joinRoom(context, this.loginResEntity);
                    Player.this.initParam = p;
                }
            }

            public void onErr(int errCode) {
                if (Player.this.mListener != null) {
                    Player.this.mListener.onErr(errCode);
                }
            }
        });
        this.req.setbAttendeeOnly(true);
        this.req.initWithGensee(p);
    }

    private void trackPreferredLog(int level, int code, String msg) {
        if (this.uploadPreferredNetworkLog) {
            GenseeLog.trackLog((int)level, (int)code, (String)TAG, (String)msg);
        } else {
            GenseeLog.i((String)TAG, (String)msg);
        }
        this.outputLogText(msg);
    }

    public void leave() {
        this.trackPreferredLog(4, 2, "leave");
        GenseeLog.clearLogEntry();
        if (this.req != null) {
            this.req.setCallback(null);
        }
        this.mPlayer.leave(new OnTaskRet(){

            public void onTaskRet(boolean arg0, int arg1, String arg2) {
            }
        });
    }

    public void release() {
        GenseeLog.i((String)TAG, (String)"release");
        GenseeLog.clearLogEntry();
        UserManager.getIns().clear();
        this.mListener = null;
        this.mHandler.removeCallbacksAndMessages(null);
        if (this.mChatView != null) {
            this.mChatView.release();
            this.mChatView = null;
        }
        if (null != this.mQaView) {
            this.mQaView.release();
            this.mQaView = null;
        }
        this.mQaListener = null;
        this.onChatListener = null;
        this.voteCallback = null;
        this.rate = VideoRate.RATE_NORMAL;
        if (this.mQaMap != null) {
            this.mQaMap.clear();
        }
        if (this.selfChatMsgs != null) {
            this.selfChatMsgs.clear();
        }
        this.mPlayer.release(null);
        if (this.mWordFilter != null) {
            this.mWordFilter.release();
        }
        this.doubleTeacherStatus = 0;
        if (this.extensions != null) {
            this.extensions.clear();
        }
        this.mContext = null;
    }

    private int getIntValue(String strValue) {
        try {
            return Integer.valueOf(strValue);
        }
        catch (Exception e) {
            GenseeLog.w((String)e.toString());
            return 0;
        }
    }

    protected void joinRoom(Context context, final LoginResEntity lEntity) {
        if (lEntity == null) {
            this.onJoinRet(-2);
            GenseeLog.w((String)"joinRoom the info is null");
            return;
        }
        Context appCtx = context.getApplicationContext();
        this.p = lEntity;
        this.mContext = appCtx;
        this.doubleTeacherStatus = lEntity.getRunStatus();
        int serviceType = this.getIntValue(lEntity.getServicetype());
        int sampleSize = AVConfig.getSampleRate((Context)context);
        if (this.redEnvelopes != null) {
            this.redEnvelopes.init(lEntity);
        }
        if (null != this.extensions && this.extensions.size() > 0) {
            for (IBaseExtension extension : this.extensions) {
                extension.init(lEntity);
            }
        }
        PlayerEnv.init((boolean)false, (int)serviceType, (int)sampleSize, (Context)context, (OnTaskRet)new OnTaskRet(){

            public void onTaskRet(boolean ret, int arg1, String arg2) {
                if (ret) {
                    if (null != Player.this.mListener) {
                        Player.this.mListener.onSubject(lEntity.getWebcastSubject());
                    }
                    Player.this.notifySitePriChat(Player.this.onChatListener, lEntity);
                    Player.this.joinRoom(lEntity);
                } else {
                    Player.this.onJoinRet(8);
                }
                String word = lEntity.getSensitiveWordUrl();
                if (!StringUtil.isEmpty((String)word)) {
                    if (Player.this.mWordFilter == null) {
                        Player.this.mWordFilter = new SensiviteWordFilter();
                    }
                    Player.this.mWordFilter.init(word);
                }
            }
        });
    }

    @Override
    public UserInfo getSelfInfo() {
        return this.selfInfo;
    }

    @Override
    public void voteSubmit(VotePlayerGroup voteGroup) {
        if (voteGroup == null || null == this.selfInfo) {
            return;
        }
        int ret = 0;
        if (voteGroup.isM_bForce()) {
            if (!voteGroup.haveAllAnswer()) {
                ret = 1;
            }
        } else if (!voteGroup.haveAnswer()) {
            ret = 2;
        }
        if (ret != 0) {
            if (this.voteCallback != null) {
                this.voteCallback.onVoteSubmitRet(ret);
            }
            return;
        }
        if (null != this.mPlayer) {
            if (this.p != null) {
                voteGroup.setSiteId(String.valueOf(this.p.getSiteId()));
                voteGroup.setConfId(this.p.getWebcastId());
            }
            this.mPlayer.voteSubmit(voteGroup, this.selfInfo.getUserId(), this.selfInfo.getName(), null);
        }
    }

    private HashMap<String, Long> getQaCache() {
        if (this.mQaMap == null) {
            this.mQaMap = new HashMap(1);
        }
        return this.mQaMap;
    }

    private Set<String> getSelfChatMsgs() {
        if (this.selfChatMsgs == null) {
            this.selfChatMsgs = new HashSet<String>();
        }
        return this.selfChatMsgs;
    }

    @Override
    public boolean question(String uuid, String question) {
        if (StringUtil.isEmpty((String)uuid) || StringUtil.isEmpty((String)question) || question.length() > 512 || this.selfInfo == null) {
            GenseeLog.w((String)TAG, (String)("uuid = " + uuid + " question = " + question));
            return false;
        }
        HashMap<String, Long> cache = this.getQaCache();
        cache.put(uuid, this.selfInfo.getId());
        return this.mPlayer.question(uuid, question, null);
    }

    @Override
    public boolean sameQuestion(String uuid, OnTaskRet ret) {
        GenseeLog.d((String)TAG, (String)("sameQuestion uuid = " + uuid));
        if (StringUtil.isEmpty((String)uuid)) {
            return false;
        }
        return this.mPlayer.sameQuestion(uuid, ret);
    }

    private boolean chat(String content, String richtext, int receiverId, String msgId, OnTaskRet onTaskRet) {
        String toGroup = "";
        String subclass = "";
        LoginResEntity entity = this.p;
        if (entity != null && entity.isGroupInfoValid()) {
            toGroup = entity.getGroupCode();
        }
        if (1 == this.doubleTeacherStatus) {
            subclass = entity.getWebcastId();
        }
        return this.mPlayer.chat(content, richtext, receiverId, msgId, subclass, toGroup, onTaskRet);
    }

    @Override
    public boolean chatToPersion(ChatMsg msg, OnTaskRet taskRet) {
        if (msg == null || !msg.isPlayerPriValid()) {
            GenseeLog.w((String)TAG, (String)("chatToPersion msg is not valid msg " + msg));
            return false;
        }
        int receiverChatId = msg.getChatId();
        String content = msg.getContent();
        String richtext = msg.getSendRichText();
        String msgId = msg.getId();
        return this.chat(content, richtext, receiverChatId, msgId, taskRet);
    }

    @Override
    public boolean chatToPublic(ChatMsg msg, OnTaskRet taskRet) {
        String content = msg.getContent();
        String richtext = msg.getSendRichText();
        String msgId = msg.getId();
        this.getSelfChatMsgs().add(msgId);
        if (msg == null || !msg.isPubValid()) {
            GenseeLog.w((String)TAG, (String)("chatToPublic msg is not valid msg " + msg));
            return false;
        }
        return this.chat(content, richtext, 0, msgId, taskRet);
    }

    public void audioSet(boolean isClose) {
        this.mPlayer.closeAudio(isClose, null);
    }

    public void videoSet(boolean isClose) {
        this.mPlayer.closeVideo(isClose, null);
    }

    public void setLocalVideoView(ILocalVideoView localVideoView) {
        this.mPlayer.setLocalVideoView(localVideoView);
    }

    public boolean openCamera(Context context, boolean isOpen, OnTaskRet taskRet) {
        return this.mPlayer.openCamera(context, isOpen, taskRet);
    }

    public boolean openMic(Context context, boolean isOpen, OnTaskRet taskRet) {
        return this.mPlayer.openMic(context, isOpen, taskRet);
    }

    public boolean inviteAck(int type, boolean isAccept, OnTaskRet taskRet) {
        return this.mPlayer.handleInvite(type, isAccept, taskRet);
    }

    public boolean rollCallAck(boolean isAccept, OnTaskRet taskRet) {
        return this.mPlayer.handleRollCall(isAccept, taskRet);
    }

    public boolean handUp(boolean isHand, OnTaskRet taskRet) {
        return this.mPlayer.handUp(isHand, taskRet);
    }

    public boolean downloadShareFile(String url, String fileFullPath, OnTaskRet taskRet) {
        return this.mPlayer.dlFileShare(url, fileFullPath, taskRet);
    }

    public boolean switchRate(VideoRate rate, OnTaskRet taskRet) {
        GenseeLog.d((String)TAG, (String)("switchRate rate = " + rate.getValue()));
        if (rate == this.rate) {
            GenseeLog.w((String)TAG, (String)("switchRate rate = old = " + rate.getValue()));
            return false;
        }
        this.rate = rate;
        return this.mPlayer.switchRate(rate.getValue(), taskRet);
    }

    public int onVideoData(byte[] data, VideoParam videoParam) {
        return this.mPlayer.sendVideo(data, videoParam);
    }

    private boolean isDoubleTeacherOrGroup() {
        int scene = this.p.getScene();
        List groups = this.p.getClassGroups();
        return scene == 4 || scene == 3 || groups != null && groups.size() > 0;
    }

    public boolean reward(Reward reward) {
        LoginResEntity entity = this.p;
        if (entity == null || !entity.isAliPaySupport()) {
            GenseeLog.w((String)TAG, (String)"reward alipay is not support,Asking for help from sales!");
            return false;
        }
        return new RewardAction().reward(reward, entity, new StringRes(){

            public void onConnectError(int errorType, String errorInfo) {
                this.pay(null);
            }

            public void onRes(String result) {
                this.pay(PayInfo.build((String)result));
            }

            private void pay(PayInfo info) {
                if (Player.this.mListener != null) {
                    Player.this.mListener.onGotoPay(info);
                }
            }
        });
    }

    public boolean getUserInfoById(long[] userId, OnTaskRet taskRet) {
        return this.mPlayer.getUserInfoById(userId, taskRet);
    }

    public boolean setCdnLine(String newCdn, OnTaskRet taskRet) {
        if (StringUtil.isEmpty((String)newCdn)) {
            GenseeLog.w((String)TAG, (String)"setCdnLine fail\uff0ccdn is empty ");
            return false;
        }
        if (this.mPlayer.currentCdnName.equals(newCdn)) {
            GenseeLog.w((String)TAG, (String)"setCdnLine fail\uff0cnewCdn equals currentCdnName ");
            return false;
        }
        boolean verify = false;
        for (int i = 0; i < this.mPlayer.cdnList.length; ++i) {
            if (!newCdn.equals(this.mPlayer.cdnList[i])) continue;
            verify = true;
            break;
        }
        if (!verify) {
            GenseeLog.e((String)TAG, (String)("setCdnLine fail\uff0ccdnName(" + newCdn + ") is wrong,cdnList is " + Arrays.toString(this.mPlayer.cdnList)));
            return false;
        }
        return this.mPlayer.setCdnLine(newCdn, taskRet);
    }

    public String getCurrentCDNName() {
        return this.mPlayer.currentCdnName;
    }

    public boolean reName(final String newNickName, final OnTaskRet taskRet) {
        if (StringUtil.isEmpty((String)newNickName) || newNickName.length() > 128 || this.selfInfo != null && newNickName.endsWith(this.selfInfo.getName())) {
            GenseeLog.w((String)TAG, (String)("reName fail ,newNickName is " + newNickName));
            return false;
        }
        return this.mPlayer.reName(newNickName, new OnTaskRet(){

            public void onTaskRet(boolean ret, int id, String desc) {
                if (ret) {
                    if (Player.this.p != null) {
                        Player.this.p.setNickName(newNickName);
                    }
                    if (Player.this.selfInfo != null) {
                        Player.this.selfInfo.setName(newNickName);
                    }
                }
                if (taskRet != null) {
                    taskRet.onTaskRet(ret, id, desc);
                }
            }
        });
    }

    @Override
    public String textFilter(String src) {
        SensiviteWordFilter f = this.mWordFilter;
        if (f != null) {
            return f.filter(src);
        }
        return src;
    }

    private void onJoinRet(int result) {
        if (this.mListener != null) {
            this.mListener.onJoin(result);
        }
    }

    private void joinRoom(LoginResEntity lEntity) {
        this.joinRoom(lEntity, GenseeConfig.isForceFlv);
    }

    private void joinRoom(LoginResEntity lEntity, boolean isForceLv) {
        int siteId = (int)lEntity.getSiteId();
        long userId = lEntity.getUserId();
        String subject = lEntity.getWebcastSubject();
        String albAddress = lEntity.getAlbServer();
        int serviceType = this.getIntValue(lEntity.getServicetype());
        String confId = lEntity.getWebcastId();
        String nickName = lEntity.getNickName();
        String ud = lEntity.getUserData();
        String userData = ud == null ? "" : ud;
        String cachDir = FileUtil.getCachDir((Context)this.mContext, (String)"rtmpplayer");
        this.selfInfo = new UserInfo(userId, nickName, 16, -1);
        this.selfInfo.setStrUserData(userData);
        this.selfInfo.setGroupId(lEntity.getGroupCode());
        this.selfInfo.setGroupName(lEntity.getGroupName());
        UserManager.getIns().userJoin(this.selfInfo, userId);
        GenseeLog.d((String)TAG, (String)("join room confId = " + confId + " cachDir = " + cachDir));
        if (isForceLv && !this.isDoubleTeacherOrGroup()) {
            this.outputLogText("\u7528\u6237\u671f\u671b\u76f4\u64ad\u6d41\u4e3a\uff1aHls");
            GenseeLog.i((String)TAG, (String)"The user expect live stream is: HLS.");
        } else {
            isForceLv = false;
            this.outputLogText("\u7528\u6237\u671f\u671b\u76f4\u64ad\u6d41\u4e3a\uff1aRTMP");
            GenseeLog.i((String)TAG, (String)"The user expect live stream is: RTMP.");
        }
        this.mPlayer.join(siteId, userId, nickName, albAddress, serviceType, confId, subject, userData, this.nativeCallback, cachDir, lEntity.isHttpMode(), this.rate.getValue(), lEntity, isForceLv);
    }

    private void joinRoomWithHls(LoginResEntity lEntity) {
        this.joinRoom(lEntity, true);
    }

    public void registerRedEnvelop(IRedEnvelopes redEnvelopes) {
        if (this.p != null) {
            redEnvelopes.init(this.p);
        }
        this.redEnvelopes = redEnvelopes;
    }

    public void registerExtension(IBaseExtension extension) {
        if (extension == null) {
            return;
        }
        if (null != this.p) {
            extension.init(this.p);
        }
        if (this.extensions == null) {
            this.extensions = new ArrayList<IBaseExtension>(2);
        }
        this.extensions.add(extension);
    }

    public void setServerPort(short httpPort, short webSocketPort) {
        this.mPlayer.setServerPort(httpPort, webSocketPort);
    }

    public int getAudioLevel() {
        return this.mPlayer.getAudioLevel();
    }

    public static class PreferredNetworkConfig {
        public int CACHE_TIME = 5;
        public int TIMEOUT = 15;

        PreferredNetworkConfig(int cacheTime, int timeout) {
            this.CACHE_TIME = cacheTime;
            this.TIMEOUT = timeout;
        }
    }
}

