/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.adapter;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import com.gensee.adapter.SelectAvatarInterface;
import com.gensee.chat.gif.SpanResource;
import java.util.Map;

public abstract class AbsGridViewAvatarAdapter
extends BaseAdapter {
    private Object[] resIds;
    public static final int COUNT_PER_PAGER = 18;
    private Map<String, Drawable> browMap;
    private SelectAvatarInterface selectAvatarInterface;

    public AbsGridViewAvatarAdapter(Context context, SelectAvatarInterface selectAvatarInterface, int num, int endSum) {
        this.browMap = SpanResource.getBrowMap((Context)context);
        Object[] res1 = this.browMap.keySet().toArray();
        if (endSum >= 1 && endSum < 18) {
            this.resIds = new Object[endSum];
            int i = num;
            int j = 0;
            while (i < num + endSum) {
                this.resIds[j] = res1[i];
                ++i;
                ++j;
            }
        } else {
            this.resIds = new Object[18];
            int i = num;
            int j = 0;
            while (i < num + 18) {
                this.resIds[j] = res1[i];
                ++i;
                ++j;
            }
        }
        this.selectAvatarInterface = selectAvatarInterface;
    }

    public int getCount() {
        return this.resIds.length;
    }

    public Object getItem(int position) {
        return this.resIds[position];
    }

    public long getItemId(int position) {
        return position;
    }

    protected abstract int getChatGvItemLyId();

    protected abstract AbsGridViewHolder getGridViewHolder(View var1);

    public View getView(int position, View convertView, ViewGroup parent) {
        AbsGridViewHolder viewHolder = null;
        if (null == convertView) {
            LayoutInflater inflater = LayoutInflater.from((Context)parent.getContext());
            convertView = inflater.inflate(this.getChatGvItemLyId(), null);
            viewHolder = this.getGridViewHolder(convertView);
            convertView.setTag((Object)viewHolder);
        } else {
            viewHolder = (AbsGridViewHolder)convertView.getTag();
        }
        viewHolder.init((String)this.getItem(position), this.browMap.get(this.getItem(position)), convertView);
        return convertView;
    }

    protected abstract class AbsGridViewHolder {
        private ImageView ivAvatar;

        protected abstract int getChatExpressionIvId();

        public AbsGridViewHolder(View view) {
            this.ivAvatar = (ImageView)view.findViewById(this.getChatExpressionIvId());
        }

        public void init(final String sAvatar, final Drawable resId, View view) {
            this.ivAvatar.setBackgroundDrawable(resId);
            view.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (null != AbsGridViewAvatarAdapter.this.selectAvatarInterface) {
                        AbsGridViewAvatarAdapter.this.selectAvatarInterface.selectAvatar(sAvatar, resId);
                    }
                }
            });
        }
    }
}

