/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.video;

import com.gensee.routine.UserInfo;
import com.gensee.utils.GenseeLog;
import com.gensee.video.AbsVideoBase;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.HashMap;

public class VideoEventImpl
extends AbsVideoBase {
    private static final String TAG = "VideoEventImpl";

    private Object initDirectBuffCache(long userId, int size) {
        ByteBuffer byteBuffer;
        if (null == this.userVideoDataCache) {
            this.userVideoDataCache = new HashMap();
        }
        if (null == (byteBuffer = (ByteBuffer)this.userVideoDataCache.get(userId))) {
            byteBuffer = ByteBuffer.allocateDirect(size);
            this.userVideoDataCache.put(userId, byteBuffer);
            GenseeLog.d((String)TAG, (String)("allocateDirect buffer size = " + size));
        }
        if (byteBuffer.capacity() >= size) {
            ((Buffer)byteBuffer).limit(size);
        } else {
            byteBuffer = ByteBuffer.allocateDirect(size);
            this.userVideoDataCache.put(userId, byteBuffer);
        }
        ((Buffer)byteBuffer).position(0);
        return byteBuffer;
    }

    @Override
    public void onVideoCameraOpened() {
        GenseeLog.d((String)TAG, (String)"onVideoCameraOpened");
        if (this.mVideoCallback != null) {
            this.mVideoCallback.onVideoCameraOpened();
        }
    }

    @Override
    public void onVideoJoin(UserInfo user) {
        GenseeLog.d((String)TAG, (String)("onVideoJoin user = " + user));
        if (this.mVideoCallback != null) {
            this.mVideoCallback.onVideoJoin(user);
        }
    }

    @Override
    public void onVideoLeave(long userId) {
        GenseeLog.d((String)TAG, (String)("onVideoLeave userId = " + userId));
        if (null != this.userVideoDataCache && this.userVideoDataCache.containsKey(userId)) {
            this.userVideoDataCache.remove(userId);
        }
        if (this.mVideoCallback != null) {
            this.mVideoCallback.onVideoLeave(userId);
        }
    }

    @Override
    protected String onGetLogTag() {
        return TAG;
    }

    @Override
    public void release() {
        super.release();
    }
}

