/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.video;

import android.content.Context;
import android.hardware.Camera;
import com.gensee.callback.IVideoCallBack;
import com.gensee.common.GenseeConfig;
import com.gensee.common.RTSharedPref;
import com.gensee.room.AbsModule;
import com.gensee.routine.IRTEvent;
import com.gensee.routine.UserInfo;
import com.gensee.utils.GenseeLog;
import com.gensee.videoparam.IVideoCoreInterface;
import com.gensee.videoparam.VideoParam;
import com.gensee.view.ILocalVideoView;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public abstract class AbsVideoBase
extends AbsModule
implements IRTEvent.IVideoEvent,
IVideoCoreInterface {
    private static final String TAG = "AbsVideoBase";
    private static final String CAMERA_KEY_BACK = "_Facing back, Orientation ";
    private static final String CAMERA_KEY_FRONT = "_Facing front, Orientation ";
    private static final String CAMERA_KEY_UNKNOW = "_Facing unknow, Orientation ";
    private ILocalVideoView mLocalVideoView;
    protected IVideoCallBack mVideoCallback;
    private long videoHandle = 0L;
    private List<String> cameras = null;
    protected boolean isLodPlaying = false;
    protected long localUserId;
    private long nStartTime;
    protected HashMap<Long, ByteBuffer> userVideoDataCache;
    protected HashMap<Long, byte[]> userByteDataCache;
    private ISinkCropRotationData mSinkCropRotationData;

    @Override
    public void onVideoJoinConfirm(boolean isOk) {
        GenseeLog.d((String)TAG, (String)("onVideoJoinConfirm isOk = " + isOk));
        if (this.mVideoCallback != null) {
            this.mVideoCallback.onVideoJoinConfirm(isOk);
        }
    }

    @Override
    public void onVideoCameraAvailiable(boolean isAvailiable) {
        GenseeLog.d((String)TAG, (String)("onVideoCameraAvailiable isAvailiable = " + isAvailiable));
        if (this.mVideoCallback != null) {
            this.mVideoCallback.onVideoCameraAvailiable(isAvailiable);
        }
    }

    @Override
    public void onVideoCameraClosed() {
        GenseeLog.d((String)TAG, (String)"onVideoCameraClosed");
        if (this.mVideoCallback != null) {
            this.mVideoCallback.onVideoCameraClosed();
        }
    }

    @Override
    public void onVideoDisplay(UserInfo user) {
        GenseeLog.d((String)("onVideoDisplay user = " + user));
        if (this.mVideoCallback != null) {
            this.mVideoCallback.onVideoDisplay(user);
        }
    }

    @Override
    public void onVideoActived(UserInfo user, boolean bActived) {
        GenseeLog.d((String)TAG, (String)("onVideoActived user = " + user + " bActived = " + bActived));
        if (this.mVideoCallback != null) {
            this.mVideoCallback.onVideoActived(user, bActived);
        }
    }

    @Override
    public void onVideoUndisplay(long userId) {
        GenseeLog.d((String)TAG, (String)("onVideoUndisplay userId = " + userId));
        if (this.mVideoCallback != null) {
            this.mVideoCallback.onVideoUndisplay(userId);
        }
    }

    @Override
    public void onVideoSyncDisplay(boolean bAutoSync, long[] users) {
        GenseeLog.d((String)TAG, (String)("onVideoSyncDisplay bAutoSync = " + bAutoSync));
    }

    @Override
    public void onVideoData4Render(long userId, int width, int height, int dwFrameFormat, float fDisplayRatio, byte[] data, int len) {
        if (this.mVideoCallback != null) {
            byte[] bData;
            if (null == this.userVideoDataCache) {
                return;
            }
            ByteBuffer byteBuffer = this.userVideoDataCache.get(userId);
            if (null == byteBuffer) {
                return;
            }
            if (this.isHardDecode(byteBuffer)) {
                bData = new byte[byteBuffer.limit()];
            } else {
                byte[] cache;
                if (null == this.userByteDataCache) {
                    this.userByteDataCache = new HashMap();
                }
                if (null == (cache = this.userByteDataCache.get(userId)) || cache.length != byteBuffer.limit()) {
                    cache = new byte[byteBuffer.limit()];
                    this.userByteDataCache.put(userId, cache);
                }
                bData = cache;
            }
            ((Buffer)byteBuffer).position(0);
            byteBuffer.get(bData, 0, bData.length);
            this.mVideoCallback.onVideoDataRender(userId, width, height, dwFrameFormat, fDisplayRatio, bData);
        }
    }

    private boolean isHardDecode(ByteBuffer byteBuffer) {
        return byteBuffer.limit() < 39424;
    }

    @Override
    public String getDeviceName(int index) {
        GenseeLog.d((String)TAG, (String)("getDeviceName index = " + index));
        Camera.CameraInfo info = new Camera.CameraInfo();
        String devName = null;
        try {
            Camera.getCameraInfo((int)index, (Camera.CameraInfo)info);
            devName = info.facing == 0 ? "Camera_" + index + CAMERA_KEY_BACK + info.orientation : (info.facing == 1 ? "Camera_" + index + CAMERA_KEY_FRONT + info.orientation : "Camera_" + index + CAMERA_KEY_UNKNOW + info.orientation);
        }
        catch (Throwable e) {
            devName = "Camera_" + index + "fail";
            GenseeLog.w((String)TAG, (String)("getDeviceName fail get " + index));
        }
        if (this.cameras == null) {
            this.cameras = new ArrayList<String>();
        }
        if (!this.cameras.contains(devName)) {
            this.cameras.add(devName);
        }
        return devName;
    }

    @Override
    public boolean startCaptureVideo(long sendHandle, String uniq, int width, int height, int fps) {
        GenseeLog.d((String)TAG, (String)("StartCaptureVideo sendHandle " + sendHandle + " uniq = " + uniq + " width = " + width + " height = " + height + " fps = " + fps));
        if (this.cameras == null || this.cameras.size() == 0 || uniq == null || "".equals(uniq)) {
            return false;
        }
        fps = 15;
        this.videoHandle = sendHandle;
        int indexDefault = -1;
        int indexUniq = -1;
        String defCamera = GenseeConfig.isVideoDefaultBackCamera() ? CAMERA_KEY_BACK : CAMERA_KEY_FRONT;
        for (int i = 0; i < this.cameras.size(); ++i) {
            String name = this.cameras.get(i);
            if (name == null || "".equals(name)) continue;
            if (name.contains(defCamera)) {
                indexDefault = i;
                break;
            }
            if (!name.equals(uniq)) continue;
            indexUniq = i;
        }
        VideoParam param = new VideoParam(width, height, fps, indexDefault == -1 ? indexUniq : indexDefault);
        if (this.mLocalVideoView != null) {
            this.mLocalVideoView.open((Object)param, (IVideoCoreInterface)this);
        } else {
            GenseeLog.w((String)TAG, (String)"LocalVideoView is null");
        }
        return true;
    }

    @Override
    public boolean stopCaptureVideo() {
        GenseeLog.d((String)TAG, (String)"stopCaptureVideo");
        this.videoHandle = 0L;
        if (this.mLocalVideoView != null) {
            this.mLocalVideoView.close();
        }
        return true;
    }

    @Override
    public int getNumberOfCameras() {
        GenseeLog.d((String)TAG, (String)"NumberOfCaptureDevices");
        return Camera.getNumberOfCameras();
    }

    public int sendVideoData(byte[] data, VideoParam vp) {
        if (this.videoHandle == 0L) {
            return -1;
        }
        return this.sendData(data, vp);
    }

    private synchronized int sendData(byte[] data, VideoParam vp) {
        if (this.videoHandle != 0L) {
            int ret = this.onVideoData(this.videoHandle, data, vp.width, vp.height, vp.fmt, vp.bitCount, vp.rotate);
            return ret;
        }
        return 0;
    }

    public void sendCropRotationData(byte[] data, int width, int height, int fmt, int rotate) {
        this.onRotationCropData(data, width, height, fmt, rotate);
    }

    public void onSinkCropRotationData(byte[] data, int width, int height, int fmt, int rotate) {
        if (null != this.mSinkCropRotationData) {
            this.mSinkCropRotationData.onSinkCropRotationData(data, width, height, fmt, rotate);
        }
    }

    private native void onRotationCropData(byte[] var1, int var2, int var3, int var4, int var5);

    private native int onVideoData(long var1, byte[] var3, int var4, int var5, int var6, int var7, int var8);

    public void setVideoCallBack(IVideoCallBack back) {
        this.mVideoCallback = back;
    }

    public void setLocalVideoView(ILocalVideoView localVideoView) {
        this.mLocalVideoView = localVideoView;
        if (this.mLocalVideoView != null) {
            this.mLocalVideoView.setVideoCore((IVideoCoreInterface)this);
        }
    }

    @Override
    public void release() {
        super.release();
        this.videoHandle = 0L;
        if (null != this.mLocalVideoView) {
            this.mLocalVideoView.release();
        }
        if (null != this.userVideoDataCache) {
            this.userVideoDataCache.clear();
        }
        if (null != this.userByteDataCache) {
            this.userByteDataCache.clear();
        }
    }

    private boolean isUnCrop() {
        if (this.mLocalVideoView != null) {
            return 10 == this.mLocalVideoView.getOrientation();
        }
        return false;
    }

    private boolean isPortrait9_16() {
        if (this.mLocalVideoView != null) {
            return 11 == this.mLocalVideoView.getOrientation();
        }
        return false;
    }

    private boolean isPortrait16_9() {
        if (this.mLocalVideoView != null) {
            return 13 == this.mLocalVideoView.getOrientation();
        }
        return false;
    }

    private boolean isLandscape16_9() {
        if (this.mLocalVideoView != null) {
            return 12 == this.mLocalVideoView.getOrientation();
        }
        return false;
    }

    public int getVideoParm(String key, int defValue) {
        if ("save.video.fps".equals(key)) {
            return RTSharedPref.getIns().getInt(key, 15);
        }
        boolean isOrietationUnCrop = this.isUnCrop();
        String key1 = key;
        if ("save.video.height".equals(key)) {
            if (isOrietationUnCrop) {
                key1 = "save.video.width";
                defValue = 320;
            } else {
                if (this.isPortrait9_16()) {
                    return RTSharedPref.getIns().getInt("save.video.width", 320);
                }
                if (this.isPortrait16_9()) {
                    int w = RTSharedPref.getIns().getInt("save.video.height", 240);
                    int wMod = (w = 9 * w / 16) % 16;
                    if (wMod != 0) {
                        w += 16 - wMod;
                    }
                    return w;
                }
                if (this.isLandscape16_9()) {
                    int w = RTSharedPref.getIns().getInt("save.video.width", 320);
                    int h = 9 * w / 16;
                    int hMod = h % 16;
                    if (hMod != 0) {
                        h += 16 - hMod;
                    }
                    return h;
                }
                defValue = 240;
            }
        } else if ("save.video.width".equals(key)) {
            if (isOrietationUnCrop) {
                key1 = "save.video.height";
                defValue = 240;
            } else {
                if (this.isPortrait9_16()) {
                    int w = RTSharedPref.getIns().getInt("save.video.width", 320);
                    int wMod = (w = 9 * w / 16) % 16;
                    if (wMod != 0) {
                        w += 16 - wMod;
                    }
                    return w;
                }
                if (this.isPortrait16_9()) {
                    return RTSharedPref.getIns().getInt("save.video.height", 240);
                }
                if (this.isLandscape16_9()) {
                    return RTSharedPref.getIns().getInt("save.video.width", 320);
                }
                defValue = 320;
            }
        }
        return RTSharedPref.getIns().getInt(key1, defValue);
    }

    public void setSinkCropRotationData(ISinkCropRotationData mSinkCropRotationData) {
        this.mSinkCropRotationData = mSinkCropRotationData;
    }

    public void setVideoSize(Context c, int width, int height) {
        RTSharedPref pref = RTSharedPref.initPref((Context)c);
        if (pref != null && width > 0 && height > 0) {
            pref.putInt("save.video.height", height);
            pref.putInt("save.video.width", width);
        }
    }

    public int getCameraId() {
        if (null == RTSharedPref.getIns()) {
            return -1;
        }
        return RTSharedPref.getIns().getInt("KEY_CAMERA_INDEX", -1);
    }

    public void saveCameraId(int cameraId) {
        if (null != RTSharedPref.getIns()) {
            RTSharedPref.getIns().putInt("KEY_CAMERA_INDEX", cameraId);
        } else {
            GenseeLog.w((String)TAG, (String)" saveCameraId RTSharedPref.getIns() is null");
        }
    }

    public void forceKeyFrame() {
        if (this.mLocalVideoView != null) {
            this.mLocalVideoView.forceKeyFrame();
        }
    }

    public void cleanData() {
        GenseeLog.d((String)TAG, (String)"cleanData");
        this.videoHandle = 0L;
    }

    public static interface ISinkCropRotationData {
        public void onSinkCropRotationData(byte[] var1, int var2, int var3, int var4, int var5);
    }
}

