/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.routine;

import com.gensee.callback.IChatCallBack;
import com.gensee.entity.ChatMsg;
import com.gensee.entity.LoginResEntity;
import com.gensee.room.AbsModule;
import com.gensee.room.RTRoom;
import com.gensee.routine.IRTEvent;
import com.gensee.routine.UserInfo;
import com.gensee.taskret.OnTaskRet;
import com.gensee.user.UserManager;
import com.gensee.utils.GenseeLog;
import com.gensee.utils.StringUtil;

public class ChatEventImpl
extends AbsModule
implements IRTEvent.IChatEvent {
    private static final String TAG = ChatEventImpl.class.getSimpleName();
    private IChatCallBack chatCallBack;

    public void setChatCallBack(IChatCallBack chatCallBack) {
        this.chatCallBack = chatCallBack;
    }

    @Override
    public void OnChatJoinConfirm(final boolean bRet) {
        GenseeLog.d((String)TAG, (String)("OnChatJoinConfirm " + bRet));
        if (null != this.chatCallBack) {
            this.postPool(new Runnable(){

                @Override
                public void run() {
                    ChatEventImpl.this.chatCallBack.onChatJoinConfirm(bRet);
                }
            });
        }
    }

    @Override
    public void onChatMessage(final long userId, final int role, final String userName, final int msgType, final String msg, final String rich, final String msgId, final String str2SubClass, final String str2Group, final String contentType) {
        if (this.chatCallBack != null) {
            this.postPool(new Runnable(){

                @Override
                public void run() {
                    UserInfo mUserInfo;
                    GenseeLog.d((String)TAG, (String)("onChatMessage() called with: userId = " + userId + " userName = " + userName + " msgType = " + msgType + " msg = " + msg + " rich = " + rich + " str2SubClass = " + str2SubClass + " str2Group = " + str2Group));
                    int tmpRole = role;
                    if (tmpRole == 0 && (mUserInfo = UserManager.getIns().getUserByUserId(userId)) != null) {
                        tmpRole = mUserInfo.getRole();
                    }
                    if (msgType == 0 && ChatEventImpl.this.isFilterOtherGroupMsg(str2SubClass, str2Group)) {
                        GenseeLog.d((String)TAG, (String)("filter chat msg str2SubClass = " + str2SubClass + " str2Group = " + str2Group));
                        return;
                    }
                    ChatMsg chatMsg = new ChatMsg();
                    chatMsg.setChatMsgType(msgType);
                    chatMsg.setContent(msg);
                    chatMsg.receiveRichText(rich);
                    chatMsg.setId(msgId);
                    chatMsg.setSender(userName);
                    chatMsg.setSenderId(userId);
                    chatMsg.setSenderRole(tmpRole);
                    chatMsg.setTimeStamp(System.currentTimeMillis());
                    chatMsg.setContentType(contentType);
                    chatMsg.setGroupId(str2Group);
                    chatMsg.setSubClassId(str2SubClass);
                    ChatEventImpl.this.chatCallBack.onChatMessage(chatMsg);
                }
            });
        }
    }

    public boolean isFilterOtherGroupMsg(String subclass, String toGroup) {
        LoginResEntity entity = RTRoom.getIns().getEntity();
        if (entity != null && entity.isGroupInfoValid() && !StringUtil.isEmpty((String)toGroup) && !toGroup.equals(entity.getGroupCode())) {
            return true;
        }
        return entity != null && !StringUtil.isEmpty((String)subclass) && !subclass.equals(entity.getWebcastId());
    }

    public void OnChatWithPersion(UserInfo userInfo, String msg, String rich) {
        GenseeLog.d((String)TAG, (String)("OnChatWithPersion " + userInfo.getName() + " : msg = " + msg + " rich = " + rich));
    }

    public void OnChatWithPanelist(UserInfo userInfo, String msg, String rich) {
        GenseeLog.d((String)TAG, (String)("OnChatWithPanelist " + userInfo.getName() + " : " + msg));
    }

    public void OnChatWithPublic(UserInfo userInfo, String msg, String rich) {
        GenseeLog.d((String)TAG, (String)("OnChatWithPublic " + userInfo.getName() + " : msg = " + msg + "  rich :" + rich));
    }

    @Override
    public void OnChatMyselfEnable(final boolean enable) {
        GenseeLog.d((String)TAG, (String)("OnChatEnable " + enable));
        if (null != this.chatCallBack) {
            this.postPool(new Runnable(){

                @Override
                public void run() {
                    ChatEventImpl.this.chatCallBack.onChatEnable(enable);
                }
            });
        }
    }

    @Override
    public void OnChatEmotionIconUpdate(String iconUrl) {
        GenseeLog.d((String)TAG, (String)("OnChatEmotionIconUpdate iconUrl = " + iconUrl));
    }

    @Override
    protected String onGetLogTag() {
        return TAG;
    }

    public boolean chatWithPublic(ChatMsg msg, OnTaskRet taskRet) {
        if (msg == null || !msg.isPubValid()) {
            GenseeLog.w((String)TAG, (String)("chatWithPublic err msg = " + msg));
            return false;
        }
        String toGroup = "";
        String subclass = "";
        LoginResEntity entity = RTRoom.getIns().getEntity();
        if (entity != null && entity.isGroupInfoValid()) {
            toGroup = entity.getGroupCode();
        }
        if (1 == entity.getRunStatus()) {
            subclass = entity.getWebcastId();
        }
        String sendRichText = msg.getSendRichText();
        GenseeLog.d((String)TAG, (String)("chatWithPublic() called with: msg = [" + sendRichText + "] subclass = " + subclass + " toGroup = " + toGroup));
        return this.getRoutine().chatWithPublic(msg.getContent(), sendRichText, msg.getId(), subclass, toGroup, msg.getContentType(), taskRet);
    }

    public boolean chatWithPanelist(ChatMsg msg, OnTaskRet taskRet) {
        if (msg == null || !msg.isPubValid()) {
            GenseeLog.w((String)TAG, (String)("chatWithPanelist err msg = " + msg));
            return false;
        }
        return this.getRoutine().chatWithPanelist(msg.getContent(), msg.getSendRichText(), msg.getId(), msg.getContentType(), taskRet);
    }

    public boolean chatWithPersion(ChatMsg msg, OnTaskRet taskRet) {
        if (msg == null || !msg.isPriValid()) {
            GenseeLog.w((String)TAG, (String)("chatWithPublic err msg = " + msg));
            return false;
        }
        return this.getRoutine().chatWithPersion(msg.getContent(), msg.getSendRichText(), msg.getReceiverId(), msg.getId(), msg.getContentType(), taskRet);
    }

    @Override
    public void onChatCensor(final long userId, final String msgId) {
        this.postPool(new Runnable(){

            @Override
            public void run() {
                if (null != ChatEventImpl.this.chatCallBack) {
                    ChatEventImpl.this.chatCallBack.onChatCensor(userId, msgId);
                }
            }
        });
    }
}

