/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.room;

import com.gensee.callback.IAsCallBack;
import com.gensee.callback.IAudioCallBack;
import com.gensee.callback.ILodCallBack;
import com.gensee.callback.IRoomCallBack;
import com.gensee.callback.IVideoCallBack;
import com.gensee.common.ServiceType;
import com.gensee.entity.LiveInfo;
import com.gensee.entity.LoginResEntity;
import com.gensee.media.IVideoIndication;
import com.gensee.pdu.GSDocView;
import com.gensee.room.RtSdk;
import com.gensee.routine.GSCountDownInfo;
import com.gensee.routine.GSResponderInfo;
import com.gensee.routine.LayoutInfo;
import com.gensee.routine.LiveodItem;
import com.gensee.routine.State;
import com.gensee.routine.UserInfo;
import com.gensee.taskret.OnTaskRet;
import com.gensee.utils.GenseeLog;
import com.gensee.view.GSDocViewGx;
import java.util.Map;

public abstract class RtSimpleImpl
implements IRoomCallBack,
IVideoCallBack,
ILodCallBack,
IAsCallBack,
IAudioCallBack {
    private RtSdk mRtSdk = new RtSdk();
    private IVideoIndication mVideoView;
    private long activeId = 0L;
    private boolean isLodPlaying = false;
    private boolean isAsPlaying = false;
    private boolean isNeedVideo = true;
    private boolean isRefreshVideo = true;

    public void setVideoView(IVideoIndication videoView) {
        this.mVideoView = videoView;
    }

    public void setDocView(GSDocView docView) {
        this.mRtSdk.setDocView(docView);
    }

    public void setGSDocViewGx(GSDocViewGx docView) {
        this.mRtSdk.setGSDocViewGx(docView);
    }

    public boolean isRefreshVideo() {
        return this.isRefreshVideo;
    }

    public void setRefreshVideo(boolean isRefreshVideo) {
        this.isRefreshVideo = isRefreshVideo;
    }

    public void displayVideo() {
        this.isNeedVideo = true;
        if (this.isAsPlaying) {
            return;
        }
        if (this.isLodPlaying) {
            this.displayVideo(0x7F00000000000000L);
            return;
        }
        if (this.activeId > 0L) {
            this.displayVideo(this.activeId);
        }
    }

    public void unDisplayVideo() {
        this.isNeedVideo = false;
        if (this.isAsPlaying) {
            this.onVideoUndisplay(-1L);
            return;
        }
        if (this.isLodPlaying) {
            this.unDisplayVideo(0x7F00000000000000L);
            return;
        }
        if (this.activeId > 0L) {
            this.unDisplayVideo(this.activeId);
        }
    }

    public long getVideoActiveId() {
        return this.activeId;
    }

    public RtSdk getRtSdk() {
        return this.mRtSdk;
    }

    public void joinWithParam(String logFileName, String param) {
        this.mRtSdk.initWithParam(logFileName, param, this);
    }

    public void joinWithLaunchCode(String logFileName, String launchCode) {
        this.mRtSdk.initWithLaunchCode(logFileName, launchCode, this);
    }

    public void joinWithWebApi(LoginResEntity entity) {
        this.mRtSdk.initWithWebApi(entity, this);
    }

    public void leave(boolean isClose) {
        this.isAsPlaying = false;
        this.isLodPlaying = false;
        this.activeId = 0L;
        this.isNeedVideo = true;
        this.mRtSdk.leave(isClose, new OnTaskRet(){

            public void onTaskRet(boolean ret, int id, String desc) {
                if (1 == id && !ret) {
                    RtSimpleImpl.this.onRoomLeave(0);
                }
            }
        });
    }

    @Override
    public void onAsJoinConfirm(boolean ok) {
    }

    @Override
    public void onAsBegin(long owner) {
        this.isAsPlaying = true;
        if (this.activeId == 0L) {
            this.onVideoStart();
        } else {
            this.unDisplayVideo(this.activeId);
        }
    }

    @Override
    public void onAsEnd() {
        if (this.activeId == 0L) {
            this.onVideoEnd();
        } else {
            this.displayVideo(this.activeId);
        }
        this.isAsPlaying = false;
    }

    @Override
    public void onDsBegin(long owner) {
    }

    @Override
    public void onDsEnd() {
    }

    @Override
    public void onAsData(byte[] data, int width, int height) {
        if (this.isNeedVideo && this.isRefreshVideo && this.isAsPlaying) {
            this.renderVideo(0L, width, height, 0, 0.0f, data);
        }
    }

    @Override
    public void onLodFailed(String id) {
    }

    @Override
    public void onLodStart(LiveodItem liveodItem) {
    }

    @Override
    public void onLodSkip(LiveodItem liveodItem) {
    }

    @Override
    public void onLodPause(LiveodItem liveodItem) {
    }

    @Override
    public void onLodStop(LiveodItem liveodItem) {
    }

    @Override
    public void onLodPlaying(LiveodItem liveodItem) {
    }

    @Override
    public void onLodAdd(LiveodItem liveodItem) {
    }

    @Override
    public void onLodRemove(String id) {
    }

    @Override
    public void onVideoJoinConfirm(boolean ok) {
    }

    @Override
    public void onVideoCameraAvailiable(boolean ok) {
    }

    @Override
    public void onVideoCameraOpened() {
    }

    @Override
    public void onVideoCameraClosed() {
    }

    @Override
    public void onVideoJoin(UserInfo user) {
        long userId;
        if (user != null && 0x7F00000000000000L == (userId = user.getId())) {
            if (!this.isLodPlaying) {
                this.isLodPlaying = true;
            }
            if (this.activeId > 0L) {
                this.unDisplayVideo(this.activeId);
            } else {
                this.onVideoStart();
            }
            this.displayVideo(userId);
        }
    }

    @Override
    public void onVideoLeave(long userId) {
        if (0x7F00000000000000L == userId) {
            this.unDisplayVideo(userId);
            this.isLodPlaying = false;
            if (this.activeId > 0L) {
                this.displayVideo(this.activeId);
            } else {
                this.onVideoEnd();
            }
        } else {
            this.videoUnActived(userId);
        }
    }

    @Override
    public void onVideoActived(UserInfo user, boolean bActived) {
        if (user != null) {
            long userId = user.getId();
            if (bActived) {
                if (this.activeId != 0L && this.activeId != userId) {
                    this.unDisplayVideo(this.activeId);
                }
                long preAcitveId = this.activeId;
                this.activeId = userId;
                this.displayVideo(this.activeId);
                if (!this.isLodPlaying && !this.isAsPlaying && preAcitveId == 0L) {
                    this.onVideoStart();
                }
            } else {
                this.videoUnActived(userId);
            }
        }
    }

    private void videoUnActived(long userId) {
        if (this.activeId > 0L && userId == this.activeId) {
            this.activeId = 0L;
            if (!this.isLodPlaying && !this.isAsPlaying) {
                this.onVideoEnd();
            }
            this.unDisplayVideo(userId);
        }
    }

    @Override
    public void onVideoDisplay(UserInfo user) {
    }

    @Override
    public void onVideoUndisplay(long userId) {
    }

    @Override
    public void onVideoDataRender(long userId, int width, int height, int frameFormat, float displayRatio, byte[] data) {
        if (this.isAsPlaying || !this.isNeedVideo) {
            return;
        }
        if (this.isLodPlaying) {
            if (0x7F00000000000000L == userId && this.isRefreshVideo) {
                this.renderVideo(userId, width, height, frameFormat, displayRatio, data);
            }
        } else if (this.activeId == userId && this.isRefreshVideo) {
            this.renderVideo(userId, width, height, frameFormat, displayRatio, data);
        }
    }

    protected void renderVideo(long userId, int width, int height, int frameFormat, float displayRatio, byte[] data) {
        if (this.mVideoView != null) {
            this.mVideoView.onReceiveFrame(data, width, height);
        }
    }

    @Override
    public void onInit(boolean result) {
        if (result) {
            this.mRtSdk.setAudioCallback(this);
            this.mRtSdk.setAsCallBack(this);
            this.mRtSdk.setVideoCallBack(this);
            this.mRtSdk.setLodCallBack(this);
            this.mRtSdk.join(new OnTaskRet(){

                public void onTaskRet(boolean ret, int id, String desc) {
                    GenseeLog.d((String)("onInit join ret = " + ret));
                }
            });
        } else {
            this.onRoomJoin(RtSdk.loadLibrarys() ? -1 : -2, null, false);
        }
    }

    @Override
    public void onRoomJoin(int result, UserInfo self, boolean svrFailover) {
    }

    @Override
    public void onRoomLeave(final int reason) {
        this.mRtSdk.release(new OnTaskRet(){

            public void onTaskRet(boolean ret, int id, String desc) {
                RtSimpleImpl.this.onRelease(reason);
                RtSimpleImpl.this.mVideoView = null;
                RtSimpleImpl.this.isAsPlaying = false;
                RtSimpleImpl.this.isLodPlaying = false;
                RtSimpleImpl.this.activeId = 0L;
            }
        });
    }

    protected void onRelease(int reason) {
    }

    @Override
    public void onRoomReconnecting() {
        this.isAsPlaying = false;
        this.isLodPlaying = false;
        this.activeId = 0L;
    }

    @Override
    public void onRoomLock(boolean locked) {
    }

    @Override
    public void onRoomUserJoin(UserInfo userInfo) {
    }

    @Override
    public void onRoomUserUpdate(UserInfo userInfo) {
    }

    @Override
    public void onRoomUserLeave(UserInfo userInfo) {
    }

    @Override
    public void onRoomPublish(State s) {
    }

    @Override
    public void onRoomRecord(State s) {
    }

    @Override
    public void onRoomData(String key, long value) {
    }

    @Override
    public void onChatMode(int nChatMode) {
    }

    @Override
    public void onFreeMode(boolean isFreeMode) {
    }

    @Override
    public void onRoomBroadcastMsg(String msg) {
    }

    @Override
    public void onRoomRollcall(int timeout) {
    }

    @Override
    public void onRoomRollcallAck(long userId) {
    }

    @Override
    public void onRoomHandup(long userId, String data) {
    }

    @Override
    public void onRoomHanddown(long userId) {
    }

    @Override
    public void OnUpgradeNotify(String downloadUrl) {
    }

    @Override
    public void onAudioSpeakerOpened() {
    }

    @Override
    public void onAudioSpeakerClosed() {
    }

    @Override
    public void onAudioMicOpened() {
    }

    @Override
    public void onAudioMicClosed() {
    }

    @Override
    public void onAudioLevel(int level, long userId) {
    }

    @Override
    public void onAudioJoinConfirm(boolean ok) {
    }

    @Override
    public void onAudioMicAvailable(boolean isAvailable) {
    }

    protected boolean displayVideo(long userId) {
        if (this.mRtSdk != null && this.isNeedVideo) {
            return this.mRtSdk.displayVideo(userId, new OnTaskRet(){

                public void onTaskRet(boolean ret, int id, String desc) {
                }
            });
        }
        return false;
    }

    protected boolean unDisplayVideo(long userId) {
        if (this.mRtSdk != null) {
            return this.mRtSdk.unDisplayVideo(userId, new OnTaskRet(){

                public void onTaskRet(boolean ret, int id, String desc) {
                }
            });
        }
        return false;
    }

    protected abstract void onVideoStart();

    protected abstract void onVideoEnd();

    public boolean haveVideo() {
        return this.activeId > 0L || this.isAsPlaying || this.isLodPlaying;
    }

    public boolean isAsPlaying() {
        return this.isAsPlaying;
    }

    public boolean isLodPlaying() {
        return this.isLodPlaying;
    }

    @Override
    public ServiceType getServiceType() {
        return null;
    }

    @Override
    public void onLottery(byte type, String sUserlist) {
    }

    @Override
    public int onSettingQuery(String key, int val) {
        return 0;
    }

    @Override
    public String onSettingQuery(String key) {
        return null;
    }

    @Override
    public void onSettingSet(String key, String val) {
    }

    @Override
    public void onSettingSet(String key, int val) {
    }

    @Override
    public void onNetworkReport(byte level) {
    }

    @Override
    public void onNetworkBandwidth(int bpsSend, int bpsRecv) {
    }

    @Override
    public void onRoomPhoneServiceStatus(boolean bAvailable) {
    }

    @Override
    public void onRoomPhoneCallingStatus(String phoneNumber, int reason, int status) {
    }

    @Override
    public void onLiveInfo(LiveInfo info) {
    }

    @Override
    public void onRoomWebLayoutChange(int webLayout) {
    }

    @Override
    public void onLessonTimerPaused(boolean isPaused) {
    }

    @Override
    public void onLessonTimerStart(long dwTime) {
    }

    @Override
    public void onRoomData(String key, String value) {
    }

    @Override
    public void onRandomSelect(byte type, String sUserlist) {
    }

    @Override
    public void onRoomClassAlarm(int time) {
    }

    @Override
    public void onRoomBroadcastCmd(Map map) {
    }

    @Override
    public void onLayoutSync(LayoutInfo info) {
    }

    @Override
    public void onRoomCountDown(GSCountDownInfo countDownInfo) {
    }

    @Override
    public void onRoomPresentorChanged(long userId) {
    }

    @Override
    public void onRoomResponsderInfo(GSResponderInfo responderInfo) {
    }

    @Override
    public void onRoomNavigate(String url) {
    }

    @Override
    public void onRoomClassReuninCmd() {
    }

    @Override
    public void onRoomClassSeparateCmd() {
    }

    @Override
    public void onRoomSubClassUserNum(int nUsers) {
    }

    @Override
    public void onRoomDBTDataPrepared() {
    }
}

