/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.net;

import android.content.Context;
import com.gensee.common.GenseeConfig;
import com.gensee.entity.LoginResEntity;
import com.gensee.entity.MainIdc;
import com.gensee.entity.PingEntity;
import com.gensee.net.AbsRoomSite;
import com.gensee.net.AbsRtAction;
import com.gensee.utils.GenseeLog;
import com.gensee.utils.StringUtil;
import com.gensee.utils.upload.LogProperty;
import java.util.List;

public class RtComp
extends AbsRoomSite {
    private Callback mCallback;

    public RtComp(Context context, Callback callback) {
        super(context);
        this.mCallback = callback;
    }

    public void setCallback(Callback callback) {
        this.mCallback = callback;
    }

    protected void onErr(int errCode) {
        if (this.mCallback != null) {
            this.mCallback.onErr(errCode);
        }
    }

    protected void onLoginEnd(LoginResEntity loginResEntity) {
        LogProperty.getIns().setDefDesc("RtSDK" + GenseeConfig.getSDKVersion());
        GenseeLog.d((String)"AbsHttpAction", (String)"onLoginEnd");
        if (this.mCallback != null) {
            String ini = this.converToIni(loginResEntity);
            if ("".equals(ini)) {
                this.mCallback.onErr(-106);
            } else {
                this.mCallback.onInited(ini);
            }
        }
    }

    private String converToIni(LoginResEntity resEntity) {
        String classType;
        StringBuilder sb = new StringBuilder();
        String albBak = resEntity.getAlbBakServer();
        String confId = resEntity.getWebcastId();
        MainIdc mainIdc = resEntity.getMainIdc();
        String userData = resEntity.getUserData();
        userData = userData == null ? "" : userData;
        String uploadCtrlServerUrl = resEntity.getUploadCtrlServerUrl();
        sb.append("ALBAddress=").append(resEntity.getAlbServer()).append('\n').append("ALBAddress2=").append(StringUtil.isEmpty((String)albBak) ? "" : albBak).append('\n').append("IPBelong=" + resEntity.getIpowner()).append('\n').append("ConfID=").append(StringUtil.isEmpty((String)confId) ? "" : confId).append('\n').append("ServiceType=" + resEntity.getServicetype()).append('\n').append("GlobalUserID=" + resEntity.getUserId()).append('\n').append("OwnerSiteID=" + resEntity.getSiteId()).append('\n').append("UserName=" + resEntity.getNickName()).append('\n').append("UserRole=" + resEntity.getRole()).append('\n').append("UserPri=0").append('\n').append("webApiUrl=" + resEntity.getWebUrl() + "?sc=" + resEntity.getServicetype() + "&upgrade=true\n").append("needPing=" + (this.isTrue(resEntity.getIsNeedVisitALB()) ? 1 : 0)).append('\n').append("idcId=" + mainIdc.getId()).append('\n').append("IDCId_Top=" + mainIdc.getCode()).append('\n').append("UserInfo=" + userData).append('\n').append("eventUrl=" + resEntity.getWebUrl()).append('\n').append("InvisibleUser=").append('\n').append("IsBranding=").append('\n').append("runStatus=" + resEntity.getRunStatus()).append('\n').append("UploadCtrlServerUrl=").append(uploadCtrlServerUrl == null ? "" : uploadCtrlServerUrl).append('\n');
        String diagnoseUploadUrl = mainIdc.getDiagnoseUploadUrl();
        if (diagnoseUploadUrl != null) {
            sb.append("DiagnoseUploadUrl=").append(diagnoseUploadUrl).append('\n');
        }
        if ((classType = "0".equals(classType = resEntity.getServicetype()) ? "CastLine" : "TrainLine") != null) {
            sb.append("ClassType=").append(classType).append('\n');
        }
        sb.append("[IDC]");
        sb.append('\n');
        List idcs = resEntity.getPingArray();
        if (idcs != null) {
            String priorNetwork = resEntity.getChoosePriorNetwork();
            int size = idcs.size();
            sb.append("pingRequired=" + ("true".equals(mainIdc.getPingRequired()) ? "1" : "0"));
            sb.append('\n');
            sb.append("count=" + size);
            sb.append('\n');
            sb.append("pingThreshold=" + mainIdc.getPingThreshold());
            sb.append('\n');
            PingEntity idc = null;
            for (int i = 0; i < size; ++i) {
                idc = (PingEntity)idcs.get(i);
                if (idc == null) continue;
                String pingUrl = idc.getPingUrl();
                String code = idc.getCode();
                String supported = idc.getSupported();
                String description = idc.getDescription();
                sb.append("url").append(i + 1).append("=").append(pingUrl == null || this.isTrue(priorNetwork) ? "" : pingUrl).append("\n").append("id").append(i + 1).append("=").append(code == null ? "" : code).append("\n").append("type").append(i + 1).append("=").append(supported == null ? Integer.valueOf(3) : supported).append("\n").append("name").append(i + 1).append("=").append(description).append("\n");
            }
        }
        return sb.toString();
    }

    private boolean isTrue(String isNeedPing) {
        if (!StringUtil.isEmpty((String)isNeedPing)) {
            return Boolean.valueOf(isNeedPing.toLowerCase());
        }
        return false;
    }

    public static interface Callback
    extends AbsRtAction.ErrCode {
        public void onInited(String var1);
    }
}

