/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.hongbao;

import com.gensee.callback.IHongbaoCallBack;
import com.gensee.callback.ITipInfoCallBack;
import com.gensee.common.GenseeConfig;
import com.gensee.entity.LoginResEntity;
import com.gensee.entity.PayInfo;
import com.gensee.entity.Reward;
import com.gensee.entity.RewardResult;
import com.gensee.hongbao.GrabInfo;
import com.gensee.hongbao.HongbaoInfo;
import com.gensee.hongbao.TipInfo;
import com.gensee.hongbao.UserGrabInfo;
import com.gensee.net.RewardAction;
import com.gensee.net.StringRes;
import com.gensee.routine.IRTEvent;
import com.gensee.utils.GenseeLog;
import java.util.Arrays;

public class HongbaoEventImpl
implements IRTEvent.IHongbaoEvent,
IRTEvent.ITipInfoEvent {
    private static final String TAG = "HongbaoEventImpl";
    private IHongbaoCallBack mHongbaoCallBack;
    private ITipInfoCallBack mTipInfoCallBack;

    public void setHongbaoCallBack(IHongbaoCallBack mHongbaoCallBack) {
        this.mHongbaoCallBack = mHongbaoCallBack;
    }

    @Override
    public void onHongbaoCreate(int result, String id) {
        GenseeLog.d((String)("onHongbaoCreate result = " + result + " id = " + id));
        if (null != this.mHongbaoCallBack) {
            this.mHongbaoCallBack.onHongbaoCreate(result, id);
        }
    }

    @Override
    public void onHongbaoGrabHongbao(int result, String id, int money) {
        GenseeLog.d((String)("onHongbaoGrabHongbao result = " + result + " id = " + id + " money = " + money));
        if (null != this.mHongbaoCallBack) {
            this.mHongbaoCallBack.onHongbaoGrabHongbao(result, id, money);
        }
    }

    @Override
    public void onHongbaoQueryHongbaoList(HongbaoInfo[] infos) {
        GenseeLog.d((String)("onHongbaoQueryHongbaoList infos = " + Arrays.asList(infos)));
        if (null != this.mHongbaoCallBack) {
            this.mHongbaoCallBack.onHongbaoQueryHongbaoList(infos);
        }
    }

    @Override
    public void onHongbaoQueryHongbaoGrabList(String id, GrabInfo[] grabs) {
        GenseeLog.d((String)("onHongbaoQueryHongbaoGrabList id = " + id + " infos = " + Arrays.asList(grabs)));
        if (null != this.mHongbaoCallBack) {
            this.mHongbaoCallBack.onHongbaoQueryHongbaoGrabList(id, grabs);
        }
    }

    @Override
    public void onHongbaoQuerySelfGrabList(UserGrabInfo[] grabs) {
        GenseeLog.d((String)("onHongbaoQuerySelfGrabList grabs = " + Arrays.asList(grabs)));
        if (null != this.mHongbaoCallBack) {
            this.mHongbaoCallBack.onHongbaoQuerySelfGrabList(grabs);
        }
    }

    @Override
    public void onHongbaoQueryBalance(boolean ok, int balance) {
        GenseeLog.d((String)("onHongbaoQueryBalance ok = " + ok + " balance = " + balance));
        if (null != this.mHongbaoCallBack) {
            this.mHongbaoCallBack.onHongbaoQueryBalance(ok, balance);
        }
    }

    @Override
    public void onHongbaoComingNotify(HongbaoInfo bhInfo) {
        GenseeLog.d((String)("onHongbaoComingNotify bhInfo = " + bhInfo.toString()));
        if (null != this.mHongbaoCallBack) {
            this.mHongbaoCallBack.onHongbaoComingNotify(bhInfo);
        }
    }

    @Override
    public void onHongbaoGrabbedNotify(String id, GrabInfo grabInfo, int hongbaoType) {
        GenseeLog.d((String)("onHongbaoGrabbedNotify id = " + id + " grabInfo = " + grabInfo.toString() + " hongbaoType = " + hongbaoType));
        if (null != this.mHongbaoCallBack) {
            this.mHongbaoCallBack.onHongbaoGrabbedNotify(id, grabInfo, hongbaoType);
        }
    }

    public void setOnTipInfoCallBack(ITipInfoCallBack mTipInfoCallback) {
        this.mTipInfoCallBack = mTipInfoCallback;
    }

    @Override
    public void onTipQueryTotalAmount(int result, int dwAmount) {
        GenseeLog.d((String)TAG, (String)"onTipQueryTotalAmount");
        if (null != this.mTipInfoCallBack) {
            this.mTipInfoCallBack.onTipQueryTotalAmount(result, dwAmount);
        }
    }

    @Override
    public void onTipQueryTopList(int result, TipInfo[] tips) {
        GenseeLog.d((String)TAG, (String)("onTipQueryTopList result = " + result + " tips = " + (tips == null ? 0 : tips.length)));
        if (null != this.mTipInfoCallBack) {
            this.mTipInfoCallBack.onTipQueryTopList(result, tips);
        }
    }

    public void onTipComingNotify(TipInfo tip, int totalAmount) {
    }

    @Override
    public void onTipNotify(RewardResult tip, int totalAmount) {
        GenseeLog.d((String)TAG, (String)("onTipResult tip = " + tip + " totalAmount = " + totalAmount));
        if (null != this.mTipInfoCallBack) {
            this.mTipInfoCallBack.onTipNotify(tip, totalAmount);
        }
    }

    public boolean reward(Reward reward) {
        LoginResEntity entity = GenseeConfig.getIns().getLoginResEntity();
        if (entity != null && !entity.isAliPaySupport()) {
            GenseeLog.w((String)TAG, (String)"reward alipay is not support,Asking for help from sales!");
            return false;
        }
        return new RewardAction().reward(reward, entity, new StringRes(){

            public void onConnectError(int errorType, String errorInfo) {
                this.pay(null);
            }

            public void onRes(String result) {
                this.pay(PayInfo.build((String)result));
            }

            private void pay(PayInfo info) {
                if (HongbaoEventImpl.this.mTipInfoCallBack != null) {
                    HongbaoEventImpl.this.mTipInfoCallBack.onGotoPay(info);
                }
            }
        });
    }
}

