/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.doc;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.os.SystemClock;
import android.text.TextUtils;
import android.view.View;
import com.gensee.callback.IDocCallBack;
import com.gensee.common.GenseeConfig;
import com.gensee.doc.IDocModule;
import com.gensee.pdu.AbsAnno;
import com.gensee.pdu.AnnoAction;
import com.gensee.pdu.AnnoCleaner;
import com.gensee.pdu.AnnoFPoint;
import com.gensee.pdu.AnnoFreepenEx;
import com.gensee.pdu.IGSDocView;
import com.gensee.pdu.PduDoc;
import com.gensee.pdu.PduPage;
import com.gensee.room.AbsModule;
import com.gensee.routine.IRTEvent;
import com.gensee.routine.IRoutine;
import com.gensee.routine.UserInfo;
import com.gensee.taskret.OnTaskRet;
import com.gensee.user.UserManager;
import com.gensee.utils.FileUtil;
import com.gensee.utils.GenseeLog;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;

public class DocEventImpl
extends AbsModule
implements IRTEvent.IDocEvent,
AnnoAction,
IDocModule {
    private static final int TIMELONG = 3000;
    private long nJoinConfirmTime = 0L;
    private static final String TAG = "DocEventImpl";
    private int mPhotoCount = 0;
    private IGSDocView mDocView;
    private List<PduDoc> docs = new ArrayList<PduDoc>(0);
    private PduDoc mCurDoc;
    private int annoTmpUserId;
    private long lastAnnoReceiveTime = 0L;
    private IDocCallBack mDocCallBack;
    private AnnoFreepenEx srcFreepen = null;
    private volatile long annoTmpId = 1000L;

    public static void initPageCachDir(Context c) {
        PduPage.setFileDir((String)FileUtil.getCachDir((Context)c, (String)"rtsdk"));
    }

    public void setDocView(IGSDocView docView) {
        GenseeLog.d((String)TAG, (String)("setDocView docView = " + docView));
        this.mDocView = docView;
        if (this.mDocView != null) {
            PduPage p;
            this.mDocView.setAnnoAction((AnnoAction)this);
            if (this.mCurDoc != null && (p = this.mCurDoc.getCurPage()) != null) {
                this.mDocView.showDocPage(p);
            }
        }
    }

    public void setDocViewGx(IGSDocView glDocViewGroup) {
        this.setDocView(glDocViewGroup);
    }

    public void setDocCallbak(IDocCallBack docCallBack) {
        this.mDocCallBack = docCallBack;
    }

    @Override
    public List<PduDoc> getDocs() {
        return this.docs;
    }

    @Override
    public PduDoc getCurrentDoc() {
        return this.mCurDoc;
    }

    @Override
    public boolean isCurrentDoc(PduDoc doc) {
        if (doc == null || this.mCurDoc == null) {
            return false;
        }
        return doc.getDocId() == this.mCurDoc.getDocId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PduDoc changeCurDoc(int index) {
        List<PduDoc> list = this.docs;
        synchronized (list) {
            PduDoc o;
            if (index < this.docs.size() && (o = this.docs.get(index)) instanceof PduDoc) {
                this.mCurDoc = o;
                return this.mCurDoc;
            }
        }
        return null;
    }

    @Override
    public void gotoPage(PduPage page, boolean syn, OnTaskRet taskRet) {
        IRoutine routine = this.getRoutine();
        if (page == null || routine == null) {
            if (taskRet != null) {
                taskRet.onTaskRet(false, 0, "switchPage");
            }
            GenseeLog.w((String)TAG, (String)("gotoPage page = " + page + " routine = " + routine));
            return;
        }
        if (this.mDocView != null) {
            this.mDocView.showDocPage(page);
        }
        routine.docGotoPage(page.getDocId(), page.getPageId(), syn, taskRet);
    }

    @Override
    public void gotoAnimation(PduPage page, int nAniStep, boolean syn, OnTaskRet taskRet) {
        IRoutine routine = this.getRoutine();
        if (page == null || routine == null) {
            if (taskRet != null) {
                taskRet.onTaskRet(false, 0, "gotoAnimation");
            }
            return;
        }
        routine.docGotoAnimation(page.getDocId(), page.getPageId(), nAniStep, syn, taskRet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PduDoc getDocById(int docId) {
        if (this.mCurDoc != null && this.mCurDoc.getDocId() == docId) {
            return this.mCurDoc;
        }
        List<PduDoc> list = this.docs;
        synchronized (list) {
            for (PduDoc o : this.docs) {
                PduDoc doc;
                if (!(o instanceof PduDoc) || (doc = o) == null || doc.getDocId() != docId) continue;
                return doc;
            }
        }
        return null;
    }

    public boolean sendAnno(final AbsAnno anno, final Runnable onTaskRet) {
        AnnoFreepenEx annoFreepenEx;
        IRoutine routine = this.getRoutine();
        if (this.mCurDoc == null || routine == null) {
            return false;
        }
        anno.setDocId(this.mCurDoc.getDocId());
        UserInfo self = UserManager.getIns().getMyUserInfo();
        if (null != self) {
            anno.setOwner(self.getId());
        }
        AbsAnno newAnnoFreepenEx = anno;
        if (anno instanceof AnnoFreepenEx && (annoFreepenEx = (AnnoFreepenEx)anno).getStepType() == 1) {
            ++this.annoTmpId;
            if (this.annoTmpId >= Long.MAX_VALUE) {
                this.annoTmpId = 1000L;
            }
            anno.setId(this.annoTmpId);
            GenseeLog.d((String)TAG, (String)("sendAnno copy anno = " + anno));
            newAnnoFreepenEx = new AnnoFreepenEx();
            newAnnoFreepenEx.setType(anno.getType());
            newAnnoFreepenEx.setId(anno.getId());
            newAnnoFreepenEx.setDocId(anno.getDocId());
            newAnnoFreepenEx.setPageId(anno.getPageId());
            newAnnoFreepenEx.setOwner(anno.getOwner());
            ((AnnoFreepenEx)newAnnoFreepenEx).setColor(((AnnoFreepenEx)anno).getColor());
            AnnoFPoint[] points = ((AnnoFreepenEx)anno).getPoints();
            ((AnnoFreepenEx)newAnnoFreepenEx).setPoints(Arrays.asList(points));
            ((AnnoFreepenEx)newAnnoFreepenEx).setHighLight(((AnnoFreepenEx)anno).isHighLight());
            ((AnnoFreepenEx)newAnnoFreepenEx).setLinesize((byte)((AnnoFreepenEx)anno).getLinesize());
            ((AnnoFreepenEx)newAnnoFreepenEx).setStepType(((AnnoFreepenEx)anno).getStepType());
        }
        final AbsAnno sendAnno = newAnnoFreepenEx;
        boolean ret = routine.docAddAnnotation(sendAnno.getDocId(), sendAnno.getPageId(), sendAnno, new OnTaskRet(){

            public void onTaskRet(boolean ret, int id, String desc) {
                if (sendAnno instanceof AnnoFreepenEx && ((AnnoFreepenEx)sendAnno).getStepType() == 1) {
                    anno.setId(sendAnno.getId());
                }
                if (null != onTaskRet) {
                    onTaskRet.run();
                }
            }
        });
        return ret;
    }

    public boolean modifyAnno(AbsAnno anno) {
        IRoutine routine = this.getRoutine();
        if (this.mCurDoc == null || routine == null) {
            return false;
        }
        anno.setDocId(this.mCurDoc.getDocId());
        return routine.docModifyAnnotation(anno.getDocId(), anno.getPageId(), anno, null);
    }

    public boolean deleteAnno(AbsAnno anno, boolean isAll) {
        IRoutine routine = this.getRoutine();
        if (this.mCurDoc == null || routine == null) {
            return false;
        }
        int docId = this.mCurDoc.getDocId();
        int pageId = anno.getPageId();
        GenseeLog.d((String)TAG, (String)("deleteAnno " + anno.toString()));
        return isAll ? routine.docRemoveAllAnnotation(docId, pageId, null) : routine.docRemoveAnnotation(docId, pageId, anno, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onDocOrLodAdd(PduDoc o) {
        String string = TAG;
        synchronized (TAG) {
            if (!this.docs.contains(o)) {
                this.docs.add(o);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onDocOrLodRemove(Object o) {
        String string = TAG;
        synchronized (TAG) {
            int index = this.docs.indexOf(o);
            if (index != -1) {
                this.docs.remove(index);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    @Override
    public boolean docNewWhiteboard(String name, boolean createOnce, OnTaskRet taskRet) {
        return this.getRoutine().docNewWhiteboard(name, createOnce, taskRet);
    }

    @Override
    public boolean docNewBlackboard(String name, int type, OnTaskRet taskRet) {
        return this.getRoutine().docNewBlackboard(name, type, taskRet);
    }

    @Override
    public boolean docClose(int docId, boolean bDelOnServer, OnTaskRet taskRet) {
        return this.getRoutine().docClose(docId, bDelOnServer, taskRet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void openDoc(String name, Bitmap bitmap) {
        ByteArrayOutputStream stream;
        if (bitmap == null || bitmap.isRecycled()) {
            return;
        }
        int w = bitmap.getWidth();
        int h = bitmap.getHeight();
        Bitmap tmp = null;
        if (w * h > 512000) {
            try {
                float scale = (float)Math.sqrt(512000.0 / (double)w * (double)h);
                Matrix m = new Matrix();
                m.setScale(scale, scale);
                bitmap = tmp = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)w, (int)h, (Matrix)m, (boolean)false);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        if (bitmap.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)(stream = new ByteArrayOutputStream()))) {
            try {
                stream.flush();
                byte[] arr = stream.toByteArray();
                this.openDoc(name, arr, bitmap.getWidth(), bitmap.getHeight());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                    }
                }
            }
        }
        if (tmp != null) {
            tmp.recycle();
        }
    }

    @Override
    public void openDoc(String name, byte[] data, int w, int h) {
        GenseeLog.d((String)TAG, (String)("openDoc data len = " + (data == null ? 0 : data.length)));
        if (null == data || data.length <= 0) {
            return;
        }
        ++this.mPhotoCount;
        Context context = this.getContextFromView((View)this.mDocView);
        if (null == context) {
            return;
        }
        if (!(TextUtils.isEmpty((CharSequence)name) || name.endsWith(".jpg") || name.endsWith(".jpeg") || name.endsWith(".png"))) {
            name = name + ".jpg";
        }
        String filePath = FileUtil.saveToCache((Context)context, (String)"doc", (String)name, (byte[])data);
        this.docRemoteOpen(filePath, name, new OnTaskRet(){

            public void onTaskRet(boolean ret, int id, String desc) {
            }
        });
    }

    @Override
    public void onDocJoinConfirm(final boolean bRet) {
        this.postPool(new Runnable(){

            @Override
            public void run() {
                if (DocEventImpl.this.mDocCallBack != null) {
                    DocEventImpl.this.mDocCallBack.onDocJoinConfirm(bRet);
                }
            }
        });
        this.annoTmpUserId = new Random().nextInt();
        this.nJoinConfirmTime = bRet ? SystemClock.elapsedRealtime() : 0L;
        GenseeLog.d((String)TAG, (String)("onDocJoinConfirm bRet = " + bRet + " annoTmpUserId = " + this.annoTmpUserId));
    }

    @Override
    public void onDocOpened(final PduDoc doc) {
        this.postPool(new Runnable(){

            @Override
            public void run() {
                GenseeLog.d((String)DocEventImpl.TAG, (String)("onDocOpened docId = " + doc.getDocId() + " docName = " + doc.getDocName()));
                DocEventImpl.this.onDocOrLodAdd(doc);
                DocEventImpl.this.calcPhotoCount();
                if (DocEventImpl.this.mDocCallBack != null) {
                    DocEventImpl.this.mDocCallBack.onDocOpened(doc);
                }
            }
        });
    }

    @Override
    public void onDocClosed(final int docId) {
        this.postPool(new Runnable(){

            @Override
            public void run() {
                GenseeLog.d((String)DocEventImpl.TAG, (String)("onDocClosed docId = " + docId));
                PduDoc doc = DocEventImpl.this.getDocById(docId);
                if (doc != null) {
                    doc.close();
                }
                DocEventImpl.this.onDocOrLodRemove(doc);
                DocEventImpl.this.calcPhotoCount();
                if (DocEventImpl.this.mDocCallBack != null) {
                    DocEventImpl.this.mDocCallBack.onDocClosed(docId);
                }
            }
        });
    }

    @Override
    public void onDocGotoPage(final int docId, final int pageId, final int aniStep) {
        this.postPool(new Runnable(){

            @Override
            public void run() {
                DocEventImpl.this.runDocGotoPage(docId, pageId, aniStep);
            }
        });
    }

    private void runDocGotoPage(int docId, int pageId, int aniStep) {
        PduPage curPage;
        GenseeLog.d((String)TAG, (String)("onDocGotoPage docId = " + docId + " pageId = " + pageId + " aniStep = " + aniStep));
        PduDoc curDoc = this.getCurrentDoc();
        if (curDoc != null && docId == curDoc.getDocId() && (curPage = curDoc.getCurPage()) != null && curPage.getPageId() == pageId) {
            curPage.setAniStep(aniStep);
            this.mDocCallBack.onDocGotoAnimation(docId, pageId, aniStep);
            return;
        }
        PduDoc doc = this.getDocById(docId);
        if (doc != null) {
            PduPage p = doc.onCmd((long)pageId, aniStep);
            this.mCurDoc = doc;
            if (this.mDocCallBack != null) {
                this.mDocCallBack.onDocGotoPage(docId, pageId, aniStep);
                if (p != null) {
                    this.mDocCallBack.onDocPageSize(p.getImgWidth(), p.getImgHeight());
                }
            }
            if (p != null && this.mDocView != null) {
                this.mDocView.showDocPage(p);
            }
        }
    }

    @Override
    public void onDocGotoAnimation(final int docId, final int pageId, final int step) {
        GenseeLog.d((String)TAG, (String)("onDocGotoAnimation docId = " + docId + " pageId = " + pageId + " step = " + step));
        this.postPool(new Runnable(){

            @Override
            public void run() {
                PduPage page;
                PduDoc doc = DocEventImpl.this.getDocById(docId);
                if (doc != null && (page = doc.getPageById((long)pageId)) != null) {
                    page.setAniStep(step);
                }
            }
        });
    }

    @Override
    public void onDocSavedOnServer(final int docId, final boolean bRet, final boolean savedByMyself) {
        GenseeLog.d((String)TAG, (String)("onDocSavedOnServer docId = " + docId + " bRet = " + bRet));
        this.postPool(new Runnable(){

            @Override
            public void run() {
                PduDoc doc = null;
                doc = DocEventImpl.this.mCurDoc != null && DocEventImpl.this.mCurDoc.getDocId() == docId ? DocEventImpl.this.mCurDoc : DocEventImpl.this.getDocById(docId);
                if (null != doc) {
                    doc.setSavedOnServer((byte)(bRet ? 1 : 0));
                }
                if (DocEventImpl.this.mDocCallBack != null) {
                    DocEventImpl.this.mDocCallBack.onDocSavedOnServer(docId, bRet, savedByMyself);
                }
            }
        });
    }

    @Override
    public void onDocPublish(final int docId, final boolean bRet, final boolean isPublish, final boolean publishByMyself) {
        this.postPool(new Runnable(){

            @Override
            public void run() {
                PduDoc doc = DocEventImpl.this.getDocById(docId);
                if (doc != null) {
                    doc.setPublish(isPublish);
                }
                if (DocEventImpl.this.mDocCallBack != null) {
                    DocEventImpl.this.mDocCallBack.onDocPublish(docId, bRet, isPublish, publishByMyself);
                }
            }
        });
    }

    @Override
    public void onDocPageReady(final int docId, final PduPage page, final byte[] data) {
        if (null == page) {
            return;
        }
        GenseeLog.d((String)TAG, (String)("onDocPageReady docId = " + docId + " pageId = " + page.getPageId() + " data len = " + data.length));
        this.postPool(new Runnable(){

            @Override
            public void run() {
                page.setDocId(docId);
                PduDoc doc = DocEventImpl.this.getDocById(docId);
                PduPage p = null;
                if (null != doc && null == (p = doc.getPageById((long)page.getPageId())) && doc.addPage(page)) {
                    p = page;
                }
                if (p != null) {
                    if (GenseeConfig.isDocDataPng) {
                        p.onContent(data, false, docId);
                    } else {
                        p.onGlContent(data, false, docId);
                    }
                }
                if (DocEventImpl.this.mDocCallBack != null) {
                    DocEventImpl.this.mDocCallBack.onDocPageReady(docId, page, data);
                }
            }
        });
    }

    @Override
    public void onDocReceiveAnno(int docId, int pageId, final AbsAnno anno) {
        this.postPool(new Runnable(){

            @Override
            public void run() {
                DocEventImpl.this.receiveAnno(anno);
            }
        });
    }

    @Override
    public void onDocRemoveAnno(final int docId, final int pageId, final long llAnnoId) {
        GenseeLog.d((String)TAG, (String)("onDocRemoveAnno docId = " + docId + " pageId = " + pageId + " llAnnoId = " + llAnnoId));
        this.postPool(new Runnable(){

            @Override
            public void run() {
                AnnoCleaner cleaner = new AnnoCleaner();
                cleaner.setDocId(docId);
                cleaner.setPageId(pageId);
                cleaner.setRemovedId(llAnnoId);
                DocEventImpl.this.receiveAnno((AbsAnno)cleaner);
            }
        });
    }

    private void receiveAnno(AbsAnno anno) {
        PduDoc doc = this.getDocById(anno.getDocId());
        if (doc != null) {
            doc.receiveAnno(anno, this.nJoinConfirmTime);
        }
    }

    @Override
    protected String onGetLogTag() {
        return TAG;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanData() {
        List<PduDoc> list = this.docs;
        synchronized (list) {
            for (PduDoc doc : this.docs) {
                if (doc == null) continue;
                doc.clean(doc.equals((Object)this.mCurDoc));
            }
            this.mCurDoc = null;
            this.docs.clear();
        }
    }

    @Override
    public void synCurrentDoc() {
        PduPage page;
        if ((UserManager.getIns().isHost() || UserManager.getIns().isPanlist()) && this.mCurDoc != null && (page = this.mCurDoc.getCurPage()) != null) {
            this.getRoutine().docGotoPage(this.mCurDoc.getDocId(), page.getPageId(), true, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void calcPhotoCount() {
        String string = TAG;
        synchronized (TAG) {
            int size = this.docs.size();
            int photoNumb = 0;
            for (int i = 0; i < size; ++i) {
                PduDoc pduDoc = this.docs.get(i);
                if (null == pduDoc || pduDoc.getDocType() != 5) continue;
                ++photoNumb;
            }
            this.mPhotoCount = photoNumb;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @Override
    public int getPhotoCount() {
        return this.mPhotoCount;
    }

    public Context getContextFromView(View ... views) {
        if (null == views) {
            return null;
        }
        int size = views.length;
        for (int i = 0; i < size; ++i) {
            if (null == views[i]) continue;
            return views[i].getContext();
        }
        return null;
    }

    @Override
    public void release() {
        this.mPhotoCount = 0;
        this.mDocView = null;
        this.setHandler(null);
        String filePath = PduPage.getFileDir();
        if (filePath != null) {
            FileUtil.deleteFileByTime((File)new File(filePath), (long)System.currentTimeMillis(), (long)86400000L);
        }
    }

    @Override
    public boolean docRemoteOpen(String filePath, String fileName, OnTaskRet taskRet) {
        GenseeLog.d((String)TAG, (String)("docRemoteOpen path = " + filePath + " fileName " + fileName));
        if (filePath == null || "".equals(filePath) || fileName == null || "".equals(fileName)) {
            GenseeLog.e((String)TAG, (String)("docRemoteOpen Error path = " + filePath + " desc " + fileName));
            return false;
        }
        File f = new File(filePath);
        if (f == null || !f.isFile() || !f.exists()) {
            GenseeLog.e((String)TAG, (String)("docRemoteOpen Error path = " + filePath + " is not a file or not exist"));
            return false;
        }
        return this.getRoutine().docRemoteOpen(filePath, fileName, taskRet);
    }

    @Override
    public void onDocRename(int docId, String name) {
        GenseeLog.d((String)TAG, (String)("onDocRename name = " + name));
        if (this.mDocCallBack != null) {
            this.mDocCallBack.onDocRename(docId, name);
        }
    }

    @Override
    public void onPageChanged(int docId, int pageId, int newDocId, int newPageId) {
        GenseeLog.d((String)TAG, (String)("onPageChanged docId = " + docId + " pageId = " + pageId + " newDocId = " + newDocId + " newPageId = " + newPageId));
    }

    @Override
    public void onDocUploadStatus(String name, int nStatus, int percent) {
        GenseeLog.d((String)TAG, (String)("onDocRename name = " + name));
        if (this.mDocCallBack != null) {
            this.mDocCallBack.onDocUploadStatus(name, nStatus, percent);
        }
    }
}

