/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.view;

import android.content.Context;
import android.graphics.RectF;
import android.graphics.SurfaceTexture;
import android.os.Handler;
import android.os.Message;
import android.util.AttributeSet;
import com.gensee.GPUImage.GLTextureView;
import com.gensee.pdu.IGSDocZoom;
import com.gensee.pdu.PduPage;
import com.gensee.swf.GLSwfRender;
import com.gensee.swf.ISwfCallback;
import com.gensee.swf.OnLocalAnimCallback;
import com.gensee.swf.OnOpenglRenderMaxListener;
import com.gensee.utils.GenseeLog;
import com.gensee.view.IGSGLDocView;
import com.gensee.view.OnDocFileOpen;
import com.gensee.view.OnPageOpenListener;
import java.lang.ref.WeakReference;

public class GSSWFTextureView
extends GLTextureView
implements IGSGLDocView,
IGSDocZoom,
ISwfCallback,
GLSwfRender.OnOpenFileListener,
OnOpenglRenderMaxListener {
    private static final String TAG = "GSDocTextureView";
    private PduPage docPage;
    private PduPage prePage;
    private GLSwfRender glViewRender;
    private DocViewExHanlder handler;
    private OnDocFileOpen docExInterface;
    private OnPageOpenListener onPageOpenListener;
    private OnOpenglRenderMaxListener onOpenglRenderMaxListener;
    boolean killTimer = false;

    @Override
    public void setOnPageOpenListener(OnPageOpenListener onPageOpenListener) {
        this.onPageOpenListener = onPageOpenListener;
    }

    public GSSWFTextureView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public GSSWFTextureView(Context context) {
        super(context);
        this.init(context);
    }

    @Override
    public void setDocExInterface(OnDocFileOpen docExInterface) {
        this.docExInterface = docExInterface;
    }

    private void init(Context context) {
        this.handler = new DocViewExHanlder(this);
        if (!this.isInEditMode()) {
            this.glViewRender = new GLSwfRender(this);
            this.setEGLConfigChooser(8, 8, 8, 8, 8, 8);
            this.setRenderer(this.glViewRender);
            this.setRenderMode(0);
            this.glViewRender.setOnOpenFileListener(this);
            this.glViewRender.setOnOpenglRenderMaxListener(this);
        }
    }

    public void onSurfaceTextureUpdated(SurfaceTexture surface) {
    }

    private void docPageAnimation(final PduPage pduPage) {
        if (pduPage == null || !pduPage.isPrepare() || !pduPage.isRefreshAnnos()) {
            return;
        }
        this.queueEvent(new Runnable(){

            @Override
            public void run() {
                GSSWFTextureView.this.glViewRender.goToAnimation(pduPage.getAniStep(), true);
            }
        });
    }

    private void setDocPage(PduPage d) {
        if (d == null || !d.isPrepare()) {
            GenseeLog.w((String)"GSDocTextureView setDocPage page is unPrepared");
            return;
        }
        this.prePage = this.docPage;
        this.docPage = d;
        d.setRefreshAnnos(false);
        GenseeLog.d((String)TAG, (String)("setDocPage aniStep = " + d.getAniStep() + " fileId = " + d.hashCode()));
        this.glViewRender.setDocPage(d.getPath(), d.getAnimationPath(), d.getAniStep(), d.hashCode());
        this.queueEvent(new Runnable(){

            @Override
            public void run() {
                if (GSSWFTextureView.this.docPage != null) {
                    GSSWFTextureView.this.glViewRender.reOpenFile();
                    GSSWFTextureView.this.requestRender();
                }
            }
        });
    }

    private void callOnTimer() {
        this.glViewRender.callOnTimer();
    }

    @Override
    public Handler getHandler() {
        return this.handler;
    }

    @Override
    public void onResume() {
        super.onResume();
        if (null != this.docPage && null != this.glViewRender) {
            this.queueEvent(new Runnable(){

                @Override
                public void run() {
                    PduPage p = GSSWFTextureView.this.docPage;
                    if (p != null) {
                        GSSWFTextureView.this.glViewRender.goToAnimation(p.getAniStep(), false);
                    }
                }
            });
        }
    }

    @Override
    public void setBackgroundColor(final int argb) {
        if (!this.isInEditMode()) {
            this.queueEvent(new Runnable(){

                @Override
                public void run() {
                    GSSWFTextureView.this.glViewRender.setBackgroundColor(argb);
                    GSSWFTextureView.this.requestRender();
                }
            });
        }
    }

    public void setVisibility(int visibility) {
        super.setVisibility(visibility);
        if (visibility == 0 && null != this.docPage && null != this.glViewRender) {
            this.queueEvent(new Runnable(){

                @Override
                public void run() {
                    PduPage p = GSSWFTextureView.this.docPage;
                    if (p != null && GSSWFTextureView.this.glViewRender != null) {
                        GSSWFTextureView.this.glViewRender.goToAnimation(p.getAniStep(), false);
                    }
                }
            });
        }
    }

    @Override
    public void destroy() {
        this.setOnPageOpenListener(null);
        this.glViewRender.destroy();
    }

    @Override
    public void closeDoc() {
        this.glViewRender.closeFile();
        this.docPage = null;
    }

    @Override
    public void onDocBound(final RectF rectF, final int w, final int h) {
        this.queueEvent(new Runnable(){

            @Override
            public void run() {
                GSSWFTextureView.this.glViewRender.onDocBound(rectF, w, h);
                GSSWFTextureView.this.requestRender();
            }
        });
    }

    @Override
    public void onBeginDraw() {
        GenseeLog.d((String)TAG, (String)"onBeginDraw");
    }

    @Override
    public void onEndDraw() {
        GenseeLog.d((String)TAG, (String)"onEndDraw");
    }

    @Override
    public void onSetTimer() {
        GenseeLog.d((String)TAG, (String)"onSetTimer");
        this.killTimer = false;
        this.handler.sendEmptyMessage(143);
    }

    @Override
    public void onKillTimer() {
        GenseeLog.d((String)TAG, (String)"onKillTimer");
        this.killTimer = true;
        this.handler.removeMessages(143);
    }

    @Override
    public void onNeedDraw() {
        GenseeLog.d((String)TAG, (String)"onNeedDraw");
        this.requestRender();
    }

    @Override
    public void onOpenComplete(int fileID) {
        PduPage p = this.docPage;
        if (p != null) {
            GenseeLog.d((String)TAG, (String)("onOpenComplete hasCode = " + p.hashCode() + " fileId = " + fileID));
            if (p.hashCode() == fileID) {
                p.setFrameCount(this.glViewRender.getFrameCount());
                p.setRefreshAnnos(true);
                this.queueEvent(new Runnable(){

                    @Override
                    public void run() {
                        PduPage page = GSSWFTextureView.this.docPage;
                        if (page != null) {
                            PduPage pre = GSSWFTextureView.this.prePage;
                            boolean animation = true;
                            int aniStep = page.getAniStep();
                            if (pre != null && pre.getDocId() == page.getDocId() && pre.getPageId() - 1 == page.getPageId()) {
                                animation = false;
                                GSSWFTextureView.this.prePage = null;
                                if (aniStep == 0) {
                                    aniStep = GSSWFTextureView.this.glViewRender.getTriger();
                                }
                            }
                            GSSWFTextureView.this.glViewRender.goToAnimation(aniStep, animation);
                        }
                    }
                });
            }
        }
        int frameCount = this.glViewRender.getFrameCount();
        if (null != this.docExInterface) {
            this.docExInterface.onPageOpenComplete(fileID, frameCount);
        }
        if (null != this.onPageOpenListener) {
            this.onPageOpenListener.onPageOpenComplete(fileID, frameCount);
        }
    }

    @Override
    public int nextAnimation(final OnLocalAnimCallback taskRet) {
        this.queueEvent(new Runnable(){

            @Override
            public void run() {
                int ret = GSSWFTextureView.this.glViewRender.nextAnimation();
                if (taskRet != null) {
                    taskRet.onAnimStep(ret);
                }
            }
        });
        return -1;
    }

    @Override
    public void setLimitTextureCount(int val) {
        this.glViewRender.setLimitTextureCount(val);
    }

    @Override
    public void onOpenFileFailure(int fileId) {
        if (null != this.onPageOpenListener) {
            this.onPageOpenListener.onPageOpenFileFailure(fileId);
        }
    }

    @Override
    public void resetDocPage() {
        this.docPage = null;
    }

    @Override
    public void onOpenGlRenderMax(int maxWidth, int maxHeight) {
        if (null != this.onOpenglRenderMaxListener) {
            this.onOpenglRenderMaxListener.onOpenGlRenderMax(maxWidth, maxHeight);
        }
    }

    @Override
    public void setOnOpenglRenderMaxListener(OnOpenglRenderMaxListener onOpenglRenderMaxListener) {
        this.onOpenglRenderMaxListener = onOpenglRenderMaxListener;
    }

    private void gotoAnimation(boolean animation) {
        this.queueEvent(new Runnable(){

            @Override
            public void run() {
                PduPage page = GSSWFTextureView.this.docPage;
                if (page != null) {
                    GSSWFTextureView.this.glViewRender.goToAnimation(page.getAniStep(), true);
                }
            }
        });
    }

    @Override
    public void setZOrderOnTop(boolean onTop) {
    }

    @Override
    public void setZOrderMediaOverlay(boolean isMediaOverlay) {
    }

    private static class DocViewExHanlder
    extends Handler {
        private WeakReference<GSSWFTextureView> docViewEx;

        public DocViewExHanlder(GSSWFTextureView docView) {
            this.docViewEx = new WeakReference<GSSWFTextureView>(docView);
        }

        public void handleMessage(Message msg) {
            final GSSWFTextureView view = (GSSWFTextureView)this.docViewEx.get();
            if (view == null) {
                GenseeLog.w((String)GSSWFTextureView.TAG, (String)("handleMessage view = " + view));
                return;
            }
            switch (msg.what) {
                case 140: {
                    PduPage p1 = view.docPage;
                    GenseeLog.i((String)GSSWFTextureView.TAG, (String)("DOC_CMD_CONTENT_REC pdupage = " + msg.obj + " docPage = " + (null == p1 ? "null" : p1.toString())));
                }
                case 138: {
                    PduPage p = view.docPage;
                    if (!msg.obj.equals(p)) {
                        view.setDocPage((PduPage)msg.obj);
                        break;
                    }
                    GenseeLog.e((String)GSSWFTextureView.TAG, (String)("handleMessage obj equal p pdupage = " + p));
                    break;
                }
                case 142: {
                    view.docPageAnimation((PduPage)msg.obj);
                    break;
                }
                case 143: {
                    GenseeLog.e((String)GSSWFTextureView.TAG, (String)"handleMessage DOC_LOOP_ANIMATION ");
                    view.queueEvent(new Runnable(){

                        @Override
                        public void run() {
                            view.callOnTimer();
                            if (!view.killTimer) {
                                DocViewExHanlder.this.sendEmptyMessageDelayed(143, 160L);
                            }
                        }
                    });
                }
            }
        }
    }
}

