/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.view;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.PorterDuff;
import android.graphics.RectF;
import android.util.AttributeSet;
import com.gensee.pdu.GSDocView;
import com.gensee.pdu.IGSDocZoom;
import com.gensee.pdu.PduPage;
import com.gensee.view.OnDocFileOpen;

public class GSPduView
extends GSDocView
implements OnDocFileOpen {
    private IGSDocZoom mZoomer;

    public GSPduView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init();
    }

    public GSPduView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public GSPduView(Context c) {
        this(c, null);
    }

    public void setDocZoomer(IGSDocZoom zoom) {
        this.mZoomer = zoom;
    }

    private void init() {
        this.setBackgroundColor(0);
    }

    @Override
    public void setBackgroundColor(int color) {
        super.setBackgroundColor(0);
    }

    @Override
    public void drawDocPage(PduPage pduPage, Canvas mCanvas, int bgColor) {
        if (pduPage != null) {
            String path = pduPage.getPath();
            if (path != null && (path.endsWith("png") || path.endsWith("png.1"))) {
                super.drawDocPage(pduPage, mCanvas, bgColor);
            } else {
                mCanvas.drawColor(bgColor, PorterDuff.Mode.CLEAR);
            }
        } else {
            mCanvas.drawColor(bgColor, PorterDuff.Mode.CLEAR);
        }
    }

    @Override
    public void onDocBound(RectF rectF, int w, int h) {
        IGSDocZoom t = this.mZoomer;
        if (null != t) {
            t.onDocBound(rectF, w, h);
        }
    }

    @Override
    public boolean isDrawAnnos() {
        PduPage docPage = this.docViewImpl.getDocPage();
        if (null != docPage) {
            String path = docPage.getPath();
            if (path != null && (path.endsWith("png") || path.endsWith("png.1"))) {
                return true;
            }
            if (docPage.isRefreshAnnos()) {
                return true;
            }
        }
        return false;
    }

    @Override
    public void onPageOpenComplete(int fileId, int frameCount) {
        this.postInvalidate();
    }

    public void setMaxRectWidth(int maxRectWidth) {
        if (null != this.docViewImpl) {
            this.docViewImpl.setMaxRectWidth(maxRectWidth);
        }
    }

    public void setMaxRectHeight(int maxRectHeight) {
        if (null != this.docViewImpl) {
            this.docViewImpl.setMaxRectHeight(maxRectHeight);
        }
    }
}

