/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.view;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Typeface;
import android.os.Handler;
import android.os.Message;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.gensee.doc.AnnoInputMode;
import com.gensee.doc.CtrlMode;
import com.gensee.doc.DrawMode;
import com.gensee.doc.LINE_SIZE;
import com.gensee.doc.OnAnnoDataListener;
import com.gensee.doc.OnAnnoEraseUserIdListener;
import com.gensee.doc.OnDocViewEventListener;
import com.gensee.pdu.AnnoAction;
import com.gensee.pdu.AnnoText;
import com.gensee.pdu.DocViewImpl;
import com.gensee.pdu.IGSDocView;
import com.gensee.pdu.IGSDocZoom;
import com.gensee.pdu.OnReAndUndoListener;
import com.gensee.pdu.PduPage;
import com.gensee.swf.OnLocalAnimCallback;
import com.gensee.swf.OnOpenglRenderMaxListener;
import com.gensee.utils.GenseeLog;
import com.gensee.view.GSDocViewEx;
import com.gensee.view.GSPduTextureView;
import com.gensee.view.GSPduView;
import com.gensee.view.GSSWFTextureView;
import com.gensee.view.IGSGLDocView;
import com.gensee.view.OnDocFileOpen;
import com.gensee.view.OnPageOpenListener;
import java.lang.ref.SoftReference;

public class GSDocViewGx
extends FrameLayout
implements OnOpenglRenderMaxListener,
IGSDocView {
    private static int PDU_VIEW_TYPE = 0;
    public static int GL_VIEW_TYPE_SURFACE = 0;
    public static int GL_VIEW_TYPE_TEXTURE = 1;
    private static final String TAG = "GSDocViewGx";
    private IGSGLDocView glDocView;
    private IGSDocView pduView;
    private Handler docViewHandler;
    private Handler glDocViewHandler;
    private MyHandler handler;
    private Typeface typeface;
    private SoftReference<PduPage> prePage;

    public void setTypeface(Typeface typeface) {
        GenseeLog.i((String)TAG, (String)("setTypeface typeface=" + typeface));
        this.typeface = typeface;
        AnnoText.typeface = typeface;
    }

    public int getGLViewType() {
        return GL_VIEW_TYPE_SURFACE;
    }

    public int getAnnoViewType() {
        return PDU_VIEW_TYPE;
    }

    @Override
    public Handler getHandler() {
        return this.handler;
    }

    public GSDocViewGx(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context);
    }

    public GSDocViewGx(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public GSDocViewGx(Context context) {
        super(context);
        this.init(context);
    }

    private void init(Context context) {
        this.handler = new MyHandler(this);
        this.removeAllViews();
        int glViewType = this.getGLViewType();
        this.glDocView = (IGSGLDocView)((Object)(glViewType == GL_VIEW_TYPE_TEXTURE ? new GSSWFTextureView(context) : new GSDocViewEx(context)));
        this.addView((View)this.glDocView, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        this.glDocViewHandler = this.glDocView.getHandler();
        if (PDU_VIEW_TYPE == 0) {
            this.pduView = new GSPduView(context);
            ((GSPduView)this.pduView).setDocZoomer((IGSDocZoom)((Object)this.glDocView));
        } else {
            this.pduView = new GSPduTextureView(context);
            ((GSPduTextureView)this.pduView).setDocZoomer((IGSDocZoom)((Object)this.glDocView));
        }
        if (glViewType == GL_VIEW_TYPE_TEXTURE) {
            ((View)this.pduView).setLayerType(1, null);
        }
        this.addView((View)this.pduView, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        this.glDocView.setDocExInterface((OnDocFileOpen)((Object)this.pduView));
        this.docViewHandler = this.pduView.getHandler();
        this.glDocView.setOnOpenglRenderMaxListener(this);
    }

    public void setBackgroundColor(int argb) {
        super.setBackgroundColor(argb);
        this.glDocView.setBackgroundColor(argb);
    }

    @Override
    public void forbidZoomGestrue(boolean isFobid) {
        this.pduView.forbidZoomGestrue(isFobid);
    }

    @Override
    public void setTouchforbidden(boolean isTouchforbidden) {
        this.pduView.setTouchforbidden(isTouchforbidden);
    }

    @Override
    public void setOnDocViewClickedListener(OnDocViewEventListener l) {
        this.pduView.setOnDocViewClickedListener(l);
    }

    @Override
    public void showAdaptViewWidth() {
        this.pduView.showAdaptViewWidth();
    }

    @Override
    public void showAdaptViewHeight() {
        this.pduView.showAdaptViewHeight();
    }

    @Override
    public void showFillView() {
        this.pduView.showFillView();
    }

    @Override
    public void showAdaptView() {
        this.pduView.showAdaptView();
    }

    @Override
    public void showSourceScall() {
        this.pduView.showSourceScall();
    }

    @Override
    public void showAdaptViewWidthAlignTop() {
        this.pduView.showAdaptViewWidthAlignTop();
    }

    @Override
    public void showAdaptViewHeightAlignLeft() {
        this.pduView.showAdaptViewHeightAlignLeft();
    }

    public void onResume() {
        this.glDocView.onResume();
    }

    public void onPause() {
        this.glDocView.onPause();
    }

    @Override
    public void onUpdate() {
        this.pduView.onUpdate();
    }

    public void destroy() {
        this.glDocView.setDocExInterface(null);
        this.glDocView.setOnPageOpenListener(null);
        if (PDU_VIEW_TYPE == 0) {
            ((GSPduView)this.pduView).setDocZoomer(null);
        } else {
            ((GSPduTextureView)this.pduView).setDocZoomer(null);
        }
        this.glDocView.destroy();
    }

    @Override
    public void setDefImg(Bitmap bitmap, boolean isFillView) {
        this.pduView.setDefImg(bitmap, isFillView);
    }

    public void setVisibility(int visibility) {
        super.setVisibility(visibility);
        ((View)this.glDocView).setVisibility(visibility);
    }

    public void setGlVisible(boolean bVisible) {
        ((View)this.glDocView).setVisibility(bVisible ? 0 : 4);
    }

    public void closeDoc() {
        this.glDocView.closeDoc();
        this.pduView.clear();
        this.pduView.reset();
    }

    public void resetDocPage() {
        this.glDocView.resetDocPage();
    }

    public void setZOrderOnTop(boolean onTop) {
        this.glDocView.setZOrderOnTop(onTop);
    }

    public void setZOrderMediaOverlay(boolean isMediaOverlay) {
        this.glDocView.setZOrderMediaOverlay(isMediaOverlay);
    }

    public void setOnPageOpenListener(OnPageOpenListener onPageOpenListener) {
        this.glDocView.setOnPageOpenListener(onPageOpenListener);
    }

    @Override
    public boolean isDragScale() {
        return this.pduView.isDragScale();
    }

    @Override
    public void setPaintColor(int color) {
        this.pduView.setPaintColor(color);
    }

    @Override
    public void addTextAnno(String text) {
        this.pduView.addTextAnno(text);
    }

    @Override
    public void addPictureAnno(float x, float y, String url, String localPath) {
        this.pduView.addPictureAnno(x, y, url, localPath);
    }

    @Override
    public void undo(long ownerId) {
        this.pduView.undo(ownerId);
    }

    @Override
    public void setStrokeWidth(LINE_SIZE width) {
        this.pduView.setStrokeWidth(width);
    }

    @Override
    public void setTextSize(int size) {
        this.pduView.setTextSize(size);
    }

    @Override
    public void setAnnoMakeType(DrawMode mode) {
        this.pduView.setAnnoMakeType(mode);
    }

    @Override
    public DrawMode getAnnoMakeType() {
        return this.pduView.getAnnoMakeType();
    }

    @Override
    public void eraseAll() {
        this.pduView.eraseAll();
    }

    @Override
    public void setCtrlMode(CtrlMode mode) {
        this.pduView.setCtrlMode(mode);
    }

    @Override
    public void setAnnoAction(AnnoAction action) {
        this.pduView.setAnnoAction(action);
    }

    public int nextAnimation(OnLocalAnimCallback taskRet) {
        return this.glDocView.nextAnimation(taskRet);
    }

    public void setLimitTextureCount(int val) {
        this.glDocView.setLimitTextureCount(val);
    }

    @Override
    public void setOnAnnoDataListener(OnAnnoDataListener onAnnoDataListener) {
        this.pduView.setOnAnnoDataListener(onAnnoDataListener);
    }

    @Override
    public void setOnAnnoEraseUserIdListener(OnAnnoEraseUserIdListener onAnnoEraseUserIdListener) {
        this.pduView.setOnAnnoEraseUserIdListener(onAnnoEraseUserIdListener);
    }

    @Override
    public void onOpenGlRenderMax(int maxWidth, int maxHeight) {
        if (null != this.pduView && this.pduView instanceof GSPduView) {
            ((GSPduView)this.pduView).setMaxRectWidth(maxWidth);
            ((GSPduView)this.pduView).setMaxRectHeight(maxHeight);
        }
    }

    @Override
    public void setOnDocLabelListener(DocViewImpl.OnDocLabelListener onDocLabelListener) {
        this.pduView.setOnDocLabelListener(onDocLabelListener);
    }

    @Override
    public void redoStep() {
        this.pduView.redoStep();
    }

    @Override
    public void undoStep() {
        this.pduView.undoStep();
    }

    @Override
    public int getRedoStackSize() {
        return this.pduView.getRedoStackSize();
    }

    @Override
    public int getUndoStackSize() {
        return this.pduView.getUndoStackSize();
    }

    @Override
    public void setOnReAndUndoListener(OnReAndUndoListener onReAndUndoListener) {
        this.pduView.setOnReAndUndoListener(onReAndUndoListener);
    }

    @Override
    public void resetStatus() {
        this.pduView.resetStatus();
    }

    @Override
    public void setEndAnimation(boolean endAnimation) {
        this.pduView.setEndAnimation(endAnimation);
    }

    @Override
    public void setThirdPartyMotionEvent(MotionEvent motionEvent) {
        this.pduView.setThirdPartyMotionEvent(motionEvent);
    }

    @Override
    public void setAnnoInputMode(AnnoInputMode annoInputMode) {
        this.pduView.setAnnoInputMode(annoInputMode);
    }

    @Override
    public Bitmap getBitmap() {
        Bitmap docContent = null;
        if (this.glDocView instanceof GSSWFTextureView) {
            docContent = ((GSSWFTextureView)this.glDocView).getBitmap();
        }
        Bitmap docAnno = this.pduView.getBitmap();
        if (docContent == null) {
            return docAnno;
        }
        Canvas canvas = new Canvas(docContent);
        canvas.drawBitmap(docAnno, 0.0f, 0.0f, new Paint());
        docAnno.recycle();
        return docContent;
    }

    @Override
    public void showDocPage(PduPage docPage) {
        PduPage page;
        PduPage pduPage = page = this.prePage == null ? null : this.prePage.get();
        if (page != null) {
            page.setHandler(null);
        }
        if (docPage != null) {
            docPage.setHandler(this.getHandler());
        }
        this.prePage = new SoftReference<PduPage>(docPage);
    }

    @Override
    public void clear() {
        this.pduView.clear();
    }

    @Override
    public void reset() {
        this.pduView.reset();
    }

    @Override
    public int getShowMode() {
        return this.pduView.getShowMode();
    }

    private static class MyHandler
    extends Handler {
        private SoftReference<GSDocViewGx> docViewGxRef;

        public MyHandler(GSDocViewGx gsDocViewGx) {
            this.docViewGxRef = new SoftReference<GSDocViewGx>(gsDocViewGx);
        }

        public void handleMessage(Message msg) {
            GSDocViewGx docViewGx = this.docViewGxRef.get();
            if (docViewGx == null) {
                GenseeLog.w((String)GSDocViewGx.TAG, (String)("docViewGx is null,but handle msg " + msg == null ? "null" : "" + msg.what));
                return;
            }
            Handler glDocViewHandler = docViewGx.glDocViewHandler;
            Handler docViewHandler = docViewGx.docViewHandler;
            switch (msg.what) {
                case 140: {
                    glDocViewHandler.sendMessage(glDocViewHandler.obtainMessage(140, msg.obj));
                    docViewHandler.sendMessage(docViewHandler.obtainMessage(140, msg.obj));
                    break;
                }
                case 138: {
                    glDocViewHandler.sendMessage(glDocViewHandler.obtainMessage(138, msg.obj));
                    docViewHandler.sendMessage(docViewHandler.obtainMessage(138, msg.obj));
                    break;
                }
                case 135: {
                    docViewHandler.sendEmptyMessage(135);
                    break;
                }
                case 136: {
                    docViewHandler.sendMessage(docViewHandler.obtainMessage(136, msg.obj));
                    break;
                }
                case 141: {
                    docViewHandler.sendEmptyMessage(141);
                    break;
                }
                case 142: {
                    glDocViewHandler.sendMessage(glDocViewHandler.obtainMessage(142, msg.obj));
                    break;
                }
                case 144: {
                    docViewHandler.sendMessage(docViewHandler.obtainMessage(144, msg.obj));
                    break;
                }
                case 145: {
                    docViewHandler.sendEmptyMessage(145);
                    break;
                }
                case 146: {
                    GSDocViewGx gx = this.docViewGxRef.get();
                    if (null != gx && null != gx.glDocView) {
                        gx.glDocView.closeDoc();
                    }
                    docViewHandler.sendEmptyMessage(146);
                    break;
                }
                case 148: {
                    docViewHandler.sendMessage(docViewHandler.obtainMessage(148, msg.obj));
                }
            }
        }
    }
}

