/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.pdu;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.os.Environment;
import android.os.Handler;
import android.os.SystemClock;
import com.gensee.net.AbsHttpAction;
import com.gensee.net.StreamRes;
import com.gensee.parse.AnnotaionParse;
import com.gensee.pdu.AbsAnno;
import com.gensee.pdu.AnnoCleaner;
import com.gensee.pdu.AnnoFPoint;
import com.gensee.pdu.AnnoFreepenEx;
import com.gensee.pdu.AnnoPicture;
import com.gensee.pdu.PduBase;
import com.gensee.utils.GenseeLog;
import com.gensee.utils.HandlerWrapper;
import com.gensee.utils.StringUtil;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class PduPage
extends PduBase {
    private long timestamp = 0L;
    public static final int RT_SDK_TYPE = 0;
    public static final int PLAYER_SDK_TYPE = 1;
    public static final int VOD_SDK_TYPE = 2;
    public static final int ANNO_SUCCESS = 0;
    public static final int ANNO_FAILURE = -1;
    public static final int ANNO_REPLACE = 1;
    public static final String FILE_DIR = Environment.getExternalStorageDirectory().getPath() + "/gensee/rtsdk/";
    private static final String TAG = "PduPage";
    public static final int SHOW_NONE = 0;
    public static final int SHOW_SOURCE = 1;
    public static final int SHOW_ADAPT = 2;
    private static final int TIMELONG = 3000;
    private static String fileDir;
    private int nSdkType = 0;
    private SoftReference<Bitmap> reference;
    private String path = null;
    private String animationPath = null;
    private String pageName;
    private int pageId;
    private int docId;
    private char imgBitCount;
    private short imgWidth;
    private short imgHeight;
    private String thumbData;
    private String fullText;
    private String titleText;
    private String linkUrl;
    private String aniCfg;
    private int aniStep;
    private List<AbsAnno> annos = new ArrayList<AbsAnno>(0);
    private AbsAnno latestAnno;
    private Matrix matrix = new Matrix();
    private int showMode = 0;
    private boolean bRefreshAnnos = false;
    private int nFrameCount;
    private HandlerWrapper mHandlerWrapper = new HandlerWrapper();
    private long lastAnnoReceiveTime = 0L;
    private long lastAnnoReceiveTime2 = 0L;
    static Paint bgPaint;
    private boolean isPrepare = false;

    public int getFrameCount() {
        return this.nFrameCount;
    }

    public void setFrameCount(int nFrameCount) {
        this.nFrameCount = nFrameCount;
    }

    public void setRefreshAnnos(boolean bRefreshAnnos) {
        this.bRefreshAnnos = bRefreshAnnos;
    }

    public boolean isRefreshAnnos() {
        return this.bRefreshAnnos;
    }

    public static void setFileDir(String dir) {
        fileDir = dir;
    }

    public static String getFileDir() {
        return fileDir == null ? FILE_DIR : fileDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setAnnos(AbsAnno[] annos) {
        if (annos != null) {
            List<AbsAnno> list = this.annos;
            synchronized (list) {
                for (int i = 0; i < annos.length; ++i) {
                    this.annos.add(annos[i]);
                }
            }
        }
    }

    protected AbsAnno[] getAnnos() {
        if (this.annos.size() > 0) {
            AbsAnno[] arr = new AbsAnno[this.annos.size()];
            return this.annos.toArray(arr);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawAnno(Canvas canvas) {
        if (canvas == null) {
            GenseeLog.w((String)TAG, (String)"drawAnno canvas is null!");
            return;
        }
        CopyOnWriteArrayList<AbsAnno> cowaList = null;
        List<AbsAnno> list = this.annos;
        synchronized (list) {
            try {
                cowaList = new CopyOnWriteArrayList<AbsAnno>(this.annos);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (cowaList != null) {
            canvas.save();
            for (AbsAnno anno : cowaList) {
                if (anno != null) {
                    anno.draw(canvas, this.matrix);
                    continue;
                }
                GenseeLog.w((String)TAG, (String)"drawAnno anno is null!");
            }
            canvas.restore();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addAnno(AbsAnno anno, boolean isLocalAdd) {
        List<AbsAnno> list = this.annos;
        synchronized (list) {
            AbsAnno lastUserAnno = null;
            int index = -1;
            for (int i = this.annos.size() - 1; i >= 0 && !isLocalAdd; --i) {
                AbsAnno tempAnno = this.annos.get(i);
                if (tempAnno.getOwner() == anno.getOwner()) {
                    lastUserAnno = tempAnno;
                }
                if (!anno.equals(tempAnno)) continue;
                index = i;
                break;
            }
            if (index == -1) {
                int nStepType;
                if (lastUserAnno != null && lastUserAnno instanceof AnnoFreepenEx && (nStepType = ((AnnoFreepenEx)lastUserAnno).getStepType()) != 3 && nStepType != 0) {
                    ((AnnoFreepenEx)lastUserAnno).setStepType(3);
                }
                this.latestAnno = anno;
                return this.annos.add(anno) ? 0 : -1;
            }
            try {
                if (anno instanceof AnnoFreepenEx) {
                    AnnoFreepenEx src = (AnnoFreepenEx)this.annos.get(index);
                    if (src.getStepType() == 3 && this.nSdkType == 0) {
                        return -1;
                    }
                    this.latestAnno = src;
                    return src.appendEX((AnnoFreepenEx)anno) ? 0 : -1;
                }
                if (anno instanceof AnnoPicture) {
                    AbsAnno anno2 = this.annos.get(index);
                    ((AnnoPicture)anno2).updateFromOther(anno);
                    this.latestAnno = anno2;
                } else {
                    AbsAnno anno2 = this.annos.remove(index);
                    anno2.clean();
                    this.annos.add(index, anno);
                }
                return 1;
            }
            catch (Exception e) {
                GenseeLog.e((String)TAG, (String)e.toString());
                return -1;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean delAnno(long annoId) {
        List<AbsAnno> list = this.annos;
        synchronized (list) {
            AbsAnno remove = null;
            for (AbsAnno anno : this.annos) {
                if (anno == null || anno.getId() != annoId) continue;
                remove = anno;
                break;
            }
            return this.annos.remove(remove);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean delAnno(AbsAnno cleaner) {
        List<AbsAnno> list = this.annos;
        synchronized (list) {
            if (0L == ((AnnoCleaner)cleaner).getRemovedId()) {
                this.annos.clear();
                return true;
            }
            AbsAnno remove = null;
            for (AbsAnno anno : this.annos) {
                if (anno == null || anno.getId() != ((AnnoCleaner)cleaner).getRemovedId()) continue;
                remove = anno;
                break;
            }
            return remove == null ? false : this.annos.remove(remove);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean changePoint(AbsAnno point) {
        List<AbsAnno> list = this.annos;
        synchronized (list) {
            int size = this.annos.size();
            AbsAnno anno = null;
            int removeIndex = -1;
            for (int i = size - 1; i >= 0; --i) {
                anno = this.annos.get(i);
                if (anno == null || anno.getType() != 17 && anno.getType() != 9 && anno.getType() != 1) continue;
                removeIndex = i;
                break;
            }
            if (removeIndex >= 0 && removeIndex < size) {
                this.annos.remove(removeIndex);
            }
            return this.annos.add(point);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbsAnno cleanAnno(float mX, float mY) {
        List<AbsAnno> list = this.annos;
        synchronized (list) {
            int size = this.annos.size();
            AbsAnno anno = null;
            for (int i = size - 1; i >= 0; --i) {
                anno = this.annos.get(i);
                if (anno == null || !anno.contain(mX, mY)) continue;
                return anno;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbsAnno findAnno(float x, float y, int annoType) {
        List<AbsAnno> list = this.annos;
        synchronized (list) {
            int size = this.annos.size();
            AbsAnno anno = null;
            for (int i = size - 1; i >= 0; --i) {
                anno = this.annos.get(i);
                if (anno == null || anno.getType() != annoType || !anno.contain(x, y)) continue;
                return anno;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbsAnno cleanLastOwnAnno(long ownerId) {
        List<AbsAnno> list = this.annos;
        synchronized (list) {
            AbsAnno lastOwn = null;
            for (int i = this.annos.size() - 1; i >= 0; --i) {
                lastOwn = this.annos.get(i);
                if (lastOwn == null || lastOwn.getOwner() != ownerId) continue;
                return lastOwn;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cleanAllAnno() {
        List<AbsAnno> list = this.annos;
        synchronized (list) {
            this.annos.clear();
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawBitmap(Canvas canvas, Context c, int defColor) {
        if (canvas == null) {
            return;
        }
        String string = TAG;
        synchronized (TAG) {
            Bitmap b = this.getBitmap();
            canvas.drawColor(defColor);
            if (b == null || b.isRecycled()) {
                GenseeLog.e((String)TAG, (String)("drawBitmap canvas =" + canvas + " reference = " + this.reference));
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return;
            }
            if (bgPaint == null) {
                bgPaint = new Paint(2);
            }
            b.setDensity(c.getResources().getDisplayMetrics().densityDpi);
            canvas.drawBitmap(b, this.matrix, bgPaint);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    public Matrix getMatrix() {
        return this.matrix;
    }

    public int getBitmapW() {
        return this.imgWidth;
    }

    public int getBitmapH() {
        return this.imgHeight;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        try {
            List<AbsAnno> list = this.annos;
            synchronized (list) {
                for (AbsAnno anno : this.annos) {
                    anno.clean();
                }
                this.annos.clear();
            }
        }
        catch (Exception e) {
            GenseeLog.w((String)TAG, (String)("clear " + e.getMessage()));
        }
        this.matrix.reset();
        this.showMode = 0;
        this.recycle();
    }

    public void initBitmap(int w, int h) {
        this.getBitmap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recycle() {
        String string = TAG;
        synchronized (TAG) {
            if (this.reference != null) {
                Bitmap b = this.reference.get();
                GenseeLog.d((String)TAG, (String)("recycle Bitmap = " + b));
                if (b != null) {
                    b.recycle();
                }
                this.reference.clear();
                this.reference = null;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private void saveBitmap(Bitmap bitmap, String fileName) {
        File fdir = new File(PduPage.getFileDir());
        if (!fdir.exists()) {
            boolean ret = fdir.mkdirs();
            GenseeLog.d((String)TAG, (String)("save page make dir ok = " + ret + PduPage.getFileDir()));
            if (!ret) {
                GenseeLog.w((String)"save page make dir fail");
            }
        }
        File imgFile = new File(fdir, fileName);
        try {
            imgFile.createNewFile();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        FileOutputStream outputStream = null;
        try {
            outputStream = new FileOutputStream(imgFile);
            bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)outputStream);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        if (outputStream != null) {
            try {
                outputStream.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                ((OutputStream)outputStream).close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public String getPageName() {
        return this.pageName;
    }

    public void setPageName(String pageName) {
        this.pageName = pageName;
    }

    public int getPageId() {
        return this.pageId;
    }

    public void setPageId(int pageId) {
        this.pageId = pageId;
    }

    public int getDocId() {
        return this.docId;
    }

    public void setDocId(int docId) {
        this.docId = docId;
    }

    public char getImgBitCount() {
        return this.imgBitCount;
    }

    public void setImgBitCount(char imgBitCount) {
        this.imgBitCount = imgBitCount;
    }

    public short getImgWidth() {
        return this.imgWidth;
    }

    public void setImgWidth(short imgWidth) {
        this.imgWidth = imgWidth;
    }

    public short getImgHeight() {
        return this.imgHeight;
    }

    public void setImgHeight(short imgHeight) {
        this.imgHeight = imgHeight;
    }

    public String getThumbData() {
        return this.thumbData;
    }

    public void setThumbData(String thumbData) {
        this.thumbData = thumbData;
    }

    public String getFullText() {
        return this.fullText;
    }

    public void setFullText(String fullText) {
        this.fullText = fullText;
    }

    public String getTitleText() {
        return this.titleText;
    }

    public void setTitleText(String titleText) {
        this.titleText = titleText;
    }

    public String getLinkUrl() {
        return this.linkUrl;
    }

    public void setLinkUrl(String linkUrl) {
        this.linkUrl = linkUrl;
    }

    public String getAniCfg() {
        return this.aniCfg;
    }

    public void setAniCfg(String aniCfg) {
        this.aniCfg = aniCfg;
    }

    public int getAniStep() {
        return this.aniStep;
    }

    public void setAniStep(int aniStep) {
        if (this.aniStep != aniStep) {
            this.aniStep = aniStep;
            this.mHandlerWrapper.sendMessage(142, (Object)this);
        }
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setPath(String path, boolean refresh) {
        this.setPath(path);
        if (refresh) {
            this.mHandlerWrapper.sendMessage(140, (Object)this);
        }
    }

    public String getPath() {
        if (this.nSdkType == 0) {
            return this.getPageSwfFilePath();
        }
        return this.path;
    }

    public void setSdkType(int nSdkType) {
        this.nSdkType = nSdkType;
    }

    public void setAnimationPath(String animationPath) {
        this.animationPath = animationPath;
    }

    public String getAnimationPath() {
        if (this.nSdkType == 0) {
            return this.getPageSwfXmlFilePath();
        }
        return this.animationPath;
    }

    public Bitmap getBitmap() {
        if (this.reference == null || this.reference.get() == null) {
            Bitmap docBitmap = null;
            if (this.path != null) {
                Bitmap temp = null;
                try {
                    temp = BitmapFactory.decodeFile((String)this.path);
                }
                catch (OutOfMemoryError e) {
                    GenseeLog.e((String)TAG, (String)e.toString());
                }
                docBitmap = this.cropImg(temp);
            } else {
                File f = new File(PduPage.getFileDir() + this.getPageFileName());
                if (f.exists()) {
                    try {
                        docBitmap = BitmapFactory.decodeFile((String)f.getPath());
                    }
                    catch (OutOfMemoryError e) {
                        GenseeLog.e((String)TAG, (String)e.toString());
                    }
                }
            }
            if (docBitmap != null) {
                this.reference = new SoftReference<Bitmap>(docBitmap);
            }
        }
        return this.reference == null ? null : this.reference.get();
    }

    private Bitmap cropImg(Bitmap temp) {
        Bitmap docBitmap = null;
        if (temp != null) {
            int bw = temp.getWidth();
            int bh = temp.getHeight();
            if (this.imgWidth > 3000 || this.imgHeight > 3000) {
                GenseeLog.w((String)("PduPage pageWidth = " + this.imgWidth + " bw = " + bw + " bh = " + bh + " pageHeight = " + this.imgHeight));
                this.imgWidth = (short)bw;
                this.imgHeight = (short)bh;
                return temp;
            }
            if (bw != this.imgWidth || bh != this.imgHeight) {
                float scallX = (float)this.imgWidth / (float)bw;
                float scallY = (float)this.imgHeight / (float)bh;
                Matrix m = new Matrix();
                m.postScale(scallX, scallY);
                try {
                    docBitmap = Bitmap.createBitmap((Bitmap)temp, (int)0, (int)0, (int)bw, (int)bh, (Matrix)m, (boolean)true);
                }
                catch (OutOfMemoryError e) {
                    GenseeLog.e((String)TAG, (String)e.toString());
                }
                temp.recycle();
            } else {
                return temp;
            }
        }
        return docBitmap;
    }

    @Override
    public String toString() {
        return "PudPage [pageName=" + this.pageName + ", pageId=" + this.pageId + ", docId=" + this.docId + " w = " + this.imgWidth + " h = " + this.imgHeight + " annos =" + (this.annos == null ? 0 : this.annos.size()) + "]";
    }

    protected String getPageFileName() {
        return "" + this.getDocId() + '_' + this.getPageId() + ".png";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.docId;
        result = 31 * result + this.pageId;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PduPage other = (PduPage)obj;
        if (this.timestamp != other.timestamp) {
            return false;
        }
        if (this.docId != other.docId) {
            return false;
        }
        return this.pageId == other.pageId;
    }

    public void onContent(byte[] data, boolean isShowing, int docId) {
        this.docId = docId;
        File f = new File(PduPage.getFileDir() + this.getPageFileName());
        if (!(f.exists() || this.reference != null && this.reference.get() != null)) {
            Bitmap temp = null;
            try {
                temp = BitmapFactory.decodeByteArray((byte[])data, (int)0, (int)data.length);
            }
            catch (OutOfMemoryError e) {
                GenseeLog.e((String)TAG, (String)e.toString());
            }
            Bitmap docBitmap = this.cropImg(temp);
            if (docBitmap != null) {
                this.saveBitmap(docBitmap, this.getPageFileName());
                if (!isShowing) {
                    this.recycle();
                } else {
                    this.reference = new SoftReference<Bitmap>(docBitmap);
                }
            } else {
                GenseeLog.w((String)"onContent page  decode fail");
            }
        }
        this.mHandlerWrapper.sendMessage(140, (Object)this);
    }

    public boolean isPrepare() {
        if (this.isPrepare) {
            return true;
        }
        this.isPrepare = this.checkPrepare();
        return this.isPrepare;
    }

    private boolean checkPrepare() {
        if (this.isSwfPrepare()) {
            return true;
        }
        File f = new File(PduPage.getFileDir() + this.getPageFileName());
        return f.exists() || this.getBitmap() != null;
    }

    public void initBitmap() {
    }

    public int getShowMode() {
        return this.showMode;
    }

    public void setShowMode(int showMode) {
        this.showMode = showMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanUndoAnno(long userId) {
        List<AbsAnno> list = this.annos;
        synchronized (list) {
            for (AbsAnno anno : this.annos) {
                if (null == anno || anno.getOwner() != userId) continue;
                anno.setOwner(0L);
            }
        }
    }

    public boolean isGlPrepare() {
        if (!this.isSwfPrepare()) {
            return false;
        }
        File swfXmlFile = new File(this.getPageSwfXmlFilePath());
        return swfXmlFile.exists();
    }

    public boolean isSwfPrepare() {
        String path = this.getPath();
        if (null == path) {
            return false;
        }
        File swfFile = new File(path);
        return swfFile.exists();
    }

    private String getPageSwfFilePath() {
        return PduPage.getFileDir() + this.getPageSwfFileName();
    }

    private String getPageSwfXmlFilePath() {
        return PduPage.getFileDir() + this.getPageSwfXmlFileName();
    }

    private String getPageSwfFileName() {
        return "" + this.getDocId() + '_' + this.getPageId() + ".swf";
    }

    private String getPageSwfXmlFileName() {
        return "" + this.getDocId() + '_' + this.getPageId() + ".xml";
    }

    public void onGlContent(byte[] data, boolean isShowing, int docId) {
        File aniCfgFile;
        boolean ret;
        this.docId = docId;
        File fdir = new File(PduPage.getFileDir());
        if (!fdir.exists() && !(ret = fdir.mkdirs())) {
            GenseeLog.w((String)("onGlContent save page make dir fail" + fdir.getAbsolutePath()));
            return;
        }
        File f = new File(this.getPageSwfFilePath());
        if (!f.exists()) {
            this.writeToFile(f, data);
        }
        if (!StringUtil.isEmpty((String)this.aniCfg) && !(aniCfgFile = new File(this.getPageSwfXmlFilePath())).exists()) {
            this.writeToFile(aniCfgFile, this.aniCfg.getBytes());
        }
        this.mHandlerWrapper.sendMessage(140, (Object)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeToFile(File f, byte[] data) {
        FilterOutputStream stream = null;
        try {
            f.createNewFile();
            FileOutputStream fstream = new FileOutputStream(f);
            stream = new BufferedOutputStream(fstream);
            stream.write(data);
            ((BufferedOutputStream)stream).flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public void close() {
        this.clear();
        this.mHandlerWrapper.sendMessage(146, (Object)this.docId);
        this.mHandlerWrapper.setHandler(null);
    }

    public void setHandler(Handler handler) {
        Handler preHandler = this.mHandlerWrapper.getHandler();
        GenseeLog.d((String)TAG, (String)("setHandler pre = " + preHandler + " handler = " + handler));
        this.mHandlerWrapper.setHandler(handler);
        this.mHandlerWrapper.sendMessage(138, (Object)this);
    }

    public void receiveAnno(String xmlAnno, final boolean check) {
        AnnotaionParse.getParse().setOnAnnoParseListener(new AnnotaionParse.OnAnnoParseListener(){

            @Override
            public void onAnno(AbsAnno absAnno) {
                if (absAnno == null) {
                    GenseeLog.w((String)"onAnnotaion anno is null!");
                    return;
                }
                if (check && !PduPage.this.path.contains("_" + absAnno.getPageId())) {
                    return;
                }
                PduPage.this.receiveAnno(absAnno, 0L);
            }
        }).parseAnnoXml(xmlAnno);
    }

    public void receiveAnno(AbsAnno anno, long joinOkTime) {
        switch (anno.getType()) {
            case 18: {
                long nCurTime = SystemClock.elapsedRealtime();
                if (nCurTime - joinOkTime > 3000L && this.mHandlerWrapper.isOk()) {
                    this.onFreePenF((AnnoFreepenEx)anno);
                    break;
                }
            }
            case 16: {
                this.postToAddAnno(anno);
                break;
            }
            case 3: 
            case 23: {
                this.cleanAnno(anno);
                break;
            }
            case 1: 
            case 9: 
            case 17: {
                this.mHandlerWrapper.sendMessage(148, (Object)anno);
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 24: {
                this.addAnno(anno);
                break;
            }
        }
    }

    private void postToAddAnno(final AbsAnno anno) {
        this.mHandlerWrapper.postForce(new Runnable(){

            @Override
            public void run() {
                PduPage.this.addAnno(anno);
            }
        });
    }

    private void addAnno(AbsAnno anno) {
        int nAnnoFlag = this.addAnno(anno, false);
        boolean isPrepared = this.isPrepare();
        if (anno instanceof AnnoPicture) {
            this.pictureAnno((AnnoPicture)anno, nAnnoFlag, isPrepared);
        }
        if (!isPrepared) {
            GenseeLog.w((String)TAG, (String)"addAnno isCurPagePrepared false");
            return;
        }
        if (nAnnoFlag != -1) {
            if (anno instanceof AnnoFreepenEx) {
                long time = System.currentTimeMillis();
                long timeLag = time - this.lastAnnoReceiveTime;
                this.lastAnnoReceiveTime = time;
                if (timeLag < 10L) {
                    this.mHandlerWrapper.removeMessages(136);
                }
                this.mHandlerWrapper.sendMessageDelayed(136, (Object)this.latestAnno, 100L);
            } else {
                if (anno instanceof AnnoPicture) {
                    return;
                }
                if (nAnnoFlag == 0) {
                    this.mHandlerWrapper.sendMessage(136, (Object)anno);
                } else if (nAnnoFlag == 1) {
                    long time = System.currentTimeMillis();
                    long timeLag = time - this.lastAnnoReceiveTime2;
                    this.lastAnnoReceiveTime2 = time;
                    if (timeLag < 80L) {
                        this.mHandlerWrapper.removeMessages(141);
                    }
                    this.mHandlerWrapper.sendMessageDelayed(141, (Object)anno, 100L);
                }
            }
        }
    }

    private boolean cleanAnno(AbsAnno cleaner) {
        this.delAnno(cleaner);
        this.mHandlerWrapper.sendMessage(144, (Object)cleaner);
        return false;
    }

    private void onFreePenF(AnnoFreepenEx anno) {
        int delay = anno.getDelay();
        if (delay == 0) {
            this.postToAddAnno(anno);
            return;
        }
        List<AnnoFPoint> list = anno.getPointList();
        int size = list.size();
        if (size > 0) {
            int count = 0;
            int pTime = delay / size;
            int oldStepType = anno.getStepType();
            for (AnnoFPoint p : list) {
                AnnoFreepenEx tmpPen = AnnoFreepenEx.create(anno);
                tmpPen.appendPoints(new AnnoFPoint[]{p});
                int step = 0;
                switch (oldStepType) {
                    case 1: {
                        step = count == 0 ? 1 : 2;
                        break;
                    }
                    case 2: {
                        step = 2;
                        break;
                    }
                    case 3: {
                        step = count == size - 1 ? 3 : 2;
                        break;
                    }
                    default: {
                        step = count == size - 1 ? 3 : (count == 0 ? 1 : 2);
                    }
                }
                tmpPen.setStepType(step);
                ++count;
                this.postToAddAnno(tmpPen);
                if (pTime > 100) {
                    pTime = 100;
                } else if (pTime <= 0) {
                    pTime = 1;
                }
                try {
                    if (pTime <= 0) continue;
                    Thread.sleep(pTime);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void pictureAnno(final AnnoPicture annoPicture, int addFlag, final boolean refresh) {
        if (refresh && addFlag == 1) {
            this.mHandlerWrapper.sendMessage(141, (Object)annoPicture);
            return;
        }
        final String fileName = annoPicture.getDocId() + String.valueOf(annoPicture.getPageId()) + annoPicture.getId() + ".png";
        String localPath = PduPage.getFileDir() + fileName;
        annoPicture.setLocalPath(localPath);
        File file = new File(localPath);
        if (file.exists()) {
            if (refresh && addFlag == 0) {
                this.mHandlerWrapper.sendMessage(136, (Object)annoPicture);
            }
            return;
        }
        AbsHttpAction.getStream((String)annoPicture.getUrl(), (StreamRes)new StreamRes(){

            public void onRes(InputStream inputStream) {
                Bitmap bitmap = BitmapFactory.decodeStream((InputStream)inputStream);
                if (bitmap != null) {
                    PduPage.this.saveBitmap(bitmap, fileName);
                    try {
                        GenseeLog.d((String)PduPage.TAG, (String)("pictureAnno refresh = " + refresh));
                        if (PduPage.this.isPrepare()) {
                            annoPicture.setBitmap(bitmap);
                            PduPage.this.mHandlerWrapper.sendMessage(141, (Object)annoPicture);
                        } else {
                            bitmap.recycle();
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        GenseeLog.w((String)PduPage.TAG, (String)("pictureAnno " + e.getMessage()));
                    }
                }
            }

            public void onConnectError(int errorType, String errorInfo) {
                GenseeLog.w((String)PduPage.TAG, (String)("pictureAnno onConnectError " + errorInfo));
            }
        });
    }

    static {
        bgPaint = null;
    }
}

