/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.pdu;

import com.gensee.pdu.AbsAnno;
import com.gensee.pdu.PduBase;
import com.gensee.pdu.PduPage;
import com.gensee.utils.GenseeLog;
import java.util.ArrayList;
import java.util.List;

public class PduDoc
extends PduBase {
    private static final String TAG = "PduDoc";
    public static final int RT_PD_DOCUMENT_PPT = 1;
    public static final int RT_PD_DOCUMENT_WORD = 2;
    public static final int RT_PD_DOCUMENT_TXT = 3;
    public static final int RT_PD_DOCUMENT_EXCEL = 4;
    public static final int RT_PD_DOCUMENT_JPEG = 5;
    public static final int RT_PD_DOCUMENT_EMF = 6;
    public static final int RT_PD_DOCUMENT_PDF = 7;
    public static final int RT_PD_DOCUMENT_BMP = 8;
    public static final int RT_PD_DOCUMENT_SWF = 9;
    public static final int RT_PD_DOCUMENT_PPTX = 10;
    public static final int RT_PD_DOCUMENT_SWF_VERYDOC = 16;
    public static final int RT_PD_WHITEBOARD = 32;
    public static final int RT_PD_BLACKBOARD_DEFAULT = 48;
    public static final int RT_PD_BLACKBOARD = 64;
    protected byte dataType;
    private String docName;
    private int docId;
    private int docType;
    private int pageCount;
    private long ownerId;
    protected int pageIndex;
    private byte savedOnServer;
    private boolean isPublish;
    private List<PduPage> mPages;
    private PduPage mCurPage;

    public PduDoc() {
        this.mPages = new ArrayList<PduPage>(0);
    }

    public PduDoc(int docId) {
        this.docId = docId;
    }

    public String getDocName() {
        return this.docName;
    }

    public void setDocName(String docName) {
        this.docName = docName;
    }

    public int getDocId() {
        return this.docId;
    }

    public void setDocId(int docId) {
        this.docId = docId;
    }

    public int getDocType() {
        return this.docType;
    }

    public void setDocType(int docType) {
        this.docType = docType;
    }

    public int getPageCount() {
        return this.pageCount == 0 ? this.mPages.size() : this.pageCount;
    }

    public void setPageCount(int pageCount) {
        this.pageCount = pageCount;
    }

    public long getOwnerId() {
        return this.ownerId;
    }

    public void setOwnerId(long ownerId) {
        this.ownerId = ownerId;
    }

    public byte getSavedOnServer() {
        return this.savedOnServer;
    }

    public void setSavedOnServer(byte savedOnServer) {
        this.savedOnServer = savedOnServer;
    }

    public boolean isPublish() {
        return this.isPublish;
    }

    public void setPublish(boolean publish) {
        this.isPublish = publish;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setPages(PduPage[] pages) {
        if (pages != null) {
            List<PduPage> list = this.mPages;
            synchronized (list) {
                for (int i = 0; i < pages.length; ++i) {
                    pages[i].setDocId(this.docId);
                    this.mPages.add(pages[i]);
                }
            }
        }
    }

    protected PduPage[] getDocPages() {
        int size = this.mPages.size();
        if (size > 0) {
            PduPage[] arr = new PduPage[size];
            return this.mPages.toArray(arr);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PduPage getCurPage() {
        if (this.mCurPage == null) {
            List<PduPage> list = this.mPages;
            synchronized (list) {
                if (this.mPages.size() > 0) {
                    this.mCurPage = this.mPages.get(0);
                }
            }
        }
        return this.mCurPage;
    }

    public int getCurrentPageIndex() {
        int index = 0;
        index = this.mPages.indexOf(this.mCurPage);
        return index >= 0 ? index : 0;
    }

    public PduPage getNextPage() {
        int index = this.mPages.indexOf(this.mCurPage);
        if (index < this.mPages.size() - 1 && index >= 0) {
            return this.mPages.get(index + 1);
        }
        return null;
    }

    public PduPage getPrePage() {
        int index = this.mPages.indexOf(this.mCurPage);
        if (index < this.mPages.size() && index > 0) {
            return this.mPages.get(index - 1);
        }
        return null;
    }

    public PduPage changeCurrentPage(int pageIndex) {
        PduPage page;
        if (this.mPages == null) {
            GenseeLog.e((String)TAG, (String)"changeCurrentPage pages is null");
            return null;
        }
        if (pageIndex >= this.mPages.size()) {
            return null;
        }
        this.mCurPage = page = this.mPages.get(pageIndex);
        return page;
    }

    public List<PduPage> getPages() {
        return this.mPages;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.dataType;
        result = 31 * result + this.docId;
        return result;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Integer) {
            return this.docId == (Integer)obj;
        }
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PduDoc other = (PduDoc)obj;
        return this.docId == other.docId;
    }

    @Override
    public String toString() {
        return "PduDoc [docName=" + this.docName + ", docId=" + this.docId + this.mPages + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addPage(PduPage page) {
        if (page == null) {
            return false;
        }
        List<PduPage> list = this.mPages;
        synchronized (list) {
            if (!this.mPages.contains(page)) {
                return this.mPages.add(page);
            }
            return false;
        }
    }

    public PduPage onCmd(long pageId, int aniStep) {
        PduPage pg = this.getPageById(pageId);
        if (pg != null) {
            this.mCurPage = pg;
            pg.setDocId(this.docId);
            pg.setAniStep(aniStep);
        }
        return pg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PduPage getPageById(long pageId) {
        if (this.mCurPage != null && (long)this.mCurPage.getPageId() == pageId) {
            return this.mCurPage;
        }
        List<PduPage> list = this.mPages;
        synchronized (list) {
            for (PduPage page : this.mPages) {
                if (page == null || (long)page.getPageId() != pageId) continue;
                return page;
            }
        }
        return null;
    }

    public int addAnno(AbsAnno anno) {
        if (this.mCurPage != null && this.mCurPage.getPageId() == anno.getPageId()) {
            return this.mCurPage.addAnno(anno, false);
        }
        PduPage p = this.getPageById(anno.getPageId());
        if (p != null) {
            p.addAnno(anno, false);
        }
        return -1;
    }

    public void receiveAnno(AbsAnno anno, long joinOkTime) {
        PduPage page = this.getPageById(anno.getPageId());
        if (page != null) {
            page.receiveAnno(anno, joinOkTime);
        }
    }

    public boolean delAnno(AbsAnno cleaner) {
        if (this.mCurPage != null && this.mCurPage.getPageId() == cleaner.getPageId()) {
            return this.mCurPage.delAnno(cleaner);
        }
        PduPage p = this.getPageById(cleaner.getPageId());
        if (p != null) {
            p.delAnno(cleaner);
        }
        return false;
    }

    public boolean changePoint(AbsAnno point) {
        if (this.mCurPage != null && this.mCurPage.getPageId() == point.getPageId()) {
            return this.mCurPage.changePoint(point);
        }
        PduPage page = this.getPageById(point.getPageId());
        if (page != null) {
            page.changePoint(point);
        }
        return false;
    }

    public void onGlContent(long blockId, byte[] data, boolean isShowing) {
        PduPage p = this.getPageById(blockId);
        if (p != null) {
            p.onGlContent(data, isShowing, this.docId);
        }
    }

    public void onContent(long blockId, byte[] data, boolean isShowing) {
        PduPage p = this.getPageById(blockId);
        if (p != null) {
            p.onContent(data, isShowing, this.docId);
        }
    }

    public void close() {
        for (PduPage p : this.mPages) {
            p.close();
        }
        this.mPages.clear();
    }

    public void clean(boolean isCurrent) {
        for (PduPage p : this.mPages) {
            if (isCurrent && p != null && p.equals(this.mCurPage)) {
                p.setPageId(-1);
                p.setDocId(-1);
                continue;
            }
            p.clear();
        }
        this.mPages.clear();
        this.mCurPage = null;
    }
}

