/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.pdu;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BlurMaskFilter;
import android.graphics.Canvas;
import android.graphics.EmbossMaskFilter;
import android.graphics.MaskFilter;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.PointF;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Xfermode;
import android.os.Handler;
import android.os.Message;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.ViewConfiguration;
import com.gensee.doc.AnnoInputMode;
import com.gensee.doc.CtrlMode;
import com.gensee.doc.DrawMode;
import com.gensee.doc.LINE_SIZE;
import com.gensee.doc.OnAnnoDataListener;
import com.gensee.doc.OnAnnoDataStatus;
import com.gensee.doc.OnAnnoEraseUserIdListener;
import com.gensee.doc.OnDocViewEventListener;
import com.gensee.pdu.AbsAnno;
import com.gensee.pdu.AnnoAction;
import com.gensee.pdu.AnnoCleaner;
import com.gensee.pdu.AnnoFreepenEx;
import com.gensee.pdu.AnnoLineEx;
import com.gensee.pdu.AnnoPicture;
import com.gensee.pdu.AnnoPointerEx;
import com.gensee.pdu.AnnoText;
import com.gensee.pdu.AnnosFactory;
import com.gensee.pdu.IGSDocView;
import com.gensee.pdu.OnReAndUndoListener;
import com.gensee.pdu.PduPage;
import com.gensee.pdu.ReAndUndoAnnoImpl;
import com.gensee.pdu.ThirdPartyPenAnnoPointer;
import com.gensee.utils.GenseeLog;
import com.gensee.utils.ThreadPool;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DocViewImpl
implements IGSDocView {
    private Bitmap mBitmap;
    private Bitmap defBitmap;
    private Canvas mCanvas;
    private AbsAnno tmpAnno;
    private AnnoPicture annoPicture;
    private HashMap<Long, AbsAnno> receiveAnnos;
    private RectF rectF = new RectF();
    private Paint mPaint;
    private MaskFilter mEmboss;
    private MaskFilter mBlur;
    private DrawMode drawMode = DrawMode.PEN;
    protected PduPage docPage;
    private AnnoAction mAnnoAction;
    private GestureDetector detector;
    private OnDocViewEventListener mOnDocViewClickedListener;
    private int paintColor = -16777216;
    private boolean isHighLight = false;
    private boolean isDefImageFillView;
    private float[] values;
    static final int NONE = 0;
    static final int DRAG = 1;
    static final int ZOOM = 2;
    private static final String TAG = "GSDocView";
    int mode = 0;
    private PointF start = new PointF();
    private PointF mid = new PointF();
    private float oldDist = 1.0f;
    private CtrlMode option = CtrlMode.SIGHT;
    private int bgColor = -1;
    private int w;
    private int h;
    private boolean isGestureforbidden;
    private boolean isTouchforbidden = false;
    private int docShowMode = 0;
    private int mTouchSlop;
    private Handler handler;
    private OnAnnoDataListener onAnnoDataListener;
    private OnAnnoEraseUserIdListener onAnnoEraseUserIdListener;
    private IGSDocView iGsDocView;
    private onDocViewImplListener onDocViewImplListener;
    public int maxRectWidth = 4096;
    public int maxRectHeight = 4096;
    float downX = 0.0f;
    float downY = 0.0f;
    private static float POINTER_MIN_SCALE_INSTANCE = 25.0f;
    private Map<Integer, PointF> pointerDownPoints;
    private Map<Integer, PointF> pointerUpPoints;
    float lastDownX = 0.0f;
    float lastDownY = 0.0f;
    float lastSecondDownX = 0.0f;
    float lastSecondDownY = 0.0f;
    boolean twoPointerDrag = true;
    boolean onePointerAnno = false;
    private List<Integer> pointerIds = new ArrayList<Integer>();
    private OnDocLabelListener onDocLabelListener;
    private ReAndUndoAnnoImpl reAndUndoAnnoImpl;
    private boolean isEndAnimation = true;
    private Matrix mMatrix = new Matrix();
    private float[] mNeedValues = new float[]{1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f};
    private AnnoInputMode annoInputMode = AnnoInputMode.SCREEN;
    private ThirdPartyPenAnnoPointer thirdPartyPenAnnoPointer;
    private boolean isTouchScreenEvent = true;
    private Context context;
    private boolean isMorePoint = false;
    private float mX;
    private float mY;
    private static final float TOUCH_TOLERANCE = 4.0f;
    boolean isTouchDown = false;

    @Override
    public void setAnnoInputMode(AnnoInputMode annoInputMode) {
        this.annoInputMode = annoInputMode;
        GenseeLog.d((String)TAG, (String)("setAnnoInputMode annoInputMode = " + annoInputMode.getValue()));
    }

    public AnnoInputMode getAnnoInputMode() {
        return this.annoInputMode;
    }

    @Override
    public void setEndAnimation(boolean endAnimation) {
        this.isEndAnimation = endAnimation;
    }

    @Override
    public void setOnDocLabelListener(OnDocLabelListener onDocLabelListener) {
        this.onDocLabelListener = onDocLabelListener;
    }

    public void setMaxRectWidth(int maxRectWidth) {
        this.maxRectWidth = maxRectWidth;
    }

    public void setMaxRectHeight(int maxRectHeight) {
        this.maxRectHeight = maxRectHeight;
    }

    public void setOnDocViewImplListener(onDocViewImplListener onDocViewEventListener) {
        this.onDocViewImplListener = onDocViewEventListener;
    }

    @Override
    public void setOnAnnoEraseUserIdListener(OnAnnoEraseUserIdListener onAnnoEraseUserIdListener) {
        this.onAnnoEraseUserIdListener = onAnnoEraseUserIdListener;
    }

    @Override
    public void setOnAnnoDataListener(OnAnnoDataListener onAnnoDataListener) {
        this.onAnnoDataListener = onAnnoDataListener;
    }

    @Override
    public Handler getHandler() {
        return this.handler;
    }

    public DocViewImpl(Context context, final IGSDocView iGsDocView) {
        this.context = context;
        this.pointerDownPoints = new HashMap<Integer, PointF>();
        this.pointerUpPoints = new HashMap<Integer, PointF>();
        POINTER_MIN_SCALE_INSTANCE = context.getResources().getDisplayMetrics().density * 25.0f;
        this.iGsDocView = iGsDocView;
        this.handler = new MyHandler();
        ViewConfiguration configuration = ViewConfiguration.get((Context)context);
        this.mTouchSlop = configuration.getScaledTouchSlop();
        this.values = new float[]{1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f};
        this.mCanvas = new Canvas();
        this.mPaint = new Paint();
        this.mPaint.setAntiAlias(true);
        this.mPaint.setDither(true);
        this.mPaint.setColor(-16777216);
        this.mPaint.setStyle(Paint.Style.STROKE);
        this.mPaint.setStrokeJoin(Paint.Join.ROUND);
        this.mPaint.setStrokeCap(Paint.Cap.ROUND);
        this.mPaint.setStrokeWidth((float)LINE_SIZE.M.getValue());
        this.mEmboss = new EmbossMaskFilter(new float[]{1.0f, 1.0f, 1.0f}, 0.4f, 6.0f, 3.5f);
        this.mBlur = new BlurMaskFilter(8.0f, BlurMaskFilter.Blur.NORMAL);
        this.detector = new GestureDetector(context, (GestureDetector.OnGestureListener)new GestureDetector.SimpleOnGestureListener(){

            public boolean onDoubleTap(MotionEvent e) {
                boolean bTrue;
                if (DocViewImpl.this.option == CtrlMode.EDIT) {
                    return true;
                }
                boolean bl = bTrue = DocViewImpl.this.mOnDocViewClickedListener != null && DocViewImpl.this.mOnDocViewClickedListener.onDoubleClicked(iGsDocView);
                if (!bTrue) {
                    DocViewImpl.this.switchShowMode();
                    return false;
                }
                return true;
            }

            public boolean onSingleTapConfirmed(MotionEvent e) {
                if (DocViewImpl.this.option == CtrlMode.EDIT) {
                    DocViewImpl.this.downX = e.getX();
                    DocViewImpl.this.downY = e.getY();
                    if (DocViewImpl.this.drawMode == DrawMode.PEN) {
                        if (null != DocViewImpl.this.onDocLabelListener) {
                            DocViewImpl.this.onDocLabelListener.onDocLabelSingleClick();
                        }
                    } else if (DocViewImpl.this.drawMode == DrawMode.PICTURE) {
                        DocViewImpl.this.selectPictureAnno(DocViewImpl.this.downX, DocViewImpl.this.downY);
                    } else if (DocViewImpl.this.drawMode == DrawMode.TEXT && DocViewImpl.this.mOnDocViewClickedListener != null) {
                        return DocViewImpl.this.mOnDocViewClickedListener.onSingleClicked(iGsDocView);
                    }
                    return true;
                }
                if (DocViewImpl.this.mOnDocViewClickedListener != null) {
                    return DocViewImpl.this.mOnDocViewClickedListener.onSingleClicked(iGsDocView);
                }
                return super.onSingleTapConfirmed(e);
            }
        });
        this.reAndUndoAnnoImpl = new ReAndUndoAnnoImpl(this);
    }

    public void sizeChanged(int w, int h) {
        if (this.mCanvas == null) {
            this.mCanvas = new Canvas();
        }
        if (w != 0 && h != 0) {
            this.w = w;
            this.h = h;
            Bitmap b = this.mBitmap;
            this.mBitmap = this.createBitmap(w, h);
            if (b != null) {
                b.recycle();
            }
            if (this.mBitmap == null) {
                this.mBitmap = this.createBitmap(w, h);
            }
            if (this.mBitmap != null) {
                this.mCanvas.setBitmap(this.mBitmap);
            }
            if (this.docPage != null) {
                this.viewAndDocChange(this.docPage, w, h);
            } else {
                this.drawDefBitmap(this.defBitmap, this.isDefImageFillView);
            }
        }
    }

    private Bitmap createBitmap(int w, int h) {
        Bitmap b = null;
        try {
            b = Bitmap.createBitmap((int)w, (int)h, (Bitmap.Config)Bitmap.Config.ARGB_4444);
        }
        catch (OutOfMemoryError e) {
            GenseeLog.w((String)("GSDocView->" + e));
        }
        catch (Exception e) {
            GenseeLog.w((String)("GSDocView->" + e));
            e.printStackTrace();
        }
        return b;
    }

    public void drawAnnos(Canvas canvas) {
        canvas.drawColor(this.bgColor);
        if (this.docPage != null) {
            if (!this.isDrawAnnos()) {
                GenseeLog.w((String)TAG, (String)"onDraw anno need not draw");
                return;
            }
            this.drawDocPage(this.docPage, canvas, this.bgColor);
            canvas.clipRect(this.rectF);
            if (this.mBitmap != null) {
                canvas.drawBitmap(this.mBitmap, 0.0f, 0.0f, new Paint(4));
                if (this.receiveAnnos != null) {
                    for (AbsAnno anno : this.receiveAnnos.values()) {
                        anno.drawOnViewCanvas(canvas, this.docPage.getMatrix());
                    }
                }
            } else {
                GenseeLog.e((String)TAG, (String)"onDraw anno mBitmap is null");
            }
            if (this.option == CtrlMode.EDIT) {
                AbsAnno anno;
                if ((DrawMode.PEN == this.drawMode || DrawMode.LINE == this.drawMode || DrawMode.RECT == this.drawMode || DrawMode.CIRCLE == this.drawMode || DrawMode.LINE_ARROW == this.drawMode || DrawMode.LINE_DASH == this.drawMode || this.drawMode == DrawMode.PICTURE) && (anno = this.tmpAnno) != null) {
                    anno.touchDraw(canvas, this.docPage.getMatrix());
                }
                if (null != this.thirdPartyPenAnnoPointer) {
                    this.thirdPartyPenAnnoPointer.draw(canvas, this.docPage.getMatrix());
                }
            }
        } else if (this.defBitmap != null && this.mBitmap != null) {
            canvas.drawBitmap(this.mBitmap, 0.0f, 0.0f, new Paint(4));
        }
    }

    public void setBackgroundColor(int color) {
        this.bgColor = color;
    }

    @Override
    public void setOnDocViewClickedListener(OnDocViewEventListener l) {
        this.mOnDocViewClickedListener = l;
    }

    @Override
    public void forbidZoomGestrue(boolean isFobid) {
        this.isGestureforbidden = isFobid;
    }

    @Override
    public void setTouchforbidden(boolean isTouchforbidden) {
        this.isTouchforbidden = isTouchforbidden;
    }

    private boolean isHandAnnoInputMode() {
        return this.annoInputMode == AnnoInputMode.HAND && this.isTouchScreenEvent;
    }

    private void touch_start(float x, float y) {
        this.mX = x;
        this.mY = y;
        this.downX = x;
        this.downY = y;
        switch (this.drawMode) {
            case ERASE: {
                break;
            }
            case ERASE_ALL: {
                break;
            }
            case DOC_TIP: {
                break;
            }
            case PEN: {
                if (this.isHandAnnoInputMode()) {
                    return;
                }
                this.tmpAnno = this.sendFreepenEx(x, y, 1);
                this.tmpAnno.touchDown(x, y);
                break;
            }
            case LINE: {
                this.tmpAnno = (AnnoLineEx)this.createAnno(21, 0);
                this.tmpAnno.touchDown(x, y);
                break;
            }
            case LINE_ARROW: {
                this.tmpAnno = (AnnoLineEx)this.createAnno(21, 2);
                this.tmpAnno.touchDown(x, y);
                break;
            }
            case LINE_DASH: {
                this.tmpAnno = this.createAnno(21, 1);
                this.tmpAnno.touchDown(x, y);
                break;
            }
            case RECT: {
                this.tmpAnno = this.createAnno(20, 0);
                this.tmpAnno.touchDown(x, y);
                break;
            }
            case CIRCLE: {
                this.tmpAnno = this.createAnno(5, 0);
                this.tmpAnno.touchDown(x, y);
                break;
            }
            case PICTURE: {
                if (this.annoPicture == null) break;
                this.annoPicture.touchDown(x, y);
                break;
            }
        }
    }

    private AbsAnno createAnno(int annoType, int subType) {
        AbsAnno anno = AnnosFactory.crateAnnoByType(annoType, subType);
        anno.setLinesize((byte)this.mPaint.getStrokeWidth());
        anno.setArgbColor(this.mPaint.getColor());
        anno.setPageId(this.docPage.getPageId());
        return anno;
    }

    private void touch_move(float x, float y) {
        switch (this.drawMode) {
            case DOC_TIP: {
                this.mX = x;
                this.mY = y;
                this.doDocTip(this.mX, this.mY);
                break;
            }
            case PEN: {
                if (this.isHandAnnoInputMode()) {
                    return;
                }
                this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        if (null != DocViewImpl.this.onDocLabelListener) {
                            DocViewImpl.this.onDocLabelListener.onDocLabelStart();
                        }
                    }
                });
                this.mX = x;
                this.mY = y;
                this.sendFreepenEx(x, y, 2);
                AbsAnno absAnno = this.tmpAnno;
                if (null == absAnno) break;
                absAnno.touchMove(x, y);
                break;
            }
            case LINE: 
            case LINE_ARROW: 
            case LINE_DASH: 
            case RECT: {
                if (!this.isMoveValid(x, y)) break;
                this.mX = x;
                this.mY = y;
                AbsAnno anno = this.tmpAnno;
                if (null == anno) break;
                anno.touchMove(x, y);
                break;
            }
            case CIRCLE: {
                if (null == this.tmpAnno) break;
                this.tmpAnno.touchMove(x, y);
                break;
            }
            case PICTURE: {
                if (this.annoPicture == null || !this.isMoveValid(x, y)) break;
                this.annoPicture.touchMove(x, y);
                this.drawDocPage(this.docPage, this.mCanvas, this.bgColor);
                this.docPage.drawAnno(this.mCanvas);
                this.synPic(this.annoPicture);
                break;
            }
        }
    }

    private void synPic(AbsAnno anno) {
        if (this.mAnnoAction != null) {
            this.mAnnoAction.modifyAnno(anno);
        }
    }

    private boolean isMoveValid(float x, float y) {
        float dx = Math.abs(x - this.mX);
        float dy = Math.abs(y - this.mY);
        return dx >= 4.0f || dy >= 4.0f;
    }

    private void touch_up() {
        switch (this.drawMode) {
            case ERASE: {
                AbsAnno anno = this.docPage.cleanAnno(this.mX, this.mY);
                long nEraseUserId = 0L;
                if (null != this.onAnnoEraseUserIdListener) {
                    nEraseUserId = this.onAnnoEraseUserIdListener.getAnnoEraseUserId();
                }
                if (nEraseUserId > 0L) {
                    if (null != anno && anno.getOwner() == nEraseUserId) {
                        this.deleteAnno(anno);
                    } else {
                        anno = null;
                    }
                } else {
                    this.deleteAnno(anno);
                }
                if (null == this.onAnnoDataListener || null == anno) break;
                this.onAnnoDataListener.onAnnoData(anno, OnAnnoDataStatus.DEL);
                break;
            }
            case ERASE_ALL: {
                break;
            }
            case DOC_TIP: {
                AnnoPointerEx annoPointerEx = this.doDocTip(this.mX, this.mY);
                if (null == this.onAnnoDataListener || null == annoPointerEx) break;
                this.onAnnoDataListener.onAnnoData(annoPointerEx, OnAnnoDataStatus.NEW);
                break;
            }
            case PEN: {
                AbsAnno freepenAnno;
                if (this.isHandAnnoInputMode()) {
                    return;
                }
                if (null != this.tmpAnno) {
                    this.handler.post(new Runnable(){

                        @Override
                        public void run() {
                            if (null != DocViewImpl.this.onDocLabelListener) {
                                DocViewImpl.this.onDocLabelListener.onDocLabelStop();
                            }
                        }
                    });
                    this.mX = (float)((double)this.mX + 0.5);
                    this.mY = (float)((double)this.mY + 0.5);
                }
                if ((freepenAnno = this.tmpAnno) != null) {
                    freepenAnno.touchUp(this.mX, this.mY);
                    if (this.docPage != null) {
                        this.docPage.addAnno(freepenAnno, true);
                    }
                    this.sendFreepenEx(this.mX, this.mY, 3);
                    this.transAnnoToCache();
                    if (null != this.onAnnoDataListener) {
                        this.onAnnoDataListener.onAnnoData(freepenAnno, OnAnnoDataStatus.NEW);
                    }
                }
                this.tmpAnno = null;
                break;
            }
            case LINE: 
            case LINE_ARROW: 
            case LINE_DASH: 
            case RECT: 
            case CIRCLE: {
                AbsAnno absAnno = this.tmpAnno;
                if (absAnno != null) {
                    absAnno.touchUp(0.0f, 0.0f);
                    if (this.docPage != null) {
                        this.docPage.addAnno(absAnno, true);
                    }
                    this.sendAnno(absAnno);
                    this.transAnnoToCache();
                    if (null != this.onAnnoDataListener) {
                        this.onAnnoDataListener.onAnnoData(absAnno, OnAnnoDataStatus.NEW);
                    }
                }
                this.tmpAnno = null;
                break;
            }
        }
    }

    private void transAnnoToCache() {
        if (this.tmpAnno != null) {
            this.tmpAnno.touchDraw(this.mCanvas, this.docPage.getMatrix());
        }
    }

    private AnnoPointerEx doDocTip(float x, float y) {
        if (this.mAnnoAction != null) {
            AnnoPointerEx pointerEx = (AnnoPointerEx)this.createAnno(17, 0);
            byte pType = 0;
            pointerEx.setPointerType(pType);
            pointerEx.setX(x);
            pointerEx.setY(y);
            pointerEx.setPageId(this.docPage.getPageId());
            pointerEx.setDocId(this.docPage.getDocId());
            this.docPage.changePoint(pointerEx);
            this.mAnnoAction.sendAnno(pointerEx, null);
            this.drawDocPage(this.docPage, this.mCanvas, this.bgColor);
            this.docPage.drawAnno(this.mCanvas);
            return pointerEx;
        }
        return null;
    }

    @Override
    public void setThirdPartyMotionEvent(MotionEvent robotMotionEvent) {
        if (null == this.docPage || this.annoInputMode == AnnoInputMode.SCREEN || this.option != CtrlMode.EDIT) {
            return;
        }
        float[] values = new float[9];
        this.docPage.getMatrix().getValues(values);
        float windowX = robotMotionEvent.getX() * values[0] + values[2];
        float windowY = robotMotionEvent.getY() * values[4] + values[5];
        int action = robotMotionEvent.getAction();
        MotionEvent event = MotionEvent.obtain((long)robotMotionEvent.getDownTime(), (long)robotMotionEvent.getEventTime(), (int)action, (float)windowX, (float)windowY, (int)0);
        if (action == 0 || action == 2 || action == 1) {
            if (null != this.thirdPartyPenAnnoPointer) {
                this.thirdPartyPenAnnoPointer = null;
                this.getHandler().sendMessage(this.getHandler().obtainMessage(147, null));
            }
            if (DrawMode.PEN == this.drawMode) {
                this.isTouchScreenEvent = false;
                this.onTouchEvent(event, false);
            }
        } else if (action == 7) {
            ThirdPartyPenAnnoPointer thirdPartyPenAnnoPointer = new ThirdPartyPenAnnoPointer();
            thirdPartyPenAnnoPointer.x = (int)robotMotionEvent.getX();
            thirdPartyPenAnnoPointer.y = (int)robotMotionEvent.getY();
            this.getHandler().removeMessages(147);
            this.getHandler().sendMessage(this.getHandler().obtainMessage(147, (Object)thirdPartyPenAnnoPointer));
        } else if (action == 3) {
            this.getHandler().sendMessage(this.getHandler().obtainMessage(147, null));
        }
    }

    public int setTouchScreenEvent(MotionEvent motionEvent) {
        this.isTouchScreenEvent = true;
        return this.onTouchEvent(motionEvent, true);
    }

    private boolean judgeDistance(float xDistance, float yDistance, boolean isJudgeDistance) {
        if (isJudgeDistance) {
            return this.context.getResources().getDisplayMetrics().density * Math.abs(xDistance) >= POINTER_MIN_SCALE_INSTANCE || this.context.getResources().getDisplayMetrics().density * Math.abs(yDistance) >= POINTER_MIN_SCALE_INSTANCE;
        }
        return true;
    }

    public int onTouchEvent(MotionEvent event, boolean isJudgeDistance) {
        if (this.option == CtrlMode.SIGHT) {
            if (this.isTouchforbidden) {
                return -1;
            }
            if (this.detector.onTouchEvent(event)) {
                return 1;
            }
            int action = event.getAction() & 0xFF;
            if (action == 0) {
                this.isTouchDown = true;
            } else if (action == 1 || action == 3 || action == 2) {
                if (!this.isTouchDown) {
                    GenseeLog.e((String)TAG, (String)("onTouchEvent detector action = " + action));
                }
                this.isTouchDown = false;
            }
            return this.scale(event);
        }
        if (this.docPage == null) {
            GenseeLog.e((String)"onTouchEvent", (String)"docPage is null! ");
            return 0;
        }
        float x = event.getX();
        float y = event.getY();
        int pointerIndex = event.getActionIndex();
        int pointerId = event.getPointerId(pointerIndex);
        switch (event.getAction() & 0xFF) {
            case 0: {
                this.mMatrix = new Matrix(this.docPage.getMatrix());
                this.onePointerAnno = false;
                if (this.drawMode == DrawMode.ERASE || this.drawMode == DrawMode.ERASE_ALL || this.drawMode == DrawMode.DOC_TIP || this.drawMode == DrawMode.PICTURE) {
                    this.docPage.getMatrix().getValues(this.values);
                    this.rectF.set(this.values[2], this.values[5], (float)this.docPage.getBitmapW() * this.values[0] + this.values[2], (float)this.docPage.getBitmapH() * this.values[4] + this.values[5]);
                    this.touch_start((x - this.values[2]) / this.values[0], (y - this.values[5]) / this.values[4]);
                    this.invalidate();
                    this.onePointerAnno = true;
                }
                this.pointerIds.add(pointerId);
                this.lastDownX = x;
                this.lastDownY = y;
                this.setPointerDownPoint(event, pointerId);
                break;
            }
            case 5: {
                this.isMorePoint = true;
                this.pointerIds.add(pointerId);
                this.setPointerDownPoint(event, pointerId);
                if (this.pointerIds.size() != 2) break;
                if (this.onePointerAnno) {
                    this.touch_up();
                    this.invalidate();
                    this.onePointerAnno = false;
                }
                this.resetTwoPointerStatus(event);
                break;
            }
            case 2: {
                if (event.getPointerCount() == 1) {
                    if (!this.onePointerAnno) {
                        if (this.drawMode == DrawMode.PEN) {
                            if (!this.isMorePoint) {
                                this.move_touch_start();
                            }
                        } else if (this.judgeDistance(x - this.lastDownX, y - this.lastDownY, isJudgeDistance)) {
                            this.move_touch_start();
                        }
                    }
                    if (!this.onePointerAnno) break;
                    this.touch_move((x - this.values[2]) / this.values[0], (y - this.values[5]) / this.values[4]);
                    this.invalidate();
                    break;
                }
                if (event.getPointerCount() != 2) break;
                this.processTwoPointerDragOrScale(event);
                break;
            }
            case 6: {
                this.pointerIds.remove((Object)pointerId);
                this.removePointerPointById(pointerId);
                if (this.pointerIds.size() == 1) {
                    int nSelectPointerId = this.pointerIds.get(0);
                    int nActionIndex = event.findPointerIndex(nSelectPointerId);
                    x = event.getX(nActionIndex);
                    y = event.getY(nActionIndex);
                    if (!this.twoPointerDrag) {
                        this.twoPointerDrag = true;
                        this.dragDown((x - this.values[2]) / this.values[0], (y - this.values[5]) / this.values[4]);
                        this.setPointerDownPoint(event, nSelectPointerId);
                    }
                    this.lastDownX = x;
                    this.lastDownY = y;
                    this.onePointerAnno = false;
                    break;
                }
                if (this.pointerIds.size() != 2) break;
                this.resetTwoPointerStatus(event);
                break;
            }
            case 3: {
                GenseeLog.w((String)TAG, (String)"onTouchEvent ACTION_CANCEL");
            }
            case 1: {
                this.pointerIds.clear();
                this.setPointerUpPoint(event, pointerId);
                this.scaleOrDragActionUp(x, y, pointerId);
                if (this.onePointerAnno) {
                    this.touch_up();
                    this.invalidate();
                    this.onePointerAnno = false;
                }
                this.removePointerPointById(pointerId);
                this.isMorePoint = false;
            }
        }
        this.detector.onTouchEvent(event);
        return 1;
    }

    private void move_touch_start() {
        this.onePointerAnno = true;
        this.docPage.getMatrix().getValues(this.values);
        this.rectF.set(this.values[2], this.values[5], (float)this.docPage.getBitmapW() * this.values[0] + this.values[2], (float)this.docPage.getBitmapH() * this.values[4] + this.values[5]);
        this.touch_start((this.lastDownX - this.values[2]) / this.values[0], (this.lastDownY - this.values[5]) / this.values[4]);
        this.invalidate();
    }

    private void resetTwoPointerStatus(MotionEvent event) {
        if (this.pointerIds.size() < 2) {
            return;
        }
        int firstIndex = event.findPointerIndex(this.pointerIds.get(0).intValue());
        int secondIndex = event.findPointerIndex(this.pointerIds.get(1).intValue());
        if (firstIndex < 0 || secondIndex < 0) {
            GenseeLog.d((String)TAG, (String)(" resetTwoPointerStatus pointerid0 = " + this.pointerIds.get(0) + " pointerid1 = " + this.pointerIds.get(1) + " firstIndex = " + firstIndex + " secondIndex = " + secondIndex));
            return;
        }
        this.oldDist = this.spacing(event, firstIndex, secondIndex);
        this.docPage.getMatrix().getValues(this.values);
        float nFirstX = event.getX(firstIndex);
        float nFirstY = event.getY(firstIndex);
        this.dragDown((nFirstX - this.values[2]) / this.values[0], (nFirstY - this.values[5]) / this.values[4]);
        this.midPoint(this.mid, event, firstIndex, secondIndex);
        this.lastDownX = nFirstX;
        this.lastDownY = nFirstY;
        float secondX = event.getX(secondIndex);
        float secondY = event.getY(secondIndex);
        this.lastSecondDownX = secondX;
        this.lastSecondDownY = secondY;
    }

    private void processTwoPointerDragOrScale(MotionEvent event) {
        if (this.pointerIds.size() < 2) {
            return;
        }
        int firstIndex = event.findPointerIndex(this.pointerIds.get(0).intValue());
        int secondIndex = event.findPointerIndex(this.pointerIds.get(1).intValue());
        if (firstIndex < 0 || secondIndex < 0) {
            GenseeLog.d((String)TAG, (String)(" processTwoPointerDragOrScale pointerid0 = " + this.pointerIds.get(0) + " pointerid1 = " + this.pointerIds.get(1) + " firstIndex = " + firstIndex + " secondIndex = " + secondIndex));
            return;
        }
        float nCurDownX = event.getX(firstIndex);
        float nCurDownY = event.getY(firstIndex);
        float nCurSecondX = event.getX(secondIndex);
        float nCurSecondY = event.getY(secondIndex);
        float pointerMoveInstance = this.spacing(event, firstIndex, secondIndex);
        boolean bEqualOritention = this.isEqualOritention(nCurDownX, nCurDownY, nCurSecondX, nCurSecondY);
        if (!bEqualOritention) {
            if (this.twoPointerDrag) {
                this.twoPointerDrag = false;
                this.docPage.getMatrix().getValues(this.values);
                float midX = (this.lastDownX + this.lastSecondDownX) / 2.0f;
                float midY = (this.lastDownY + this.lastSecondDownY) / 2.0f;
                this.mid.set(midX, midY);
            }
            float newDist = pointerMoveInstance;
            this.scaleActionMoveZoom(newDist);
            this.invalidate();
        } else {
            if (!this.twoPointerDrag) {
                this.twoPointerDrag = true;
                this.docPage.getMatrix().getValues(this.values);
                this.dragDown((this.lastDownX - this.values[2]) / this.values[0], (this.lastDownY - this.values[5]) / this.values[4]);
                this.setPointerDownPoint(event, this.pointerIds.get(0));
                this.setPointerDownPoint(event, this.pointerIds.get(1));
            }
            float firstX = event.getX(firstIndex);
            float firstY = event.getY(firstIndex);
            this.scaleActionMoveDrag(firstX, firstY);
            this.invalidate();
        }
        this.oldDist = pointerMoveInstance;
        this.lastDownX = nCurDownX;
        this.lastDownY = nCurDownY;
        this.lastSecondDownX = nCurSecondX;
        this.lastSecondDownY = nCurSecondY;
    }

    private void scaleOrDragActionUp(float x, float y, int pointerId) {
        int bw = this.docPage.getBitmapW();
        int bh = this.docPage.getBitmapH();
        int endType = 0;
        if (this.isEndAnimation) {
            endType = this.dragUpBound(this.docPage.getMatrix(), this.values, false, bw, bh);
        } else if (this.option == CtrlMode.EDIT && this.onePointerAnno) {
            endType = this.dragUpBound(this.docPage.getMatrix(), this.values, false, bw, bh);
            GenseeLog.d((String)TAG, (String)("scaleOrDragActionUp onePointerAnno = " + this.onePointerAnno));
        } else {
            this.dragUpBound(this.docPage.getMatrix(), this.values, false, bw, bh);
            endType = this.dragUpBound(this.mMatrix, this.mNeedValues, false, bw, bh);
        }
        GenseeLog.d((String)TAG, (String)("scaleOrDragActionUp endType = " + endType));
        this.rectF.set(this.values[2], this.values[5], (float)bw * this.values[0] + this.values[2], (float)bh * this.values[4] + this.values[5]);
        this.drawDocPage(this.docPage, this.mCanvas, this.bgColor);
        this.onDocBound(this.rectF, this.w, this.h);
        this.docPage.drawAnno(this.mCanvas);
        if (endType != 0 && this.mOnDocViewClickedListener != null) {
            if (null != this.pointerDownPoints.get(pointerId) && null != this.pointerUpPoints.get(pointerId)) {
                PointF start = this.pointerDownPoints.get(pointerId);
                PointF end = this.pointerUpPoints.get(pointerId);
                float xMov = Math.abs(end.x - start.x);
                float yMove = Math.abs(end.y - start.y);
                if (xMov > 0.0f) {
                    double at = Math.toRadians(Math.atan(yMove / xMov));
                    double degree = Math.toDegrees(at * 57.29577951308232);
                    double length = Math.sqrt(xMov * xMov + yMove * yMove);
                    GenseeLog.d((String)TAG, (String)("xMov = " + xMov + " yMove = " + yMove + " abs(xMov-yMov) = " + length + " mTouchSlop= " + this.mTouchSlop + " degree = " + degree));
                    if (length >= (double)(3 * this.mTouchSlop) && degree >= 0.0 && degree <= 60.0) {
                        this.mOnDocViewClickedListener.onEndHDirection(this.iGsDocView, endType, 2);
                    }
                }
            } else {
                GenseeLog.e((String)TAG, (String)"bound process error");
            }
        }
        this.invalidate();
    }

    private boolean isEqualOritention(float nCurDownX, float nCurDownY, float nCurSecondX, float nCurSecondY) {
        float xFirstOriention = nCurDownX - this.lastDownX;
        float yFirstOriention = nCurDownY - this.lastDownY;
        float xSecondOriention = nCurSecondX - this.lastSecondDownX;
        float ySecondOriention = nCurSecondY - this.lastSecondDownY;
        return xFirstOriention < 0.0f && xSecondOriention < 0.0f || xFirstOriention > 0.0f && xSecondOriention > 0.0f || yFirstOriention > 0.0f && ySecondOriention > 0.0f || yFirstOriention < 0.0f && ySecondOriention < 0.0f;
    }

    private int scale(MotionEvent event) {
        if (this.docPage == null) {
            return 1;
        }
        if (this.isGestureforbidden) {
            return -1;
        }
        float x = event.getX();
        float y = event.getY();
        int pointerIndex = event.getActionIndex();
        int pointerId = event.getPointerId(pointerIndex);
        switch (event.getAction() & 0xFF) {
            case 0: {
                this.mMatrix = new Matrix(this.docPage.getMatrix());
                this.docPage.getMatrix().getValues(this.values);
                this.dragDown((x - this.values[2]) / this.values[0], (y - this.values[5]) / this.values[4]);
                this.pointerIds.add(pointerId);
                this.lastDownX = x;
                this.lastDownY = y;
                this.setPointerDownPoint(event, pointerId);
                break;
            }
            case 5: {
                this.pointerIds.add(pointerId);
                this.setPointerDownPoint(event, pointerId);
                if (this.pointerIds.size() != 2) break;
                this.resetTwoPointerStatus(event);
                break;
            }
            case 3: {
                GenseeLog.w((String)TAG, (String)"scale ACTION_CANCEL");
            }
            case 1: {
                this.pointerIds.clear();
                this.setPointerUpPoint(event, pointerId);
                this.scaleOrDragActionUp(x, y, pointerId);
                this.removePointerPointById(pointerId);
                break;
            }
            case 6: {
                this.pointerIds.remove((Object)pointerId);
                this.removePointerPointById(pointerId);
                if (this.pointerIds.size() == 1) {
                    int nSelectPointerId = this.pointerIds.get(0);
                    int nActionIndex = event.findPointerIndex(nSelectPointerId);
                    x = event.getX(nActionIndex);
                    y = event.getY(nActionIndex);
                    if (!this.twoPointerDrag) {
                        this.twoPointerDrag = true;
                        this.dragDown((x - this.values[2]) / this.values[0], (y - this.values[5]) / this.values[4]);
                        this.setPointerDownPoint(event, nSelectPointerId);
                    }
                    this.lastDownX = x;
                    this.lastDownY = y;
                    break;
                }
                if (this.pointerIds.size() != 2) break;
                this.resetTwoPointerStatus(event);
                break;
            }
            case 2: {
                if (this.pointerIds.size() == 1) {
                    this.scaleActionMoveDrag(x, y);
                    break;
                }
                if (this.pointerIds.size() != 2) break;
                this.processTwoPointerDragOrScale(event);
            }
        }
        this.invalidate();
        return 1;
    }

    private void setPointerDownPoint(MotionEvent event, int pointerId) {
        int index = event.findPointerIndex(pointerId);
        float x = event.getX(index);
        float y = event.getY(index);
        this.pointerDownPoints.put(pointerId, new PointF(x, y));
    }

    private void setPointerUpPoint(MotionEvent event, int pointerId) {
        int index = event.findPointerIndex(pointerId);
        float x = event.getX(index);
        float y = event.getY(index);
        this.pointerUpPoints.put(pointerId, new PointF(x, y));
    }

    private void removePointerPointById(int pointerId) {
        this.pointerUpPoints.remove(pointerId);
        this.pointerDownPoints.remove(pointerId);
    }

    private void scaleActionMoveZoom(float newDist) {
        int bw = this.docPage.getBitmapW();
        int bh = this.docPage.getBitmapH();
        float scale = newDist / this.oldDist;
        this.oldDist = newDist;
        if (this.annoPicture != null && CtrlMode.EDIT == this.option && DrawMode.PICTURE == this.drawMode) {
            this.annoPicture.scall(scale, (this.mid.x - this.values[2]) / this.values[0], (this.mid.y - this.values[5]) / this.values[4]);
            this.drawDocPage(this.docPage, this.mCanvas, this.bgColor);
            this.docPage.drawAnno(this.mCanvas);
            this.synPic(this.annoPicture);
            return;
        }
        float minScall = this.getMinScall(bw, bh);
        float maxScall = Math.min((float)this.maxRectWidth / (float)bw, (float)this.maxRectHeight / (float)bh);
        this.docPage.getMatrix().getValues(this.values);
        if (scale * this.values[0] > maxScall) {
            scale = maxScall / this.values[0];
        }
        if (scale * this.values[0] < minScall) {
            scale = minScall / this.values[0];
        }
        this.docPage.getMatrix().postScale(scale, scale, this.mid.x, this.mid.y);
        this.docPage.getMatrix().getValues(this.values);
        if (null != this.mMatrix && !this.isEndAnimation) {
            this.mMatrix.getValues(this.mNeedValues);
            if (scale * this.mNeedValues[0] > maxScall) {
                scale = maxScall / this.mNeedValues[0];
            }
            if (scale * this.mNeedValues[0] < minScall) {
                scale = minScall / this.mNeedValues[0];
            }
            this.mMatrix.postScale(scale, scale, this.mid.x, this.mid.y);
            this.mMatrix.getValues(this.mNeedValues);
        }
        this.rectF.set(this.values[2], this.values[5], (float)bw * this.values[0] + this.values[2], (float)bh * this.values[4] + this.values[5]);
        this.drawDocPage(this.docPage, this.mCanvas, this.bgColor);
        this.docPage.drawAnno(this.mCanvas);
        this.onDocBound(this.rectF, this.w, this.h);
    }

    private void scaleActionMoveDrag(float x, float y) {
        int endType;
        int bw = this.docPage.getBitmapW();
        int bh = this.docPage.getBitmapH();
        this.docPage.getMatrix().postTranslate((x - this.values[2]) / this.values[0] - this.start.x, (y - this.values[5]) / this.values[4] - this.start.y);
        this.docPage.getMatrix().getValues(this.values);
        if (this.isEndAnimation) {
            endType = this.dragMoveBound(this.values, bw, bh);
        } else {
            this.mMatrix.postTranslate((x - this.mNeedValues[2]) / this.mNeedValues[0] - this.start.x, (y - this.mNeedValues[5]) / this.mNeedValues[4] - this.start.y);
            this.mMatrix.getValues(this.mNeedValues);
            endType = this.dragMoveBound(this.mNeedValues, bw, bh);
            this.caculatBound(false, bw, bh);
        }
        this.rectF.set(this.values[2], this.values[5], (float)bw * this.values[0] + this.values[2], (float)bh * this.values[4] + this.values[5]);
        this.drawDocPage(this.docPage, this.mCanvas, this.bgColor);
        this.onDocBound(this.rectF, this.w, this.h);
        this.docPage.drawAnno(this.mCanvas);
        OnDocViewEventListener l = this.mOnDocViewClickedListener;
        if (l != null && endType != 0) {
            l.onEndHDirection(this.iGsDocView, endType, 1);
        }
    }

    private float getMinScall(int bw, int bh) {
        float minScall = 0.5f;
        switch (this.docShowMode) {
            case 3: 
            case 5: {
                minScall = (float)this.w / (float)bw;
                break;
            }
            case 4: 
            case 6: {
                minScall = (float)this.h / (float)bh;
                break;
            }
        }
        float maxScall = Math.min((float)this.maxRectWidth / (float)bw, (float)this.maxRectHeight / (float)bh);
        if (maxScall > 0.0f && minScall > maxScall) {
            GenseeLog.w((String)TAG, (String)("getMinScall is very bigger minScall = " + minScall + " maxScall = " + maxScall));
            minScall = maxScall;
        }
        return minScall;
    }

    private void dragDown(float x, float y) {
        this.start.set(x, y);
        this.mode = 1;
    }

    private int dragMoveBound(float[] values, int bw, int bh) {
        int boundMode = 0;
        if (values[0] * (float)bw > (float)this.w) {
            if (values[2] > 0.0f) {
                boundMode = 1;
            } else if (values[2] < (float)this.w - values[0] * (float)bw) {
                boundMode = 2;
            }
        } else {
            float normalX = ((float)this.w - values[0] * (float)bw) / 2.0f;
            if (values[2] > normalX) {
                boundMode = 1;
            } else if (values[2] < normalX) {
                boundMode = 2;
            }
        }
        return boundMode;
    }

    private int dragUpBound(Matrix matrix, float[] values, boolean valueChange, int bw, int bh) {
        int boundMode = 0;
        if (values[0] * (float)bw > (float)this.w) {
            if (values[2] > 0.0f) {
                values[2] = 0.0f;
                valueChange = true;
                boundMode = 1;
            } else if (values[2] < (float)this.w - values[0] * (float)bw) {
                values[2] = (float)this.w - values[0] * (float)bw;
                boundMode = 2;
                valueChange = true;
            }
        } else {
            valueChange = true;
            float normalX = ((float)this.w - values[0] * (float)bw) / 2.0f;
            if (values[2] > normalX) {
                boundMode = 1;
            } else if (values[2] < normalX) {
                boundMode = 2;
            }
            values[2] = normalX;
        }
        if (values[4] * (float)bh > (float)this.h) {
            if (values[5] > 0.0f) {
                values[5] = 0.0f;
                valueChange = true;
            } else if (values[5] < (float)this.h - values[4] * (float)bh) {
                values[5] = (float)this.h - values[4] * (float)bh;
                valueChange = true;
            }
        } else {
            values[5] = ((float)this.h - values[4] * (float)bh) / 2.0f;
            valueChange = true;
        }
        if (valueChange) {
            matrix.setValues(values);
        }
        return boundMode;
    }

    private int caculatBound(boolean valueChange, int bw, int bh) {
        int boundMode = 0;
        if (this.values[0] * (float)bw > (float)this.w) {
            if (this.values[2] > 0.0f) {
                this.values[2] = 0.0f;
                valueChange = true;
                boundMode = 1;
            } else if (this.values[2] < (float)this.w - this.values[0] * (float)bw) {
                this.values[2] = (float)this.w - this.values[0] * (float)bw;
                boundMode = 2;
                valueChange = true;
            }
        } else {
            valueChange = true;
            float normalX = ((float)this.w - this.values[0] * (float)bw) / 2.0f;
            if (this.values[2] > normalX) {
                boundMode = 1;
            } else if (this.values[2] < normalX) {
                boundMode = 2;
            }
            this.values[2] = normalX;
        }
        if (this.values[4] * (float)bh > (float)this.h) {
            if (this.values[5] > 0.0f) {
                this.values[5] = 0.0f;
                valueChange = true;
            } else if (this.values[5] < (float)this.h - this.values[4] * (float)bh) {
                this.values[5] = (float)this.h - this.values[4] * (float)bh;
                valueChange = true;
            }
        } else {
            this.values[5] = ((float)this.h - this.values[4] * (float)bh) / 2.0f;
            valueChange = true;
        }
        if (valueChange) {
            this.docPage.getMatrix().setValues(this.values);
        }
        return boundMode;
    }

    private float spacing(MotionEvent event, int firstIndex, int secondIndex) {
        float x = event.getX(firstIndex) - event.getX(secondIndex);
        float y = event.getY(firstIndex) - event.getY(secondIndex);
        return (float)Math.sqrt(x * x + y * y);
    }

    private float spacing(MotionEvent event) {
        float x = event.getX(0) - event.getX(1);
        float y = event.getY(0) - event.getY(1);
        return (float)Math.sqrt(x * x + y * y);
    }

    private void midPoint(PointF point, MotionEvent event, int firstIndex, int secondIndex) {
        float x = (event.getX(firstIndex) + event.getX(secondIndex)) / 2.0f;
        float y = (event.getY(firstIndex) + event.getY(secondIndex)) / 2.0f;
        point.set(x, y);
    }

    private void midPoint(PointF point, MotionEvent event) {
        float x = (event.getX(0) + event.getX(1)) / 2.0f;
        float y = (event.getY(0) + event.getY(1)) / 2.0f;
        point.set(x, y);
    }

    public void setBlurMaskFilter() {
        if (this.mPaint.getMaskFilter() != this.mBlur) {
            this.mPaint.setMaskFilter(this.mBlur);
        } else {
            this.mPaint.setMaskFilter(null);
        }
    }

    public void setEmbossmMaskFilter() {
        if (this.mPaint.getMaskFilter() != this.mEmboss) {
            this.mPaint.setMaskFilter(this.mEmboss);
        } else {
            this.mPaint.setMaskFilter(null);
        }
    }

    @Override
    public void setPaintColor(int color) {
        this.paintColor = color;
        if (this.option == CtrlMode.EDIT) {
            if (this.isHighLight) {
                color = 0xAFFFFFFF & color;
            }
            this.mPaint.setColor(color);
        }
    }

    public void setErase() {
        this.option = CtrlMode.EDIT;
        this.drawMode = DrawMode.ERASE;
        this.mPaint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.CLEAR));
    }

    private AnnoFreepenEx sendFreepenEx(float x, float y, int step) {
        AnnoFreepenEx freepenEx = (AnnoFreepenEx)this.createAnno(18, 0);
        freepenEx.addPoint(x, y);
        freepenEx.setHighLight(this.isHighLight);
        freepenEx.setStepType(step);
        this.sendAnno(freepenEx);
        return freepenEx;
    }

    private void sendAnno(AbsAnno anno) {
        if (this.mAnnoAction != null && anno != null && anno.getPageId() >= 0) {
            this.mAnnoAction.sendAnno(anno, null);
        }
    }

    @Override
    public void eraseAll() {
        long nEraseUserId = 0L;
        if (null != this.onAnnoEraseUserIdListener) {
            nEraseUserId = this.onAnnoEraseUserIdListener.getAnnoEraseUserId();
        }
        this.eraseAll(nEraseUserId);
    }

    private void eraseAll(long userId) {
        if (this.mAnnoAction == null) {
            GenseeLog.e((String)TAG, (String)"IAnnoAction is not set,so delete Annos failed!");
            return;
        }
        if (userId == 0L) {
            if (this.docPage != null) {
                this.docPage.cleanAllAnno();
                AnnoCleaner cleaner = new AnnoCleaner();
                cleaner.setRemovedId(0L);
                cleaner.setPageId(this.docPage.getPageId());
                cleaner.setDocId(this.docPage.getDocId());
                this.mAnnoAction.deleteAnno(cleaner, true);
                this.drawDocPage(this.docPage, this.mCanvas, this.bgColor);
                this.postInvalidate();
            }
        } else if (this.docPage != null) {
            if (this.mAnnoAction == null) {
                GenseeLog.e((String)TAG, (String)"eraseAll IAnnoAction is not set,so delete Anno failed!");
                return;
            }
            AbsAnno[] annos = this.docPage.getAnnos();
            if (null != annos && annos.length > 0) {
                boolean bDelete = false;
                for (AbsAnno anno : annos) {
                    if (anno.getOwner() != userId) continue;
                    bDelete = true;
                    this.docPage.delAnno(anno.getId());
                    this.mAnnoAction.deleteAnno(anno, false);
                }
                if (bDelete) {
                    this.drawDocPage(this.docPage, this.mCanvas, this.bgColor);
                    this.docPage.drawAnno(this.mCanvas);
                    this.postInvalidate();
                }
            }
        }
    }

    private boolean deleteAnno(AbsAnno anno) {
        if (this.mAnnoAction == null) {
            GenseeLog.e((String)TAG, (String)"IAnnoAction is not set,so delete Anno failed!");
            return false;
        }
        if (anno != null) {
            this.docPage.delAnno(anno.getId());
            this.mAnnoAction.deleteAnno(anno, false);
            this.drawDocPage(this.docPage, this.mCanvas, this.bgColor);
            this.docPage.drawAnno(this.mCanvas);
            return true;
        }
        return false;
    }

    private void selectPictureAnno(float x, float y) {
        GenseeLog.d((String)TAG, (String)("selectPictureAnno x " + x + " y " + y));
        if (this.docPage != null) {
            AnnoPicture tmpPicture;
            this.docPage.getMatrix().getValues(this.values);
            if (this.annoPicture != null) {
                this.annoPicture.setSelected(false);
            }
            if ((tmpPicture = (AnnoPicture)this.docPage.findAnno((x - this.values[2]) / this.values[0], (y - this.values[5]) / this.values[4], 24)) != null) {
                tmpPicture.setSelected(true);
                tmpPicture.setPageWidthAndHeight(this.docPage.getBitmapW(), this.docPage.getBitmapH());
            }
            GenseeLog.d((String)TAG, (String)("selectPictureAnno tmpPicture = " + tmpPicture));
            if (this.annoPicture != null || tmpPicture != null) {
                this.docPage.drawAnno(this.mCanvas);
                this.invalidate();
            }
            this.annoPicture = tmpPicture;
        }
    }

    private void unSelectPicture() {
        this.cleanSelectPicAnno();
        if (this.annoPicture != null) {
            this.docPage.drawAnno(this.mCanvas);
            this.postInvalidate();
        }
    }

    @Override
    public void undo(long ownerId) {
        AbsAnno delAnno;
        if (this.docPage != null && this.deleteAnno(delAnno = this.docPage.cleanLastOwnAnno(ownerId))) {
            this.postInvalidate();
        }
    }

    public void setIndicate() {
        this.option = CtrlMode.EDIT;
        this.drawMode = DrawMode.DOC_TIP;
    }

    @Override
    public void setStrokeWidth(LINE_SIZE width) {
        this.option = CtrlMode.EDIT;
        this.mPaint.setXfermode(null);
        this.mPaint.setStrokeWidth((float)width.getValue());
    }

    @Override
    public void setTextSize(int size) {
        this.option = CtrlMode.EDIT;
        this.mPaint.setXfermode(null);
        this.mPaint.setTextSize((float)((int)((float)size * 4.0f / 3.0f + 0.5f)));
        GenseeLog.d((String)TAG, (String)("setTextSize size = " + size));
    }

    @Override
    public void setAnnoMakeType(DrawMode mode) {
        if (mode != DrawMode.PICTURE) {
            this.unSelectPicture();
        }
        this.isHighLight = false;
        this.drawMode = mode;
        this.mPaint.setXfermode(null);
        this.mPaint.setColor(this.paintColor);
        this.option = CtrlMode.EDIT;
        switch (mode) {
            case PEN: {
                this.setHLType(0);
                break;
            }
            case HLIGHT: {
                this.isHighLight = true;
                this.setHLType(1);
                break;
            }
            case RECT: {
                break;
            }
            case LINE: {
                break;
            }
            case DOC_TIP: {
                this.setIndicate();
                break;
            }
            case ERASE: {
                this.setErase();
                break;
            }
            case ERASE_ALL: {
                this.eraseAll();
                break;
            }
            case CIRCLE: {
                break;
            }
            case LINE_DASH: {
                break;
            }
            case LINE_ARROW: {
                break;
            }
            default: {
                this.option = CtrlMode.SIGHT;
            }
        }
    }

    @Override
    public DrawMode getAnnoMakeType() {
        return this.drawMode;
    }

    public void setHLType(int type) {
        this.option = CtrlMode.EDIT;
        this.drawMode = DrawMode.PEN;
        this.mPaint.setXfermode(null);
        int color = this.paintColor;
        if (type == 1) {
            color = 0xAFFFFFFF & this.paintColor;
            this.isHighLight = true;
        } else {
            this.isHighLight = false;
            color = this.paintColor;
        }
        this.mPaint.setColor(color);
    }

    @Override
    public void setCtrlMode(CtrlMode mode) {
        this.option = mode;
    }

    @Override
    public void setAnnoAction(AnnoAction action) {
        this.mAnnoAction = action;
        this.reAndUndoAnnoImpl.setAnnoAction(action);
    }

    public void setDocPage(PduPage docPage) {
        if (this.docPage != null && this.docPage.equals(docPage)) {
            return;
        }
        this.cleanSelectPicAnno();
        if (this.mPaint != null && this.docPage != null && this.option == CtrlMode.EDIT) {
            this.touch_up();
        }
        if (this.receiveAnnos != null) {
            this.receiveAnnos.clear();
        }
        this.cleanDefImg();
        PduPage tpg = this.docPage;
        this.docPage = docPage;
        if (this.w > 0 && this.h > 0) {
            if (docPage != null) {
                this.initFirstFram(docPage, this.w, this.h);
            }
            this.postInvalidate();
        }
        if (tpg != null) {
            tpg.recycle();
        }
        if (null != this.docPage) {
            this.reAndUndoAnnoImpl.onSwitchDocOrPage(this.docPage.getDocId(), this.docPage.getPageId());
        }
    }

    @Override
    public void showDocPage(PduPage docPage) {
        PduPage prePage = this.docPage;
        GenseeLog.d((String)TAG, (String)("showDocPage " + docPage + " old is " + prePage));
        if (docPage != null) {
            docPage.setHandler(this.getHandler());
        }
        if (prePage != null && !prePage.equals(docPage)) {
            prePage.setHandler(null);
        }
    }

    private void cleanSelectPicAnno() {
        if (this.annoPicture != null) {
            this.annoPicture.setSelected(false);
            this.annoPicture = null;
        }
    }

    public PduPage getDocPage() {
        return this.docPage;
    }

    protected void initBitmap(PduPage page, int w, int h) {
        page.initBitmap(w, h);
    }

    private void initFirstFram(PduPage page, int w, int h) {
        this.initBitmap(page, w, h);
        this.viewAndDocChange(page, w, h);
    }

    private void viewAndDocChange(PduPage page, int w, int h) {
        switch (this.docShowMode) {
            case 0: {
                this.adaptScall(page, w, h);
                break;
            }
            case 1: {
                this.showFillScall(page, w, h);
                break;
            }
            case 2: {
                this.sourceScall(page, w, h);
                break;
            }
            case 3: 
            case 5: {
                this.showAdaptWidthOrHeight(page);
                break;
            }
            case 4: 
            case 6: {
                this.showAdaptWidthOrHeight(page);
                break;
            }
        }
    }

    private void sourceScall(PduPage page, int w, int h) {
        this.docShowMode = 0;
        int bw = page.getBitmapW();
        int bh = page.getBitmapH();
        Matrix matrix = page.getMatrix();
        matrix.reset();
        matrix.getValues(this.values);
        if (this.values[0] == 1.0f && this.values[2] == 0.0f && this.values[4] == 1.0f && this.values[5] == 0.0f) {
            this.caculatBound(false, bw, bh);
        }
        this.drawDocPage(page, this.mCanvas, this.bgColor);
        page.drawAnno(this.mCanvas);
        this.rectF.set(this.values[2], this.values[5], (float)bw * this.values[0] + this.values[2], (float)bh * this.values[4] + this.values[5]);
        this.onDocBound(this.rectF, w, h);
    }

    private void showFillScall(PduPage page, int w, int h) {
        this.docShowMode = 1;
        Matrix matrix = page.getMatrix();
        int bw = page.getBitmapW();
        int bh = page.getBitmapH();
        float scallx = (float)w / (float)bw;
        float scally = (float)h / (float)bh;
        matrix.reset();
        matrix.postScale(scallx, scally);
        matrix.getValues(this.values);
        this.caculatBound(false, bw, bh);
        this.drawDocPage(page, this.mCanvas, this.bgColor);
        page.drawAnno(this.mCanvas);
        this.rectF.set(this.values[2], this.values[5], (float)bw * this.values[0] + this.values[2], (float)bh * this.values[4] + this.values[5]);
        this.onDocBound(this.rectF, w, h);
    }

    private void adaptScall(PduPage page, int w, int h) {
        int bh;
        float scally;
        this.docShowMode = 0;
        Matrix matrix = page.getMatrix();
        int bw = page.getBitmapW();
        float scallx = (float)w / (float)bw;
        float scall = scallx < (scally = (float)h / (float)(bh = page.getBitmapH())) ? scallx : scally;
        matrix.reset();
        matrix.postScale(scall, scall);
        matrix.getValues(this.values);
        this.caculatBound(false, bw, bh);
        this.drawDocPage(page, this.mCanvas, this.bgColor);
        page.drawAnno(this.mCanvas);
        this.rectF.set(this.values[2], this.values[5], (float)bw * this.values[0] + this.values[2], (float)bh * this.values[4] + this.values[5]);
        this.onDocBound(this.rectF, w, h);
    }

    @Override
    public void showAdaptViewWidthAlignTop() {
        this.docShowMode = 5;
        if (this.docPage != null) {
            this.showAdaptWidthOrHeight(this.docPage);
            this.postInvalidate();
        }
    }

    @Override
    public void showAdaptViewHeightAlignLeft() {
        this.docShowMode = 6;
        if (this.docPage != null) {
            this.showAdaptWidthOrHeight(this.docPage);
            this.postInvalidate();
        }
    }

    @Override
    public void showAdaptViewWidth() {
        this.docShowMode = 3;
        if (this.docPage != null) {
            this.showAdaptWidthOrHeight(this.docPage);
            this.postInvalidate();
        }
    }

    private void showAdaptWidthOrHeight(PduPage page) {
        Matrix matrix = page.getMatrix();
        matrix.reset();
        int bw = page.getBitmapW();
        int bh = page.getBitmapH();
        float minScall = this.getMinScall(bw, bh);
        matrix.postScale(minScall, minScall);
        if (this.docShowMode == 5 && minScall * (float)bh > (float)this.h) {
            matrix.postTranslate(((float)this.w - minScall * (float)bw) / 2.0f, 0.0f);
        } else if (this.docShowMode == 6 && minScall * (float)bw > (float)this.w) {
            matrix.postTranslate(0.0f, ((float)this.h - minScall * (float)bh) / 2.0f);
        } else {
            matrix.postTranslate(((float)this.w - minScall * (float)bw) / 2.0f, ((float)this.h - minScall * (float)bh) / 2.0f);
        }
        this.drawDocPage(page, this.mCanvas, this.bgColor);
        page.drawAnno(this.mCanvas);
        matrix.getValues(this.values);
        this.rectF.set(this.values[2], this.values[5], (float)bw * this.values[0] + this.values[2], (float)bh * this.values[4] + this.values[5]);
        this.onDocBound(this.rectF, this.w, this.h);
    }

    @Override
    public void showAdaptViewHeight() {
        this.docShowMode = 4;
        if (this.docPage != null) {
            this.showAdaptWidthOrHeight(this.docPage);
            this.postInvalidate();
        }
    }

    @Override
    public void showFillView() {
        this.docShowMode = 1;
        if (this.docPage != null) {
            this.showFillScall(this.docPage, this.w, this.h);
            this.postInvalidate();
        }
    }

    @Override
    public void showAdaptView() {
        this.docShowMode = 0;
        if (this.docPage != null) {
            this.adaptScall(this.docPage, this.w, this.h);
            this.postInvalidate();
        }
    }

    @Override
    public void showSourceScall() {
        this.docShowMode = 2;
        if (this.docPage != null) {
            this.sourceScall(this.docPage, this.w, this.h);
            this.postInvalidate();
        }
    }

    @Override
    public int getShowMode() {
        return this.docShowMode;
    }

    private void switchShowMode() {
        if (this.docPage != null) {
            if (this.docShowMode == 1) {
                this.adaptScall(this.docPage, this.w, this.h);
            } else if (this.docShowMode == 2) {
                this.sourceScall(this.docPage, this.w, this.h);
            } else {
                this.showFillScall(this.docPage, this.w, this.h);
            }
        }
    }

    @Override
    public void clear() {
        if (this.mBitmap != null) {
            this.mBitmap.recycle();
            this.mBitmap = null;
        }
        if (this.docPage != null) {
            this.docPage.clear();
        }
    }

    @Override
    public void reset() {
        if (this.docPage != null) {
            this.docPage.recycle();
            this.docPage = null;
        }
        this.postInvalidate();
    }

    public void onAnnoAdd(AbsAnno anno) {
        ThreadPool.getInstance().execute(new Runnable(){

            @Override
            public void run() {
            }
        });
        if (anno != null && this.docPage != null) {
            anno.draw(this.mCanvas, this.docPage.getMatrix());
            this.postInvalidate();
        }
    }

    public void onAnnoDel(AbsAnno anno) {
        this.onUpdate();
    }

    @Override
    public void onUpdate() {
        if (this.docPage != null) {
            this.drawDocPage(this.docPage, this.mCanvas, this.bgColor);
            this.docPage.drawAnno(this.mCanvas);
            this.postInvalidate();
        }
    }

    protected void drawDocPage(PduPage docPage, Canvas mCanvas, int bgColor) {
        if (this.onDocViewImplListener != null) {
            this.onDocViewImplListener.drawDocPage(docPage, mCanvas, bgColor);
        }
    }

    @Override
    public void setDefImg(Bitmap bitmap, boolean isFillView) {
        if (this.docPage == null) {
            this.isDefImageFillView = isFillView;
            this.cleanDefImg();
            this.defBitmap = bitmap;
            this.drawDefBitmap(bitmap, isFillView);
            this.invalidate();
        }
    }

    private boolean isDrawAnnos() {
        if (null != this.onDocViewImplListener) {
            return this.onDocViewImplListener.isDrawAnnos();
        }
        return false;
    }

    private void drawDefBitmap(Bitmap bitmap, boolean isFillView) {
        if (bitmap == null || bitmap.isRecycled() || this.onDocViewImplListener == null) {
            return;
        }
        int densityDpi = this.onDocViewImplListener.getContext().getResources().getDisplayMetrics().densityDpi;
        int bw = bitmap.getScaledWidth(densityDpi);
        int bh = bitmap.getScaledHeight(densityDpi);
        Matrix matrix = new Matrix();
        float sx = (float)this.w / (float)bw;
        float sy = (float)this.h / (float)bh;
        float px = 0.0f;
        float py = 0.0f;
        if (!isFillView) {
            if (sx < sy) {
                sy = sx;
                py = ((float)this.h - (float)bh * sy) * 0.5f + 0.5f;
            } else {
                sx = sy;
                px = ((float)this.w - (float)bw * sx) * 0.5f + 0.5f;
            }
        }
        matrix.postScale(sx, sy);
        matrix.postTranslate(px, py);
        this.mCanvas.save();
        this.mCanvas.concat(matrix);
        this.mCanvas.drawBitmap(bitmap, null, new Rect(0, 0, bw, bh), new Paint());
        this.mCanvas.restore();
    }

    @Override
    public boolean isDragScale() {
        if (null != this.docPage) {
            int bh;
            int bw;
            float minScall;
            float[] values = new float[]{1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f};
            this.docPage.getMatrix().getValues(values);
            if (!(this.docShowMode != 3 && this.docShowMode != 4 && this.docShowMode != 5 && this.docShowMode != 6 || values[0] == (minScall = this.getMinScall(bw = this.docPage.getBitmapW(), bh = this.docPage.getBitmapH())) && values[4] == minScall)) {
                return true;
            }
        }
        return false;
    }

    private void cleanDefImg() {
        Bitmap b = this.defBitmap;
        this.defBitmap = null;
        if (b != null && !b.isRecycled()) {
            b.recycle();
        }
    }

    private void invalidate() {
        if (null != this.onDocViewImplListener) {
            this.onDocViewImplListener.invalidateDraw();
        }
    }

    private void postInvalidate() {
        if (null != this.onDocViewImplListener) {
            this.onDocViewImplListener.postinvalidateDraw();
        }
    }

    private void onDocBound(RectF rectF, int w, int h) {
        if (null != this.onDocViewImplListener) {
            this.onDocViewImplListener.onDocBound(rectF, w, h);
        }
    }

    @Override
    public void addPictureAnno(float x, float y, String url, String localPath) {
        GenseeLog.d((String)TAG, (String)("addPictureAnno left = " + x + " top = " + y + " url = " + url + " localPath = " + localPath));
        if (this.docPage != null) {
            AnnoPicture ap = new AnnoPicture(url, localPath);
            ap.draw(this.mCanvas, this.docPage.getMatrix());
            this.docPage.addAnno(ap, true);
            ap.setPageId(this.docPage.getPageId());
            this.sendAnno(ap);
            if (this.onAnnoDataListener != null) {
                this.onAnnoDataListener.onAnnoData(ap, OnAnnoDataStatus.NEW);
            }
            this.postInvalidate();
        }
    }

    @Override
    public void addTextAnno(String txt) {
        if (this.docPage != null && txt != null) {
            AnnoText text = new AnnoText();
            text.setType(19);
            this.docPage.getMatrix().getValues(this.values);
            text.setLeft((this.downX - this.values[2]) / this.values[0]);
            text.setTop((this.downY - this.values[5]) / this.values[4]);
            text.setRight(text.getLeft() + 200.0f);
            text.setBottom(text.getTop() + 200.0f);
            byte textSize = (byte)this.mPaint.getTextSize();
            text.setFontsize(textSize);
            text.setArgbColor(this.mPaint.getColor());
            text.setPageId(this.docPage.getPageId());
            text.setText(txt);
            GenseeLog.d((String)TAG, (String)("addTextAnno left = " + text.getLeft() + " top = " + text.getTop() + " text = " + text.getText() + " textSize = " + textSize));
            text.draw(this.mCanvas, this.docPage.getMatrix());
            this.docPage.addAnno(text, true);
            this.sendAnno(text);
            if (this.onAnnoDataListener != null) {
                this.onAnnoDataListener.onAnnoData(text, OnAnnoDataStatus.NEW);
            }
            this.postInvalidate();
        } else {
            GenseeLog.w((String)TAG, (String)("addTextAnno text = " + txt + " docpage = " + this.docPage));
        }
    }

    @Override
    public void redoStep() {
        this.reAndUndoAnnoImpl.redoStep();
    }

    @Override
    public void undoStep() {
        this.reAndUndoAnnoImpl.undoStep();
    }

    @Override
    public int getRedoStackSize() {
        return this.reAndUndoAnnoImpl.getRedoStackSize();
    }

    @Override
    public int getUndoStackSize() {
        return this.reAndUndoAnnoImpl.getUndoStackSize();
    }

    @Override
    public void setOnReAndUndoListener(OnReAndUndoListener onReAndUndoListener) {
        this.reAndUndoAnnoImpl.setOnReAndUndoListener(onReAndUndoListener);
    }

    @Override
    public void resetStatus() {
        this.reAndUndoAnnoImpl.resetStatus();
    }

    @Override
    public Bitmap getBitmap() {
        return Bitmap.createBitmap((Bitmap)this.mBitmap);
    }

    private void removeReceiveAnno(Long key) {
        if (this.receiveAnnos != null) {
            this.receiveAnnos.remove(key);
        }
    }

    private void addReceiveAnno(Long key, AbsAnno absAnno) {
        if (this.receiveAnnos == null) {
            this.receiveAnnos = new HashMap(1);
        }
        this.receiveAnnos.put(key, absAnno);
    }

    public static interface OnDocLabelListener {
        public void onDocLabelStart();

        public void onDocLabelStop();

        public void onDocLabelSingleClick();
    }

    public static interface onDocViewImplListener {
        public void invalidateDraw();

        public void postinvalidateDraw();

        public Context getContext();

        public void onDocBound(RectF var1, int var2, int var3);

        public void drawDocPage(PduPage var1, Canvas var2, int var3);

        public boolean isDrawAnnos();
    }

    private class MyHandler
    extends Handler {
        private MyHandler() {
        }

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 140: {
                    PduPage p = (PduPage)msg.obj;
                    if (p == null) break;
                    if (p.equals(DocViewImpl.this.docPage)) {
                        DocViewImpl.this.onUpdate();
                        break;
                    }
                    DocViewImpl.this.setDocPage(p);
                    break;
                }
                case 138: {
                    DocViewImpl.this.setDocPage((PduPage)msg.obj);
                    break;
                }
                case 147: {
                    if (null == msg.obj) {
                        DocViewImpl.this.thirdPartyPenAnnoPointer = null;
                    } else {
                        DocViewImpl.this.thirdPartyPenAnnoPointer = (ThirdPartyPenAnnoPointer)msg.obj;
                    }
                    DocViewImpl.this.onUpdate();
                    break;
                }
                case 135: {
                    DocViewImpl.this.onUpdate();
                    break;
                }
                case 136: {
                    AbsAnno anno = (AbsAnno)msg.obj;
                    DocViewImpl.this.removeReceiveAnno(anno.getOwner());
                    if (anno instanceof AnnoFreepenEx) {
                        AnnoFreepenEx ex = (AnnoFreepenEx)anno;
                        if (3 == ex.getStepType() || 0 == ex.getStepType()) {
                            DocViewImpl.this.removeReceiveAnno(anno.getId());
                            DocViewImpl.this.onUpdate();
                            break;
                        }
                        if (3 == ex.getStepType()) {
                            DocViewImpl.this.onAnnoAdd(anno);
                            break;
                        }
                        DocViewImpl.this.addReceiveAnno(anno.getId(), anno);
                        DocViewImpl.this.postInvalidate();
                        break;
                    }
                    DocViewImpl.this.onAnnoAdd(anno);
                    break;
                }
                case 144: {
                    AnnoCleaner cleaner = (AnnoCleaner)msg.obj;
                    if (cleaner != null) {
                        long removeId = cleaner.getRemovedId();
                        if (removeId == 0L || DocViewImpl.this.annoPicture != null && DocViewImpl.this.annoPicture.getId() == removeId) {
                            DocViewImpl.this.cleanSelectPicAnno();
                        }
                        if (DocViewImpl.this.receiveAnnos != null) {
                            if (removeId == 0L) {
                                if (DocViewImpl.this.receiveAnnos != null) {
                                    DocViewImpl.this.receiveAnnos.clear();
                                }
                            } else {
                                Long key = null;
                                for (Map.Entry en : DocViewImpl.this.receiveAnnos.entrySet()) {
                                    if (removeId != ((AbsAnno)en.getValue()).getId()) continue;
                                    key = (Long)en.getKey();
                                    break;
                                }
                                DocViewImpl.this.removeReceiveAnno(key);
                            }
                        }
                    }
                }
                case 141: {
                    DocViewImpl.this.onUpdate();
                    break;
                }
                case 145: 
                case 146: {
                    DocViewImpl.this.setDocPage(null);
                    break;
                }
                case 148: {
                    AbsAnno receiveAnno = (AbsAnno)msg.obj;
                    DocViewImpl.this.addReceiveAnno(receiveAnno.getOwner(), receiveAnno);
                    DocViewImpl.this.postInvalidate();
                }
            }
        }
    }
}

