/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.pdu;

import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import com.gensee.pdu.AbsAnno;

public class AnnoRect
extends AbsAnno {
    private int color;
    private byte linesize;
    private float left;
    private float top;
    private float right;
    private float bottom;
    private Paint mPaint;
    private Path mPath;

    public AnnoRect() {
        this.setType(6);
    }

    public Paint getPaint() {
        if (this.mPaint == null) {
            if (this.argbColor == -1) {
                this.argbColor = this.agbrToArgb(this.color);
            }
            this.mPaint = new Paint();
            this.mPaint.setColor(this.argbColor);
            this.mPaint.setStrokeWidth((float)this.linesize);
            this.mPaint.setAntiAlias(true);
            this.mPaint.setDither(true);
            this.mPaint.setStyle(Paint.Style.STROKE);
            this.mPaint.setStrokeJoin(Paint.Join.ROUND);
            this.mPaint.setStrokeCap(Paint.Cap.ROUND);
        }
        return this.mPaint;
    }

    public Path getPath() {
        if (this.mPath == null) {
            this.mPath = new Path();
            this.mPath.addRect(this.left, this.top, this.right, this.bottom, Path.Direction.CW);
        }
        return this.mPath;
    }

    @Override
    public void draw(Canvas canvas, Matrix matrix) {
        this.drawContent(canvas, matrix);
    }

    private void drawContent(Canvas canvas, Matrix matrix) {
        Path p = new Path(this.getPath());
        p.transform(matrix);
        canvas.drawPath(p, this.getPaint());
    }

    @Override
    public boolean contain(float x, float y) {
        float tl = this.left;
        float tt = this.top;
        float tr = this.right;
        float tb = this.bottom;
        if (this.left > this.right) {
            tl = this.right;
            tr = this.left;
        }
        if (this.top > this.bottom) {
            tt = this.bottom;
            tb = this.top;
        }
        if (x >= tl - 32.0f && x <= tl + 32.0f || x >= tr - 32.0f && x <= tr + 32.0f) {
            return y >= tt && y <= tb;
        }
        if (y >= tt - 32.0f && y <= tt + 32.0f || y >= tb - 32.0f && y <= tb + 32.0f) {
            return x >= tl && x <= tr;
        }
        return false;
    }

    @Override
    public void setPath(Path p) {
        this.mPath = p;
    }

    @Override
    public void touchDown(float x, float y) {
        this.left = this.right = x;
        this.top = this.bottom = y;
        this.getPath();
    }

    @Override
    public void touchMove(float x, float y) {
        this.right = x;
        this.bottom = y;
        Path p = this.getPath();
        p.reset();
        p.addRect(this.left, this.top, this.right, this.bottom, Path.Direction.CW);
    }

    @Override
    public void touchUp(float x, float y) {
        this.touchMove(this.right == this.left ? this.right + 0.5f : this.right, this.top == this.bottom ? this.bottom + 0.5f : this.bottom);
    }

    @Override
    public void touchDraw(Canvas canvas, Matrix matrix) {
        this.drawContent(canvas, matrix);
    }

    public long getColor() {
        return this.color;
    }

    public void setColor(int color) {
        this.color = color;
    }

    @Override
    public int setArgbColor(int argb) {
        this.argbColor = argb;
        this.color = super.setArgbColor(argb);
        return this.color;
    }

    public short getLinesize() {
        return this.linesize;
    }

    @Override
    public void setLinesize(byte linesize) {
        this.linesize = linesize;
    }

    public float getLeft() {
        return this.left;
    }

    public void setLeft(float left) {
        this.left = left;
    }

    public float getTop() {
        return this.top;
    }

    public void setTop(float top) {
        this.top = top;
    }

    public float getRight() {
        return this.right;
    }

    public void setRight(float right) {
        this.right = right;
    }

    public float getBottom() {
        return this.bottom;
    }

    public void setBottom(float bottom) {
        this.bottom = bottom;
    }

    @Override
    public String toString() {
        return "AnnoRect [color=" + this.color + ", linesize=" + this.linesize + ", left=" + this.left + ", top=" + this.top + ", right=" + this.right + ", bottom=" + this.bottom + ", mPaint=" + this.mPaint + ", mPath=" + this.mPath + "," + super.toString() + "]";
    }
}

